<?php
/*
Pendientes:
- FN: Asociar tablas relacionadas (join)
- BN: Crear atributos de tablas relacionadas
- BN: Validar matriz de objetos de tablas relacionadas.
*/

function clearText( $s_Text )
{
    $s_Text = str_replace( "á", "a", $s_Text );
    $s_Text = str_replace( "é", "e", $s_Text );
    $s_Text = str_replace( "í", "i", $s_Text );
    $s_Text = str_replace( "ó", "o", $s_Text );
    $s_Text = str_replace( "ú", "u", $s_Text );
    $s_Text = str_replace( "ñ", "n", $s_Text );
    $s_Text = str_replace( "\n", " ", $s_Text );
    return $s_Text;
}

include_once 'functions.php';

/*
Generacion de librerias de la capa dispatcher v2.1:
===================================================
- BaseBN ( abstract )..................: Establece y recupera el valor de los campos
    |
    +- BN ( extends )..................: Para que el usuario pueda redefinir la clase
    |    |
    |    +- BaseBV ( abstract )........: Valida el tipo de dato y establece el valor del campo
    |        |
    |        +- BV ( extends ).........: Para que el usuario pueda redefinir la clase
    |            |
    |            + BaseDP ( abstract ).: Realiza el mantenimiento de la tabla ( save, update, delete )
    |                |
    |                +- DP ( extends ).: Para que el usuario pueda redefinir la clase
    |
    +- BaseFN ( abstract ).............: Realiza la busqueda de los registros
        |
        +- FN ( extends )..............: Para que el usuario pueda redefinir la clase
*/
?>

<style> 
    body{ color: #000000; font: 12px "Lucida Sans Unicode", "Lucida Sans", "Lucida Grande", Malayalam, Verdana, sans-serif;    margin: 10px 0px 0px 0px; padding: 0px; }
    .alt2, .alt2Active{    background: #EEE; color: #000000; }
    .smallfont{    font: 11px verdana, geneva, lucida, 'lucida grande', arial, helvetica, sans-serif; }
</style>

<?php
if ( !isset( $_GET[ "folder" ] ) || $_GET[ "folder" ] == "" 
    || !isset( $_GET[ "file" ] ) || $_GET[ "file" ] == "" 
    || !isset( $_GET["output" ] ) || ( $_GET[ "output" ] !== "BBN" && $_GET[ "output" ] !== "BN" 
        && $_GET[ "output" ] !== "BBV" && $_GET[ "output" ] !== "BV" 
        && $_GET[ "output" ] !== "BDP" && $_GET[ "output" ] !== "DP" 
        && $_GET[ "output" ] !== "BFN" && $_GET[ "output" ] !== "FN" ) )
{
?>
    <table width = "100%" border = "1">
        <tr>
            <td>
            Se requiere de los siguientes paramtros:<br/>
            - folder = [ carpeta donde se ubica el archivo XML ]<br/>
            - file   = [ Archivo XML ]<br/>
            - output = [ BBN = Base Single Bean | BBV = Base Bean Valid (model) | BDP = Base Dispatcher | BFN = Base Find] | [BN = Single Bean | BV = Bean Valid (model) | DP = Dispatcher | FN = Find ]
    </tr>
  </table><?php
  exit;
}

/* obtenemos la estructura del modelo (Erwin) */
$s_folderRead = $_GET[ "folder" ];
$s_fileXML    = $_GET[ "file" ];
$a_Model = array();
$a_Model[ "entity" ] = array();
$o_xml = simplexml_load_file( $s_folderRead . DIRECTORY_SEPARATOR . $s_fileXML );
foreach ( $o_xml->Model as $oModel )
{
    //pr( ( string ) $oModel['database'] );
    $s_Dabatase = ( string ) $oModel['database'];
    /* por el grupo de tablas */
    foreach ( $oModel->Entity_Groups as $a_Entity )
    {
        /* por cada entidad (tabla) */
        foreach ( $a_Entity->Entity as $o_Entity )
        {
            $i_Entity = count( $a_Model[ "entity" ] );
            $a_Model[ "entity" ][ $i_Entity ] = array();
            $a_Model[ "entity" ][ $i_Entity ][ "name" ] = ( string ) $o_Entity->EntityProps->Name;
            $a_Model[ "entity" ][ $i_Entity ][ "physical_name" ] =  ( string ) $o_Entity->EntityProps->Physical_Name;
            $a_Model[ "entity" ][ $i_Entity ][ "column" ] = array();
            
            if( $a_Model[ "entity" ][ $i_Entity ][ "physical_name" ] == "" ){ $a_Model[ "entity" ][ $i_Entity ][ "physical_name" ] = $a_Model[ "entity" ][ $i_Entity ][ "name" ]; }
            
            /* por cada campo */
            foreach ( $o_Entity->Attribute_Groups->Attribute as $o_Attribute )
            {
                $i_Column = ( ( int ) $o_Attribute->AttributeProps->Order ) - 1;
                $s_DataType = ( string ) $o_Attribute->AttributeProps->Datatype;
                if( $s_DataType == "" )
                {
                    echo "<font color='red'><b>BBV Warning: [ ".$a_Model[ "entity" ][ $i_Entity ][ "physical_name" ]." ] -> ( ".$o_Attribute->AttributeProps->Name." ) no tiene un Atributo ( Datatype ).<br></b></font>";
                }
                $s_DataType = str_replace( "unsigned", "", strtolower( $s_DataType ) );
                $s_DataType = str_replace( ")", "", $s_DataType );
                $s_DataType = trim( $s_DataType );
                $s_DataType = str_replace( "(", ",", $s_DataType );
                $s_DataType = str_replace( " ", ",", $s_DataType );
                $s_DataType = trim( $s_DataType );
                $aDataType = explode( ",", $s_DataType );
                if ( !isset( $aDataType[ 1 ] ) )
                { 
                    $aDataType[ 1 ] = 0;
                }
                if ( !isset( $aDataType[ 2 ] ) )
                {
                    $aDataType[ 2 ] = 0;
                }
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ] = array();
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "id" ] = ( string ) $o_Attribute[ "id" ];
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "name" ] = ( string ) $o_Attribute->AttributeProps->Name;
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "physical_name" ] = ( string ) $o_Attribute->AttributeProps->Physical_Name;
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "primary" ] = false;
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] = $aDataType[ 0 ];
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ] = ( string ) $o_Attribute->AttributeProps->Parent_Domain;
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "length" ] = $aDataType[ 1 ];
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "decimal" ] = $aDataType[ 2 ];
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "not_null" ]= ( ( ( int ) $o_Attribute->AttributeProps->Null_Option) ? true : false );
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "valid" ] = ( string ) $o_Attribute->AttributeProps->Validation_Rule_Ref;
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "default" ] = ( string ) $o_Attribute->AttributeProps->Default;
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "definition" ] = ( string ) $o_Attribute->AttributeProps->Definition;
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "prefix" ] = null;
                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "cast" ] = "@";
                
                if( trim( $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "physical_name" ] == "" ) ){ $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "physical_name" ] = $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "name" ]; } //WILLY_CAMBIOS
                
                /*** verificamos si el campo pertenece a una llave primaria ***/
                $b_Found = false;
                if ( $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "id" ] )
                {
                    /* por cada conjunto de llaves (grupo de grupo de llaves ) */
                    foreach ( $o_Entity->Key_Group_Groups as $aKey )
                    {
                        /* por cada grupo de llaves */
                        foreach ( $aKey as $oKey )
                        {
                            /* si el grupo de la llaves forman una llave primaria */
                            if ( ( string ) $oKey[ "Name" ] == "Primary Key" )
                            {
                                /* por cada mienbro de la llave primaria */
                                foreach ( $oKey->Key_Group_Member_Groups->Key_Group_Member as $aField )
                                {
                                    /* si el id del campo pertenece al grupo de llave primaria */
                                    if ( ( ( string ) $aField->Key_Group_MemberProps->Key_Group_Member_Column) == $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "id" ] )
                                    {
                                        /* afirmamos que el campo pertenecia a la llave primaria */
                                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "primary" ] = true;
                                        break 3;
                                    }
                                }
                            }
                        }
                    }
                }
                
                /*** obtenemos el dominio del campo ***/
                foreach ( $oModel->Domain_Groups as $aDomain )
                {
                    foreach ( $aDomain as $oDomain )
                    {
                        if ( ( string ) $oDomain[ "id" ] == $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ] )
                        {
                            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ] = ( string ) $oDomain->DomainProps->Domain_Name;
                            break 2;
                        }
                    }
                }
                
                /*** establecemos el prefijo del tipo de dato ***/
                switch ( strtolower( $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] ) )
                {
                    case "float":
                    case "decimal":
                    case "numeric":
                    case "double":
                    case "real":
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ] = "Number";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "prefix" ] = "f";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "cast" ] = "( float ) @";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "";
                        break;
                    case "int":
                    case "integer":
                    case "smallint":
                    case "tinyint":
                    case "bigint":
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ] = "Number";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "prefix" ] = "i";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "cast" ] = "( integer ) @";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "";
                    break;
                    case "date":
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ] = "Datetime";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "prefix" ] = "d";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "cast" ] = "utilTimestamp::getTimestamp( @, \"Y-m-d\" )";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "'";
                    break;    
                    case "datetime":
                    case "timestamp":
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ] = "Datetime";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "prefix" ] = "d";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "cast" ] = "utilTimestamp::getTimestamp( @, \"Y-m-d H:i:s\" )";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "'";
                    break;    
                    case "char":
                    case "varchar":
                    case "blob":
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "prefix" ] = "s";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ] = "String";
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "'";
                    break;
                    default:
                        $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "prefix" ] = "u";
                    break;
                }
                if( !isset( $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] ) ){ $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "'"; }  //WILLY_CAMBIOS
                
                /*** obtenemos la regla de validacion del campo ***/
                $b_Found = false;
                if ( $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "valid" ] )
                {
                    foreach( $o_xml->Model->Validation_Rule_Groups as $aValidation )
                    {
                        foreach( $aValidation as $oValidation )
                        {
                            if( ( ( string ) $oValidation["id"] ) == $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"] )
                            {
                                foreach( $oValidation->Validation_RuleProps as $oRule )
                                {
                                    $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"]           = array();
                                    $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"]["type"] = ( string ) $oRule->Type;
                                    switch( $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"]["type"] )
                                    {
                                        case "1":
                                            $b_Found = true;
                                            $s_Value = ( string ) $oRule->Validation_Rule_Min_Value;
                                            if( $s_Value === "" )
                                            {
                                                $s_Value = null;
                                            }
                                            $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"]["min_value"] = $s_Value;
                                            $s_Value = ( string ) $oRule->Validation_Rule_Max_Value;
                                            if( $s_Value === "" )
                                            {
                                                $s_Value = null;
                                            }
                                            $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"]["max_value"] = $s_Value;
                                            break;
                                        case "2":
                                            $b_Found                                                                 = true;
                                            $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"]["values"]    = array();
                                            foreach( $oValidation->Valid_Value_Groups as $aRule )
                                            {
                                                foreach( $aRule as $oRule )
                                                {
                                                    foreach( $oRule->Valid_ValueProps as $oValue )
                                                    {
                                                        $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"]["values"][] = ( string ) $oValue->Name;
                                                    }
                                                }
                                            }
                                        break;
                                    }
                                    break;
                                }
                                if( !$b_Found )
                                {
                                    $a_Model["entity"][$i_Entity]["column"][$i_Column]["valid"] = "";
                                }
                                break;
                            }
                        }
                        if( $b_Found )
                        {
                            break;
                        }
                    }
                }
                
                /*** obtenemos el valor por defecto del campo ***/
                if ( $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "default" ] )
                {
                    /* por cada grupo de valores por defecto */
                    foreach ( $o_xml->Model->Default_Value_Groups as $aDefault )
                    {
                        /* por cada valor por defecto */
                        foreach ( $aDefault as $oDefault )
                        {
                            /* si el id del valor por defecto pertenece al grupo de valores por defecto */
                            if ( ( ( string ) $oDefault[ "id" ] ) == $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "default" ] )
                            {
                                /* asignamos el valor por defecto al campo */
                                $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "default" ] = ( string ) $oDefault->Default_ValueProps->Server_Value;
                                break 2;
                            }
                        }
                    }
                }
            }
        }
    }
}

/* construimos el codigo php */
$s_Tab = "&nbsp;&nbsp;&nbsp;&nbsp;";
$s_Base = "Base";
foreach ( $a_Model[ "entity" ] as $o_Entity )
{
    $s_PhpFileName = "";
    $s_PhpClassName = "";
    
    ////////////////////////////////////////////////////////// BBN //////////////////////////////////////////////////////////
    if ( $_GET[ "output" ] == "BBN" )
    {
        $s_PhpClassName = $s_Base.ucfirst( $o_Entity[ "name" ] )."BN";
        $s_PhpFileName = $s_PhpClassName.".class.php";

        /* concatenamos el codigo php ( class )  */
        $s_PhpCode = "/* Autor...:  */<br>";
        $s_PhpCode .= "/* Esquema.: ".$_GET[ "file" ]." */<br>";
        $s_PhpCode .= "/* Generado: ".date( "Y-m-d H:i:s" )." */<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "/* Metodos de acceso a los campos de la tabla ".$o_Entity[ "physical_name" ]." */<br>";
        $s_PhpCode .= "abstract class ".$s_PhpClassName."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= $s_Tab."/* Campos de la tabla */<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab."private \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] ).";    // ".$a_Column[ "name" ].": ".( $a_Column[ "definition" ] ? clearText( $a_Column[ "definition" ] ) : "( no definido )" )."<br>";
        }
        $s_PhpCode .= "<br>";

        /* concatenamos el codigo php ( set y get ) */
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab."/* Establece el valor del campo ".$a_Column[ "name" ]." */<br>";
            $s_PhpCode .= $s_Tab."public function set".ucfirst( $a_Column[ "name" ] )."( \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." )<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."\$this->".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." = \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] ).";<br>";
            $s_PhpCode .= $s_Tab."}<br><br>";
            $s_PhpCode .= $s_Tab."/* Obtiene el valor del campo ".$a_Column[ "name" ]." */<br>";
            $s_PhpCode .= $s_Tab."public function get".ucfirst( $a_Column[ "name" ] )."()<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."return \$this->".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] ).";<br>";
            $s_PhpCode .= $s_Tab."}<br><br>";
        }

        //nuevo metodo para el serialice
        $s_PhpCode .= $s_Tab."public function getJsonSerialize()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return <br>";
        $s_PhpCode .= $s_Tab.$s_Tab."[<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."'".ucfirst( $a_Column[ "name" ] )."' => \$this->get".ucfirst( $a_Column[ "name" ] )."(),<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab."];<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////
        //nuevos metodos para el toArray
        $s_PhpCode .= $s_Tab."public function toArray()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return \$this->processArray( get_object_vars( \$this ) ); <br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        $s_PhpCode .= $s_Tab."private function processArray( \$array )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."foreach( \$array as \$key => \$value ) <br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."if ( is_object( \$value ) )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$array[\$key] = \$value->toArray();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."if ( is_array( \$value ) ) <br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$array[\$key] = \$this->processArray( \$value );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return \$array;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        $s_PhpCode .= $s_Tab."public function __toString()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return json_encode( \$this->toArray() ); <br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        /* concatenamos el codigo php ( retrieveByRs ) */
        $s_PhpCode .= $s_Tab."/* Recupera un objeto ".ucfirst( $o_Entity[ "name" ] )."BN desde un RecordSet */<br>";
        $s_PhpCode .= $s_Tab."public static function retrieveByRs( \$o_".ucfirst( $o_Entity[ "name" ] )."Rs )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_".ucfirst( $o_Entity[ "name" ] )."BN = new ".ucfirst( $o_Entity[ "name" ] )."BN();<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_Field = "\$o_".ucfirst( $o_Entity[ "name" ] )."Rs[ \"".ucfirst( $a_Column[ "name" ] )."\" ]";
            $s_Field = str_replace( "@", $s_Field, $a_Column[ "cast" ] );
            $s_PhpCode .= $s_Tab.$s_Tab."\$o_".ucfirst( $o_Entity[ "name" ] )."BN->set".ucfirst( $a_Column[ "name" ] )."( ".$s_Field." );<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab."return \$o_".ucfirst( $o_Entity[ "name" ] )."BN;<br>";
        $s_PhpCode .= $s_Tab."}<br>";
        
        /* fin de la concatenacion del codigo php */
        $s_PhpCode .= "}";
    }
    
    ////////////////////////////////////////////////////////// BN //////////////////////////////////////////////////////////

    if ( $_GET[ "output" ] == 'BN' )
    {
        $s_PhpClassName = ucfirst( $o_Entity[ "name" ] ).'BN';
        $s_PhpBaseClassName = $s_Base.$s_PhpClassName;
        $s_PhpFileName = $s_PhpClassName.".class.php";

        /* concatenamos el codigo php ( class ) */
        $s_PhpCode = "/* Metodos de acceso a los campos de la tabla ".$o_Entity[ "physical_name" ]." redefinidos por el usuario */<br>";
        $s_PhpCode .= "class ".$s_PhpClassName." extends ".$s_PhpBaseClassName."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= "}";
    }

    ////////////////////////////////////////////////////////// BBV //////////////////////////////////////////////////////////
    if ( $_GET[ "output" ] == "BBV" )
    {
        $s_PhpClassName = $s_Base.ucfirst( $o_Entity[ "name" ] )."BV";
        $s_PhpBaseClassName = ucfirst( $o_Entity[ "name" ] )."BN";
        $s_PhpFileName = ucfirst( $s_PhpClassName).".class.php";

        /* concatenamos el codigo php ( class ) */
        $s_PhpCode = "/* Autor...: William L. Taype Perez */<br>";
        $s_PhpCode .= "/* Esquema.: ".$_GET[ "file" ]." */<br>";
        $s_PhpCode .= "/* Generado: ".date( "Y-m-d H:i:s" )." */<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "/* Validacion del contenido de los campos campos de la tabla ".$o_Entity[ "physical_name" ]." */<br>";
        $s_PhpCode .= "abstract class ".$s_PhpClassName." extends ".$s_PhpBaseClassName."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= $s_Tab."/* Contiene la clase que valida el tipo de dato */<br>";
        $s_PhpCode .= $s_Tab."private \$o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.<br>";
        $s_PhpCode .= $s_Tab."private \$s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.<br><br>";

        /* concatenamos el codigo php ( constructor / setDefault ) */
        $s_PhpCode .= $s_Tab."/* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */<br>";
        $s_PhpCode .= $s_Tab."public function __construct()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."/* Establecemos el objeto que realizara la validacion del tipo de dato */<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->o_Validator = new utilValidDataType();<br><br>";
        
        $s_PhpCode .= $s_Tab.$s_Tab."/* Establecemos los valores por defecto */<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( $a_Column[ "default" ]!= "" )
            {
                $s_PhpCode .= $s_Tab.$s_Tab."\$this->set".ucfirst( $a_Column[ "name" ] )."( ";
                if( $a_Column[ "default" ] == "CURRENT_TIMESTAMP" )
                {
                    $s_PhpCode .= "date( \"Y-m-d H:i:s\" )";
                }
                else
                {
                    $s_PhpCode .= str_replace( "'", '"', $a_Column[ "default" ] );
                }
                $s_PhpCode .= " );<br>";
            }
        }
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        /* concatenamos el codigo php ( validate ) */
        $s_PhpCode .= $s_Tab."/* Valida en tipo de dato */<br>";
        $s_PhpCode .= $s_Tab."private function validateData( \$u_Data, \$s_DataType, \$i_Length, \$i_Decimal, \$b_NotNull )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->s_ValidatorMessage = null;<br>";
        
        //$s_PhpCode .= $s_Tab.$s_Tab."if( ( ( \$s_DataType == \"CHAR\" ) || ( \$s_DataType == \"VARCHAR\" ) ) && ( trim( \$u_Data ) == \"\" ) )<br>";
        //$s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        //$s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$u_Data = null;<br>";
        //$s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        
        $s_PhpCode .= $s_Tab.$s_Tab."if( !\$this->o_Validator->validate( \$u_Data, \$s_DataType, \$i_Length, \$i_Decimal, \$b_NotNull ) )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$this->s_ValidatorMessage = \$this->o_Validator->getMessage();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return is_null( \$this->s_ValidatorMessage );<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        /* concatenamos el codigo php ( set ) */
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab."/* Valida y establece el valor del campo ".$a_Column[ "name" ]." */<br>";
            $s_PhpCode .= $s_Tab."public function set".ucfirst( $a_Column[ "name" ] )."( \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] ).", \$b_ValidateData = true )<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            
            /* validacion de campo restricted */
            if ( $a_Column[ "primary" ] )
            {
                /*
                $s_PhpCode .= $s_Tab.$s_Tab."if ( ";
                $s_PhpCode .= "\$this->get".ucfirst( $a_Column[ "name" ] )."() && \$this->get".ucfirst( $a_Column[ "name" ] )."() !== \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." )<br>";
                $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El campo '".$a_Column[ "name" ]."' es un campo restringido.\" );<br>";
                $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
                */
            }
            
            /* validacion del valor del campo */
            
            $s_PhpCode .= $s_Tab.$s_Tab."if ( \$b_ValidateData == true )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
            
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."if ( !\$this->validateData( \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] ).", \"".strtoupper( $a_Column[ "datatype" ] )."\", ".( $a_Column[ "length" ] ? $a_Column[ "length" ] : "0" ).", ".( $a_Column[ "decimal" ] ? $a_Column[ "decimal" ] : "0" ).", ".( $a_Column[ "not_null" ] ? "true" : "false" )." ) )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El campo ".$a_Column[ "name" ]." \".strtolower( \$this->s_ValidatorMessage ) );<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
            
            /* validacion del campo ( regla de validacion ) */
            if ( is_array( $a_Column[ "valid" ] ) )
            {
                switch ( $a_Column[ "domain" ] )
                {
                    case "Number":
                        $s_Separator= "";
                        $s_Separator2= "";
                        break;
                        
                    default:
                        $s_Separator= "'";
                        $s_Separator2= "\"";
                        break;
                }
                switch ( $a_Column[ "valid" ][ "type" ] )
                {
                    case "1":
                        $s_Condition = "";
                        $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." ) && !(";
                        if ( !is_null( $a_Column[ "valid" ][ "min_value" ] ) )
                        {
                            $s_PhpCode .= " \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." >= ".$s_Separator2.$a_Column[ "valid" ][ "min_value" ].$s_Separator2;
                            $s_Condition= " && ";
                        }
                        if ( !is_null( $a_Column[ "valid" ][ "max_value" ] ) )
                        {
                            $s_PhpCode .= $s_Condition." \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." <= ".$s_Separator2.$a_Column[ "valid" ][ "max_value" ].$s_Separator2;
                        }
                        $s_PhpCode .= " ) )<br>";
                        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
                        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El campo '".$a_Column[ "name" ]."' debe ser ";
                        if ( !is_null( $a_Column[ "valid" ][ "min_value" ] ) )
                        {
                            $s_PhpCode .= "mayor o igual a ".$s_Separator.$a_Column[ "valid" ][ "min_value" ].$s_Separator;
                            $s_Condition= " y ";
                        }
                        if ( !is_null( $a_Column[ "valid" ][ "max_value" ] ) )
                        {
                            $s_PhpCode .= $s_Condition."menor o igual a ".$s_Separator.$a_Column[ "valid" ][ "max_value" ].$s_Separator;
                        }
                        $s_PhpCode .= ".\" );<br>";
                        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
                        break;
                        
                    case "2":
                        $s_Condition= "";
                        $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." ) && !(";
                        foreach ( $a_Column[ "valid" ][ "values" ] as $s_Value )
                        {
                            $s_PhpCode .= $s_Condition." \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." === ".$s_Separator2.$s_Value.$s_Separator2;
                            $s_Condition= " || ";
                        }
                        $s_PhpCode .= " ) )<br>";
                        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
                        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El campo '".$a_Column[ "name" ]."' solo debe contener: ";
                        $s_Condition= "";
                        foreach ( $a_Column[ "valid" ][ "values" ] as $s_Value )
                        {
                            $s_PhpCode .= $s_Condition.$s_Separator.$s_Value.$s_Separator;
                            $s_Condition= ", ";
                        }
                        $s_PhpCode .= ".\" );<br>";
                        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
                        break;
                }
            }
            $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."parent::set".ucfirst( $a_Column[ "name" ] )."( \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." );<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."return true;<br>";
            $s_PhpCode .= $s_Tab."}<br><br>";
        }

        /* concatenamos el codigo php ( validate ) */
        $s_PhpCode .= $s_Tab."/* Valida el contenido del registro */<br>";
        $s_PhpCode .= $s_Tab."public function validateRecord()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( !$a_Column[ "primary" ] )
            {
                $s_PhpCode .= $s_Tab.$s_Tab."\$this->set".ucfirst( $a_Column[ "name" ] )."( \$this->get".ucfirst( $a_Column[ "name" ] )."(), true );<br>";
            }
            else 
            {
                $s_PhpCode .= $s_Tab.$s_Tab."\$this->set".ucfirst( $a_Column[ "name" ] )."( \$this->get".ucfirst( $a_Column[ "name" ] )."(), false );<br>";
            }
        }
        $s_PhpCode .= $s_Tab.$s_Tab."return true;<br>";
        $s_PhpCode .= $s_Tab."}<br>";

        /* fin de la concatenacion del codigo php */
        $s_PhpCode .= "}";
    }

    ////////////////////////////////////////////////////////// BV //////////////////////////////////////////////////////////

    if ( $_GET[ "output" ] == "BV" )
    {
        $s_PhpClassName = ucfirst( $o_Entity[ "name" ] ).'BV';
        $s_PhpBaseClassName = $s_Base.$s_PhpClassName;
        $s_PhpFileName = $s_PhpClassName.".class.php";

        /* concatenamos el codigo php ( class ) */
        $s_PhpCode = "/* validacion del contenido de los campos de la tabla ".$o_Entity[ "physical_name" ]." redefinidos por el usaurio */<br>";
        $s_PhpCode .= "class ".$s_PhpClassName." extends ".$s_PhpBaseClassName."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= "}";
    }

    ////////////////////////////////////////////////////////// BDP //////////////////////////////////////////////////////////

    if ( $_GET[ "output" ] == "BDP" )
    {
        $s_PhpClassName = $s_Base.ucfirst( $o_Entity[ "name" ] )."DP";
        $s_PhpClassNameBN = ucfirst( $o_Entity[ "name" ] )."BN";
        $s_PhpBaseClassName = ucfirst( $o_Entity[ "name" ] )."BV";
        $s_PhpFileName = ucfirst( $s_PhpClassName ).".class.php";

        /* concatenamos el codigo php ( class ) */
        $s_PhpCode = "/* Autor...: William L. Taype Perez */<br>";
        $s_PhpCode .= "/* Esquema.: ".$_GET[ "file" ]." */<br>";
        $s_PhpCode .= "/* Generado: ".date( "Y-m-d H:i:s" )." */<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "/* Mantenimiento de los registros de la tabla ".$o_Entity[ "physical_name" ]." */<br>";
        $s_PhpCode .= "abstract class ".$s_PhpClassName." extends ".$s_PhpBaseClassName."<br>";
        $s_PhpCode .= "{<br>";
        
        /* concatenamos el codigo php ( __construct ) */
        $s_PhpCode .= $s_Tab."/* Constructor ( Establece los valores desde un objeto ".$s_PhpClassNameBN." ) */<br>";
        $s_PhpCode .= $s_Tab."public function __construct( ".$s_PhpClassNameBN." \$o_".$s_PhpClassNameBN." = null )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."parent::__construct();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$o_".$s_PhpClassNameBN." ) )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$this->setByBN( \$o_".$s_PhpClassNameBN." );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        /* concatenamos el codigo php ( setByBN ) */
        $s_PhpCode .= $s_Tab."/* Establece los valores desde un objeto ".$s_PhpClassNameBN." */<br>";
        $s_PhpCode .= $s_Tab."public function setByBN( ".$s_PhpClassNameBN." \$o_".$s_PhpClassNameBN." )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$o_".ucfirst( $o_Entity[ "name" ] )."BN->get".ucfirst( $a_Column[ "name" ] )."() ) )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$this->set".ucfirst( $a_Column[ "name" ] )."( \$o_".ucfirst( $o_Entity[ "name" ] )."BN->get".ucfirst( $a_Column[ "name" ] )."() );<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        }
        $s_PhpCode .= $s_Tab."}<br><br>";

        /* concatenamos el codigo php ( save ) */
        $s_PhpCode .= $s_Tab."/* Graba un nuevo registro */<br>";
        $s_PhpCode .= $s_Tab."public function save()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->validateRecord();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_".$o_Entity[ "name" ]."FN = new ".ucfirst( $o_Entity[ "name" ] )."FN();<br>";
        $s_PhpCode2  = "";
        $s_Separator = "";
        $b_Control   = false; //se valida si tiene primary keys sino se inserta de frente.
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( $a_Column[ "primary" ] )
            {
                $b_Control   = true;
                $s_PhpCode2  .= $s_Separator."\$this->get".ucfirst( $a_Column[ "name" ] )."()";
                $s_Separator = ", ";
            }
        }
        if( $b_Control )
        {
            $s_PhpCode .= $s_Tab.$s_Tab."\$o_".$o_Entity[ "name" ]."BN = \$o_".$o_Entity[ "name" ]."FN->selectByPk( ";
            $s_PhpCode .= $s_PhpCode2;
            $s_PhpCode .= " );<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."if ( is_null( \$o_".$o_Entity[ "name" ]."BN ) )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery1 = \"INSERT INTO ".$o_Entity[ "physical_name" ]." ( \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery2 = \"VALUES ( \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_Separator = \"\";<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."if ( !is_null( \$this->get".ucfirst( $a_Column[ "name" ] )."() ) )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery1 .= \$s_Separator.\"".$a_Column[ "physical_name" ]."\";<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery2 .= \$s_Separator.\"".$a_Column[ "delimiter" ]."\".\$this->get".ucfirst( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ]."\";<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_Separator = \", \";<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery = \$s_SQLQuery1.\" ) \".\$s_SQLQuery2.\" );\";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$i_Afectos = Connection::getConexion()->executeUpdate( \$s_SQLQuery );<br>";
        if( $b_Control )
        {
            $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."else<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El id ya esta registrado.\" );<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab."return \$i_Afectos;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        /* concatenamos el codigo php ( update ) */
        $s_PhpCode .= $s_Tab."/* Actualiza los datos del registro */<br>";
        $s_PhpCode .= $s_Tab."public function update()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->validateRecord();<br>";
        //$s_PhpCode .= $s_Tab.$s_Tab."\$o_".$o_Entity[ "name" ]."FN = new ".ucfirst( $o_Entity[ "name" ] )."FN();<br>";
        $s_Separator = "";
        $s_PhpCode .= $s_Tab.$s_Tab."if ( true )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery = \"UPDATE ".$o_Entity[ "physical_name" ]." SET \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_Separator = \"\";<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( !$a_Column[ "primary" ] )
            {
                $s_Comentario = "";
                if( $a_Column[ "name" ] == "fecharegistro" || $a_Column[ "name" ]=="usuarioregistro" )
                {
                    $s_Comentario = "//";
                }
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."if ( !is_null( \$this->get".ucfirst( $a_Column[ "name" ] )."() ) )<br>"; //&& \$this->get".ucfirst( $a_Column[ "name" ] )."()
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab.$s_Comentario."\$s_SQLQuery .= \$s_Separator.\"".$a_Column[ "physical_name" ]." = ".$a_Column[ "delimiter" ]."\".\$this->get".ucfirst( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ]."\";<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab.$s_Comentario."\$s_Separator = \", \";<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
            }
        }
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \" WHERE ";
        $s_And = "";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( $a_Column[ "primary" ] )
            {
                $s_PhpCode .= $s_And." ".$a_Column[ "physical_name" ]." = ".$a_Column[ "delimiter" ]."\".\$this->get".ucfirst( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ]."";
                $s_And = " AND ";
            }
        }
        $s_PhpCode .= ";\";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$i_Afectos = Connection::getConexion()->executeUpdate( \$s_SQLQuery );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."else<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El id no esta registrado.\" );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return \$i_Afectos;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        /* concatenamos el codigo php ( delete ) */
        $s_PhpCode .= $s_Tab."/* Elimina el registro */<br>";
        $s_PhpCode .= $s_Tab."public function delete()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        //$s_PhpCode .= $s_Tab.$s_Tab."\$o_".$o_Entity[ "name" ]."FN = new ".ucfirst( $o_Entity[ "name" ] )."FN();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery = \"DELETE FROM ".$o_Entity[ "physical_name" ]." WHERE ";
        $s_And = "";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( $a_Column[ "primary" ] )
            {
                $s_PhpCode .= $s_And." ".$a_Column[ "physical_name" ]." = ".$a_Column[ "delimiter" ]."\".\$this->get".ucfirst( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ]."";
                $s_And = " AND ";
            }
        }
        $s_PhpCode .= ";\";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return Connection::getConexion()->executeUpdate( \$s_SQLQuery );<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";       
        /* fin de la concatenacion del codigo php */
        $s_PhpCode .= "}";
    }

    ////////////////////////////////////////////////////////// DP //////////////////////////////////////////////////////////

    if ( $_GET[ "output" ] == "DP" )
    {
        $s_PhpClassName = ucfirst( $o_Entity[ "name" ] ).'DP';
        $s_PhpBaseClassName = $s_Base.$s_PhpClassName;
        $s_PhpFileName = $s_PhpClassName.".class.php";

        /* concatenamos el codigo php ( class ) */
        $s_PhpCode = "/* Mantenimiento de los registros de la tabla ".$o_Entity[ "physical_name" ]." redefinidos por el usaurio */<br>";
        $s_PhpCode .= "class ".$s_PhpClassName." extends ".$s_PhpBaseClassName."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= "}";
    }

    ////////////////////////////////////////////////////////// BFN //////////////////////////////////////////////////////////

    if ( $_GET[ "output" ] == "BFN" )
    {
        $s_PhpClassName = $s_Base.ucfirst( $o_Entity[ "name" ] ).'FN';
        $s_PhpClassNameBN = ucfirst( $o_Entity[ "name" ] ).'BN';
        $s_PhpBaseClassName = ucfirst( $o_Entity[ "name" ] ).'BN';
        $s_PhpFileName = $s_PhpClassName.".class.php";

        /* concatenamos el codigo php ( class ) */
        $s_PhpCode = "/* Autor...: William L. Taype Perez */<br>";
        $s_PhpCode .= "/* Esquema.: ".$_GET[ "file" ]." */<br>";
        $s_PhpCode .= "/* Generado: ".date( "Y-m-d H:i:s" )." */<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "/* Busqueda de registros de la tabla ".$o_Entity[ "physical_name" ].". */<br>";
        $s_PhpCode .= "abstract class ".$s_PhpClassName." extends ".$s_PhpBaseClassName."<br>";
        $s_PhpCode .= "{<br>";
        
        /* declaracion de constantes */
        $s_PhpCode .= $s_Tab."/* Declaracion de constantes */<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab."const ".ucfirst( $a_Column[ "name" ] )." = \"".$o_Entity[ "physical_name" ].".".( $a_Column[ "physical_name" ] )."\";<br>";
        }
        $s_PhpCode .= "<br>";
        $s_PhpCode .= $s_Tab."public \$a_Condition = array();<br>";
        $s_PhpCode .= $s_Tab."public \$a_OrderBy = array();<br>";
        $s_PhpCode .= $s_Tab."public \$a_GroupBy = array();<br>";
        
        /* concatenamos el codigo php ( getConnect ) */
        $s_PhpCode .= $s_Tab."/* Obtiene una conexion a la base de datos */<br>";
        $s_PhpCode .= $s_Tab."public function getConnect()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return Connection::getConexion();<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        /* concatenamos el codigo php ( getSelectColumns ) */
        $s_PhpCode .= $s_Tab."/* Obtiene la cadena de columas */<br>";
        $s_PhpCode .= $s_Tab."public function getSelectColumns()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_Concat = "";
        $s_Separator = ", ";
        $i_Count = 0;
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $i_Count++;
            if ( $i_Count == count( $o_Entity[ "column" ] ) ) $s_Separator = " ";
            $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery ".$s_Concat."= \"".$o_Entity[ "physical_name" ].".".$a_Column[ "physical_name" ]." AS ".$a_Column[ "name" ].$s_Separator."\";<br>";
            $s_Concat = ".";
        }
        $s_PhpCode .= $s_Tab.$s_Tab."return \$s_SQLQuery;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        /* concatenamos el codigo php ( addCondition ) */
        $s_PhpCode .= $s_Tab."/* Establece el condicion de filtro de la lista resultante */<br>";
        $s_PhpCode .= $s_Tab."public function addCondition( \$s_Const, \$s_Operator, \$u_Value, \$b_ComSimple = true )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->a_Condition[] = array( \"COLUMN\" => \$s_Const, \"OPERATOR\" => \$s_Operator, \"VALUE\" => \$u_Value, \"FLAG_COMILLAS\" => \$b_ComSimple );<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        /* concatenamos el codigo php ( addOrderBy ) */
        $s_PhpCode .= $s_Tab."/* Establece el orden de la lista resultante */<br>";
        $s_PhpCode .= $s_Tab."public function addOrderBy( \$s_Const, \$b_OrderAsc = true )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->a_OrderBy[] = array( \"COLUMN\" => \$s_Const, \"ASC\" => \$b_OrderAsc );<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        /* concatenamos el codigo php ( addGroupBy ) */
        $s_PhpCode .= $s_Tab."/* Establece el orden de la lista resultante */<br>";
        $s_PhpCode .= $s_Tab."public function addGroupBy( \$s_Const )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->a_GroupBy[] = array( \"COLUMN\" => \$s_Const );<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        /* concatenamos el codigo php ( setByBN ) */
        $s_PhpCode .= $s_Tab."/* Establece los valores desde un objeto ".$s_PhpClassNameBN." */<br>";
        $s_PhpCode .= $s_Tab."public function setByBN( ".$s_PhpClassNameBN." \$o_".$s_PhpClassNameBN." )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$o_".ucfirst( $o_Entity[ "name" ] )."BN->get".ucfirst( $a_Column[ "name" ] )."() ) )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$this->set".ucfirst( $a_Column[ "name" ] )."( \$o_".ucfirst( $o_Entity[ "name" ] )."BN->get".ucfirst( $a_Column[ "name" ] )."() );<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        }
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        /* concatenamos el codigo php ( selectByPK ) */
        $s_PhpCode .= $s_Tab."/**<br>";
        $s_PhpCode .= $s_Tab."* @return ".ucfirst( $o_Entity[ "name" ] )."BN|null<br>";
        $s_PhpCode .= $s_Tab."* @throws SQLException<br>";
        $s_PhpCode .= $s_Tab."*/<br>";
        $s_PhpCode .= $s_Tab."public function selectByPK( ";
        $s_Separator= "";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( $a_Column[ "primary" ] )
            {
                $s_PhpCode .= $s_Separator."\$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] );
                $s_Separator= ", ";
            }
        }
        $s_PhpCode .= " )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( $a_Column[ "primary" ] )
            {
                $s_PhpCode .= $s_Tab.$s_Tab."if( is_null( \$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." ) ){ ";
                $s_PhpCode .= "\$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] )." = ".$a_Column[ "delimiter" ]."-1".$a_Column[ "delimiter" ].";";
                $s_PhpCode .= " } <br>";
            }
        }
        $s_PhpCode .= " <br>";
        
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery = \"SELECT \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \$this->getSelectColumns();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \"FROM ".$o_Entity[ "physical_name" ]." \";<br>";
        $s_Separator = "WHERE ";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            if ( $a_Column[ "primary" ] )
            {
                $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \"".$s_Separator.$a_Column[ "physical_name" ]." = ".$a_Column[ "delimiter" ]."\".\$".$a_Column[ "prefix" ]."_".ucfirst( $a_Column[ "name" ] ).".\"".$a_Column[ "delimiter" ]." \";<br>";
                $s_Separator = "AND ";
            }
        }
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \"LIMIT 1;\";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_".ucfirst( $o_Entity[ "name" ] )."BN = null;<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_ResultSet = \$o_ResultSet = \$this->getConnect()->executeQuery( \$s_SQLQuery );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if( \$o_ResultSet->num_rows > 0 )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$a_SQLRow = \$o_ResultSet->fetch_assoc(); //devuele array<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$o_".ucfirst( $o_Entity[ "name" ] )."BN = \$this->insertObjectBN( \$a_SQLRow );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return \$o_".ucfirst( $o_Entity[ "name" ] )."BN;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        //BUILDCONSULT
        $s_PhpCode .= $s_Tab."public function buildConsult()<br>".$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery = \"\";<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$this->get".ucfirst( $a_Column[ "name" ] )."() ) ) \$s_SQLQuery .= \"".$o_Entity[ "physical_name" ].".".$a_Column[ "physical_name" ]." = ".$a_Column[ "delimiter" ]."\".\$this->get".ucfirst( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ]." AND \";<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab."if( count( \$this->a_Condition ) > 0 )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."foreach ( \$this->a_Condition as \$a_Condition )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."if( \$a_Condition['FLAG_COMILLAS'] )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \$a_Condition[ \"COLUMN\" ].\" \".\$a_Condition[ \"OPERATOR\" ].\" '\".\$a_Condition[ \"VALUE\" ].\"' AND \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."else<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \$a_Condition[ \"COLUMN\" ].\" \".\$a_Condition[ \"OPERATOR\" ].\" \".\$a_Condition[ \"VALUE\" ].\" AND \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \"1 = 1 \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return \$s_SQLQuery;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        //FIN BUILDCONSULT
        
        //SELECTNUMROWS
        $s_PhpCode .= $s_Tab."public function selectNumRows()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery = \"SELECT \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \"COUNT(*) AS cnt \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \"FROM " . $o_Entity["physical_name"] . " WHERE \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \$this->buildConsult();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."<br>";
        //procedimiento para el GROUP BY
        $s_PhpCode .= $s_Tab.$s_Tab."if ( count( \$this->a_GroupBy ) > 0 )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \"GROUP BY \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_Separator = \"\";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."foreach ( \$this->a_GroupBy as \$a_GroupBy )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \$s_Separator.\$a_GroupBy[ \"COLUMN\" ].\" \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_Separator = \", \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_ResultSet = \$this->getConnect()->executeQuery( \$s_SQLQuery );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$a_Data = \$o_ResultSet->fetch_assoc();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return intval( \$a_Data['cnt'] );<br>";
        $s_PhpCode.= $s_Tab."}<br><br>";
        //FIN SELECTNUMROWS
        
        /* concatenamos el codigo php ( select ) */
        $s_PhpCode .= $s_Tab."/**<br>";
        $s_PhpCode .= $s_Tab."* @param null \$i_Position<br>";
        $s_PhpCode .= $s_Tab."* @param null \$i_Rows<br>";
        $s_PhpCode .= $s_Tab."* @return ".ucfirst( $o_Entity[ "name" ] )."BN[]<br>";
        $s_PhpCode .= $s_Tab."* @throws SQLException<br>";
        $s_PhpCode .= $s_Tab."*/<br>";
        $s_PhpCode .= $s_Tab."public function select( \$i_Position = null, \$i_Rows = null )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery = \"SELECT \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \$this->getSelectColumns();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \"FROM ".$o_Entity[ "physical_name" ]." WHERE \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \$this->buildConsult();<br>";
        //procedimiento para el GROUP BY
        $s_PhpCode .= $s_Tab.$s_Tab."if ( count( \$this->a_GroupBy ) > 0 )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \"GROUP BY \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_Separator = \"\";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."foreach ( \$this->a_GroupBy as \$a_GroupBy )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \$s_Separator.\$a_GroupBy[ \"COLUMN\" ].\" \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_Separator = \", \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        //procedimiento para el ORDER BY
        $s_PhpCode .= $s_Tab.$s_Tab."if ( count( \$this->a_OrderBy ) > 0 )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery = \$s_SQLQuery.\"ORDER BY \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_Separator = \"\";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."foreach ( \$this->a_OrderBy as \$a_OrderBy )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \$s_Separator.\$a_OrderBy[ \"COLUMN\" ].\" \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."if ( \$a_OrderBy[ \"ASC\" ] === false ) \$s_SQLQuery .= \"DESC \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$s_Separator = \", \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if( !is_null( \$i_Position ) && is_null( \$i_Rows ) ) \$s_SQLQuery .= \"LIMIT \".\$i_Position;<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if( !is_null( \$i_Position ) && !is_null( \$i_Rows ) ) \$s_SQLQuery .= \"LIMIT \".\$i_Position.\", \".\$i_Rows;<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \";\";<br><br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$a_".ucfirst( $o_Entity[ "name" ] )."BN = array();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_ResultSet = \$this->getConnect()->executeQuery( \$s_SQLQuery );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if( \$o_ResultSet->num_rows > 0 )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."while( \$a_SQLRow = \$o_ResultSet->fetch_assoc() ) <br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$o_".ucfirst( $o_Entity[ "name" ] )."BN = \$this->insertObjectBN( \$a_SQLRow );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$a_".ucfirst( $o_Entity[ "name" ] )."BN[] = \$o_".ucfirst( $o_Entity[ "name" ] )."BN;<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return \$a_".ucfirst( $o_Entity[ "name" ] )."BN;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        /* concatenamos el codigo php ( insertObjectBN ) */
        $s_PhpCode .= $s_Tab."/* Devuelve un objeto ".ucfirst( $o_Entity[ "name" ] )."BN desde un objeto propel */<br>";
        $s_PhpCode .= $s_Tab."public function insertObjectBN( \$a_".ucfirst( $o_Entity[ "name" ] )." )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_".ucfirst( $o_Entity[ "name" ] )."BN = new ".ucfirst( $o_Entity[ "name" ] )."BN();<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_Field1 = "\$a_".ucfirst( $o_Entity[ "name" ] )."['".$a_Column[ "name" ]."']";
            $s_Field2 = str_replace( "@", $s_Field1, $a_Column[ "cast" ] );
            $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( ".$s_Field1." ) ) \$o_".ucfirst( $o_Entity[ "name" ] )."BN->set".ucfirst( $a_Column[ "name" ] )."( ".$s_Field2." );<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab."return \$o_".ucfirst( $o_Entity[ "name" ] )."BN;<br>";
        $s_PhpCode .= $s_Tab."}<br>";

        /* fin de la concatenacion del codigo php */
        $s_PhpCode .= "}";
    }

    ////////////////////////////////////////////////////////// FN //////////////////////////////////////////////////////////

    if ( $_GET[ "output" ] == "FN" )
    {
        $s_PhpClassName = ucfirst( $o_Entity[ "name" ] )."FN";
        $s_PhpBaseClassName = $s_Base.$s_PhpClassName;
        $s_PhpFileName = $s_PhpClassName.".class.php";

        /* concatenamos el codigo php ( class ) */
        $s_PhpCode = "/* Busqueda de registros de la tabla ".$o_Entity[ "physical_name" ]." redefinidos por el usuario. */<br>";
        $s_PhpCode .= "class ".$s_PhpClassName." extends ".$s_PhpBaseClassName."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= "}";
    }
    
    ////////////////////////////////////////////////////////// -- //////////////////////////////////////////////////////////

    list( $s_NombreXml, $sExtencionXml ) = explode( ".", $s_fileXML );
    $s_NombreXml = "repositorio";
    if ( !file_exists( $s_NombreXml ) )
    {
        mkdir( $s_NombreXml );
    }
    if ( !file_exists( $s_NombreXml."/".strtolower( $_GET[ "output" ] ) ) )
    {
        mkdir( $s_NombreXml."/".strtolower( $_GET[ "output" ] ) );
    }
    
    $i_archivo = fopen( $s_NombreXml."/".strtolower( $_GET[ "output" ] )."/".$s_PhpFileName, "w" );
    $s_clase = "<?php<br>".$s_PhpCode."<br>";
    $s_clase = str_replace( "<br>", "\n", $s_clase);
    $s_clase = str_replace( "&nbsp;&nbsp;&nbsp;&nbsp;", "    ", $s_clase);
    $s_clase = str_replace( "&nbsp;", " ", $s_clase);
    fputs ( $i_archivo, $s_clase );
    fclose( $i_archivo );
    ?>
    <div style = "margin: 5px 20px 20px;">
    <div class= "smallfont" style = "margin-bottom: 2px;">codigo PHP: <?php echo $s_PhpFileName; ?></div>
    <div class= "alt2" dir= "ltr" style = "border: 1px inset ; margin: 0px; padding: 6px; overflow: auto; width: 100%; height: 60%; text-align: left;">
    <code style = "white-space: nowrap;">
    <code><?php echo $s_PhpCode ?></code>
    </code>
    </div>
    </div>
    <?php
}
?>