<?php

namespace LeadTime\Label\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\View\LayoutInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Serialize\SerializerInterface;

class CheckoutCartAddObserver implements ObserverInterface
{
    protected $request;
    private   $serializer;
    protected $layout;
    protected $storeManager;

    public function __construct( RequestInterface $request, SerializerInterface $serializer, StoreManagerInterface $storeManager, LayoutInterface $layout )
    {
        $this->_request     = $request;
        $this->serializer   = $serializer;
        $this->layout       = $layout;
        $this->storeManager = $storeManager;
    }

    public function execute( \Magento\Framework\Event\Observer $observer )
    {
        $item              = $observer->getQuoteItem();
        $additionalOptions = array();
        $product           = $observer->getProduct();
        $productId         = $product->getId();
        $objectManager     = \Magento\Framework\App\ObjectManager::getInstance();
        $StockState        = $objectManager->get( '\Magento\CatalogInventory\Api\StockStateInterface' );
        $qty               = $StockState->getStockQty( $product->getId(), $product->getStore()->getWebsiteId() );
        if( $qty > 0 )
        {
            $label = 'Product Instock Lead Time: 7 -21 days';
        }
        else
        {
            $label = 'Special Order Lead Time: 16 - 22 Weeks';
        }
        if( $additionalOption = $item->getOptionByCode( 'additional_options' ) )
        {
            $additionalOptions = $this->serializer->unserialize( $additionalOption->getValue() );
        }
        $additionalOptions[] = [
            'label' => 'Lead Time',
            'value' => $label
        ];
        if( !is_null( $additionalOptions ) )
        {
            $item->addOption( array(
                'product_id' => $item->getProductId(),
                'code'       => 'additional_options',
                'value'      => $this->serializer->serialize( $additionalOptions )
            ) );
        }
    }
}