<?php
class sfContext
{
    protected
    $actionStack       = null,
    $controller        = null,
    $databaseManager   = null,
    $request           = null,
    $response          = null,
    $storage           = null,
    $viewCacheManager  = null,
    $i18n              = null,
    $logger            = null,
    $user              = null;
    protected static
    $instance          = null;
    public static function removeInstance()
    {
        self::$instance = null;
    }
    protected function initialize()
    {
        /*
        $this->logger = sfLogger::getInstance();

        $this->actionStack = new sfActionStack();
        // 'config/factories.yml' config file
        // auto-generated by sfFactoryConfigHandler
        // date: 2010/05/14 10:14:21
        $this->controller = sfController::newInstance(sfConfig::get('sf_factory_controller', 'sfFrontWebController'));
        $this->request = sfRequest::newInstance(sfConfig::get('sf_factory_request', 'sfWebRequest'));
        $this->response = sfResponse::newInstance(sfConfig::get('sf_factory_response', 'sfWebResponse'));
        $this->storage = sfStorage::newInstance(sfConfig::get('sf_factory_storage', 'sfSessionStorage'));
        $this->user = sfUser::newInstance(sfConfig::get('sf_factory_user', 'myUser'));
        $this->controller->initialize($this);
        $this->request->initialize($this, sfConfig::get('sf_factory_request_parameters', NULL), sfConfig::get('sf_factory_request_attributes', array()));
        $this->response->initialize($this, sfConfig::get('sf_factory_response_parameters', NULL));
        $this->storage->initialize($this, sfConfig::get('sf_factory_storage_parameters', array (
        'session_name' => 'symfony',
        )));
        $this->user->initialize($this, sfConfig::get('sf_factory_user_parameters', NULL));
        if (sfConfig::get('sf_cache'))
        {
        $this->viewCacheManager = new sfViewCacheManager();
        $this->viewCacheManager->initialize($this, sfConfig::get('sf_factory_view_cache', 'sfFileCache'), sfConfig::get('sf_factory_view_cache_parameters', array (
        'automaticCleaningFactor' => 0,
        'cacheDir' => '/var/www/sflstore/cache/im/prod/template',
        )));
        }
        */
        register_shutdown_function( array( $this, 'shutdown' ) );
    }
    public static function getInstance()
    {
        if (!isset(self::$instance))
        {
            $class = __CLASS__;
            self::$instance = new $class();
            self::$instance->initialize();
        }
        return self::$instance;
    }
    public static function hasInstance()
    {
        return isset(self::$instance);
    }
    public function getActionName()
    {
        if ($this->actionStack && $lastEntry = $this->actionStack->getLastEntry())
        {
            return $lastEntry->getActionName();
        }
    }
    public function getActionStack()
    {
        return $this->actionStack;
    }
    public function getController()
    {
        return $this->controller;
    }
    public function getLogger()
    {
        return $this->logger;
    }
    public function getDatabaseConnection($name = 'default')
    {
        if ($this->databaseManager != null)
        {
            return $this->databaseManager->getDatabase($name)->getConnection();
        }
        return null;
    }
    public function retrieveObjects($class, $peerMethod)
    {
        $retrievingClass = 'sf'.ucfirst(sfConfig::get('sf_orm', 'propel')).'DataRetriever';
        return call_user_func(array($retrievingClass, 'retrieveObjects'), $class, $peerMethod);
    }
    public function getDatabaseManager()
    {
        return $this->databaseManager;
    }
    public function getModuleDirectory()
    {
        if ($this->actionStack && $lastEntry = $this->actionStack->getLastEntry())
        {
            return sfConfig::get('sf_app_module_dir').'/'.$lastEntry->getModuleName();
        }
    }
    public function getModuleName()
    {
        if ($this->actionStack && $lastEntry = $this->actionStack->getLastEntry())
        {
            return $lastEntry->getModuleName();
        }
    }
    public function getCurrentViewInstance()
    {
        if ($this->actionStack && $lastEntry = $this->actionStack->getLastEntry())
        {
            return $lastEntry->getViewInstance();
        }
    }
    public function getRequest()
    {
        return $this->request;
    }
    public function getResponse()
    {
        return $this->response;
    }
    public function setResponse($response)
    {
        $this->response = $response;
    }
    public function getStorage()
    {
        return $this->storage;
    }
    public function getViewCacheManager()
    {
        return $this->viewCacheManager;
    }
    public function getI18N()
    {
        if (!$this->i18n && sfConfig::get('sf_i18n'))
        {
            $this->i18n = sfI18N::getInstance();
            $this->i18n->initialize($this);
        }
        return $this->i18n;
    }
    public function getUser()
    {
        return $this->user;
    }
    public function shutdown()
    {
        //echo "Se cerro";
        /*
        $this->getUser()->shutdown();
        $this->getStorage()->shutdown();
        $this->getRequest()->shutdown();
        $this->getResponse()->shutdown();
        if (sfConfig::get('sf_logging_enabled'))
        {
        $this->getLogger()->shutdown();
        }
        if (sfConfig::get('sf_use_database'))
        {
        $this->getDatabaseManager()->shutdown();
        }
        if (sfConfig::get('sf_cache'))
        {
        $this->getViewCacheManager()->shutdown();
        }
        */
    }
}