<?php
// antes -> extends sfBasicSecurityUser
class myUser extends sfUser
{

    protected static $instance = null;

    /**
     * @return myUser|null
     */
    public static function getUser()
    {
        if( ! isset( self::$instance ) )
        {
            $class = __CLASS__;
            self::$instance = new $class();
            // self::$instance->initialize();
        }
        return self::$instance;
    }

    public function signIn( $login, $password )
    {
        $isLoginOk = false;
        $TipoProc  = "";
        $user = new user_class();
        // nickname exists?
        if( $user->findUser( $login ) )
        {
            $o_SEG_UsuarioBN = $this->getObjectUsuario( $login );
            if( $o_SEG_UsuarioBN->getEnUso() == "Y" )
            {
                if( $user->getUserPassword() == md5( $password ) )
                {
                    $isLoginOk = true;
                }
                else
                {
                    $TipoProc = "2";
                }
            }
            else
            {
                $TipoProc = "3";
            }
        }
        else
        {
            $TipoProc = "1";
        }
        
        if( $isLoginOk )
        {
            $this->setAuthenticated( true );
            $this->addCredential( Constantes::APP_CREDENTIALS );
            $this->setAttribute( 'UserId', $user->getUserId(), Constantes::APP_CREDENTIALS );
            $this->setAttribute( 'Name', $user->getUserName(), Constantes::APP_CREDENTIALS );
            $this->setAttribute( 'RoleId', $user->getUserRoleId(), Constantes::APP_CREDENTIALS );
            //el acceso
            $this->setAttribute( 'Password', $password, Constantes::APP_CREDENTIALS );
            //ahora se guarda el ultimo acceso
            $this->saveLastLogon( $user->getUserId() );

            return $isLoginOk;
        }
        else
        {
            if( $TipoProc == "2" )
            {
                $o_SEG_UsuarioBN = $this->getObjectUsuario( $login );
                $i_ContadorPwd = $o_SEG_UsuarioBN->getContadorPwd();
                $i_ContadorPwd = $i_ContadorPwd + 1;

                if( $i_ContadorPwd >= 3 )
                {
                    $o_SEG_UsuarioDP = new SEG_UsuarioDP();
                    $o_SEG_UsuarioDP->setIdUsuario( $login );
                    $o_SEG_UsuarioDP->setContadorPwd( $i_ContadorPwd );
                    $o_SEG_UsuarioDP->setEnUso( "N" );
                    $o_SEG_UsuarioDP->update();

                    $TipoProc = "3";
                }
                else
                {
                    $o_SEG_UsuarioDP = new SEG_UsuarioDP();
                    $o_SEG_UsuarioDP->setIdUsuario( $login );
                    $o_SEG_UsuarioDP->setContadorPwd( $i_ContadorPwd );
                    $o_SEG_UsuarioDP->update();
                }
            }
            return $TipoProc;
        }

    }

    public function signOut()
    {
        //se agrega el procedimiento para borrar sesion por tabla 2020-02-10
        SEG_UsuarioSesionDP::borrarSesion( myUser::getUser()->getRoleId() );
        $this->setAuthenticated( false );
        $this->clearCredentials();
        $this->removeNamespace( Constantes::APP_CREDENTIALS );
    }

    public function validar_session()
    {
        if( !$this->isAuthenticated() )
        {
            throw new Exception( "Por favor, es necesario iniciar Sesion." );
        }
        else
        {
            //$o_SEG_UsuarioSesionBN = SEG_UsuarioSesionFN::buscarPorIP( $this->getRoleId() );
            //return $o_SEG_UsuarioSesionBN;
            $o_SEG_UsuarioFN = new SEG_UsuarioFN();
            $o_SEG_UsuarioBN = $o_SEG_UsuarioFN->selectByPK( myUser::getUser()->getUserId() );
            return $o_SEG_UsuarioBN;
        }
    }

    public function getUserId()
    {
        return $this->getAttribute( 'UserId', '', Constantes::APP_CREDENTIALS );
    }

    public function getName()
    {
        return $this->getAttribute( 'Name', '', Constantes::APP_CREDENTIALS );
    }

    public function getRoleId()
    {
        return $this->getAttribute( 'RoleId', '', Constantes::APP_CREDENTIALS );
    }
    
    public function getNameBusiness()
    {
        return $this->getAttribute( 'CompaniaNombre', '', Constantes::APP_CREDENTIALS );
    }
    public function getIdBusiness()
    {
        return $this->getAttribute( 'IdCompania', '', Constantes::APP_CREDENTIALS );
    }
    public function getIdCompania()
    {
        return $this->getAttribute( 'IdCompania', '', Constantes::APP_CREDENTIALS );
    }
    
    public function setAttributeHolder( $s_NameParam, $v_Value )
    {
        $this->setAttribute( $s_NameParam, $v_Value, Constantes::APP_CREDENTIALS );
    }
    public function getAttributeHolder( $s_NameParam )
    {
        return $this->getAttribute( $s_NameParam, '', Constantes::APP_CREDENTIALS );
    }

    //METODOS PARA SUCURSAL
    
    public function getNameSucursal()
    {
        return $this->getAttribute( 'SucursalNombre', '', Constantes::APP_CREDENTIALS );
    }
    public function getIdSucursal()
    {
        return $this->getAttribute( 'IdSucursal', '', Constantes::APP_CREDENTIALS );
    }
    
    public function getPerm( $task )
    {
        $this->mnuMain = new menu_class();
        $this->mnuMain->getInit( $this->getRoleId() );
        
        $this->mnuTask = $this->mnuMain->getTask( $task );
        if( count( $this->mnuTask ) > 0 )
            return TRUE;
        return FALSE;
    }

    public function getObjectRol()
    {
        $o_SEG_RolFN = new SEG_RolFN();
        $o_SEG_RolBN = $o_SEG_RolFN->selectByPK( myUser::getUser()->getRoleId() );
        return $o_SEG_RolBN;
        
        /*$con = Conexion::getConexion();
        $sql = "SELECT IdRol, RolDescripcion, IdTareaInicio, AccesoGlobal FROM SEG_Rol WHERE IdRol = '" . myUser::getUser()->getRoleId() . "';";
        $result = mysql_query( $sql, $con->getResource() );
        $db_result = $result ? mysql_fetch_object( $result ) : null;
        return $db_result;*/
    }

    public function hasTask( $task )
    {
        $o_SEG_TareaFN = new SEG_TareaFN();
        $o_SEG_TareaBN = $o_SEG_TareaFN->selectByPK( $task );
        return $o_SEG_TareaBN;
        // return mnu_taskPeer::retrieveByPK($task);
        /*$con = Conexion::getConexion();
        $sql = "SELECT * FROM SEG_Tarea WHERE IdTarea = '" . $task . "';";
        $result = mysql_query( $sql, $con->getResource() );
        $db_result = $result ? mysql_fetch_object( $result ) : null;
        return $db_result;*/
    }

    public function getObjectUsuario( $UserId = null )
    {
        if( is_null( $UserId ) )
        {
            $UserId = $this->getUserId();
        }
        $o_UsuarioFN = new SEG_UsuarioFN();
        return $o_UsuarioFN->selectByPK( $UserId );
    }

    public function getObjectCompania()
    {
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->getIdBusiness() );
        if( !$o_GSS_CompaniaBN )
        {
            $o_GSS_CompaniaBN = new GSS_CompaniaBN();
        }
        return $o_GSS_CompaniaBN;
    }

    public function getObjectSucursal()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        if( !$o_GSS_SucursalBN )
        {
            $o_GSS_SucursalBN = new GSS_SucursalBN();
        }
        return $o_GSS_SucursalBN;
    }
    
    public function hasGlobalAccess()
    {
        $o_menu_class = new menu_class();
        $o_menu_class->getInit( $this->getRoleId() );
        
        if( $o_menu_class->getGlobalAccess() == "Y" )
        {
            return true;
        }
        return false;
    }

    public function saveLastLogon( $s_IdUsuario )
    {
        $o_SEG_UsuarioDP = new SEG_UsuarioDP();
        $o_SEG_UsuarioDP->setIdUsuario( $s_IdUsuario );
        $o_SEG_UsuarioDP->setLogonFecha( date( "Y-m-d" ) );
        $o_SEG_UsuarioDP->setLogonHora( date( "Y-m-d H:i:s" ) );
        $o_SEG_UsuarioDP->setContadorPwd( 0 );
        $o_SEG_UsuarioDP->update();
    }
}