<?php
/* Busqueda de registros de la tabla SR_Movimiento redefinidos por el usuario. */
class SR_MovimientoFN extends BaseSR_MovimientoFN
{
    public static function selectOneRefNum( $s_OrdenNum )
    {
        $o_SR_MovimientoFN = new SR_MovimientoFN();
        $o_SR_MovimientoFN->setReferenciaNumero( $s_OrdenNum );
        $a_SR_Movimiento = $o_SR_MovimientoFN->select();
        $o_SR_MovimientoBN = null;
        if( $a_SR_Movimiento )
        {
            $o_SR_MovimientoBN = $a_SR_Movimiento[0];
        }
        return $o_SR_MovimientoBN;
    }

    public static function selectOneRefId( $s_DocId )
    {
        $o_SR_MovimientoFN = new SR_MovimientoFN();
        $o_SR_MovimientoFN->setReferenciaId( $s_DocId );
        $a_SR_Movimiento = $o_SR_MovimientoFN->select();
        $o_SR_MovimientoBN = null;
        if( $a_SR_Movimiento )
        {
            $o_SR_MovimientoBN = $a_SR_Movimiento[0];
        }
        return $o_SR_MovimientoBN;
    }

    public static function getObjectMovimientoByIdOrden( $i_IdOrden )
    {
        $s_Sql = "SELECT * FROM SR_Movimiento where ReferenciaNumero in ( SELECT NumeroDocumento FROM VTA_Documento where DocumentoParentId=$i_IdOrden );";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_SR_MovimientoBN = null;
        $o_SR_MovimientoFN = new SR_MovimientoFN();
        while( $o_ResultSet->next() )
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_SR_MovimientoBN = $o_SR_MovimientoFN->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_MovimientoBN;
    }

    public static function getArrayResumenCantidadPorDetalles( $i_MovimientoId )
    {
        $s_Sql = "SELECT MovimientoId, SUM( CantidadPedida ) CantidadPedida, SUM( COALESCE( CantidadRecibida, 0 ) ) CantidadRecibida, SUM( ( CantidadPedida - COALESCE( CantidadRecibida, 0 ) ) ) CantidadPorEntregar
                    FROM SR_Movimiento m
                      LEFT JOIN VTA_Documento d ON d.NumeroDocumento=m.ReferenciaId
                        LEFT JOIN VTA_DocumentoDetalle l ON l.IdTipoDocumento=d.IdTipoDocumento AND l.IdCompania=d.IdCompania AND l.NumeroDocumento=d.NumeroDocumento
                    WHERE 1=1
                    AND MovimientoId=$i_MovimientoId
                    GROUP BY MovimientoId;";
        $a_SQLRow = array( "MovimientoId" => $i_MovimientoId, "CantidadPedida" => 0, "CantidadRecibida" => 0, "CantidadPorEntregar" => 0 );
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow();
        }
        return $a_SQLRow;
    }
}
?>