<?php
/* Busqueda de registros de la tabla MST_Ubigeo redefinidos por el usuario. */
class MST_UbigeoFN extends BaseMST_UbigeoFN
{
    public static function selectDepartamentoActivos()
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoFN->setTipo( "DEPT" );
        $o_MST_UbigeoFN->setEstado( "A" );
        $a_MST_Ubigeo = $o_MST_UbigeoFN->select();
        return $a_MST_Ubigeo;
    }
    
    public static function getArrayDireccionCompleta( $s_IdUbigeo )
    {
        $a_DirCompleta = array();
        
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $s_IdUbigeo );
        if( $o_MST_UbigeoBN )
        {
            $s_Distrito = $o_MST_UbigeoBN->getDescripcion();
            $s_Pertenece = $o_MST_UbigeoBN->getPertenece();
            
            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $s_Pertenece );
            
            $s_Provincia = $o_MST_UbigeoBN->getDescripcion();
            $s_Pertenece = $o_MST_UbigeoBN->getPertenece();
            
            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $s_Pertenece );
            
            $s_Departamento = $o_MST_UbigeoBN->getDescripcion();
            $s_Pertenece = $o_MST_UbigeoBN->getPertenece();
            
            $a_DirCompleta = array( "Departamento" => $s_Departamento, "Provincia" => $s_Provincia, "Distrito" => $s_Distrito );
        }
        return $a_DirCompleta;
    }
    
    public static function buscarDireccionCompleta( $s_IdUbigeo )
    {
        $s_DirCompleta = "";
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $s_IdUbigeo );
        if( $o_MST_UbigeoBN )
        {
            $s_Distrito = $o_MST_UbigeoBN->getDescripcion();
            $s_Pertenece = $o_MST_UbigeoBN->getPertenece();
            
            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $s_Pertenece );
            
            $s_Provincia = $o_MST_UbigeoBN->getDescripcion();
            $s_Pertenece = $o_MST_UbigeoBN->getPertenece();
            
            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $s_Pertenece );
            
            $s_Departamento = $o_MST_UbigeoBN->getDescripcion();
            $s_Pertenece = $o_MST_UbigeoBN->getPertenece();
            
            $s_DirCompleta = $s_Departamento."-".$s_Provincia."-".$s_Distrito;
        }
        return $s_DirCompleta;
    }

    public static function getDescripcionPorId( $s_IdUbigeo )
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $s_IdUbigeo );
        if( $o_MST_UbigeoBN )
        {
            return $o_MST_UbigeoBN->getDescripcion();
        }
        return "";
    }
    
    public static function selectProvinciaActivos( $s_Departamento=null )
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoFN->setTipo( "PROV" );
        if( $s_Departamento )
        {
            $o_MST_UbigeoFN->setPertenece( $s_Departamento );
        }
        $o_MST_UbigeoFN->setEstado( "A" );
        $o_MST_UbigeoFN->addOrderBy( MST_UbigeoFN::Descripcion );
        return $o_MST_UbigeoFN->select();
    }
    
    public static function selectDistritoActivos( $s_Provincia )
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoFN->setTipo( "DIST" );
        $o_MST_UbigeoFN->setPertenece( $s_Provincia );
        $o_MST_UbigeoFN->setEstado( "A" );
        $o_MST_UbigeoFN->addOrderBy( MST_UbigeoFN::Descripcion );
        return $o_MST_UbigeoFN->select();
    }
}