<?php
/* Busqueda de registros de la tabla MST_PersonaMast redefinidos por el usuario. */
class MST_PersonaMastFN extends BaseMST_PersonaMastFN
{
    /**
     * Recupero el Id + 1
     *
     * @return int
     */
    public static function recuperarId()
    {
        $s_Sql = "SELECT IF( MAX( IdPersona ) IS NULL, 1, MAX( IdPersona ) + 1 ) i_Id FROM MST_PersonaMast;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        return $o_ResultSet->getInt( 'i_Id' );
    }
    
    public static function recuperarUsuarioLogin( $IdPersona )
    {
        $s_Sql = "SELECT IdUsuario FROM MST_PersonaMast WHERE IdPersona='$IdPersona';";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        if( $a_Row )
        {
            return $a_Row['IdUsuario'];
        }
        return "";
    }
    
    public static function existeUsuarioLogin( $UsuarioLogin=null )
    {
        if( $UsuarioLogin )
        {
            $s_Sql = "SELECT IdUsuario FROM MST_PersonaMast WHERE IdUsuario='$UsuarioLogin';";
            $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
            if( $o_ResultSet->getRecordCount() > 0 )
            {
                return true;
            }
        }
        return false;
    }
    
    public function selectAutocomplete( $s_Termino )
    {
        $s_Sql = "SELECT *
                    FROM MST_PersonaMast
                    WHERE 1=1   
                        AND
                        (
                          CONCAT( Nombres, ' ', ApellidoPaterno, ' ', ApellidoMaterno ) LIKE '%$s_Termino%'
                          OR NombreCompleto LIKE '%$s_Termino%'
                          OR Documento LIKE '%$s_Termino%'
                          OR DocumentoIdentidad  LIKE '%$s_Termino%'
                        )
                        AND EsCliente = 'SI'
                        AND Estado = 'A'
                ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_MST_PersonaMast = array();
        while( $o_ResultSet->next() ) 
        {
            $a_Row = $o_ResultSet->getRow();
            $o_MST_PersonaMastBN = $this->insertObjectBN( $a_Row );
            $a_MST_PersonaMast[] = $o_MST_PersonaMastBN;
        }
        return $a_MST_PersonaMast;
    }

    public function selectAutocompletePersonalizado( $s_Termino )
    {
        $s_Where = "";

        if( $this->getDocumentoIdentidad() )
        {
            $s_Where .= " AND DocumentoIdentidad<>'' ";
            $this->setDocumentoIdentidad( null );
        }

        $s_Where .= " AND ".$this->buildConsult();

        $s_Join     = "";
        $s_WhereAux = "";
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //FILTRO PARA QUE LOS VENDEDORES SOLO VEA SUS ORDENES
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            if( !myUser::getUser()->getObjectRol()->tieneRolAdministrativo() )
            {
                if( myUser::getUser()->getObjectCompania()->getCarteraClienteFlag() )
                {
                    $s_Join     = " LEFT JOIN MST_ClienteMast ON MST_ClienteMast.IdCliente=MST_PersonaMast.IdPersona ";
                    $s_WhereAux = " AND MST_ClienteMast.VendedorCod='".myUser::getUser()->getUserId()."' ";
                }
            }
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $s_Sql = "SELECT *
                    FROM MST_PersonaMast
                        $s_Join
                    WHERE 1=1   
                        $s_WhereAux
                        AND
                        (
                          CONCAT( Nombres, ' ', ApellidoPaterno, ' ', ApellidoMaterno ) LIKE '%$s_Termino%'
                          OR NombreCompleto LIKE '%$s_Termino%'
                        )
                        $s_Where
                ";
        //AND EsCliente = 'SI' AND Estado = 'A'

        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_MST_PersonaMast = array();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_MST_PersonaMastBN = $this->insertObjectBN( $a_SQLRow );
            $a_MST_PersonaMast[] = $o_MST_PersonaMastBN;
        }
        return $a_MST_PersonaMast;
    }

    public function selectAutocompletePorDocu( $s_Termino )
    {
        $s_Where = "";
        if( $this->getTipoDocumento() )
        {
            $s_Where .= " and TipoDocumento='".$this->getTipoDocumento()."' ";
            $this->setDocumentoIdentidad( null );
        }

        $s_Where .= " AND ".$this->buildConsult();

        $s_Join     = "";
        $s_WhereAux = "";
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //FILTRO PARA QUE LOS VENDEDORES SOLO VEA SUS ORDENES
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            if( !myUser::getUser()->getObjectRol()->tieneRolAdministrativo() )
            {
                if( myUser::getUser()->getObjectCompania()->getCarteraClienteFlag() )
                {
                    $s_Join     = " LEFT JOIN MST_ClienteMast ON MST_ClienteMast.IdCliente=MST_PersonaMast.IdPersona ";
                    $s_WhereAux = " AND MST_ClienteMast.VendedorCod='".myUser::getUser()->getUserId()."' ";
                }
            }
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $s_Sql = "SELECT * 
                    FROM MST_PersonaMast 
                        $s_Join
                    WHERE 1=1 
                      $s_WhereAux
                      AND Documento LIKE '%$s_Termino%' $s_Where 
                ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_MST_PersonaMastBN = array();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_MST_PersonaMastBN = $this->insertObjectBN( $a_SQLRow );
            $a_MST_PersonaMastBN[] = $o_MST_PersonaMastBN;
        }
        return $a_MST_PersonaMastBN;
    }

    public function selectAutocompletePorDocumentoIdentidad( $s_Termino )
    {
        $s_Join     = "";
        $s_WhereAux = "";
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //FILTRO PARA QUE LOS VENDEDORES SOLO VEA SUS ORDENES
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            if( !myUser::getUser()->getObjectRol()->tieneRolAdministrativo() )
            {
                if( myUser::getUser()->getObjectCompania()->getCarteraClienteFlag() )
                {
                    $s_Join     = " LEFT JOIN MST_ClienteMast ON MST_ClienteMast.IdCliente=MST_PersonaMast.IdPersona ";
                    $s_WhereAux = " AND MST_ClienteMast.VendedorCod='".myUser::getUser()->getUserId()."' ";
                }
            }
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $s_Sql = "SELECT * 
                    FROM MST_PersonaMast 
                        $s_Join
                    WHERE 1=1  
                        $s_WhereAux
                      AND DocumentoIdentidad LIKE '%$s_Termino%' AND Estado = 'A' AND EsCliente = 'SI' ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_MST_PersonaMastBN = array();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_MST_PersonaMastBN = $this->insertObjectBN( $a_SQLRow );
            $a_MST_PersonaMastBN[] = $o_MST_PersonaMastBN;
        }
        return $a_MST_PersonaMastBN;
    }

    public static function buscarClientePorId( $IdPersona )
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $IdPersona );
        return $o_MST_PersonaMastBN;
    }

    public static function buscarPersonaPorIdUsuario( $IdUsuario )
    {
        if( !$IdUsuario )
        {
            return new MST_PersonaMastBN();
        }
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setIdUsuario( $IdUsuario );
        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        if( $a_MST_PersonaMast )
        {
            if( count( $a_MST_PersonaMast ) == 1 )
            {
                return $a_MST_PersonaMast[0];
            }
        }

        if( !$a_MST_PersonaMast )
        {
            return new MST_PersonaMastBN();
        }

        return $a_MST_PersonaMast;
    }

    public static function buscarClientePorNroDocumento( $NroDocumento )
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsCliente( "SI" );
        $o_MST_PersonaMastFN->setDocumento( $NroDocumento );
        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        if( $a_MST_PersonaMast )
        {
            if( count( $a_MST_PersonaMast ) == 1 )
            {
                return $a_MST_PersonaMast[0];
            }
        }
        return $a_MST_PersonaMast;
    }
    
    public static function buscarListaProveedor()
    {
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        //$o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        return $a_MST_PersonaMast;
    }
}
?>