<?php
/* Busqueda de registros de la tabla MST_ListaPrecioDetalle redefinidos por el usuario. */
class MST_ListaPrecioDetalleFN extends BaseMST_ListaPrecioDetalleFN
{
    public function selectByPK( $s_IdBusiness=null, $s_IdSucursal=null, $s_IdItem=null, $s_IdTipoPrecio=null )
    {
        if( !is_null( $s_IdBusiness ) && is_null( $s_IdSucursal ) && is_null( $s_IdItem ) && is_null( $s_IdTipoPrecio ) )
        {
            return parent::selectByPK( $s_IdBusiness );
        }
        else
        {
            return MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_IdItem, $s_IdTipoPrecio );
        }
    }
    
    public static function buscarPrecioGeneral( $IdItem, $IdTipoPrecio=null )
    {
        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
        $o_MST_ListaPrecioDetalleFN->setIdItem( $IdItem );
        //$o_MST_ListaPrecioDetalleFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_MST_ListaPrecioDetalleFN->addOrderBy( MST_ListaPrecioDetalleFN::PrecioVentaIGV, false );
        $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();
        if( $a_MST_ListaPrecioDetalle )
        {
            if( is_null( $IdTipoPrecio ) )
            {
                return $a_MST_ListaPrecioDetalle[0];
            }
            if( $IdTipoPrecio )
            {
                foreach ( $a_MST_ListaPrecioDetalle as $key => $o_MST_ListaPrecioDetalleBN )
                {
                    if( $o_MST_ListaPrecioDetalleBN->getIdTipoPrecio() == $IdTipoPrecio )
                    {
                        return $o_MST_ListaPrecioDetalleBN;
                    }
                }
            }
        }
        return null;
    }

    public static function buscarPorCostoGeneral( $IdItem, $IdTipoPrecio=null )
    {
        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
        $o_MST_ListaPrecioDetalleFN->setIdItem( $IdItem );
        $o_MST_ListaPrecioDetalleFN->addOrderBy( MST_ListaPrecioDetalleFN::PrecioCosto, false );
        $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select( 1 );
        if( $a_MST_ListaPrecioDetalle )
        {
            if( is_null( $IdTipoPrecio ) )
            {
                return $a_MST_ListaPrecioDetalle[0];
            }
            if( $IdTipoPrecio )
            {
                foreach ( $a_MST_ListaPrecioDetalle as $key => $o_MST_ListaPrecioDetalleBN )
                {
                    if( $o_MST_ListaPrecioDetalleBN->getIdTipoPrecio() == $IdTipoPrecio )
                    {
                        return $o_MST_ListaPrecioDetalleBN;
                    }
                }
            }
        }
        else
        {
            $o_MST_ListaPrecioDetalleBN = new MST_ListaPrecioDetalleBN();
            return $o_MST_ListaPrecioDetalleBN;
        }
        return null;
    }


    public static function buscarListaPreciosByObject( $v_Obj )
    {
        $s_Where = "";

        if( is_array( $v_Obj ) ) 
        {
            if( count( $v_Obj ) > 0 )
            {
                foreach ( $v_Obj as $o_Obj ) 
                {
                    $a_Lst[] = $o_Obj->getIdItem();
                }
                $s_LstIdItem = implode( "','", $a_Lst );
                $s_Where .= " AND P.IdItem IN ('$s_LstIdItem') ";
            }
        }

        $s_Sql = "
        SELECT
            P.IdItem, I.IdMarca, I.DescripcionCompleta, P.IdTipoPrecio, MAX(P.PrecioCosto) PrecioCosto, MAX(P.PrecioCostoIGV) PrecioCostoIGV, MAX(P.PorcentajeUtilidad) PorcentajeUtilidad, MAX(P.PrecioVenta) PrecioVenta, MAX(P.PrecioVentaIGV) PrecioVentaIGV, SUM(S.StockDisponible) StockDisponible
        FROM MST_ListaPrecioDetalle P
            INNER JOIN ALM_ItemMast I ON P.IdItem=I.IdItem
                LEFT JOIN ALM_ItemAlmacenStock S ON S.IdItem=I.IdItem
        WHERE 1=1
            $s_Where
            AND S.StockDisponible>0
        GROUP BY I.IdItem
        ORDER BY I.DescripcionCompleta,P.IdTipoPrecio;
        ";
        //pr( $s_Sql ); 
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        while( $o_ResultSet->next() ) 
        {
            $a_Row = $o_ResultSet->getRow();
            $a_Result[] = $a_Row;
        }
        //pr( $a_Result ); exit;
        return $a_Result;
    }

    public static function getArrayPrecios( $s_IdItem )
    {
        $s_Sql = "
            SELECT IdCompania, IdSucursal, IdItem, IdTipoPrecio, Estado, PrecioCosto, PrecioCostoIGV, PorcentajeUtilidad, PrecioVenta, MontoIGV, PrecioVentaIGV
            FROM MST_ListaPrecioDetalle
            where 1=1
              and IdItem='$s_IdItem' and Estado='A';
        ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_Result = array();
        while( $o_ResultSet->next() ) 
        {
            $a_Row = $o_ResultSet->getRow();
            $a_Result[$a_Row['IdTipoPrecio']] = $a_Row;
        }
        return $a_Result;
    }
}
