<?php
/* Busqueda de registros de la tabla ALM_Kardex redefinidos por el usuario. */
class ALM_KardexFN extends BaseALM_KardexFN
{
    public function consultaStockInicial()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= " IdItem, SUM(CantidadDoble) Cantidad ";
        $s_SQLQuery .= "FROM ALM_Kardex WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        $s_SQLQuery .= " GROUP BY IdItem ;";
        //pr( $s_SQLQuery );
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return intval( $a_Row['Cantidad'] );
    }

    public static function buscarSaldoEnStockHis( $s_IdCompania, $s_IdSucursal, $s_IdFecha, $s_IdAlmacen, $s_IdLote = null, $s_IdItem )
    {
        $s_Sql = "
                SELECT *
                       -- IdAlmacen, IdCompania, IdItem, IdCondicion, IdLote, IdFecha, IdTransaccion, PrecioCosto, Cantidad, SaldoCantidad, SaldoPrecioCosto, SaldoCostoTotal
                FROM ALM_Kardex
                WHERE 1=1
                    AND IdCompania='$s_IdCompania'
                    AND IdSucursal='$s_IdSucursal'
                    AND IdAlmacen='$s_IdAlmacen'
                    AND IdItem='$s_IdItem'
                    AND IdFecha<'$s_IdFecha'
                ORDER BY IdFecha DESC
                LIMIT 1
    ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        //pr( $a_Row );
        return $a_Row;
    }

    public static function buscarTransaccionDet( $s_IdItem, $s_Periodo, $IdAlmacen="", $IdLote="" )
    {
        $s_Where = "";
        
        if( $IdAlmacen != "" )
        {
            $s_Where .= " AND K.IdAlmacen='$IdAlmacen' ";
        }
        if( $IdLote != "" )
        {
            $s_Where .= " AND K.IdLote='$IdLote' ";
        }
        $s_Sql = "SELECT K.IdFecha, K.Cantidad, ( SELECT IngresoEgresoFlag FROM ALM_TransaccionMast WHERE IdTransaccion=K.IdTransaccion ) TipoIngreso
                    FROM ALM_Kardex K
                    WHERE Periodo='$s_Periodo' AND K.IdItem='$s_IdItem' $s_Where
                  ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        return $o_ResultSet;
    }
    
    public static function recuperarTransxRango( $i_IdCompania, $s_IdAlmacen, $s_IdLote="", $s_IdItem, $s_IdFechaIni="", $s_IdFechaFin="" )
    {
        $s_Where = "";
        $s_Orden = "";
        
        if( $s_IdAlmacen != "" )
        {
            $s_Where .= " AND IdAlmacen='$s_IdAlmacen' ";
            $s_Orden .= " ,IdAlmacen ";
        }
        if( $s_IdLote != "" )
        {
            $s_Where .= " AND IdLote='$s_IdLote' ";
            $s_Orden .= " ,IdLote ";
        }
        if( $s_IdFechaIni != "" )
        {
            $s_Where .= " AND IdFecha>='$s_IdFechaIni' ";
        }
        if( $s_IdFechaFin != "" )
        {
            $s_Where .= " AND IdFecha<='$s_IdFechaFin' ";
        }
        $s_Sql = "SELECT *
                    FROM ALM_Kardex
                    WHERE 1=1
                    AND IdCompania='$i_IdCompania'
                    AND IdItem='$s_IdItem'
                    $s_Where
                    ORDER BY IdCompania, IdItem $s_Orden ,FechCreacion ;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_ALM_KardexBN = array();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_ALM_KardexFN = new ALM_KardexFN();
            $o_ALM_KardexBN = $o_ALM_KardexFN->insertObjectBN( $a_SQLRow );
            $a_ALM_KardexBN[] = $o_ALM_KardexBN;
        }
        return $a_ALM_KardexBN;
    }

    public static function buscarParentRef( $s_ParentCode )
    {
        $a_ParentCode                   = explode( "_", $s_ParentCode );
        
        $s_IdAlmacen                    = $a_ParentCode[0];
        $s_IdCompania                   = $a_ParentCode[1];
        $s_IdItem                       = $a_ParentCode[2];
        $s_IdFecha                      = $a_ParentCode[3];
        $s_ReferenciaTipoDocumento      = $a_ParentCode[4];
        $s_ReferenciaNumeroDocumento    = $a_ParentCode[5];
        $s_ReferenciaSecuencia          = $a_ParentCode[6];
        
        $o_ALM_KardexBN = new ALM_KardexBN();
        
        $o_ALM_KardexFN = new ALM_KardexFN();
        $o_ALM_KardexFN->setIdAlmacen( $s_IdAlmacen );
        $o_ALM_KardexFN->setIdCompania( $s_IdCompania );
        $o_ALM_KardexFN->setIdItem( $s_IdItem );
        $o_ALM_KardexFN->setIdFecha( $s_IdFecha );
        $o_ALM_KardexFN->setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento );
        $o_ALM_KardexFN->setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento );
        $o_ALM_KardexFN->setReferenciaSecuencia( $s_ReferenciaSecuencia );
        $a_ALM_Kardex = $o_ALM_KardexFN->select();
        if( $a_ALM_Kardex )
        {
            $o_ALM_KardexBN = $a_ALM_Kardex[0];
        }
        return $o_ALM_KardexBN;
    }
    
    public function select_custom( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM ALM_Kardex WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        //$s_SQLQuery .= " AND IdItem IN ('PAST002797','ACEI002841') ";
        
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        return $o_ResultSet;
    }
    
    public static function buscarUltimoCosto( $IdCompania, $IdAlmacen, $IdItem )
    {
        $s_Sql = "
            SELECT * FROM ALM_Kardex 
            WHERE IdAlmacen='$IdAlmacen' and IdCompania='$IdCompania' and IdItem='$IdItem' and IdCondicion='I' AND PrecioCosto>0
            ORDER BY FechCreacion DESC
            LIMIT 1; ";
        //and ReferenciaTipoDocumento='NI'
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            $o_ResultSet->next();
            $a_Row = $o_ResultSet->getRow();
            return floatval( $a_Row['PrecioCosto'] );
        }
        return 0;
    }

    public static function buscarUltimoPrecioUnitario( $IdCompania, $IdAlmacen, $IdItem, $Lote=null )
    {
        $s_Where = "";
        
        if( $Lote != "" )
        {
            $s_Where .= " AND IdLote='$Lote' ";
        }
        
        $s_Sql = "
            SELECT * FROM ALM_Kardex 
            WHERE IdAlmacen='$IdAlmacen' and IdCompania='$IdCompania' and IdItem='$IdItem' and ReferenciaTipoDocumento='NI' $s_Where
            ORDER BY FechCreacion DESC
            LIMIT 1;
                ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            $o_ResultSet->next();
            $a_Row = $o_ResultSet->getRow();
            return array( "PrecioUnitario" => floatval( $a_Row['PrecioUnitario'] ), "PrecioUnitarioDolares" => floatval( $a_Row['PrecioUnitarioDolares'] ) );
        }
        else
        {
            $s_Sql = "
                SELECT *
                FROM ALM_Kardex
                WHERE 1=1
                and IdItem='$IdItem' and ReferenciaTipoDocumento='NI' $s_Where and PrecioUnitario>0
                ORDER BY FechCreacion DESC
                LIMIT 1;
            ";
            $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
            if( $o_ResultSet->getRecordCount() > 0 )
            {
                $o_ResultSet->next();
                $a_Row = $o_ResultSet->getRow();
                return array( "PrecioUnitario" => floatval( $a_Row['PrecioUnitario'] ), "PrecioUnitarioDolares" => floatval( $a_Row['PrecioUnitarioDolares'] ) );
            }
        }
        return array();
    }

    public static function buscarUltimoCostoIngreso( $s_IdCompania, $s_IdSucursal, $s_IdAlmacen='', $s_IdItem, $s_IdFecha )
    {
        $s_Where = "";
        if( $s_IdAlmacen )
        {
            $s_Where .= " AND IdAlmacen='$s_IdAlmacen' ";
        }
        $s_Sql       = "
                    SELECT IdAlmacen, IdCompania, IdSucursal, IdItem, IdCondicion, IdLote, IdFecha, IdTransaccion, PrecioCosto, Cantidad, SaldoCantidad, SaldoPrecioCosto, SaldoCostoTotal, MontoTotal
                    FROM ALM_Kardex
                    WHERE 1=1
                        AND IdCompania='$s_IdCompania'
                        AND IdSucursal='$s_IdSucursal'
                        $s_Where
                        AND IdItem='$s_IdItem'
                        AND IdFecha<='$s_IdFecha 23:59:59'
                        AND IdCondicion='I'
                    ORDER BY IdFecha DESC
                    LIMIT 1
                    ;
        ";
        $a_Row = array( "PrecioCosto" => 0, "Cantidad" => 0, "SaldoCantidad" => 0, "SaldoPrecioCosto" => 0, "SaldoCostoTotal" => 0, "MontoTotal" => 0 );
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            $o_ResultSet->next();
            $a_Row = $o_ResultSet->getRow();
        }
        return $a_Row;
    }
}