<?php
/* Mantenimiento de los registros de la tabla RegistroHistorial redefinidos por el usaurio */
class RegistroHistorialDP extends BaseRegistroHistorialDP
{
    public function getRealIpAddr()
    {
        if ( !empty( $_SERVER['HTTP_CLIENT_IP'] ) )   //check ip from share internet
        {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        }
        elseif ( !empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) )   //to check ip is pass from proxy
        {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
        else
        {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }
    public static function recuperarId()
    {
        $o_utilGenerateId = new utilGenerateId();
        $o_utilGenerateId->setIdCompania( -1 );
        $o_utilGenerateId->setTipoCorrelativo( "REGLOG" );
        $o_utilGenerateId->setSerie( "HIST" );
        $i_Id = $o_utilGenerateId->generateId();
        return $i_Id;
    }

    public function save()
    {
        $i_IdLog = RegistroHistorialDP::recuperarId();
        $this->setIdLog( $i_IdLog );
        $this->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $this->setBaseDatos( $_SERVER['HTTP_HOST'] );
        $this->setIp( $this->getRealIpAddr() );
        $this->setIdFecha( date( "Y-m-d H:i:s" ) );
        $this->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $this->setFechaCreacion( date( "Y-m-d H:i:s" ) );
        parent::save();
    }
    
    public static function registrarHistorial( $a_Data )
    {
        $o_RegistroHistorialDP = new RegistroHistorialDP();
        $o_RegistroHistorialDP->setTabla( $a_Data['Tabla'] );                           //referencia de la tabla donde se hace el update o insert
        $o_RegistroHistorialDP->setIdDocumento( ( string ) $a_Data['IdDocumento'] );    //id del registro cabecera
        $o_RegistroHistorialDP->setIdCampo( ( string ) $a_Data['IdCampo'] );            //puede ser el id de los detalles
        $o_RegistroHistorialDP->setCampoValor( $a_Data['CampoValor'] );                 //valor que se muestra al usuario
        $o_RegistroHistorialDP->setModulo( $a_Data['Modulo'] );                         //modulo donde se ralizo la accion
        $o_RegistroHistorialDP->setCampoDescripcion( $a_Data['CampoDescripcion'] );     //descripcion de la accion a realizar
        $o_RegistroHistorialDP->setValorAnterior( $a_Data['ValorAnterior'] );
        $o_RegistroHistorialDP->setValorNuevo( $a_Data['ValorNuevo'] );
        $o_RegistroHistorialDP->save();
    }
}
?>