<?php
/* M�todos de acceso a los campos de la tabla VTA_Documento redefinidos por el usuario */
class VTA_DocumentoBN extends BaseVTA_DocumentoBN
{
    //ESTADO
    const ESTADO_PREPARACION   = "PR";
    const ESTADO_CANCELADO     = "CA";
    const ESTADO_CERRADO       = "CE";
    const ESTADO_ANULADO       = "AN";

    const FORMA_PAGO_COD_CON    = "CON";
    const FORMA_PAGO_COD_CRE    = "CRE";

    const TIPO_TRANSACCION_X_DEFECTO  = "E";
    const TRANSACCION_X_DEFECTO       = "VTA"; //TIPO TRANSACCI�N
    
    //PARA TRANSACCIONES
    const TIPO_DOCUMENTO              = "NS"; //TIPO DE DOCUMENTO
    const TIPO_DOCUMENTO_NC_TRANS     = "NI"; //TIPO DE DOCUMENTO
    const REF_TIPO_DOCUMENTO_DEFECTO  = "OC"; //DOC REFERENCIA, REFERENCIA TIPO DOCUMENTO
    const REF_TIPO_COTIZACIONES       = "CZ"; //TIPO DE REFERENCIA - COTIZACIONES
    /////////////////////////////////////
    
    const TIPO_DOCUMENTO_NOTA_DEBITO  = "ND";
    const TIPO_DOCUMENTO_NOTA_CREDITO = "NC";
    const TIPO_FORMA_PAGO_PARA_NC     = "999";
    const TRANSACCION_NOTA_CREDITO    = "VTI"; //TRANSACCION
    const TRANSACCION_MAST_X_ANULACION= "OEA"; //TRANSACCION_MAST -> OTROS 3 - ENTRADA POR ANULACIÓN DE DOCUMENTO
    const TIPO_TRANSACCION_NOTA_CREDI = "I";   //TRANSACCION
    
    //POR LA VALIDACION DEL MONTO DE 700
    const TIPO_DOCUMENTO_BOLETA_VAL   = "BV";
    const TIPO_DOCUMENTO_TIBOLETA_VAL = "TB";
    const MONTO_VALIDACION            = 700;
    
    const CODIGO_CLIENTE_GENERICO     = "00000000";

    //TIPO DE VENTA
    const TIPO_VENTA_MERCADERIA       = "MER";//"MERCADERIA";
    const TIPO_VENTA_TRANSFERENCIA    = "TRG";//"TRANSFERENCIA DE BIENES A TITULO GRATUITO";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                        self::ESTADO_PREPARACION => "PREPARACION",
                        self::ESTADO_CANCELADO   => "CANCELADO",
                        self::ESTADO_CERRADO     => "EMITIDO",
                        self::ESTADO_ANULADO     => "ANULADO"
        );
        if( !is_null( $sEstado ) )
        {
            if( isset( $a_sEstado[$sEstado] ) )
            {
                return $a_sEstado[$sEstado];
            }
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return VTA_DocumentoBN::getArrayEstados( $this->getEstado() );
    }
    
    const ESTADO_COB_PENDIENTE = "PE";
    const ESTADO_COB_COBRADO   = "CO";
    
    public static function getArrayCobranzaEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                FCO_DocReciboBN::ESTADO_COB_PENDIENTE => "PENDIENTE",
                FCO_DocReciboBN::ESTADO_COB_COBRADO   => "COBRADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    public function getCobranzaEstadoDesc()
    {
        if( $this->getCobranzaEstado() )
        {
            return VTA_DocumentoBN::getArrayCobranzaEstados( $this->getCobranzaEstado() );
        }
        return "";
    }

    public function getEstadoDespachoDesc()
    {
        $o_SR_MovimientoBN = SR_MovimientoFN::selectOneRefId( $this->getNumeroDocumento() );
        if( $o_SR_MovimientoBN )
        {
            return $o_SR_MovimientoBN->getImpresionEstadoDesc();
        }
        return "";
    }

    public static function getArrayCanal( $s_Param = null )
    {
        $a_LstData = array
        (
                        "1" => "USUARIO FINAL",
                        "2" => "COORPORATIVO",
                        "3" => "ESTADO",
        );
        if( !is_null( $s_Param ) )
        {
            if( isset( $a_LstData[$s_Param] ) )
            {
                return $a_LstData[$s_Param];
            }
        }
        return $a_LstData;
    }

    public function getCantidadDiasVence()
    {
        $s_FechaVencimiento = substr( $this->getFechaVencimiento(), 0, 10 );
        $s_FechaActual      = date( "Y-m-d" );
        $o_CantDias         = UtilDate::datetimeDiff( $s_FechaVencimiento, $s_FechaActual );
        if( $this->getCobranzaEstado() != "PE" )
        {
            $o_CantDias->day = "0";
        }
        return $o_CantDias->day;
    }

    public function getCanalDesc()
    {
        if( $this->getCanalVenta() == "" )
        {
            return "";
        }
        return VTA_DocumentoBN::getArrayCanal( $this->getCanalVenta() );
    }
    
    public function getIdConcat()
    {
        if( $this->getNumeroDocumento() )
        {
            return $this->getIdTipoDocumento()."_".$this->getIdCompania()."_".$this->getNumeroDocumento();
        }
        return null;
    }
    
    public function getDireccionUbigeo()
    {
        $s_DireccionUbigeo = MST_UbigeoFN::buscarDireccionCompleta( $this->getUbigeo() );
        return $s_DireccionUbigeo;
    }

    public function getObjectOrden()
    {
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->getDocumentoParentId() );
        return $o_VTA_OrdenBN;
    }

    public function getObjectDocuParentId()
    {
        if( $this->getIdTipoDocumento() != VTA_DocumentoBN::TIPO_DOCUMENTO_NOTA_CREDITO )
        {
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->getDocumentoParentId() );
            return $o_VTA_OrdenBN;
        }
        else
        {
            $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getDocumentoParentId() );
            return $o_VTA_DocumentoBN;
        }
    }

    public function getObjectCliente()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getClienteNumero() );
        return $o_MST_PersonaMastBN;
    }

    public function getObjectCompania()
    {
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->getIdCompania() );
        return $o_GSS_CompaniaBN;
    }
    
    public function getObjectTipoDocumento()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        if( !$o_VTA_TipoDocumentoBN )
        {
            $o_VTA_TipoDocumentoBN = new VTA_TipoDocumentoBN();
        }
        return $o_VTA_TipoDocumentoBN;
    }
    
    public function getTieneNotaCredito()
    {
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoFN->setIdTipoDocumento( VTA_DocumentoBN::TIPO_DOCUMENTO_NOTA_CREDITO );
        $o_VTA_DocumentoFN->setDocumentoParentId( $this->getNumeroDocumento() );
        //$o_VTA_DocumentoFN->setCampoReferencia( $this->getDocumentoTipoSerieNumero() );
        $a_VTA_Documento = $o_VTA_DocumentoFN->select();
        if( $a_VTA_Documento )
        {
            return true;
        }
        return false;
    }
    
    public function getTipoDocumentoDesc()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        if( !$o_VTA_TipoDocumentoBN )
        {
            $o_VTA_TipoDocumentoBN = new VTA_TipoDocumentoBN;
        }
        return $o_VTA_TipoDocumentoBN->getDescripcionLocal();
    }
    
    public function getCodigoFiscalxTipoDocumento()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        return $o_VTA_TipoDocumentoBN->getCodigoFiscal();
    }

    public function getCodigoFiscalPrsxTipoDocumento()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        return $o_VTA_TipoDocumentoBN->getCodigoFiscalPrs();
    }
    
    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN;
    }

    public function getObjectMoneda()
    {
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->getMonedaDocumento() );
        return $o_GSS_MonedaMastBN;
    }
    
    public function getObjectCaja()
    {
        $o_FCO_CajaFN = new FCO_CajaFN();
        $o_FCO_CajaBN = $o_FCO_CajaFN->selectByPK( $this->getIdCaja() );
        return $o_FCO_CajaBN;
    }

    public function getObjectTurno()
    {
        $o_MST_TurnoFN = new MST_TurnoFN();
        $o_MST_TurnoBN = $o_MST_TurnoFN->selectByPK( $this->getIdTurno() );
        return $o_MST_TurnoBN;
    }

    public function getMontoTotalSiEsSoles()
    {
        if( $this->getMonedaDocumento() == "LO" )
        {
            return $this->getMontoTotal();
        }
        return "";
    }

    public function getMontoTotalSiEsDolares()
    {
        if( $this->getMonedaDocumento() == "EX" )
        {
            return $this->getMontoTotal();
        }
        return "";
    }

    public function getMontoPagadoSiEsSoles()
    {
        if( $this->getMonedaDocumento() == "LO" )
        {
            return $this->getMontoPagado();
        }
        return "";
    }

    public function getMontoPagadoSiEsDolares()
    {
        if( $this->getMonedaDocumento() == "EX" )
        {
            return $this->getMontoPagado();
        }
        return "";
    }

    public function getMontoSaldoSiEsSoles()
    {
        if( $this->getMonedaDocumento() == "LO" )
        {
            return $this->getMontoSaldo();
        }
        return "";
    }

    public function getMontoSaldoSiEsDolares()
    {
        if( $this->getMonedaDocumento() == "EX" )
        {
            return $this->getMontoSaldo();
        }
        return "";
    }

    public function getMonedaDesc()
    {
        if( $this->getMonedaDocumento() == "LO" )
        {
            return "S";
        }
        return "";
    }
    
    public function getAlmacenDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }

    public function getObjectAlmacenDespacho()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacenDespacho() );
        return $o_ALM_AlmacenMastBN;
    }

    public function getAlmacenDespachoDesc()
    {
        $o_ALM_AlmacenMastFN = $this->getObjectAlmacenDespacho();
        return $o_ALM_AlmacenMastFN->getDescripcionLocal();
    }

    public function getArrayGuiaRemision()
    {
        $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
        $o_SR_GuiaRemisionHFN->setEstadoSunat( SR_GuiaRemisionHBN::ESTADO_SUNAT_ENVIADO );
        $o_SR_GuiaRemisionHFN->setReferenciaNumeroDocumento( $this->getNumeroDocumento() );
        $a_SR_GuiaRemisionH = $o_SR_GuiaRemisionHFN->select();
        return $a_SR_GuiaRemisionH;
    }

    public function getConcatGuiaRemision()
    {
        $a_SR_GuiaRemisionH = $this->getArrayGuiaRemision();
        $a_NumGuia = array();
        foreach( $a_SR_GuiaRemisionH as $o_SR_GuiaRemisionHBN )
        {
            $a_NumGuia[] = $o_SR_GuiaRemisionHBN->getGuiaSerieNumeroConcat();
        }
        return implode( " | ", $a_NumGuia );
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    protected $IdSucursal;
    /**
     * @return the $IdSucursal
     */
    public function getIdSucursal()
    {
        return $this->IdSucursal;
    }

    /**
     * @param field_type $IdSucursal
     */
    public function setIdSucursal($IdSucursal)
    {
        $this->IdSucursal = $IdSucursal;
    }
    
    public function getDocumentoTipoSerieNumero()
    {
        if( $this->getNumeroDocumento() )
        {
            return $this->getDocumentoCod()."".$this->getDocumentoSerie()."-".$this->getDocumentoNumero();
        }
        return "";
    }
    
    public function getDocumentoSerieNumero()
    {
        return $this->getDocumentoSerie()."-".$this->getDocumentoNumero();
    }
    
    public function getFechaDocumentoDate()
    {
        return substr( $this->getFechaDocumento(), 0, 10 );
    }

    public function getObjectFormaPago()
    {
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoBN = $o_VTA_FormaPagoFN->selectByPK( $this->getIdFormaPago() );
        if( !$o_VTA_FormaPagoBN )
        {
            $o_VTA_FormaPagoBN = new VTA_FormaPagoBN();
        }
        return $o_VTA_FormaPagoBN;
    }

    public function getFormaPagoDes()
    {
        //$o_VTA_FormaPagoBN = $this->getObjectFormaPago();
        //return $o_VTA_FormaPagoBN->getDescripcionLocal();
        if( $this->getFormaPagoCod() == "CON" )
        {
            return "CONTADO";
        }
        else
        {
            return "CREDITO A ".$this->getTerminoPago()." DIAS";
        }
    }

    protected $transferencia;
    public function getEsTransferencia()
    {
        return $this->transferencia;
    }
    public function setEsTransferencia( $v )
    {
        $this->transferencia = $v;
    }

    protected $guia_remision;
    public function getEsGuiaRemision()
    {
        return $this->guia_remision;
    }
    public function setEsGuiaRemision( $v )
    {
        $this->guia_remision = $v;
    }
    
    public function getEsNotaCredito()
    {
        if( $this->getIdTipoDocumento() == VTA_DocumentoBN::TIPO_DOCUMENTO_NOTA_CREDITO )
        {
            return true;
        }
        return false;
    }

    public function getEsNotaDebito()
    {
        if( $this->getIdTipoDocumento() == VTA_DocumentoBN::TIPO_DOCUMENTO_NOTA_DEBITO )
        {
            return true;
        }
        return false;
    }
    
    public function getNumeroDocumentoReferenciaxNC()
    {
        return VTA_DocumentoFN::buscarNroDocumentoxNotaCredito( $this->getDocumentoTipoSerieNumero() );
    }

    public function getNumeroDocumentoReferenciaxND()
    {
        return VTA_DocumentoFN::buscarNroDocumentoxNotaDebito( $this->getDocumentoTipoSerieNumero() );
    }
    
    public function getEsUltimoSerieNumero()
    {
        if( $this->getEstado() == VTA_DocumentoBN::ESTADO_ANULADO )
        {
            return false;
        }
        if( $this->getEsNotaCredito() )
        {
            return false;
        }
        $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
        $o_GSS_SucursalDocumentoFN->setIdCompania( $this->getIdCompania() );
        if( myUser::getUser()->getIdSucursal() )
        {
            $o_GSS_SucursalDocumentoFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        }
        $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( $this->getIdTipoDocumento() );
        $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
        if( $a_GSS_SucursalDocumento )
        {
            if( count( $a_GSS_SucursalDocumento ) == 1 )
            {
                $o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];
                $s_Serie  = $o_GSS_SucursalDocumentoBN->getSerieFormatoFinal();
                $s_Numero = $o_GSS_SucursalDocumentoBN->getNumeroFormatoFinal();
                $s_ConcatSerieNumero = $s_Serie."-".$s_Numero;
                $s_SerieNumeroDocu   = $this->getDocumentoSerieNumero();
                if( $s_SerieNumeroDocu == $s_ConcatSerieNumero )
                {
                    return true;
                }
            }
        }
        return false;
    }
    
    public function getIdTipoDocumentoCustom()
    {
    	$s_Tipo = $this->getIdTipoDocumento();
    	if( $this->getEstado() == VTA_DocumentoBN::ESTADO_ANULADO )
        {
            $s_Tipo = "XX";
        }
    	return $s_Tipo;
    }

    /**
     * @return VTA_DocumentoDetalleBN[]
     * @throws SQLException
     */
    public function getArrayObjectDetalles()
    {
    	$o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
    	$o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $this->getIdTipoDocumento() );
    	$o_VTA_DocumentoDetalleFN->setIdCompania( $this->getIdCompania() );
    	$o_VTA_DocumentoDetalleFN->setNumeroDocumento( $this->getNumeroDocumento() );
    	$a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
    	if( !$a_VTA_DocumentoDetalle )
    	{
    		$a_VTA_DocumentoDetalle = array();
    	}
    	return $a_VTA_DocumentoDetalle;
    }

    public function getArrayObjectDetallesAct()
    {
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $this->getIdTipoDocumento() );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $this->getIdCompania() );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $this->getNumeroDocumento() );
        $o_VTA_DocumentoDetalleFN->addCondition( VTA_DocumentoDetalleFN::TipoDetalle, "IN", "('P','S')", false );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
        if( !$a_VTA_DocumentoDetalle )
        {
            $a_VTA_DocumentoDetalle = array();
        }
        return $a_VTA_DocumentoDetalle;
    }
    
    public function getCodClienteGenerico()
    {
        /*$o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( myUser::getUser()->getIdBusiness(), 'VT', 'PRM_CLIE_GEN' );
        $s_CodCliente = $o_GSS_ParametroMastBN->getTexto();*/
        //return $s_CodCliente; 
        return false; 
    }
    
    public function getEsClienteGenerico()
    {
        $s_CodCliente = $this->getCodClienteGenerico();
        if( $this->getClienteNumero() == $s_CodCliente )
        {
            return true;
        }
        return false;
    }
    
    protected $a_VTA_DocumentoDetalle;
    public function setArrayDocumentoDetalle( $a_VTA_DocumentoDetalle )
    {
        $this->a_VTA_DocumentoDetalle = $a_VTA_DocumentoDetalle;
    }

    /**
     * @return VTA_DocumentoDetalleBN[]
     */
    public function getArrayDocumentoDetalle()
    {
        return $this->a_VTA_DocumentoDetalle;
    }
    
    protected $NumeroError;
    /**
     * @return the $NumeroError
     */
    public function getNumeroError()
    {
        return $this->NumeroError;
    }

    /**
     * @param field_type $NumeroError
     */
    public function setNumeroError($NumeroError)
    {
        $this->NumeroError = $NumeroError;
    }

    public function getCantidadTotalPedida()
    {
        return VTA_DocumentoDetalleFN::getCantidadTotalPedida( $this->getIdTipoDocumento(), $this->getIdCompania(), $this->getNumeroDocumento() );
    }

    public function getObjetFacturacionElectronica()
    {
        $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
        $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $this->getNumeroDocumento() );
        return $o_VTA_FacturacionElectronicaBN;
    }
    
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //ATRIBUTOS Y METODOS PARA TRANSACCIONES
    protected $IdTipoDocumentoTransaccion;
    protected $IdTransaccion;
    protected $IdTransaccionOperacion;
    protected $DescripcionTransaccion;

    public function getIdTipoDocumentoTransaccion()
    {
        return $this->IdTipoDocumentoTransaccion;
    }
    public function getIdTransaccion()
    {
        return $this->IdTransaccion;
    }
    public function getIdTransaccionOperacion()
    {
        return $this->IdTransaccionOperacion;
    }
    public function setIdTipoDocumentoTransaccion( $IdTipoDocumento )
    {
        $this->IdTipoDocumentoTransaccion = $IdTipoDocumento;
    }
    public function setIdTransaccion( $IdTransaccion )
    {
        $this->IdTransaccion = $IdTransaccion;
    }
    public function setIdTransaccionOperacion( $IdTransaccionOperacion )
    {
        $this->IdTransaccionOperacion = $IdTransaccionOperacion;
    }
    public function getDescripcionTransaccion()
    {
        return $this->DescripcionTransaccion;
    }
    public function setDescripcionTransaccion( $DescripcionTransaccion ): void
    {
        $this->DescripcionTransaccion = $DescripcionTransaccion;
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //ATRIBUTO PARA CLONAR DOCUMENTOS
    protected $IdTipoDocumentoRef;
    public function getIdTipoDocumentoRef()
    {
        return $this->IdTipoDocumentoRef;
    }
    public function setIdTipoDocumentoRef($IdTipoDocumentoRef)
    {
        $this->IdTipoDocumentoRef = $IdTipoDocumentoRef;
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////
    protected $NumeroGuia;
    public function getNumeroGuia()
    {
        return $this->NumeroGuia;
    }
    public function setNumeroGuia( $NumeroGuia )
    {
        $this->NumeroGuia = $NumeroGuia;
    }

    protected $TipoDocumentoFiscal;
    public function getTipoDocumentoFiscal()
    {
        return $this->TipoDocumentoFiscal;
    }
    public function setTipoDocumentoFiscal( $TipoDocumentoFiscal )
    {
        $this->TipoDocumentoFiscal = $TipoDocumentoFiscal;
    }

    protected $SerieDocumentoFiscal;
    public function getSerieDocumentoFiscal()
    {
        return $this->SerieDocumentoFiscal;
    }
    public function setSerieDocumentoFiscal( $SerieDocumentoFiscal )
    {
        $this->SerieDocumentoFiscal = $SerieDocumentoFiscal;
    }

    protected $NumeroDocumentoFiscal;
    public function getNumeroDocumentoFiscal()
    {
        return $this->NumeroDocumentoFiscal;
    }
    public function setNumeroDocumentoFiscal( $NumeroDocumentoFiscal )
    {
        $this->NumeroDocumentoFiscal = $NumeroDocumentoFiscal;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    private static $a_SunatTransaction = array
    (
            "MER" => "VENTA INTERNA", "EXP" => "EXPORTACIÓN", "ANT" => "VENTA INTERNA – ANTICIPOS"
    );
    
    public static function getArraySunatTransaction( $s_Param = null )
    {
        if( !is_null( $s_Param ) )
        {
            if( isset( VTA_DocumentoBN::$a_SunatTransaction[$s_Param] ) )
            {
                return VTA_DocumentoBN::$a_SunatTransaction[$s_Param];
            }
            else
            {
                return "----";
            }
        }
        return VTA_DocumentoBN::$a_SunatTransaction;
    }
    
    public function getSunatTransactionDesc()
    {
        return VTA_DocumentoBN::getArraySunatTransaction( $this->getTipoVenta() );
    }

    //MEDIO DE PAGO PARA DETRACCIONES
    private static $a_DetraccionMediosPago = array
    (
        1 => array( "Descripcion" => "DEPÓSITO EN CUENTA", "CodigoSunat" => "001", "CodigoSunatPr" => "1" )
    );

    public static function getArrayDetraccionMediosPago( $i_Id = null )
    {
        if( !is_null( $i_Id ) )
        {
            if( isset( VTA_DocumentoBN::$a_DetraccionMediosPago[$i_Id] ) )
            {
                return VTA_DocumentoBN::$a_DetraccionMediosPago[$i_Id];
            }
            else
            {
                return array();
            }
        }
        return VTA_DocumentoBN::$a_DetraccionMediosPago;
    }
    public function getDetracionMedioPagoDesc()
    {
        $a_Valores = VTA_DocumentoBN::getArrayRetenciones( $this->getDetraccionMedPagoId() );
        return $a_Valores['Descripcion'];
    }

    public function getObjectDetraccion()
    {
        $o_GSS_DetraccionFN = new GSS_DetraccionFN();
        $o_GSS_DetraccionBN = $o_GSS_DetraccionFN->selectByPK( $this->getDetraccionTipoId() );
        return $o_GSS_DetraccionBN;
    }

    public function getObjectDocumentoMotivo(  )
    {
        $o_VTA_TipoDocumentoMotivoFN = new VTA_TipoDocumentoMotivoFN();
        $o_VTA_TipoDocumentoMotivoBN = $o_VTA_TipoDocumentoMotivoFN->selectByPK( $this->getIdMotivo() );
        return $o_VTA_TipoDocumentoMotivoBN;
    }

    public function getMotivoNotaDebitoDesc()
    {
        return $this->getObjectDocumentoMotivo()->getDescripcion();
    }

    public function getMotivoNotaCreditoDesc()
    {
        return $this->getObjectDocumentoMotivo()->getDescripcion();
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public function getCodigoQR()
    {
        $data = GSS_CompaniaFN::buscarCompania( $this->getIdCompania() )->getRuc()."|".$this->getObjectTipoDocumento()->getCodigoFiscal()."|".$this->getDocumentoSerie()."|". $this->getDocumentoNumero()."|".$this->getMontoImpuestos()."|".$this->getMontoTotal()."|".substr( $this->getFechaDocumento(), 0, 10 )."|".MST_PersonaMastBN::$a_TipoDocumento[$this->getClienteTipoDoc()]."|".$this->getClienteRUC()."|";
        return$data;
    }

    public function esGravadaConImpuesto()
    {
        //sunat_transaction | NUBEFACT
        switch ( $this->getTipoVenta() )
        {
            case "EXP": //2 = EXPORTACIÓN
                return false;
            break;
            case "DET": //OPERACION SUJETA A DETRACCION
            case "VAL": //VALORIZACION
            case "ANT": //ANTICIPOS
            case "MER": //1 = VENTA INTERNA
                return true;
            break;
        }
    }

    public function getTipoOperacionSunat()
    {
        // Catálogo Código de tipo de operación | No. 51
        switch ( $this->getTipoVenta() )
        {
            case "EXP": //2 = EXPORTACIÓN
                return "0200";
            break;
            case "ANT": //ANTICIPOS
                return "0502";
            break;
            case "DET": //OPERACION SUJETA A DETRACCION
                return "1001";
            break;
            case "VAL": //VALORIZACION
            case "MER": //1 = VENTA INTERNA
                return "0101";
            break;
        }
    }

    protected $FacturacionDirecta = false;
    public function setFacturacionDirecta( $v )
    {
        $this->FacturacionDirecta = $v;
    }
    public function esFacturacionDirecta()
    {
        return $this->FacturacionDirecta;
    }

    protected $MovimientoInventario = false;
    public function setForzarMovimientoInventario( $v )
    {
        $this->MovimientoInventario = $v;
    }
    public function getforzarMovimientoInventario()
    {
        return $this->MovimientoInventario;
    }

    public function getObjectProyecto()
    {
        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
        $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $this->getIdProyecto() );
        if( !$o_VTA_PrsProyectosBN )
        {
            $o_VTA_PrsProyectosBN = new VTA_PrsProyectosBN();
        }
        return $o_VTA_PrsProyectosBN;
    }

    protected $NetoaPagar;
    public function getNetoaPagar()
    {
        return $this->NetoaPagar;
    }
    public function setNetoaPagar( $NetoaPagar ): void
    {
        $this->NetoaPagar = $NetoaPagar;
    }

    protected $ArrayDocumentoCuotasBN;
    /**
     * @return VTA_DocumentoCuotasBN[]
     */
    public function getArrayDocumentoCuotasBN()
    {
        return $this->ArrayDocumentoCuotasBN;
    }
    public function setArrayDocumentoCuotasBN( $ArrayDocumentoCuotasBN ): void
    {
        $this->ArrayDocumentoCuotasBN = $ArrayDocumentoCuotasBN;
    }

    public function getCantidadCuotas(  )
    {
        $o_VTA_DocumentoCuotasFN = new VTA_DocumentoCuotasFN();
        $o_VTA_DocumentoCuotasFN->setNumeroDocumentoId( $this->getNumeroDocumento() );
        return $o_VTA_DocumentoCuotasFN->selectNumRows();
    }

    public function getArrayObjDocumentoCuotas(  )
    {
        $o_VTA_DocumentoCuotasFN = new VTA_DocumentoCuotasFN();
        $o_VTA_DocumentoCuotasFN->setNumeroDocumentoId( $this->getNumeroDocumento() );
        return $o_VTA_DocumentoCuotasFN->select();
    }
}
?>