<?php
/* Metodos de acceso a los campos de la tabla TR_Ruta redefinidos por el usuario */
class TR_RutaBN extends BaseTR_RutaBN
{
    //TIPO DE RUTA
    const TIPO_RUTA_PREFIJO = "RU";
    
    //ESTADO
    const ESTADO_ABIERTO   = "O"; //CUANDO SE REGISTRA LA RUTA
    const ESTADO_CERRADO   = "C"; //CUANDO SE CIERRA PARA NO SEGUIR REGISTRANDO DETALLES
    //const ESTADO_CARGANDO  = "G"; //CARGANDO ITEMS AL CAMION, O CONFIRMAR LA CARGA AL CAMION
    //const ESTADO_LISTO     = "L"; //CUANDO LOS ITEMS ESTEN LISTO EN CAMION
    const ESTADO_EN_RUTA   = "F"; //CUANDO ESTE EN RUTA EL VEHICULO
    const ESTADO_TERMINADO = "T"; //CUANDO SE ENTREGO TODOS LOS PRODUCTOS
    
    public static function getArrayEstados( $s_Estado = null )
    {
        $a_sEstado = array
        (
            TR_RutaBN::ESTADO_ABIERTO   => "ABIERTO",
            TR_RutaBN::ESTADO_CERRADO   => "CERRADO",
            TR_RutaBN::ESTADO_EN_RUTA   => "EN RUTA",
            TR_RutaBN::ESTADO_TERMINADO => "TERMINADO"
        );
        if( !is_null( $s_Estado ) )
        {
            return $a_sEstado[$s_Estado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return TR_RutaBN::getArrayEstados( $this->getEstado() );
    }
    
    public function getObjectChofer()
    {
        $o_TR_ChoferFN = new TR_ChoferFN();
        $o_TR_ChoferBN = $o_TR_ChoferFN->selectByPK( $this->getIdChofer() );
        return $o_TR_ChoferBN;
    }
    
    public function getChoferDesc()
    {
        $o_TR_ChoferBN = $this->getObjectChofer();
        return $o_TR_ChoferBN->getChoferDocumento()." - ".$o_TR_ChoferBN->getChoferNombre();
    }
    
    public function getVehiculoDesc()
    {
        $o_TR_VehiculoFN = new TR_VehiculoFN();
        $o_TR_VehiculoBN = $o_TR_VehiculoFN->selectByPK( $this->getIdVehiculo() );
        return $o_TR_VehiculoBN->getVehiculoMarca()." - ".$o_TR_VehiculoBN->getVehiculoPlaca();
    }
    
    public function getTurnoDesc()
    {
        $o_TR_TurnoFN = new TR_TurnoFN();
        $o_TR_TurnoBN = $o_TR_TurnoFN->selectByPK( $this->getIdTurno() );
        return $o_TR_TurnoBN->getTurnoDescripcion();
    }
    
    public function getArrayDetalles()
    {
        $o_TR_RutaDetalleFN = new TR_RutaDetalleFN();
        $o_TR_RutaDetalleFN->setIdRuta( $this->getIdRuta() );
        $a_TR_RutaDetalle = $o_TR_RutaDetalleFN->select();
        return $a_TR_RutaDetalle;
    }
    
    public function getCantidadTotalDetalle()
    {
        $o_TR_RutaDetalleFN = new TR_RutaDetalleFN();
        $o_TR_RutaDetalleFN->setIdRuta( $this->getIdRuta() );
        return $o_TR_RutaDetalleFN->selectNumRows();
    }
    
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    protected $ObjectoDocumento;
    public function getObjectoDocumento()
    {
        return $this->ObjectoDocumento;
    }
    public function setObjectoDocumento($ObjectoDocumento)
    {
        $this->ObjectoDocumento = $ObjectoDocumento;
    }
    
    protected $ObjetoRutaDetalle;
    public function getObjetoRutaDetalle()
    {
        return $this->ObjetoRutaDetalle;
    }
    public function setObjetoRutaDetalle($ObjetoDetalle)
    {
        $this->ObjetoRutaDetalle = $ObjetoDetalle;
    }

}
?>