<?php
/* Metodos de acceso a los campos de la tabla SR_GuiaRemisionH redefinidos por el usuario */
class SR_GuiaRemisionHBN extends BaseSR_GuiaRemisionHBN
{
    const ESTADO_ANULADO    = "A";
    const ESTADO_COMPLETADO = "C";
    
    const ESTADO_SUNAT_ERROR     = "X";
    const ESTADO_SUNAT_PENDIENTE = "P";
    const ESTADO_SUNAT_ENVIADO   = "E";
    
    const ESTADO_DEVOLUCION_PENDIENTE  = "P";
    const ESTADO_DEVOLUCION_COMPLETADO = "C";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                SR_GuiaRemisionHBN::ESTADO_ANULADO    => "ANULADO",
                SR_GuiaRemisionHBN::ESTADO_COMPLETADO => "COMPLETADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return SR_GuiaRemisionHBN::getArrayEstados( $this->getEstado() );
    }
    
    public static function getArrayDevolucionEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                SR_GuiaRemisionHBN::ESTADO_DEVOLUCION_PENDIENTE  => "PENDIENTE",
                SR_GuiaRemisionHBN::ESTADO_DEVOLUCION_COMPLETADO => "COMPLETADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getDevolucionEstadoDesc()
    {
        return SR_GuiaRemisionHBN::getArrayDevolucionEstados( $this->getEstadoDevolucion() );
    }
    
    public static function getArraySunatEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            self::ESTADO_SUNAT_PENDIENTE => "PENDIENTE",
            self::ESTADO_SUNAT_ENVIADO   => "ENVIADO",
            self::ESTADO_SUNAT_ERROR     => "ERROR"
        );
        if( !is_null( $sEstado ) )
        {
            if( isset( $a_sEstado[$sEstado] ) )
            {
                return $a_sEstado[$sEstado];
            }
        }
        return $a_sEstado;
    }

    public function getSunatEstadoDesc()
    {
        return SR_GuiaRemisionHBN::getArraySunatEstados( $this->getEstadoSunat() );
    }
    
    public function getObjectProyecto()
    {
        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
        $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $this->getIdProyecto() );
        return $o_VTA_PrsProyectosBN;
    }
    
    public function getProyectoNombre()
    {
        return $this->getObjectProyecto()->getNombreProyecto();
    }
    
    public function getGuiaSerieNumeroConcat()
    {
        return $this->getGuiaSerie()."-".$this->getGuiaNumero();
    }

    public function getObjectVTADocumento()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getReferenciaNumeroDocumento() );
        return $o_VTA_DocumentoBN;
    }

    public function getArrayObjectDetalles()
    {
        $o_SR_GuiaRemisionDetFN = new SR_GuiaRemisionDetFN();
        $o_SR_GuiaRemisionDetFN->setGuiaRemisionId( $this->getGuiaRemisionId() );
        $a_SR_GuiaRemisionDet = $o_SR_GuiaRemisionDetFN->select();
        return $a_SR_GuiaRemisionDet;
    }

    public function getObjectChofer()
    {
        $o_TR_ChoferFN = new TR_ChoferFN();
        $o_TR_ChoferBN = $o_TR_ChoferFN->selectByPK( $this->getIdChofer() );
        if( !$o_TR_ChoferBN )
        {
            $o_TR_ChoferBN = new TR_ChoferBN();
        }
        return $o_TR_ChoferBN;
    }

    public function getObjectVehiculo()
    {
        $o_TR_VehiculoFN = new TR_VehiculoFN();
        $o_TR_VehiculoBN = $o_TR_VehiculoFN->selectByPK( $this->getIdVehiculo() );
        if( !$o_TR_VehiculoBN )
        {
            $o_TR_VehiculoBN = new TR_VehiculoBN();
        }
        return $o_TR_VehiculoBN;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// //"01" = "VENTA" | "14" = "VENTA SUJETA A CONFIRMACION DEL COMPRADOR" | "02" = "COMPRA" | "04" = "TRASLADO ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA" | "18" = "TRASLADO EMISOR ITINERANTE CP" | "08" = "IMPORTACION" |"09" = "EXPORTACION" | "19" = "TRASLADO A ZONA PRIMARIA" | "13" = "OTROS"
    static $a_MotivoTraslado = array
    (
        1  => array( "Descripcion" => "VENTA",                                               "CodigoSunat" => "01", "CodigoSunatPr" => "01", "Estado" => "A" ),
        2  => array( "Descripcion" => "COMPRA",                                              "CodigoSunat" => "02", "CodigoSunatPr" => "02", "Estado" => "A" ),
        3  => array( "Descripcion" => "VENTA CON ENTREGA A TERCEROS",                        "CodigoSunat" => "03", "CodigoSunatPr" => "03", "Estado" => "A" ),
        4  => array( "Descripcion" => "TRASLADO ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA", "CodigoSunat" => "04", "CodigoSunatPr" => "04", "Estado" => "A" ),
        5  => array( "Descripcion" => "CONSIGNACION",                                        "CodigoSunat" => "05", "CodigoSunatPr" => "05", "Estado" => "A" ),
        6  => array( "Descripcion" => "DEVOLUCION",                                          "CodigoSunat" => "06", "CodigoSunatPr" => "06", "Estado" => "A" ),
        7  => array( "Descripcion" => "RECOJO DE BIENES TRANSFORMADOS",                      "CodigoSunat" => "07", "CodigoSunatPr" => "07", "Estado" => "A" ),
        8  => array( "Descripcion" => "IMPORTACION",                                         "CodigoSunat" => "08", "CodigoSunatPr" => "08", "Estado" => "A" ),
        9  => array( "Descripcion" => "EXPORTACION",                                         "CodigoSunat" => "09", "CodigoSunatPr" => "09", "Estado" => "A" ),
        10 => array( "Descripcion" => "OTROS",                                               "CodigoSunat" => "13", "CodigoSunatPr" => "13", "Estado" => "A" ),
        11 => array( "Descripcion" => "VENTA SUJETA A CONFIRMACION DEL COMPRADOR",           "CodigoSunat" => "14", "CodigoSunatPr" => "14", "Estado" => "I" ),
        12 => array( "Descripcion" => "TRASLADO EMISOR ITINERANTE CP",                       "CodigoSunat" => "17", "CodigoSunatPr" => "17", "Estado" => "I" ),
        13 => array( "Descripcion" => "TRASLADO A ZONA PRIMARIA",                            "CodigoSunat" => "18", "CodigoSunatPr" => "18", "Estado" => "I" )
    );

    public static function getArrayMotivoTraslado( $s_Param = null )
    {
        if( !is_null( $s_Param ) )
        {
            if( isset( SR_GuiaRemisionHBN::$a_MotivoTraslado[$s_Param] ) )
            {
                return SR_GuiaRemisionHBN::$a_MotivoTraslado[$s_Param];
            }
            else
            {
                return "----";
            }
        }
        return SR_GuiaRemisionHBN::$a_MotivoTraslado;
    }

    public function getMotivoTrasladoDesc()
    {
        $a_Data = SR_GuiaRemisionHBN::getArrayMotivoTraslado( $this->getMotivoTrasladoId() );
        return $a_Data['Descripcion'];
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// //01 = TRANSPORTE PÚBLICO  |  02 = TRANSPORTE PRIVADO
    static $a_TipoDeTransporte = array
    (
        2 => array( "Descripcion" => "TRANSPORTE PRIVADO", "CodigoSunat" => "02", "CodigoSunatPr" => "02", "Estado" => "A" ),
        1 => array( "Descripcion" => "TRANSPORTE PÚBLICO", "CodigoSunat" => "01", "CodigoSunatPr" => "01", "Estado" => "I" ),
    );

    public static function getArrayTipoDeTransporte( $s_Param = null )
    {
        if( !is_null( $s_Param ) )
        {
            if( isset( SR_GuiaRemisionHBN::$a_TipoDeTransporte[$s_Param] ) )
            {
                return SR_GuiaRemisionHBN::$a_TipoDeTransporte[$s_Param];
            }
            else
            {
                return "----";
            }
        }
        return SR_GuiaRemisionHBN::$a_TipoDeTransporte;
    }

    public function getModalidadTransporteDesc()
    {
        $a_Data = SR_GuiaRemisionHBN::getArrayTipoDeTransporte( $this->getModalidadTransporteId() );
        return $a_Data['Descripcion'];
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}
