<?php
/* Metodos de acceso a los campos de la tabla SRV_UbicacionClienteH redefinidos por el usuario */
class SRV_UbicacionClienteHBN extends BaseSRV_UbicacionClienteHBN
{
    const ESTADO_PENDIENTE = "P";
    const ESTADO_TERMINADO = "T";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            SRV_UbicacionClienteHBN::ESTADO_PENDIENTE => "PENDIENTE",
            SRV_UbicacionClienteHBN::ESTADO_TERMINADO => "TERMINADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getObjectUbicacion()
    {
        $o_MST_UbicacionFN = new MST_UbicacionFN();
        $o_MST_UbicacionBN = $o_MST_UbicacionFN->selectByPK( $this->getIdUbicacion() );
        return $o_MST_UbicacionBN;
    }

    protected $EstadoUbicacion;
    public function getEstadoUbicacion()
    {
        return $this->EstadoUbicacion;
    }
    public function setEstadoUbicacion( $EstadoUbicacion )
    {
        $this->EstadoUbicacion = $EstadoUbicacion;
    }

    protected $EstadoUbicacionFecha;
    public function getEstadoUbicacionFecha()
    {
        return $this->EstadoUbicacionFecha;
    }
    public function setEstadoUbicacionFecha( $EstadoUbicacionFecha )
    {
        $this->EstadoUbicacionFecha = $EstadoUbicacionFecha;
    }

    public function actualizarMarcarAlerta()
    {
        SRV_UbicacionClienteHDP::marcarAlerta( $this->getIdUbicacionClienteH() );
    }
}
?>