<?php
/* Metodos de acceso a los campos de la tabla PR_Grupo redefinidos por el usuario */
class PR_GrupoBN extends BasePR_GrupoBN
{
    //ESTADO
    const ESTADO_PENDIENTE = "P";
    const ESTADO_ANULADO   = "A";
    const ESTADO_EXPIRADO  = "X";
    const ESTADO_PUBLICADO = "B";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            PR_GrupoBN::ESTADO_PENDIENTE => "PENDIENTE",
            PR_GrupoBN::ESTADO_ANULADO   => "ANULADO",
            PR_GrupoBN::ESTADO_EXPIRADO  => "EXPIRADO",
            PR_GrupoBN::ESTADO_PUBLICADO => "PUBLICADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return PR_GrupoBN::getArrayEstados( $this->getEstado() );
    }
    
    public function getTipoPromocionDesc()
    {
        $o_PR_TipoGrupoFN = new PR_TipoGrupoFN();
        $o_PR_TipoGrupoBN = $o_PR_TipoGrupoFN->selectByPK( $this->getIdPrTipoId() );
        return $o_PR_TipoGrupoBN->getNombre();
    }
    
    public function getSucursalDesc()
    {
        return GSS_SucursalFN::recuperarValor( $this->getIdSucursal(), "Descripcion" );
    }
    
    public function getFamiliaDesc()
    {
        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $o_MST_ClaseFamiliaBN = $o_MST_ClaseFamiliaFN->selectByPK( $this->getIdLinea(), $this->getIdFamilia() );
        if( $o_MST_ClaseFamiliaBN )
        {
            return $o_MST_ClaseFamiliaBN->getDescripcion();
        }
        return "";
    }
    
    public function getLineaDesc()
    {
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaBN = $o_MST_ClaseLineaFN->selectByPK( $this->getIdLinea() );
        if( $o_MST_ClaseLineaBN )
        {
            return $o_MST_ClaseLineaBN->getDescripcion();
        }
        return "";
    }
    
    public function getArrayObjectDetail()
    {
        $o_PR_ListaItemFN = new PR_ListaItemFN();
        $o_PR_ListaItemFN->setIdPrGrupo( $this->getIdPrGrupo() );
        return $o_PR_ListaItemFN->select();
    }
    
    protected $o_ALM_ItemMastBN;
    public function getObjectItemMastBN()
    {
        return $this->o_ALM_ItemMastBN;
    }
    public function setObjectItemMastBN( $o_ALM_ItemMastBN )
    {
        $this->o_ALM_ItemMastBN = $o_ALM_ItemMastBN;
    }

    
}
?>