<?php
/* Metodos de acceso a los campos de la tabla PRD_OrdenCab redefinidos por el usuario */
class PRD_OrdenCabBN extends BasePRD_OrdenCabBN
{
    const ALMACEN_PRODUCCION_X_DEFECTO = "A1303";
    
    const ESTADO_PENDIENTE  = "P";
    const ESTADO_RESERVADO  = "R";
    const ESTADO_ANULADO    = "A";
    const ESTADO_COMPLETADO = "C";
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            PRD_OrdenCabBN::ESTADO_PENDIENTE   => "PENDIENTE",
            PRD_OrdenCabBN::ESTADO_RESERVADO   => "RESERVADO",
            PRD_OrdenCabBN::ESTADO_ANULADO     => "ANULADO",
            PRD_OrdenCabBN::ESTADO_COMPLETADO  => "COMPLETADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    public function getEstadoDesc()
    {
        return PRD_OrdenCabBN::getArrayEstados( $this->getEstado() );
    }
    
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //TABLA DE CLASIFICACION DE ORDEN
    const TIPO_ORDEN_PROD_NORMAL = "PRDORD";
    const TIPO_ORDEN_PROD_COTI   = "PRDCOT";
    public static function getArrayTipoOrden( $s_Value = null )
    {
        $a_sEstado = array
        (
                PRD_OrdenCabBN::TIPO_ORDEN_PROD_NORMAL => "ORDEN POR PRODUCCION",
                PRD_OrdenCabBN::TIPO_ORDEN_PROD_COTI   => "ORDEN POR COTIZACION"
        );
        if( !is_null( $s_Value ) )
        {
            return $a_sEstado[$s_Value];
        }
        return $a_sEstado;
    }
    
    public function getTipoOrdenDesc()
    {
        return PRD_OrdenCabBN::getArrayTipoOrden( $this->getTipoOrden() );
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}
?>