<?php
/* Metodos de acceso a los campos de la tabla MST_CategoriaTalla redefinidos por el usuario */
class MST_CategoriaTallaBN extends BaseMST_CategoriaTallaBN
{
    //ESTADO
    const ESTADO_ACTIVO   = "A";
    const ESTADO_INACTIVO = "I";

    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            MST_CategoriaTallaBN::ESTADO_ACTIVO   => "ACTIVO",
            MST_CategoriaTallaBN::ESTADO_INACTIVO => "INACTIVO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getEstadoDesc()
    {
        return MST_CategoriaTallaBN::getArrayEstados( $this->getEstado() );
    }

    public function getTallas()
    {
        $o_MST_CategoriaTallaRelacionFN = new MST_CategoriaTallaRelacionFN();
        $o_MST_CategoriaTallaRelacionFN->setIdCatTalla( $this->getIdCatTalla() );
        $a_MST_CategoriaTallaRelacion = $o_MST_CategoriaTallaRelacionFN->select();
        $a_TallaDesc = array();
        foreach ( $a_MST_CategoriaTallaRelacion as $o_MST_CategoriaTallaRelacionBN )
        {
            $o_MST_TallaFN = new MST_TallaFN();
            $o_MST_TallaBN = $o_MST_TallaFN->selectByPK( $o_MST_CategoriaTallaRelacionBN->getIdTalla() );
            $a_TallaDesc[] = $o_MST_TallaBN->getDescripcion();
        }
        return implode( ", ", $a_TallaDesc );
    }

    public function getProveedorDesc()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getIdProveedor() );
        if( $o_MST_PersonaMastBN )
        {
            return $o_MST_PersonaMastBN->getNombreCompleto();
        }
        return "";
    }

    protected $isChecked;

    public function getIsChecked()
    {
        return $this->isChecked;
    }

    public function setIsChecked( $isChecked ): void
    {
        $this->isChecked = $isChecked;
    }

    public function getArrayTallaRelacion()
    {
        $o_MST_CategoriaTallaRelacionFN = new MST_CategoriaTallaRelacionFN();
        $o_MST_CategoriaTallaRelacionFN->setIdCatTalla( $this->getIdCatTalla() );
        return $o_MST_CategoriaTallaRelacionFN->select();
    }
}
?>