<?php
/* Metodos de acceso a los campos de la tabla MKT_PromocionCab redefinidos por el usuario */
class MKT_PromocionCabBN extends BaseMKT_PromocionCabBN
{
    const ESTADO_PENDIENTE = "PE";
    const ESTADO_PUBLICADO = "PU";
    const ESTADO_TERMINADO = "TE";
    const ESTADO_CANCELADO = "CA";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            MKT_PromocionCabBN::ESTADO_PENDIENTE => "PENDIENTE",
            MKT_PromocionCabBN::ESTADO_PUBLICADO => "PUBLICADO",
            MKT_PromocionCabBN::ESTADO_TERMINADO => "TERMINADO",
            MKT_PromocionCabBN::ESTADO_CANCELADO => "CANCELADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoPromoDesc()
    {
        return MKT_PromocionCabBN::getArrayEstados( $this->getEstadoPromo() );
    }

    public function getCantRegItemPromocion()
    {
        $o_MKT_ItemPromocionFN = new MKT_ItemPromocionFN();
        $o_MKT_ItemPromocionFN->setIdPromoCab( $this->getIdPromoCab() );
        return $o_MKT_ItemPromocionFN->selectNumRows();
    }

    public function getArrayItemPromocion()
    {
        $o_MKT_ItemPromocionFN = new MKT_ItemPromocionFN();
        $o_MKT_ItemPromocionFN->setIdPromoCab( $this->getIdPromoCab() );
        $a_MKT_ItemPromocion = $o_MKT_ItemPromocionFN->select();
        return $a_MKT_ItemPromocion;
    }
    
    public function getSaldoDisponible()
    {
        return $this->getCantidadPromo() - $this->getCantidadFacturado();
    }
}
?>