<?php
/* Metodos de acceso a los campos de la tabla GSS_SucursalDocumento redefinidos por el usuario */
class GSS_SucursalDocumentoBN extends BaseGSS_SucursalDocumentoBN
{
    public function getCompaniaDesc()
    {
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->getIdCompania() );
        if( !$o_GSS_CompaniaBN )
        {
            return "----";
        }
        return $o_GSS_CompaniaBN->getDescripcionCorta();
    }
    
    public function getSucursalDesc()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        if( $o_GSS_SucursalBN )
        {
            return $o_GSS_SucursalBN->getDescripcion();
        }
        return "";
    }
    
    public function getTipoDocumentoDesc()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        return $o_VTA_TipoDocumentoBN->getDescripcionLocal();
    }

    public function getObjectTipoDocumento()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        return $o_VTA_TipoDocumentoBN;
    }
    
    public function getNumeroActualFormato()
    {
        $s_Numero = str_pad( ( $this->getNumeroActual() + 1 ), 10, "0", STR_PAD_LEFT );
        return $s_Numero;
    }
    
    public function getNumeroFormatoFinal()
    {
        $s_Numero = str_pad( ( $this->getNumeroActual() ), 10, "0", STR_PAD_LEFT );
        return $s_Numero;
    }
    
    public function getSerieFormatoFinal()
    {
        $s_Numero = str_pad( ( $this->getSerieFormato() ), 4, "0", STR_PAD_LEFT );
        return $s_Numero;
    }

    public function getObjUsuarioSucuDocumento( $s_IdUsuario )
    {
        $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
        $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( $this->getIdCompania() );
        $o_GSS_UsuarioSucuDocumentoFN->setIdUsuario( $s_IdUsuario );
        $o_GSS_UsuarioSucuDocumentoFN->setIdSucursalDocumento( $this->getIdSucursalDocumento() );
        $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();
        
        if( $a_GSS_UsuarioSucuDocumento )
        {
            return $a_GSS_UsuarioSucuDocumento[0];
        }
        return null;
    }
}
?>