<?php
/* Metodos de acceso a los campos de la tabla FCO_DocRecibo redefinidos por el usuario */
class FCO_DocReciboBN extends BaseFCO_DocReciboBN
{
    const ESTADO_ACTIVO  = "AC";
    const ESTADO_ANULADO = "AN";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            FCO_DocReciboBN::ESTADO_ACTIVO  => "ACTIVO",
            FCO_DocReciboBN::ESTADO_ANULADO => "ANULADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    public function getEstadoDesc()
    {
        return FCO_DocReciboBN::getArrayEstados( $this->getEstado() );
    }

    const FLUESTADO_PENDIENTE = "PE";
    const FLUESTADO_APROBADO  = "AP";
    const FLUESTADO_RECHAZADO = "RE";
    
    public static function getArrayFlujoEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            FCO_DocReciboBN::FLUESTADO_PENDIENTE => "PENDIENTE",
            FCO_DocReciboBN::FLUESTADO_APROBADO  => "APROBADO",
            FCO_DocReciboBN::FLUESTADO_RECHAZADO => "RECHAZADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    public function getFlujoEstadoDesc()
    {
        return FCO_DocReciboBN::getArrayFlujoEstados( $this->getFlujoEstado() );
    }
    
    const ESTADO_COB_PENDIENTE = "PE";
    const ESTADO_COB_COBRADO   = "CO";
    
    public static function getArrayCobranzaEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                FCO_DocReciboBN::ESTADO_COB_PENDIENTE => "PENDIENTE",
                FCO_DocReciboBN::ESTADO_COB_COBRADO   => "COBRADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    public function getCobranzaEstadoDesc()
    {
        return FCO_DocReciboBN::getArrayCobranzaEstados( $this->getCobranzaEstado() );
    }

    protected $IdDocNumRef;
    public function getIdDocNumRef()
    {
        return $this->IdDocNumRef;
    }
    public function setIdDocNumRef( $IdDocNumRef )
    {
        $this->IdDocNumRef = $IdDocNumRef;
    }

    public function getObjectTipoPago()
    {
        $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
        $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $this->getIdTipoPago() );
        return $o_FCO_TipoPagoBN;
    }
    public function getTipoPagoNombre()
    {
        $o_FCO_TipoPagoBN = $this->getObjectTipoPago();
        return $o_FCO_TipoPagoBN->getNombre();
    }

    public function getObjectSucursal()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        return $o_GSS_SucursalBN;
    }
    public function getSucursalNombre()
    {
        $o_GSS_SucursalBN = $this->getObjectSucursal();
        return $o_GSS_SucursalBN->getDescripcion();
    }
    
    public function getObjectBanco()
    {
        $o_GSS_BancoFN = new GSS_BancoFN();
        $o_GSS_BancoBN = $o_GSS_BancoFN->selectByPK( $this->getIdBanco() );
        return $o_GSS_BancoBN ;
    }
    
    public function getBancoDesc()
    {
        $o_GSS_BancoBN = $this->getObjectBanco();
        return $o_GSS_BancoBN->getDescripcionLocal();
    }
    
    public function getObjectCuentaBancaria()
    {
        $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
        $o_MST_CuentaBancariaBN = $o_MST_CuentaBancariaFN->selectByPK( $this->getIdCuenta() );
        return $o_MST_CuentaBancariaBN;
    }

    protected $MontoAplicado;
    public function getMontoAplicado()
    {
        return $this->MontoAplicado;
    }
    public function setMontoAplicado( $MontoAplicado )
    {
        $this->MontoAplicado = $MontoAplicado;
    }

    protected $IdAplicacion;
    public function getIdAplicacion()
    {
        return $this->IdAplicacion;
    }
    public function setIdAplicacion( $IdAplicacion )
    {
        $this->IdAplicacion = $IdAplicacion;
    }

    protected $NumeroComprobante;
    public function getNumeroComprobante()
    {
        return $this->NumeroComprobante;
    }
    public function setNumeroComprobante( $NumeroComprobante )
    {
        $this->NumeroComprobante = $NumeroComprobante;
    }
    
    public function getArrayAplicaciones()
    {
        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
        $o_FCO_AplicacionFN->setIdDocRecibo( $this->getIdDocRecibo() );
        $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
        return $a_FCO_Aplicacion;
    }

    public function getMontoDebe()
    {
        return $this->getMonto();
    }
    public function getMontoHaber()
    {
        return 0;
    }
    public function getMontoDebeMN()
    {
        return $this->getMontoMN();
    }
    public function getMontoHaberMN()
    {
        return 0;
    }
}
?>