<?php
/* M�todos de acceso a los campos de la tabla COM_OrdenCompraCabecera redefinidos por el usuario */
class COM_OrdenCompraCabeceraBN extends BaseCOM_OrdenCompraCabeceraBN
{
    //ESTADO
    const ORDEN_COMPRA_PREPARACION   = "PR";
    const ORDEN_COMPRA_APROBADO      = "AP";
    const ORDEN_COMPRA_RECHAZADO     = "RE";
    const ORDEN_COMPRA_ANULADO       = "AN";
    const ORDEN_COMPRA_COMPLETADO    = "CO";
    
    const TIPO_TRANSACCION_X_DEFECTO    = "I";
    const TIPO_TRANSACCION_S_DEFECTO    = "E";
    const TRANSACCION_X_DEFECTO         = "ROC"; //TIPO TRANSACCI�N - RECEPCION DE O/C
    const TRANSACCION_X_COMPRA_NACIONAL = "CPN"; //TIPO TRANSACCI�N - COMPRA NACIONAL
    const TRANSACCION_X_BONIFICACION    = "IBO"; //TIPO TRANSACCI�N
    const TRANSACCION_X_NC_PROV         = "DRO"; //TIPO TRANSACCI�N - SALIDA POR DEVOLUCION AL PROVEEDOR
    
    const TIPO_DOCUMENTO             = "NI"; //TIPO DE DOCUMENTO
    const TIPO_DOCUMENTO_S_NC        = "NS"; //TIPO DE DOCUMENTO
    const REF_TIPO_DOCUMENTO_DEFECTO = "OC"; //DOC REFERENCIA, REFERENCIA TIPO DOCUMENTO
    
    const TIPO_REQUERIMIENTO_LOG     = "OC";
    
    const TIPO_OC_LOCAL             = "L";
    const TIPO_OC_IMPORTACION       = "I";
    
    protected $o_ObjTransaccion;
    protected $a_OrdenCompraDetalle;
    protected $o_OrdenGuiaFacturaBN;
    
    public function getIdOrdenCompraConcat()
    {
        if( $this->getIdCompania() )
        {
            return $this->getIdCompania()."_".$this->getIdOrdenCompra();
        }
        return null;
    }
    
    public static function getArrayOrdenEstados( $sEstado = null )
    {
        $a_sEstado = array
                            (
                                COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION => "PREPARACION",
                                COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO    => "APROBADO",
                                COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_RECHAZADO   => "RECHAZADO",
                                COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_ANULADO     => "ANULADO",
                                COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_COMPLETADO  => "COMPLETADO"
                            );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return COM_OrdenCompraCabeceraBN::getArrayOrdenEstados( $this->getEstado() );
    }
    
    public function getMonedaDesc()
    {
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->getIdMoneda() );
        return $o_GSS_MonedaMastBN->getDescripcion();
    }
    
    public static function getArrayTipoOrdenCompra( $s_Tipo = null )
    {
        $a_Tipos = array
        (
            COM_OrdenCompraCabeceraBN::TIPO_OC_LOCAL           => "LOCAL",
            COM_OrdenCompraCabeceraBN::TIPO_OC_IMPORTACION     => "IMPORTACION"
        );
        if( !is_null( $s_Tipo ) )
        {
            return $a_Tipos[$s_Tipo];
        }
        return $a_Tipos;
    }
    
    public function getTipoOCDesc()
    {
        return COM_OrdenCompraCabeceraBN::getArrayTipoOrdenCompra( $this->getTipoOrden() );
    }
    
    public function getObjectOrdenClasificacion()
    {
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $this->getIdOrdenClasificacion() );
        return $o_COM_OrdenItemClasificacionBN;
    }
    
    public function getOrdenClasificacionDesc()
    {
        $o_COM_OrdenItemClasificacionBN = $this->getObjectOrdenClasificacion();
        if( $o_COM_OrdenItemClasificacionBN )
        {
            return $o_COM_OrdenItemClasificacionBN->getDescripcion();
        }
        return "";
    }
    
    public function setObjectTransaccion( $v )
    {
        $this->o_ObjTransaccion = $v;
    }
    public function getObjectTransaccion()
    {
        return $this->o_ObjTransaccion;
    }
    
    public function setObjectOrdenGuiaFactura( $v )
    {
        $this->o_OrdenGuiaFacturaBN = $v;
    }
    public function getObjectOrdenGuiaFactura()
    {
        return $this->o_OrdenGuiaFacturaBN;
    }
    
    public function setArrayOrdenCompraDetalle( $v )
    {
        $this->a_OrdenCompraDetalle = $v;
    }

    /**
     * @return COM_OrdenCompraDetalleBN[]
     */
    public function getArrayOrdenCompraDetalle()
    {
        return $this->a_OrdenCompraDetalle;
    }
    
    public function getFormatMontoBruto()
    {
        return number_format( $this->getMontoBruto(), 2 );
        /*
        if( $this->getIdMoneda() == "LO" )
        {
            return number_format( $this->getMontoBruto(), 2 );
        }
        else
        {
            return number_format( $this->getMontoBruto() * $this->getTipoCambio()  , 2 );
        }
        */
    }
    
    public function getFormatMontoDolares()
    {
        if( $this->getIdMoneda() == "EX" )
        {
            return number_format( $this->getMontoBruto(), 2 );
        }
        else
        {
            return number_format( $this->getMontoBruto() / $this->getTipoCambio()  , 2 );
        }
    }

    public function getAlmacenDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacenEntrega() );
        if( !$o_ALM_AlmacenMastBN )
        {
            $o_ALM_AlmacenMastBN = new ALM_AlmacenMastBN();
        }
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }    
    
    public function getArrayObjectDetalles()
    {
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $this->getIdOrdenCompra() );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $this->getIdCompania() );
        $o_COM_OrdenCompraDetalleFN->addOrderBy( COM_OrdenCompraDetalleFN::IdItem );
        $a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
        return $a_COM_OrdenCompraDetalle;
    }
    
    public function getArrayObjectTransacciones()
    {
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $o_ALM_TransaccionCabeceraFN->setIdCompania( $this->getIdCompania() );
        $o_ALM_TransaccionCabeceraFN->setReferenciaTipoDocumento( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO );
        $o_ALM_TransaccionCabeceraFN->setReferenciaNumeroDocumento( $this->getIdOrdenCompra() );
        $o_ALM_TransaccionCabeceraFN->setIdTipoDocumento( COM_OrdenCompraCabeceraBN::TIPO_DOCUMENTO );
        $a_ALM_TransaccionCabecera = $o_ALM_TransaccionCabeceraFN->select();
        return $a_ALM_TransaccionCabecera;
    }
    
    public function getArrayObjectTransaccionesNC()
    {
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $o_ALM_TransaccionCabeceraFN->setIdCompania( $this->getIdCompania() );
        $o_ALM_TransaccionCabeceraFN->setReferenciaTipoDocumento( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO );
        $o_ALM_TransaccionCabeceraFN->setReferenciaNumeroDocumento( $this->getIdOrdenCompra() );
        $o_ALM_TransaccionCabeceraFN->setIdTipoDocumento( COM_OrdenCompraCabeceraBN::TIPO_DOCUMENTO_S_NC );
        $a_ALM_TransaccionCabecera = $o_ALM_TransaccionCabeceraFN->select();
        return $a_ALM_TransaccionCabecera;
    }
    
    protected $TipoRequerimientoLog;
    /**
     * @return the $TipoRequerimientoLog
     */
    public function getTipoRequerimientoLog()
    {
        return $this->TipoRequerimientoLog;
    }

    /**
     * @param field_type $TipoRequerimientoLog
     */
    public function setTipoRequerimientoLog($TipoRequerimientoLog)
    {
        $this->TipoRequerimientoLog = $TipoRequerimientoLog;
    }

    
    protected $s_SerieDocumentoFiscal;
    protected $s_NumeroDocumentoFiscal;
    protected $i_SecuenciaSerieNumero;
    public function setSerieDocumentoFiscal( $s_SerieDocumentoFiscal )
    {
        $this->s_SerieDocumentoFiscal = $s_SerieDocumentoFiscal;
    }
    public function getSerieDocumentoFiscal()
    {
        return $this->s_SerieDocumentoFiscal;
    }
    public function setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal )
    {
        $this->s_NumeroDocumentoFiscal = $s_NumeroDocumentoFiscal;
    }
    public function getNumeroDocumentoFiscal()
    {
        return $this->s_NumeroDocumentoFiscal;
    }

    public function getModoIngresoConIGVFlag()
    {
        return $this->getObservacionRechazo();
    }

    public function setSecuenciaSerieNumero( $v )
    {
        $this->i_SecuenciaSerieNumero = $v;
    }
    public function getSecuenciaSerieNumero()
    {
        return $this->i_SecuenciaSerieNumero;
    }

    public function esAfectoAIGV()
    {
        if( $this->getAfectoIGV() )
        {
            return true;
        }
        return false;
    }
}
?>