<?php
/* Metodos de acceso a los campos de la tabla ALM_TransferenciaDetalle redefinidos por el usuario */
class ALM_TransferenciaDetalleBN extends BaseALM_TransferenciaDetalleBN
{
    protected static $instance = null;
    
    public function getObjetocabecera()
    {
        if ( !isset( self::$instance ) )
        {
            $o_ALM_TransferenciaCabeceraFN = new ALM_TransferenciaCabeceraFN();
            $o_ALM_TransferenciaCabeceraBN = $o_ALM_TransferenciaCabeceraFN->selectByPK( $this->getIdTransferencia() );
            self::$instance = $o_ALM_TransferenciaCabeceraBN;
            //self::$instance->initialize();
        }
        return self::$instance;
    }
    
    public function getIdAlmacenOrigen()
    {
        return $this->getObjetocabecera()->getIdAlmacen();
    }
    
    public function getIdCompania()
    {
        return $this->getObjetocabecera()->getIdCompania();
    }
    
    public function getStockActual()
    {
        $s_IdCompania = $this->getIdCompania();
        $s_IdAlmacen  = $this->getIdAlmacenOrigen();
        $s_IdLote     = $this->getIdLote();
        $s_IdItem     = $this->getIdItem();
        //BUSCAR EL STOCK
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $s_IdCompania, $s_IdItem, $s_IdAlmacen, ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO, $s_IdLote );
        if( $o_ALM_ItemAlmacenStockBN )
        {    
            return $o_ALM_ItemAlmacenStockBN->getStockFisico();
        }
        return "0";
    }

    public function getObjectUnidad()
    {
        if( $this->getUnidadCodigo() )
        {
            $o_MST_UnidadMastFN = new MST_UnidadMastFN();
            $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $this->getUnidadCodigo() );
        }
        else 
        {
            $o_MST_UnidadMastBN = new MST_UnidadMastBN();
            $o_MST_UnidadMastBN->setDescripcionCorta( "-" );
        }
        return $o_MST_UnidadMastBN;
    }

    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN;
    }
}
?>