<?php
/* M�todos de acceso a los campos de la tabla ALM_ItemMast redefinidos por el usuario */
class ALM_ItemMastBN extends BaseALM_ItemMastBN
{
    protected $i_IdCompania;
    protected $s_IdAlmacen;
    protected $s_IdSucursal;
    protected $s_ConStock;
    
    const ESTADO_ACTIVO   = "A";
    const ESTADO_INACTIVO = "I";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            ALM_ItemMastBN::ESTADO_ACTIVO   => "ACTIVO",
            ALM_ItemMastBN::ESTADO_INACTIVO => "INACTIVO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return ALM_ItemMastBN::getArrayEstados( $this->getEstado() );
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    static $a_TipoOperatividad = array
    (
            "NVO" => "NUEVO", "UO" => "USADO OPERATIVO", "UI" => "USADO INOPERATIVO"
    );
    
    public static function getArrayTipoOperatividad( $s_Param = null )
    {
        if( !is_null( $s_Param ) )
        {
            if( isset( ALM_ItemMastBN::$a_TipoOperatividad[$s_Param] ) )
            {
                return ALM_ItemMastBN::$a_TipoOperatividad[$s_Param];
            }
            else
            {
                return "----";
            }
        }
        return ALM_ItemMastBN::$a_TipoOperatividad;
    }
    
    public function getTipoOperatividadDesc()
    {
        return ALM_ItemMastBN::getArrayTipoOperatividad( $this->getIdTipoOperatividad() );
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public function setIdCompania( $v )
    {
        $this->i_IdCompania = $v;
    }
    
    public function getIdCompania()
    {
        return $this->i_IdCompania;
    }
    
    public function setIdAlmacen( $v )
    {
        $this->s_IdAlmacen = $v;
    }
    
    public function getIdAlmacen()
    {
        return $this->s_IdAlmacen;
    }
    
    public function setIdSucursal( $v )
    {
        $this->s_IdSucursal = $v;
    }
    
    public function getIdSucursal()
    {
        return $this->s_IdSucursal;
    }
    
    public function setConStock( $v )
    {
        $this->s_ConStock = $v;
    }
    public function getConStock()
    {
        return $this->s_ConStock;
    }

    protected $IdColor;
    protected $IdCatTalla;
    protected $IdTalla;
    protected $IdReferencia;
    protected $IdProveedor;

    public function getIdColor()
    {
        return $this->IdColor;
    }

    public function setIdColor($IdColor): void
    {
        $this->IdColor = $IdColor;
    }

    public function getIdCatTalla()
    {
        return $this->IdCatTalla;
    }

    public function setIdCatTalla($IdCatTalla): void
    {
        $this->IdCatTalla = $IdCatTalla;
    }

    public function getIdTalla()
    {
        return $this->IdTalla;
    }

    public function setIdTalla($IdTalla): void
    {
        $this->IdTalla = $IdTalla;
    }

    public function getIdReferencia()
    {
        return $this->IdReferencia;
    }

    public function setIdReferencia($IdReferencia): void
    {
        $this->IdReferencia = $IdReferencia;
    }

    public function getIdProveedor()
    {
        return $this->IdProveedor;
    }

    public function setIdProveedor($IdProveedor): void
    {
        $this->IdProveedor = $IdProveedor;
    }

    public function getObjectTipoItem()
    {
        $o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
        $o_ALM_ItemTipoBN = $o_ALM_ItemTipoFN->selectByPK( $this->getIdItemTipo() );
        if( !$o_ALM_ItemTipoBN )
        {
            $o_ALM_ItemTipoBN = new ALM_ItemTipoBN();
        }
        return $o_ALM_ItemTipoBN;
    }

    public function getObjectUnidad( $IdUnidad=null )
    {
        if( $IdUnidad )
        {
            $o_MST_UnidadMastFN = new MST_UnidadMastFN();
            $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $IdUnidad );
            return $o_MST_UnidadMastBN;
        }
        else
        {
            $o_MST_UnidadMastFN = new MST_UnidadMastFN();
            $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $this->getUnidadVenta() );
            return $o_MST_UnidadMastBN;
        }
    }

    public function getObjectUnidadVenta()
    {
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $this->getUnidadVenta() );
        return $o_MST_UnidadMastBN;
    }

    public function getObjectUnidadCompra()
    {
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $this->getUnidadCompra() );
        return $o_MST_UnidadMastBN;
    }

    public function getObjectTipoGarantia()
    {
        $o_MST_TipoGarantiaBN = null;
        if( $this->getTipoGarantiaId() )
        {
            $o_MST_TipoGarantiaFN = new MST_TipoGarantiaFN();
            $o_MST_TipoGarantiaBN = $o_MST_TipoGarantiaFN->selectByPK( $this->getTipoGarantiaId() );
        }
        if( !$o_MST_TipoGarantiaBN )
        {
            
            $o_MST_TipoGarantiaBN = new MST_TipoGarantiaBN();
            $o_MST_TipoGarantiaBN->setNombre( "No Aplica" );
        }
        return $o_MST_TipoGarantiaBN;
    }

    public function getUnidadAlmacenajeDesc()
    {
        return $this->getObjectUnidad( $this->getUnidadAlmacenaje() )->getDescripcionCorta();
    }

    public function getUnidadVentaDesc()
    {
        return $this->getObjectUnidad( $this->getUnidadVenta() )->getDescripcionCorta();
    }
    
    public function getObjectItemAlmacenStock( $AlmacenCod, $IdLote="" )
    {
        if( $IdLote != "" )
        {
            $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
            $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( myUser::getUser()->getIdBusiness(), $this->getIdItem(), $AlmacenCod, ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO , $IdLote );
            if( !$o_ALM_ItemAlmacenStockBN )
            {
                $o_ALM_ItemAlmacenStockBN = new ALM_ItemAlmacenStockBN();
                $o_ALM_ItemAlmacenStockBN->setStockActual( 0 );
            }
            return $o_ALM_ItemAlmacenStockBN;
        }
        else
        {
            $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
            $o_ALM_ItemAlmacenStockFN->setIdAlmacen( $AlmacenCod );
            $o_ALM_ItemAlmacenStockFN->setIdItem( $this->getIdItem() );
            $a_ALM_ItemAlmacenStock = $o_ALM_ItemAlmacenStockFN->select();
            if( !$a_ALM_ItemAlmacenStock )
            {
                $a_ALM_ItemAlmacenStock = array();
            }
            return $a_ALM_ItemAlmacenStock;
        }
    }
    
    public function getStockLoteActual( $AlmacenCod, $IdLote )
    {
        return $this->getObjectItemAlmacenStock( $AlmacenCod, $IdLote )->getStockActual();
    }
    
    public function getStockAlmacenActual( $AlmacenCod=null )
    {
        $f_StockActualTotal = 0;
        $a_ALM_ItemAlmacenStock = $this->getObjectItemAlmacenStock( $AlmacenCod );
        foreach ( $a_ALM_ItemAlmacenStock as $o_ALM_ItemAlmacenStockBN )
        {
            $f_StockFisico = $o_ALM_ItemAlmacenStockBN->getStockFisico();
            $f_StockActualTotal = $f_StockActualTotal + $f_StockFisico;
        }
        return $f_StockActualTotal;
    }
    
    public function getStockFisicoTotal()
    {
        $f_StockFisicoTotal = 0;
        $AlmacenCod = null;
        
        if( myUser::getUser()->getIdSucursal() )
        {
            $AlmacenCod = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
        }
        $a_ALM_ItemAlmacenStock = $this->getObjectItemAlmacenStock( $AlmacenCod );
        foreach ( $a_ALM_ItemAlmacenStock as $o_ALM_ItemAlmacenStockBN )
        {
            $f_StockFisico = $o_ALM_ItemAlmacenStockBN->getStockFisico();
            $f_StockFisicoTotal = $f_StockFisicoTotal + $f_StockFisico;
        }
        //nuevo cambio para recuperar el stock por la unidad de medida
        if( $this->getCantidadUnidad() > 1 )
        {
            $f_StockFisicoTotal = round( $f_StockFisicoTotal / $this->getCantidadUnidad(), 2 );
        }
        return $f_StockFisicoTotal;
    }
    
    public function getStockFisicoAlmacenes()
    {
        $f_StockFisicoTotal = 0;
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockFN->setIdItem( $this->getIdItem() );
        $a_ALM_ItemAlmacenStock = $o_ALM_ItemAlmacenStockFN->select();
        foreach ( $a_ALM_ItemAlmacenStock as $o_ALM_ItemAlmacenStockBN )
        {
            $f_StockFisico = $o_ALM_ItemAlmacenStockBN->getStockFisico();
            $f_StockFisicoTotal = $f_StockFisicoTotal + $f_StockFisico;
        }
        //nuevo cambio para recuperar el stock por la unidad de medida
        if( $this->getCantidadUnidad() > 1 )
        {
            $f_StockFisicoTotal = round( $f_StockFisicoTotal / $this->getCantidadUnidad(), 2 );
        }
        return $f_StockFisicoTotal;
    }
    
    public function getStockDisponibleTotal()
    {
        $f_StockDisponileTotal = 0;
        $AlmacenCod = null;
        
        if( myUser::getUser()->getIdSucursal() )
        {
            $AlmacenCod = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
        }
        $a_ALM_ItemAlmacenStock = $this->getObjectItemAlmacenStock( $AlmacenCod );
        foreach ( $a_ALM_ItemAlmacenStock as $o_ALM_ItemAlmacenStockBN )
        {
            $f_StockDisponible = $o_ALM_ItemAlmacenStockBN->getStockDisponible();
            $f_StockDisponileTotal = $f_StockDisponileTotal + $f_StockDisponible;
        }
        //nuevo cambio para recuperar el stock por la unidad de medida
        if( $this->getCantidadUnidad() > 1 )
        {
            $f_StockDisponileTotal = round( $f_StockDisponileTotal / $this->getCantidadUnidad(), 2 );
        }

        return $f_StockDisponileTotal;
    }
    
    public function getDescripcionFamilia()
    {
        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $o_MST_ClaseFamiliaBN = $o_MST_ClaseFamiliaFN->selectByPK( $this->getIdFamilia() );
        if( $o_MST_ClaseFamiliaBN )
        {
            return $o_MST_ClaseFamiliaBN->getDescripcion();
        }
        return "";
    }
    
    public function getDescripcionSubFamilia()
    {
        $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
        $o_MST_ClaseSubFamiliaBN = $o_MST_ClaseSubFamiliaFN->selectByPK( $this->getIdSubFamilia() );
        if( $o_MST_ClaseSubFamiliaBN )
        {
            return $o_MST_ClaseSubFamiliaBN->getDescripcion();
        }
        return "";
    }
    
    public function getDescripcionLinea()
    {
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaBN = $o_MST_ClaseLineaFN->selectByPK( $this->getIdLinea() );
        if( $o_MST_ClaseLineaBN )
        {
            return $o_MST_ClaseLineaBN->getDescripcion();
        }
        return "";
    }

    public function getObjectMarca()
    {
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaBN = $o_ALM_MarcaFN->selectByPK( $this->getIdMarca() );
        if( !$o_ALM_MarcaBN )
        {
            $o_ALM_MarcaBN = new ALM_MarcaBN();
        }
        return $o_ALM_MarcaBN;
    }

    public function getDescripcionMarca()
    {
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaBN = $o_ALM_MarcaFN->selectByPK( $this->getIdMarca() );
        if( $o_ALM_MarcaBN )
        {
            return $o_ALM_MarcaBN->getDescripcionLocal();
        }
        return "XXX";
    }
    
    public function getProveedorDesc()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getIdPersona() );
        if( $o_MST_PersonaMastBN )
        {
            return $o_MST_PersonaMastBN->getNombreCompletoLLeno();
        }
        return "";
    }

    //------------------------------------------------------------------------------------------------------------------------------------------------------------------------//
    //Por el Stock Reposición

    public function getRepoStockMinimo( $IdCompania=null, $IdSucursal=null, $IdAlmacen=null, $IdPersona=null )
    {
        if( !$IdCompania )
        {
            $IdCompania = ALM_ItemMastBN::getStaticIdCompania();
            $IdSucursal = ALM_ItemMastBN::getStaticIdSucursal();
            $IdAlmacen  = ALM_ItemMastBN::getStaticIdAlmacen();
            $IdPersona  = ALM_ItemMastBN::getStaticIdPersona();
        }
        $o_MST_StockReposicionDetalleFN = new MST_StockReposicionDetalleFN();
        $o_MST_StockReposicionDetalleBN = $o_MST_StockReposicionDetalleFN->selectByPK( $IdCompania, $IdSucursal, $IdAlmacen, $IdPersona, $this->getIdItem() );
        if( $o_MST_StockReposicionDetalleBN )
        {
            return $o_MST_StockReposicionDetalleBN->getStockMinimo();
        }
        return 0;
    }

    public function buscarStockMinimo( $i_IdStockRepo )
    {
        $o_MST_StockReposicionDetalleFN = new MST_StockReposicionDetalleFN();
        $o_MST_StockReposicionDetalleFN->setIdStockRepo( $i_IdStockRepo );
        $o_MST_StockReposicionDetalleFN->setIdItem( $this->getIdItem() );
        $a_MST_StockReposicionDetalle = $o_MST_StockReposicionDetalleFN->select();
        if( $a_MST_StockReposicionDetalle )
        {
            $o_MST_StockReposicionDetalleBN = $a_MST_StockReposicionDetalle[0];
            return $o_MST_StockReposicionDetalleBN->getStockMinimo();
        }
        return 0;
    }

    public function buscarStockMaximo( $i_IdStockRepo )
    {
        $o_MST_StockReposicionDetalleFN = new MST_StockReposicionDetalleFN();
        $o_MST_StockReposicionDetalleFN->setIdStockRepo( $i_IdStockRepo );
        $o_MST_StockReposicionDetalleFN->setIdItem( $this->getIdItem() );
        $a_MST_StockReposicionDetalle = $o_MST_StockReposicionDetalleFN->select();
        if( $a_MST_StockReposicionDetalle )
        {
            $o_MST_StockReposicionDetalleBN = $a_MST_StockReposicionDetalle[0];
            return $o_MST_StockReposicionDetalleBN->getStockMaximo();
        }
        return 0;
    }

    //------------------------------------------------------------------------------------------------------------------------------------------------------------------------//

    protected $PrecioConIGV;
    public function setPrecioConIGV( $v )
    {
        $this->PrecioConIGV = $v;
    }
    public function getPrecioConIGV()
    {
        $PrecioFinal = 0;
        if( myUser::getUser()->getIdSucursal() )
        {
            if( $this->PrecioConIGV )
            {
                $PrecioFinal = $this->PrecioConIGV;
            }
            else
            {
                $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                $o_MST_ListaPrecioDetalleFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_MST_ListaPrecioDetalleFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_MST_ListaPrecioDetalleFN->setIdItem( $this->getIdItem() );
                $o_MST_ListaPrecioDetalleFN->addOrderBy( MST_ListaPrecioDetalleFN::PrecioVentaIGV, false );
                $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();
                $o_MST_ListaPrecioDetalleBN = new MST_ListaPrecioDetalleBN();
                if( $a_MST_ListaPrecioDetalle )
                {
                    $o_MST_ListaPrecioDetalleBN = $a_MST_ListaPrecioDetalle[0];
                }
                if( $o_MST_ListaPrecioDetalleBN )
                {
                    $PrecioFinal = $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV();
                }
                else
                {
                    $PrecioFinal = 0;
                }
            }
        }
        return $PrecioFinal;
    }

    protected $PrecioConIGVFra;
    public function setPrecioConIGVFra( $v )
    {
        $this->PrecioConIGVFra = $v;
    }
    public function getPrecioConIGVFra()
    {
        return $this->PrecioConIGVFra;
    }

    public function getPrecioCostoLstPrecio( $i_IdCompania, $i_IdSucursal )
    {
        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
        $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( $i_IdCompania, $i_IdSucursal, $this->getIdItem(), "1" );
        if( $o_MST_ListaPrecioDetalleBN )
        {
            return $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
        }
        return 0;
    }

    public function getPrecioCostoLstPrecioIGV( $i_IdCompania=null, $i_IdSucursal=null )
    {
        $a_DataKardex = ALM_KardexFN::buscarUltimoCostoIngreso( myUser::getUser()->getIdCompania(), myUser::getUser()->getIdSucursal(), '', $this->getIdItem(), date( "Y-m-d" ) );
        if( $a_DataKardex )
        {
            //return $a_DataKardex['SaldoPrecioCosto']; //campo que identifica el costo calculado
            return floatval( $a_DataKardex['MontoTotal'] ); //campo de costo de ingreso
        }
        return 0;
    }

    public function getPorcentajeUtilidadLstPrecio( $i_IdCompania, $i_IdSucursal, $i_IdTipoPrecio=null )
    {
        if( is_null( $i_IdTipoPrecio ) )
        {
            $i_IdTipoPrecio = 1;
        }
        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
        $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( $i_IdCompania, $i_IdSucursal, $this->getIdItem(), $i_IdTipoPrecio );
        if( $o_MST_ListaPrecioDetalleBN )
        {
            return $o_MST_ListaPrecioDetalleBN->getPorcentajeUtilidad();
        }
        return "";
    }
    
    public function getPrecioVentaLstPrecio( $i_IdCompania, $i_IdSucursal, $i_IdTipoPrecio=null )
    {
        if( is_null( $i_IdTipoPrecio ) )
        {
            $i_IdTipoPrecio = 1;
        }
        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
        $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( $i_IdCompania, $i_IdSucursal, $this->getIdItem(), $i_IdTipoPrecio );
        if( $o_MST_ListaPrecioDetalleBN )
        {
            return $o_MST_ListaPrecioDetalleBN->getPrecioVenta();
        }
        return "";
    }

    public function getMontoIGVLstPrecio( $i_IdCompania, $i_IdSucursal, $i_IdTipoPrecio=null )
    {
        if( is_null( $i_IdTipoPrecio ) )
        {
            $i_IdTipoPrecio = 1;
        }
        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
        $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( $i_IdCompania, $i_IdSucursal, $this->getIdItem(), $i_IdTipoPrecio );
        if( $o_MST_ListaPrecioDetalleBN )
        {
            return $o_MST_ListaPrecioDetalleBN->getMontoIGV();
        }
        return "";
    }

    public function getPrecioVentaLstPrecioIGV( $i_IdCompania, $i_IdSucursal, $i_IdTipoPrecio=null )
    {
        if( is_null( $i_IdTipoPrecio ) )
        {
            $i_IdTipoPrecio = 1;
        }
        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
        $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( $i_IdCompania, $i_IdSucursal, $this->getIdItem(), $i_IdTipoPrecio );
        if( $o_MST_ListaPrecioDetalleBN )
        {
            return $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV();
        }
        return "";
    }

    //------------------------------------------------------------------------------------------------------------------------------------------------------------------------//
    //Para el modulo de Requerimiento
    protected static $IdRequerimiento = null;
    public static function setIdRequerimiento( $v )
    {
        self::$IdRequerimiento = $v;
    }
    public static function getIdRequerimiento()
    {
        return self::$IdRequerimiento;
    }

    public function SiManejaLote()
    {
        if( $this->getManejoxLoteFlag() == "S" )
        {
            return true;
        }
        else 
        {
            return false;
        }
    }
    
    public function SiManejaSerie()
    {
        if( $this->getManejoxSerieFlag() == "S" )
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function SiFuscionLote()
    {
        if( $this->getFusionarLoteFlag() == "S" )
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function SiEsInventariable()
    {
        if( $this->getEsInventariableFlag() == "S" )
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function SiUsarDisponibleStock()
    {
        if( $this->getUsarDisponibleStock() == "S" )
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function SiUsarReservableStock()
    {
        if( $this->getUsarResevableStock() == "S" )
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function EsAfectoaIGV()
    {
        if( $this->getNoAfectoImpuestoVentasFlag() == "S" )
        {
            return false;
        }
        return true;
    }
    
    // --------------------------------------------------------------------------------------------- //
    protected $IdLote;
    protected $FechaVencimientoLote;
    protected $ConcatLoteFecV;
    protected $UniMedVenta;
    protected $UniMedVentaDesc;
    protected $CantUniMedVenta;

    protected $CantUniMedVentaTexto;
    protected $IdUniMedVenta;
    protected $CantidadxUnidad;
    protected $CantidadxCaja;

    public function getIdLote()
    {
        return $this->IdLote;
    }
    public function setIdLote( $IdLote )
    {
        $this->IdLote = $IdLote;
    }
    public function getFechaVencimientoLote()
    {
        return $this->FechaVencimientoLote;
    }
    public function setFechaVencimientoLote($FechaVencimientoLote)
    {
        $this->FechaVencimientoLote = $FechaVencimientoLote;
    }
    public function getConcatLoteFecV()
    {
        return $this->ConcatLoteFecV;
    }
    public function setConcatLoteFecV( $IdLote )
    {
        $this->ConcatLoteFecV = $IdLote;
    }

    public function getUniMedVentaDesc()
    {
        return $this->UniMedVentaDesc;
    }
    public function setUniMedVentaDesc($UniMedVenta)
    {
        $this->UniMedVentaDesc = $UniMedVenta;
    }
    public function getIdUniMedVenta()
    {
        return $this->IdUniMedVenta;
    }
    public function setIdUniMedVenta($UniMedVenta)
    {
        $this->IdUniMedVenta = $UniMedVenta;
    }
    
    public function getCantUniMedVenta()
    {
        return $this->CantUniMedVenta;
    }
    public function setCantUniMedVenta($CantUniMedVenta)
    {
        $this->CantUniMedVenta = $CantUniMedVenta;
    }
    public function getCantUniMedVentaTexto()
    {
        return $this->CantUniMedVentaTexto;
    }
    public function setCantUniMedVentaTexto($CantUniMedVentaTexto)
    {
        $this->CantUniMedVentaTexto = $CantUniMedVentaTexto;
    }
    public function getCantidadxUnidad()
    {
        return $this->CantidadxUnidad;
    }
    public function setCantidadxUnidad($CantidadxUnidad)
    {
        $this->CantidadxUnidad = $CantidadxUnidad;
    }
    public function getCantidadxCaja()
    {
        return $this->CantidadxCaja;
    }
    public function setCantidadxCaja($CantidadxCaja)
    {
        $this->CantidadxCaja = $CantidadxCaja;
    }
    
    // --------------------------------------------------------------------------------------------- //

    public function getImagenDir()
    {
        return ALM_ItemMastFN::existeDirImagen( $this->getIdItem() );
    }
    
    protected $StockActual;
    public function getStockActual()
    {
        if( is_null( $this->StockActual ) )
        {
            $f_StockActualTotal = 0;
            $a_ALM_ItemAlmacenStock = $this->getObjectItemAlmacenStock( GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() ) );
            foreach ( $a_ALM_ItemAlmacenStock as $i_Key => $o_ALM_ItemAlmacenStockBN )
            {
                $f_StockActual = $o_ALM_ItemAlmacenStockBN->getStockDisponible();
                $f_StockActualTotal = $f_StockActualTotal + $f_StockActual;
            }
            $this->StockActual = $f_StockActualTotal;
        }
        return $this->StockActual;
    }
    public function setStockActual( $v )
    {
        $this->StockActual = $v;
    }

    protected $StockDisponible;
    public function setStockDisponible( $v )
    {
        $this->StockDisponible = $v;
    }    
    public function getStockDisponible()
    {
        return $this->StockDisponible;
    }

    /*protected $StockFisicoActual;
    public function setStockFisicoActual( $StockFisicoActual )
    {
        $this->StockFisicoActual = $StockFisicoActual;
    }
    public function getStockFisicoActual()
    {
        return $this->StockFisicoActual;
    }*/

    protected $StockFisico;
    public function getStockFisico()
    {
        return $this->StockFisico;
    }
    public function setStockFisico( $StockFisico )
    {
        $this->StockFisico = $StockFisico;
    }

    protected $StockReservado;
    public function getStockReservado()
    {
        return $this->StockReservado;
    }
    public function setStockReservado($StockReservado)
    {
        $this->StockReservado = $StockReservado;
    }

    protected $CantidadLotes;
    public function getCantidadLotes()
    {
        return $this->CantidadLotes;
    }
    public function setCantidadLotes($CantidadLotes)
    {
        $this->CantidadLotes = $CantidadLotes;
    }

    protected $DescripcionTipoItem;
    public function getDescripcionTipoItem()
    {
        return $this->DescripcionTipoItem;
    }
    public function setDescripcionTipoItem($DescripcionTipoItem)
    {
        $this->DescripcionTipoItem = $DescripcionTipoItem;
    }

    protected $DescripcionAlmacen;
    public function getDescripcionAlmacen()
    {
        return $this->DescripcionAlmacen;
    }
    public function setDescripcionAlmacen($DescripcionAlmacen)
    {
        $this->DescripcionAlmacen = $DescripcionAlmacen;
    }

    protected $UnidadEquivalenteFlag;
    public function getUnidadEquivalenteFlag()
    {
        return $this->UnidadEquivalenteFlag;
    }
    public function setUnidadEquivalenteFlag( $UnidadEquivalenteFlag )
    {
        $this->UnidadEquivalenteFlag = $UnidadEquivalenteFlag;
    }

    protected $UsoFraccionFlag;
    public function getUsoFraccionFlag()
    {
        return $this->UsoFraccionFlag;
    }
    public function setUsoFraccionFlag( $UsoFraccionFlag )
    {
        $this->UsoFraccionFlag = $UsoFraccionFlag;
    }

    protected $EsUnidadMinimaFlag;
    public function getEsUnidadMinimaFlag()
    {
        return $this->EsUnidadMinimaFlag;
    }
    public function setEsUnidadMinimaFlag( $EsUnidadMinimaFlag )
    {
        $this->EsUnidadMinimaFlag = $EsUnidadMinimaFlag;
    }

    public function getNombreArchivoFinal(  )
    {
        if( $this->getNombreArchivo() )
        {
            return $this->getNombreArchivo();
        }
        else
        {
            return "imagen_no_disponible.jpg";
        }
    }

    protected $PrecioVenta1;
    public function getPrecioVenta1()
    {
        return $this->PrecioVenta1;
    }
    public function setPrecioVenta1( $Precio1 ): void
    {
        $this->PrecioVenta1 = $Precio1;
    }

    protected $PrecioVenta2;
    public function getPrecioVenta2()
    {
        return $this->PrecioVenta2;
    }
    public function setPrecioVenta2( $Precio2 ): void
    {
        $this->PrecioVenta2 = $Precio2;
    }

    protected $PrecioVenta3;
    public function getPrecioVenta3()
    {
        return $this->PrecioVenta3;
    }
    public function setPrecioVenta3( $Precio3 ): void
    {
        $this->PrecioVenta3 = $Precio3;
    }

    protected $ControlPrecios;
    public function getControlPrecios()
    {
        return $this->ControlPrecios;
    }
    public function setControlPrecios( $ControlPrecios ): void
    {
        $this->ControlPrecios = $ControlPrecios;
    }

    protected $MarcaDescripcion;
    public function getMarcaDescripcion()
    {
        return $this->MarcaDescripcion;
    }
    public function setMarcaDescripcion( $ControlPrecios ): void
    {
        $this->MarcaDescripcion = $ControlPrecios;
    }

    protected $LineaDescripcion;
    protected $FamiliaDescripcion;
    protected $SubFamiliaDescripcion;
    protected $UnidadMedidaVentaDesc;

    public function getUnidadMedidaVentaDesc()
    {
        return $this->UnidadMedidaVentaDesc;
    }

    public function setUnidadMedidaVentaDesc( $UnidadMedidaVentaDesc ): void
    {
        $this->UnidadMedidaVentaDesc = $UnidadMedidaVentaDesc;
    }

    public function getLineaDescripcion()
    {
        return $this->LineaDescripcion;
    }

    public function setLineaDescripcion( $LineaDescripcion ): void
    {
        $this->LineaDescripcion = $LineaDescripcion;
    }

    public function getFamiliaDescripcion()
    {
        return $this->FamiliaDescripcion;
    }

    public function setFamiliaDescripcion( $FamiliaDescripcion ): void
    {
        $this->FamiliaDescripcion = $FamiliaDescripcion;
    }

    public function getSubFamiliaDescripcion()
    {
        return $this->SubFamiliaDescripcion;
    }

    public function setSubFamiliaDescripcion( $SubFamiliaDescripcion ): void
    {
        $this->SubFamiliaDescripcion = $SubFamiliaDescripcion;
    }
}