<?php
/* M�todos de acceso a los campos de la tabla ALM_ItemAlmacenStock redefinidos por el usuario */
class ALM_ItemAlmacenStockBN extends BaseALM_ItemAlmacenStockBN
{
    const LOTE_POR_DEFECTO      = ALM_TransaccionDetalleBN::LOTE_POR_DEFECTO;
    const CONDICION_POR_DEFECTO = ALM_TransaccionDetalleBN::CONDICION_POR_DEFECTO;

    protected $IdProveedor;
    public function getIdProveedor()
    {
        return $this->IdProveedor;
    }
    public function setIdProveedor( $IdProveedor ): void
    {
        $this->IdProveedor = $IdProveedor;
    }

    protected $IdReferencia;
    public function getIdReferencia()
    {
        return $this->IdReferencia;
    }
    public function setIdReferencia( $IdReferencia ): void
    {
        $this->IdReferencia = $IdReferencia;
    }

    protected $IdColor;
    public function getIdColor()
    {
        return $this->IdColor;
    }
    public function setIdColor( $IdColor ): void
    {
        $this->IdColor = $IdColor;
    }

    protected $IdCatTalla;
    public function getIdCatTalla()
    {
        return $this->IdCatTalla;
    }
    public function setIdCatTalla( $IdCatTalla ): void
    {
        $this->IdCatTalla = $IdCatTalla;
    }

    protected $IdTalla;
    public function getIdTalla()
    {
        return $this->IdTalla;
    }
    public function setIdTalla( $IdTalla ): void
    {
        $this->IdTalla = $IdTalla;
    }

    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN;
    }

    public function getDescripcionItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        if( $o_ALM_ItemMastBN )
        {
            return $o_ALM_ItemMastBN->getDescripcionCompleta();
        }
        return "";
    }
    
    public function getUltimoCostoItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        if( $o_ALM_ItemMastBN )
        {
            return $o_ALM_ItemMastBN->getPrecioCosto();
        }
        return "";
    }
    
    public function getFechaVencimientoPr()
    {
        return substr( $this->getFechaVencimiento(), 0, 10 );
    }

    public function getFechaVencimientoLote()
    {
        return substr( $this->getFechaVencimiento(), 0, 10 );
    }
    
    public function getCodigoBarras()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        if( $o_ALM_ItemMastBN )
        {
            return $o_ALM_ItemMastBN->getCodigoBarras();
        }
        return "";
    }
    
    public function getAlmacenDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }
    
    public function getObjectSucursal()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        return $o_GSS_SucursalBN;
    }
    
    public function getSucursalDesc()
    {
        return $this->getObjectSucursal()->getDescripcion();
    }

    protected $NumeroLoteAntiguo;
    public function getNumeroLoteAntiguo()
    {
        return $this->NumeroLoteAntiguo;
    }
    public function setNumeroLoteAntiguo( $NumeroLoteAntiguo )
    {
        $this->NumeroLoteAntiguo = $NumeroLoteAntiguo;
    }

    protected $LineaDescripcion;
    public function getLineaDescripcion()
    {
        return $this->LineaDescripcion;
    }
    public function setLineaDescripcion( $LineaDescripcion ): void
    {
        $this->LineaDescripcion = $LineaDescripcion;
    }

    protected $MarcaDesc;
    public function getMarcaDesc()
    {
        return $this->MarcaDesc;
    }
    public function setMarcaDesc( $MarcaDesc ): void
    {
        $this->MarcaDesc = $MarcaDesc;
    }

    protected $PartNumber;
    public function getPartNumber()
    {
        return $this->PartNumber;
    }
    public function setPartNumber( $PartNumber ): void
    {
        $this->PartNumber = $PartNumber;
    }

    protected $FamiliaDescripcion;
    protected $SerieFlag;

    public function getFamiliaDescripcion()
    {
        return $this->FamiliaDescripcion;
    }

    public function setFamiliaDescripcion( $FamiliaDescripcion ): void
    {
        $this->FamiliaDescripcion = $FamiliaDescripcion;
    }

    public function getSerieFlag()
    {
        return $this->SerieFlag;
    }

    public function setSerieFlag( $SerieFlag ): void
    {
        $this->SerieFlag = $SerieFlag;
    }

    protected $UnidadVentaDesc;

    public function getUnidadVentaDesc()
    {
        return $this->UnidadVenta;
    }
    public function setUnidadVentaDesc( $UnidadVenta ): void
    {
        $this->UnidadVenta = $UnidadVenta;
    }
}
?>