<?php
/* M�todos de acceso a los campos de la tabla ALM_InventarioFisico redefinidos por el usuario */
class ALM_InventarioFisicoBN extends BaseALM_InventarioFisicoBN
{
    //ESTADO
    const ESTADO_ANULADO    = "A";
    const ESTADO_PENDIENTE  = "P";
    const ESTADO_CERRADO    = "C";
    
    //PARAMETROS POR DEFECTO PARA LA TRANSACCION
    const TIPO_SOB_INVENTARIO = "SOB"; //Sobrantes de inventario
    const TIPO_FAL_INVENTARIO = "FAL"; //Faltantes de Inventario
    
    const TIPO_DOC_REFERENCIA = "AJ"; //Ajuste de Inventario
    
    const TIPO_DOCUMENTO_ING      = "NI"; //TIPO DE DOCUMENTO
    const TIPO_DOCUMENTO_SAL      = "NS"; //TIPO DE DOCUMENTO
    
    const TIPO_NORMAL_SIN_MOV     = "N";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                        ALM_InventarioFisicoBN::ESTADO_ANULADO    => "ANULADO",
                        ALM_InventarioFisicoBN::ESTADO_PENDIENTE  => "PENDIENTE",
                        ALM_InventarioFisicoBN::ESTADO_CERRADO    => "CERRADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getIdInventarioFisicoConcat()
    {
        return $this->getIdCompania()."_".$this->getIdNumeroInventario();
    }
    
    public function ValidacionDetalleTerminado()
    {
        $a_ResultCont = ALM_InventarioFisicoFN::compararCountRegistrovsConteo( $this->getIdCompania(), $this->getIdNumeroInventario() );
        if( $a_ResultCont['COUNT_REG'] > 0 )
        {
            if(  $a_ResultCont['COUNT_REG'] !=  $a_ResultCont['COUNT_UPD'] )
            {
                return false;
            }
            else 
            {
                return true;
            }
        }
        else 
        {
            return false;
        }
    }
    
    public function ValidacionDetalle()
    {
        $a_ResultCont = ALM_InventarioFisicoFN::compararCountRegistrovsConteo( $this->getIdCompania(), $this->getIdNumeroInventario() );
        if( $a_ResultCont['COUNT_REG'] > 0 )
        {
            return true;
        }
        else 
        {
            return false;
        }
    }
}
?>