<?php
function buscarUltimoCostoIngreso( $s_IdCompania, $s_IdSucursal, $s_IdAlmacen, $s_IdItem, $s_IdFecha )
{
    $s_Sql       = "
                    SELECT IdAlmacen, IdCompania, IdSucursal, IdItem, IdCondicion, IdLote, IdFecha, IdTransaccion, PrecioCosto, Cantidad, SaldoCantidad, SaldoPrecioCosto, SaldoCostoTotal, PrecioUnitario, MontoTotal
                    FROM ALM_Kardex
                    WHERE 1=1
                        AND IdCompania='$s_IdCompania'
                        AND IdSucursal='$s_IdSucursal'
                        AND IdAlmacen='$s_IdAlmacen'
                        AND IdItem='$s_IdItem'
                        AND IdFecha<'$s_IdFecha'
                        AND IdCondicion='I'
                    ORDER BY IdFecha DESC
                    LIMIT 1
                    ;
        ";
    $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
    $o_ResultSet->next();
    $a_Row = $o_ResultSet->getRow();
    return $a_Row;
}
class TransaccionKardexBL
{
    public function guardarTransaccionKardex( ALM_TransaccionCabeceraBN $o_ALM_TransaccionCabeceraBN )
    {
        $a_ArrayMovientoKardex = $o_ALM_TransaccionCabeceraBN->getArrayMovientoKardex();
        foreach ( $a_ArrayMovientoKardex as $i_Key => $o_ALM_KardexBN )
        {
            $this->guardarKardex( $o_ALM_KardexBN );
        }
        return true;
    }
    
    public function guardarKardex( ALM_KardexBN $o_ALM_KardexBN )
    {
        try 
        {
            $con = Conexion::getConexion();
            $con->begin();
            
            $this->validarValoresxDefecto( $o_ALM_KardexBN );

            $o_ALM_KardexDP = new ALM_KardexDP( $o_ALM_KardexBN );
            $o_ALM_KardexDP->save();

            //nuevo proceso - series
            //$this->validarProcesoSeries( $o_ALM_KardexBN );
            //AQUI SE CAMBIA EL CONTROL DE SERIES, TIENE QUE TENER SU PROPIO MODULO DE SERIES

            $o_ALM_TransaccionDetalleBN = $o_ALM_KardexBN->getObjetoDetalleTransaccion();
            $this->ActualizarStockItemAlmacen( $o_ALM_TransaccionDetalleBN, $o_ALM_KardexBN );
            //sleep( 1 );

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            throw new Exception( "TKax: ".$o_Exception->getMessage() );
        }

        return true;
    }

    private function validarProcesoSeries( ALM_KardexBN $o_ALM_KardexBN )
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_ALM_KardexBN->getIdItem() );
        
        if( $o_ALM_ItemMastBN->SiManejaSerie() )
        {
            $o_ALM_TransaccionDetalleBN = $o_ALM_KardexBN->getObjetoDetalleTransaccion();
            
            //la validacion es por el documento
            switch ( $o_ALM_TransaccionDetalleBN->getReferenciaTipoDocumento() ) 
            {
                case 'OC': //identifico que viene de una orden de compra, osea una recepcion
                    //se busca el documento de referencia
                    $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                    $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $o_ALM_TransaccionDetalleBN->getIdCompania(), $o_ALM_TransaccionDetalleBN->getReferenciaNumeroDocumento() );

                    if( $o_COM_OrdenCompraCabeceraBN )
                    {

                    }
                break;
                /*
                case "BV":
                case "FC":
                    //ES POR VENTA DE DOCUMENTO
                    $o_VTA_DocumentoFN = new VTA_DocumentoFN();
                    $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_ALM_TransaccionDetalleBN->getReferenciaTipoDocumento(), $o_ALM_TransaccionDetalleBN->getIdCompania(), $o_ALM_TransaccionDetalleBN->getReferenciaNumeroDocumento() );
                    if( $o_VTA_DocumentoBN )
                    {
                        //por ahora la referencia principal es la orden de venta
                        $o_VTA_OrdenFN = new VTA_OrdenFN();
                        $o_VTA_OrdenBN = $o_VTA_OrdenFN->findOrdenByNum( $o_VTA_DocumentoBN->getDocumentoParentCod() );
                        if( $o_VTA_OrdenBN )
                        {
                            $o_SR_MovimientoFN = new SR_MovimientoFN();
                            $o_SR_MovimientoFN->setTipoMovimiento( VTA_DocumentoBN::TRANSACCION_X_DEFECTO );
                            $o_SR_MovimientoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                            $o_SR_MovimientoFN->setAlmacen( $o_VTA_DocumentoBN->getIdAlmacen() );
                            $o_SR_MovimientoFN->setReferenciaTipo( "OS" );
                            $o_SR_MovimientoFN->setReferenciaNumero( $o_VTA_OrdenBN->getOrdenNum() );
                            $o_SR_MovimientoFN->setReferenciaFecha( $o_VTA_OrdenBN->getOrdenFecha() );
                            
                            if( $o_ALM_KardexBN->getIdCondicion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                            {
                                //QUIERE DECIR QUE ES UN INGRESO POR ANULACION DE DOCUMENTO
                                //$o_SR_MovimientoFN->setEstado( "C" );
                                $o_SR_MovimientoFN->addCondition( "Estado", "IN", "('C','A')", false );
                                $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                                if( $a_SR_Movimiento )
                                {
                                    //ahora se tiene que anular el movimiento
                                    $o_SR_MovimientoBN = $a_SR_Movimiento[0];

                                    //ahora se envia el item de referencia
                                    $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
                                    $o_SR_MovimientoDetalleBN->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                                    $o_SR_MovimientoDetalleBN->setProductoId( $o_ALM_KardexBN->getIdItem() );

                                    $o_SR_MovimientoBN->setMovimientoDetalleObject( $o_SR_MovimientoDetalleBN );
                                    
                                    $o_SerieBL = new SerieBL();
                                    $o_SerieBL->realizarAnulacionTransaccionH( $o_SR_MovimientoBN );
                                }
                            }
                            else
                            {
                                $o_SR_MovimientoFN->setEstado( "P" );
                                $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                                if( $a_SR_Movimiento )
                                {
                                    $o_SR_MovimientoBN = $a_SR_Movimiento[0];

                                    //ahora se envia el item de referencia
                                    $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
                                    $o_SR_MovimientoDetalleBN->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                                    $o_SR_MovimientoDetalleBN->setProductoId( $o_ALM_KardexBN->getIdItem() );

                                    $o_SR_MovimientoBN->setMovimientoDetalleObject( $o_SR_MovimientoDetalleBN );

                                    $o_SerieBL = new SerieBL();
                                    $o_SerieBL->realizarTransaccionH( $o_SR_MovimientoBN );
                                }
                            }
                        }
                    }
                break;
                */
            }
        }
    }
    
    private function validarValoresxDefecto( ALM_KardexBN $o_ALM_KardexBN )
    {        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $o_ALM_KardexBN->getIdAlmacen() );

        $o_ALM_KardexBN->setIdCompania( $o_ALM_AlmacenMastBN->getIdCompania() );
        $o_ALM_KardexBN->setIdSucursal( $o_ALM_AlmacenMastBN->getIdSucursal() );

        if( $o_ALM_KardexBN->getIdCondicion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
        {
            $o_ALM_KardexBN->setCantidadDoble( $o_ALM_KardexBN->getCantidad() );
        }
        if( $o_ALM_KardexBN->getIdCondicion() == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
        {
            $o_ALM_KardexBN->setCantidadDoble( $o_ALM_KardexBN->getCantidad() * -1 );
        }

		if( !$o_ALM_KardexBN->getCodigoProveedor() ){ $o_ALM_KardexBN->setCodigoProveedor( "" ); }
        if( !$o_ALM_KardexBN->getPrecioCosto() ){ $o_ALM_KardexBN->setPrecioCosto( 0.00 ); }
        if( !$o_ALM_KardexBN->getCostoTotal() ){ $o_ALM_KardexBN->setCostoTotal( 0.00 ); }
        if( !$o_ALM_KardexBN->getSaldoCantidad() ){ $o_ALM_KardexBN->setSaldoCantidad( 0.00 ); }
        if( !$o_ALM_KardexBN->getSaldoPrecioCosto() ){ $o_ALM_KardexBN->setSaldoPrecioCosto( 0.00 ); }
        if( !$o_ALM_KardexBN->getSaldoCostoTotal() ){ $o_ALM_KardexBN->setSaldoCostoTotal( 0.00 ); }
		
        $o_ALM_KardexBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_ALM_KardexBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_ALM_KardexBN->setFechCreacion( date( "Y-m-d H:i:s" ) );
        $o_ALM_KardexBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );

        return true;
    }
    
    private function ActualizarStockItemAlmacen( ALM_TransaccionDetalleBN $o_ALM_TransaccionDetalleBN, ALM_KardexBN $o_ALM_KardexBN )
    {
        //VALIDACIONES DE ITEM, DEBEN DE EXISTIR EN LAS TABLAS: ItemAlmacenStock
        $o_ALM_ItemMastBN = new ALM_ItemMastBN();
        $o_ALM_ItemMastBN->setIdCompania( $o_ALM_KardexBN->getIdCompania() );
        $o_ALM_ItemMastBN->setIdSucursal( $o_ALM_KardexBN->getIdSucursal() );
        $o_ALM_ItemMastBN->setIdItem( $o_ALM_KardexBN->getIdItem() );
        $o_ALM_ItemMastBN->setIdAlmacen( $o_ALM_KardexBN->getIdAlmacen() );
        $o_ALM_ItemMastBN->setIdLote( $o_ALM_KardexBN->getIdLote() );
        //$o_ALM_ItemMastBN->setFechaVencimientoLote( $o_ALM_TransaccionDetalleBN->getFechaVencimientoLote() );

        $o_ValidacionxItemBL = new ValidacionxItemBL();
        $o_ValidacionxItemBL->iniciarValidacionAlmacenStock( $o_ALM_ItemMastBN ); //MEJOR SE PREGUNTA DESDE LA CREACION DEL ITEM
        ////////////////////////////////////////////////////////////////////////////////////////////////
    
        //VALIDAMOS LA UNIDAD DE MEDIDA
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_ALM_TransaccionDetalleBN->getIdItem() );
        ////////////////////////////////////////////////////////////////////////////////////////////////
    
        ////////////////////////////////////////////////////////////////////////////////////////////////
        $iItemId    = $o_ALM_KardexBN->getIdItem();
        $sItemcod   = $iItemId;
        $iIdALmacen = $o_ALM_KardexBN->getIdAlmacen();
        $iCantidad  = floatval( $o_ALM_KardexBN->getCantidad() ); //aqui se recupera la cantidad
        $fCosto     = floatval( $o_ALM_KardexBN->getPrecioUnitario() ); //AQUI SE RECUPERA EL COSTO QUE SE INGRESA POR TRANSACCION
        $fCostoD    = floatval( $o_ALM_KardexBN->getPrecioUnitarioDolares() ); //AQUI SE RECUPERA EL COSTO QUE SE INGRESA POR TRANSACCION
        //$fCostoActualizar = floatval( $o_ALM_ItemMastBN->getPrecioCosto() ); //SE RECUPERA EL COSTO DEL ITEM PARA ACTUALIZAR AL ITEM_ALMACEN_STOCK
        $sTipoOper  = $o_ALM_TransaccionDetalleBN->getIdTransaccionOperacion();
    
        //$fCantidadDoble  = floatval( $o_ALM_TransaccionDetalleBN->getCantidadDoble() );

        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockFN->setIdCompania( $o_ALM_KardexBN->getIdCompania() );
        $o_ALM_ItemAlmacenStockFN->setIdSucursal( $o_ALM_KardexBN->getIdSucursal() );
        $o_ALM_ItemAlmacenStockFN->setIdItem( $o_ALM_KardexBN->getIdItem() );
        $o_ALM_ItemAlmacenStockFN->setIdAlmacen( $o_ALM_KardexBN->getIdAlmacen() );
        $o_ALM_ItemAlmacenStockFN->setIdCondicion( ALM_TransaccionDetalleBN::CONDICION_POR_DEFECTO );
        $o_ALM_ItemAlmacenStockFN->setIdLote( $o_ALM_KardexBN->getIdLote() );
        $a_ALM_ItemAlmacenStock = $o_ALM_ItemAlmacenStockFN->select();

        if( $a_ALM_ItemAlmacenStock )
        {
            $o_ALM_ItemAlmacenStockBN = $a_ALM_ItemAlmacenStock[0];

            $i_StockFisicoTotal = ALM_ItemAlmacenStockFN::getStockFisicoTotal( $o_ALM_KardexBN->getIdItem(), $o_ALM_KardexBN->getIdAlmacen() );
    
            //$iStockFisico     = floatval( $o_ALM_ItemAlmacenStockBN->getStockActual() );
            $iStockFisico     = floatval( $o_ALM_ItemAlmacenStockBN->getStockFisico() );
            //$iStockFisico2    = floatval( $o_ALM_ItemAlmacenStockBN->getStockFisico() );
            $iStockDisponible = floatval( $o_ALM_ItemAlmacenStockBN->getStockDisponible() );
            $iStockReservada  = floatval( $o_ALM_ItemAlmacenStockBN->getStockReservado() );
            //$fCostoActual     = floatval( $o_ALM_ItemAlmacenStockBN->getPrecioUnitario() );
            //$fCostoDolActual  = floatval( $o_ALM_ItemAlmacenStockBN->getPrecioUnitarioDolares() );

            //$o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
            //$o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal(), $iItemId, 1 );

            $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $iItemId, 1 );

            //SE HACE UNA PEQUEÑA VALIDACION POR EL COSTO MAL INGRESADO
            if( $o_MST_ListaPrecioDetalleBN )
            {
                if( $o_MST_ListaPrecioDetalleBN->getPrecioCosto() )
                {
                    //pr( "if( ( {$o_MST_ListaPrecioDetalleBN->getPrecioCosto()} * 3 ) < $fCosto )" );
                    if( ( $o_MST_ListaPrecioDetalleBN->getPrecioCosto() * 6 ) < $fCosto )
                    {
                        //throw new Exception( "El costo ingresado es 6 veces mayor al costo real [$iItemId][{$o_ALM_ItemMastBN->getCodigoInterno()}] ." );
                    }
                }
            }

            if( $o_MST_ListaPrecioDetalleBN )
            {
                $fCostoActual     = floatval( $o_MST_ListaPrecioDetalleBN->getPrecioCosto() );
                $fCostoDolActual  = round( $fCostoActual / $o_ALM_TransaccionDetalleBN->getTipoCambioRef(), 2 );
            }
            else
            {
                $fCostoActual     = 0;
                $fCostoDolActual  = 0;
            }

            $bCostoPromedio       = false;
            $fNvoCostoPromedio    = 0.00;
            $fNvoCostoPromedioDol = 0.00;

            if( $sTipoOper == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
            {
                $iNvoStockFisico  = $iStockFisico + $iCantidad;
                //$iNvoStockFisico2 = $iStockFisico2 + $iCantidad;
                $iNvoStockDisp    = $iStockDisponible + $iCantidad;
                //$fNvoStockDoble   = $StockActualDoble + $fCantidadDoble;
                
                /*if ( ( $fCosto != $fCostoActual ) || ( $fCostoD != $fCostoDolActual ) )
                {
                    //FORMULA DE PRORRATEO
                    if( $fCostoActual <= 0 )
                    {
                        $fNvoCostoPromedio    = $fCosto;
                        $fNvoCostoPromedioDol = $fCostoD;
                    }
                    else 
                    {
                        //soles
                        $fCantActxCostoAct = utilMath::fnround( $i_StockFisicoTotal * $fCostoActual, 2 );
                        $fCantNvoxCostoNvo = utilMath::fnround( $iCantidad * $fCosto, 2 );
                        $iCantNvoiCantAct  = $iCantidad + $i_StockFisicoTotal;
                        $fSumaMultiplicnes = $fCantActxCostoAct + $fCantNvoxCostoNvo;
                        $fNvoCostoPromedio = utilMath::fnround( $fSumaMultiplicnes / $iCantNvoiCantAct, 2 );

                        //dolares
                        $fCantActxCostoActDol = utilMath::fnround( $i_StockFisicoTotal * $fCostoDolActual, 2 );
                        $fCantNvoxCostoNvoDol = utilMath::fnround( $iCantidad * $fCostoD, 2 );
                        $iCantNvoiCantActDol  = $iCantidad + $i_StockFisicoTotal;
                        $fSumaMultiplicnesDol = $fCantActxCostoActDol + $fCantNvoxCostoNvoDol;
                        $fNvoCostoPromedioDol = utilMath::fnround( $fSumaMultiplicnesDol / $iCantNvoiCantActDol, 2 );
                    }
                    $bCostoPromedio    = true;
                }*/

                $s_DirArchivo = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR."tools".DIRECTORY_SEPARATOR."calcular_costos.php";
                $_REQUEST['call_require'] = true;
                $_REQUEST["FechaInicio"] = date( "Y" )."-01-01";
                $_REQUEST["FechaFin"]    = date( "Y-m-d" );
                $_REQUEST["IdItem"]      = $iItemId;
                $_REQUEST["IdAlmacen"]   = $iIdALmacen;
                $_REQUEST["IdCompania"]  = $o_ALM_KardexBN->getIdCompania();
                /*
                ob_start();
                require( $s_DirArchivo );
                $s_Contenido = ob_get_clean();
                */
                if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
                {
                    $s_FechaSel = date( "Y-m-d" );

                    $o_iVentas = new iVentas();
                    $o_iVentas->registrarTipoCambio( $s_FechaSel );
                }

                $f_TipoCob = GSS_TipoCambioFN::getStaticTipoCambioCobranza();

                $a_Data             = buscarUltimoCostoIngreso( $o_ALM_KardexBN->getIdCompania(), $o_ALM_KardexBN->getIdSucursal(), $o_ALM_KardexBN->getIdAlmacen(), $o_ALM_KardexBN->getIdItem(), UtilDate::sumarDias( $_REQUEST["FechaFin"], 1 ) );
                //pr( $s_DirArchivo ); pr( $a_Data ); exit;

                $f_PrecioUnitario   = floatval( $a_Data['SaldoPrecioCosto'] ) <= 0 ? floatval( $a_Data['PrecioUnitario'] ) : floatval( $a_Data['SaldoPrecioCosto'] );
                $fCosto             = $f_PrecioUnitario;
                $fCostoD            =  round( $fCosto / $f_TipoCob, 2 );

                $fNvoCostoPromedio    = $fCosto;
                $fNvoCostoPromedioDol = $fCostoD;

                $bCostoPromedio = true;
            }
            else
            {
                $iNvoStockFisico  = $iStockFisico - $iCantidad;
                //$iNvoStockFisico2 = $iStockFisico2 - $iCantidad;
                $iNvoStockDisp    = $iStockDisponible - $iCantidad;
            }
            
            //VALIDACION STOCKS
            if( $iNvoStockDisp < 0 ) //$i_StockReservada > 0 &&
            {
                throw new Exception( "El Stock Disponible[$iNvoStockDisp] menor a 0, al parecer se encuentra Reservas activadas para el item [$sItemcod] " );
            }
            if( $iNvoStockFisico < 0 )
            {
                throw new Exception( "El Stock Fisico[$iNvoStockFisico] [$sItemcod] no debe ser menor a 0." );
            }

            $iStockCalculado = $iStockReservada + $iNvoStockDisp;
            if( $iNvoStockFisico != $iStockCalculado )
            {
                throw new Exception( "No hay consistencia con el Stock Almacen del Item( $sItemcod )." );
            }
            if( Constantes::CONS_VTA_VALIDAR_STOCK )
            {
                if( $iNvoStockFisico < 0 )
                {
                    throw new Exception( "El Stock Fisico no debe ser menor a 0." );
                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////
            //SE PROCEDE EN ACTUALIZAR EL NUEVO STOCK
            $o_ALM_ItemAlmacenStockDP = new ALM_ItemAlmacenStockDP();
            $o_ALM_ItemAlmacenStockDP->setIdCompania( ( int ) $o_ALM_KardexBN->getIdCompania() );
            $o_ALM_ItemAlmacenStockDP->setIdSucursal( $o_ALM_KardexBN->getIdSucursal() );
            $o_ALM_ItemAlmacenStockDP->setIdItem( $o_ALM_KardexBN->getIdItem() );
            $o_ALM_ItemAlmacenStockDP->setIdAlmacen( $o_ALM_KardexBN->getIdAlmacen() );
            $o_ALM_ItemAlmacenStockDP->setIdCondicion( ALM_TransaccionDetalleBN::CONDICION_POR_DEFECTO );
            $o_ALM_ItemAlmacenStockDP->setIdLote( $o_ALM_KardexBN->getIdLote() );
            $o_ALM_ItemAlmacenStockDP->setFechaVencimiento( $o_ALM_TransaccionDetalleBN->getFechaVencimiento() );
            //$o_ALM_ItemAlmacenStockDP->setStockActual( $iNvoStockFisico );
            $o_ALM_ItemAlmacenStockDP->setStockFisico( $iNvoStockFisico );
            $o_ALM_ItemAlmacenStockDP->setStockDisponible( $iNvoStockDisp );
            if( $bCostoPromedio )
            {
                $o_ALM_ItemAlmacenStockDP->setPrecioUnitario( $fCosto ); //ultimo costo
                $o_ALM_ItemAlmacenStockDP->setPrecioUnitarioDolares( $fCostoD );
                $o_ALM_ItemAlmacenStockDP->setPrecioPromedioLocal( $fNvoCostoPromedio ); //costo promedio
                $o_ALM_ItemAlmacenStockDP->setPrecioPromedioDolares( $fNvoCostoPromedioDol );
            }
            $o_ALM_ItemAlmacenStockDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_ItemAlmacenStockDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

            $o_ALM_ItemAlmacenStockDP->update();
            $o_ALM_ItemAlmacenStockDP->update_varios_costo();

            $o_ALM_KardexBN->setALMItemAlmacenStockBN( $o_ALM_ItemAlmacenStockDP );
            ////////////////////////////////////////////////////////////////////////////////////////////////

            ////////////////////////////////////////////////////////////////////////////////////////////////
            //AHORA SE ACTUALIZA EL ULTIMO COSTO AL ITEM
            $o_ALM_ItemMastDP = new ALM_ItemMastDP();
            $o_ALM_ItemMastDP->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //buscamos que configuracion de Moneda tiene el sistema en base al listado de precio
            $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
            if( !$o_MST_ListaPrecioCabeceraBN )
            {
                $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" )
            {
                $o_ALM_ItemMastDP->setPrecioCosto( $fCostoD );
            }
            else
            {
                $o_ALM_ItemMastDP->setPrecioCosto( $fCosto );
            }
            $o_ALM_ItemMastDP->setPrecioUnitarioLocal( $fCosto );
            $o_ALM_ItemMastDP->setPrecioUnitarioDolares( $fCostoD );
            $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_ALM_ItemMastDP->update_varios(); //el costo del item va ser estatico solo se actualiza por el cambio de precios - 2020-08-13
            
            //aqui actualizamos el ultimo costo, en el listado de precios
            if( $sTipoOper == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
            {
                $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
                $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18

                //POR DEFECTO SE TOMA LA CABECERA CON EL IdTipoLista VENTA
                $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
                $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( 1 );

                $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( 1, 1, $o_ALM_TransaccionDetalleBN->getIdItem(), 1 );

                if( !$o_MST_ListaPrecioDetalleBN )
                {
                    //INSERT
                    $IdTipoLista        = 1;
                    $i_IdRango          = 1;
                    $i_IdRangoDetalle   = 1; //POR DEFECTO ES EL ID ASOCIADO AL RANGO UNICO
                    if( $o_ALM_ItemMastBN->getIdRangoVenta() )
                    {
                        $IdTipoLista        = 1;
                        $i_IdRango          = $o_ALM_ItemMastBN->getIdRangoVenta();
                        $i_IdRangoDetalle   = 1; //POR DEFECTO ES EL ID ASOCIADO AL RANGO UNICO
                    }

                    $i_IdDet = MST_ListaPrecioDetalleDP::recuperarId();

                    $o_DefaultDP = new MST_ListaPrecioDetalleDP();
                    $o_DefaultDP->setIdListaPreciDet( $i_IdDet );
                    $o_DefaultDP->setIdListaPreciCab( $o_MST_ListaPrecioCabeceraBN->getIdListaPreciCab() );
                    $o_DefaultDP->setIdCompania( $o_ALM_KardexBN->getIdCompania() );
                    $o_DefaultDP->setIdSucursal( $o_ALM_KardexBN->getIdSucursal() );
                    $o_DefaultDP->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
                    $o_DefaultDP->setIdTipoPrecio( "1" );
                    $o_DefaultDP->setIdTipoLista( $IdTipoLista );
                    $o_DefaultDP->setIdRango( $i_IdRango );
                    $o_DefaultDP->setIdRangoDetalle( $i_IdRangoDetalle );
                    $o_DefaultDP->setPrecioCosto( $fCosto );
                    $o_DefaultDP->setPrecioCostoIGV( ( round( $fCosto * $f_ValorIGVMasUno, 2 ) ) );
                    $o_DefaultDP->setEstado( "A" );
                    $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $b_Result = $o_DefaultDP->save();
                }
                else
                {
                    $o_MST_ListaPrecioDetalleDP = new MST_ListaPrecioDetalleDP();
                    $o_MST_ListaPrecioDetalleDP->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
                    $o_MST_ListaPrecioDetalleDP->setPrecioCosto( $fCosto );
                    $o_MST_ListaPrecioDetalleDP->setPrecioCostoIGV( ( round( $fCosto * $f_ValorIGVMasUno, 2 ) ) );
                    $o_MST_ListaPrecioDetalleDP->actualizarCostos();
                }
            }
            
            $o_ALM_KardexBN->setALMItemMastBN( $o_ALM_ItemMastDP );
            ////////////////////////////////////////////////////////////////////////////////////////////////
        }
        else
        {
            throw new Exception( "El Item( $sItemcod ) no tiene ItemAlmacenStock registrado." );
        }

        return true;
    }
}