<?php
class ReservaItemStockBL
{
    private function buscar_reserva( ALM_ReservaItemStockBN $o_ALM_ReservaItemStockBN )
    {
        $o_ALM_ReservaItemStockFN = new ALM_ReservaItemStockFN();
        //$o_ALM_ReservaItemStockFN->setReservaDocTipo( $o_ALM_ReservaItemStockBN->getReservaDocTipo() );
        //$o_ALM_ReservaItemStockFN->setReservaDocNumero( $o_ALM_ReservaItemStockBN->getReservaDocNumero() );
        $o_ALM_ReservaItemStockFN->setReservaSecuencia( $o_ALM_ReservaItemStockBN->getReservaSecuencia() );
        $o_ALM_ReservaItemStockFN->setIdItem( $o_ALM_ReservaItemStockBN->getIdItem() );
        $o_ALM_ReservaItemStockFN->setIdAlmacen( $o_ALM_ReservaItemStockBN->getIdAlmacen() ); //EL ID ALMACEN ES UNICO
        $o_ALM_ReservaItemStockFN->setIdCompania( $o_ALM_ReservaItemStockBN->getIdCompania() );
        $o_ALM_ReservaItemStockFN->setIdLote( $o_ALM_ReservaItemStockBN->getIdLote() );
        $o_ALM_ReservaItemStockFN->setReservaRefNumero( $o_ALM_ReservaItemStockBN->getReservaRefNumero() );
        $o_ALM_ReservaItemStockFN->setReservaSecuencia( $o_ALM_ReservaItemStockBN->getReservaSecuencia() );
        $a_ALM_ReservaItemStock = $o_ALM_ReservaItemStockFN->select();

        if( $a_ALM_ReservaItemStock )
        {
            return $a_ALM_ReservaItemStock[0];
        }
        return null;
    }
    
    public function crearReserva( ALM_ReservaItemStockBN $o_ALM_ReservaItemStockBN )
    {
        $i_ReservaId = ALM_ReservaItemStockDP::recuperarId();
        
        $o_ALM_ReservaItemStockBN->setReservaId( $i_ReservaId );
        $o_ALM_ReservaItemStockDP = new ALM_ReservaItemStockDP( $o_ALM_ReservaItemStockBN );
        $o_ALM_ReservaItemStockDP->save();
        
        return true;
    }
    
    public function eliminarReserva( ALM_ReservaItemStockBN $o_ALM_ReservaItemStockBN )
    {
        $s_IdItem           = $o_ALM_ReservaItemStockBN->getIdItem();
        $s_ReservaRefNumero = $o_ALM_ReservaItemStockBN->getTipoOperacion();
        $o_ALM_ReservaItemStockBN = $this->buscar_reserva( $o_ALM_ReservaItemStockBN );
        if( $o_ALM_ReservaItemStockBN )
        {
            $o_ALM_ReservaItemStockDP = new ALM_ReservaItemStockDP();
            $o_ALM_ReservaItemStockDP->setReservaId( $o_ALM_ReservaItemStockBN->getReservaId() );
            $o_ALM_ReservaItemStockDP->delete();
        }
        else
        {
            //throw new Exception( "No se encontro la Reserva [$s_IdItem][$s_ReservaRefNumero]" );
            return false;
        }
        return true;
    }
    
    public function actualizarReserva( ALM_ReservaItemStockBN $o_ALM_ReservaItemStockBN )
    {
        $o_ALM_ReservaItemStockDP = new ALM_ReservaItemStockDP( $o_ALM_ReservaItemStockBN );
        $o_ALM_ReservaItemStockDP->update();
    }
    
    public function inincarProcesoReservaItemStock( ALM_ReservaItemStockBN $o_ALM_ReservaItemStockBN )
    {
        $s_IdItem        = $o_ALM_ReservaItemStockBN->getIdItem();
        $s_TipoOperacion = $o_ALM_ReservaItemStockBN->getTipoOperacion();
        //pr( $s_TipoOperacion );
        if( !$s_TipoOperacion )
        {
            throw new Exception( "Debe de ingresar el Tipo de Proceso para la Reserva." );
        }
        
        //SE BUSCA EL ITEM
        $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $s_IdItem );
        if( !$o_ALM_ItemMastBN )
        {
            throw new Exception( "El Item con el Id [$s_IdItem] no existe, no se puede hacer la Reserva." );
        }
        
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //AQUI SE IMPLEMENTA LA RESERVA PARA LOS Q MANEJA TRANSACCIONES - DE LA TABLA ITEM TIPO 2020-10-05
        if( !$o_ALM_ItemMastBN->getObjectTipoItem()->getTransacciondelSistemaFlag() )
        {
            return true;
        }
        //AHORA SE PREGUNTA SI ESTA ACTIVADO EL FLAG DE RESERVA STOCK
        if( $o_ALM_ItemMastBN->getUsarResevableStock() == "N" )
        {
            return true;
        }
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //AHORA SE BUSCA EL ITEM STOCK
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        //pr( "{$o_ALM_ReservaItemStockBN->getIdCompania()}, $s_IdItem, {$o_ALM_ReservaItemStockBN->getIdAlmacen()}, {$o_ALM_ReservaItemStockBN->getIdCondicion()}, {$o_ALM_ReservaItemStockBN->getIdLote()}" );
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $o_ALM_ReservaItemStockBN->getIdCompania(), $s_IdItem, $o_ALM_ReservaItemStockBN->getIdAlmacen(), $o_ALM_ReservaItemStockBN->getIdCondicion(), $o_ALM_ReservaItemStockBN->getIdLote() );

        if( !$o_ALM_ItemAlmacenStockBN )
        {
            throw new Exception( "No se encontro la Referencia de ItemAlmacenStock [$s_IdItem] para la Reserva." );
        }
        
        //$iStockActual     = $o_ALM_ItemAlmacenStockBN->getStockActual();
        $iStockfisico     = $o_ALM_ItemAlmacenStockBN->getStockFisico();
        $iStockdisponible = $o_ALM_ItemAlmacenStockBN->getStockDisponible();
        $iStockreservado  = $o_ALM_ItemAlmacenStockBN->getStockReservado();
        
        $iCantidadaReservar = $o_ALM_ReservaItemStockBN->getReservaCantidad();

        //aqui se agrega el id de sucursal
        $o_ALM_ReservaItemStockBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        
        //SE LLAMA AL TIPO DE PROCESO DE LA RESERVA
        switch ( $s_TipoOperacion )
        {
            case "I":
                $this->crearReserva( $o_ALM_ReservaItemStockBN );
                
                $iNvoStockReservada  = $iStockreservado + $iCantidadaReservar;
                $iNvoStockDisponible = $iStockfisico    - $iNvoStockReservada;
            break;
            case "D":

                $b_Control = $this->eliminarReserva( $o_ALM_ReservaItemStockBN );
                if( !$b_Control )
                {
                    return true;
                }
                
                $iNvoStockReservada  = $iStockreservado  - $iCantidadaReservar;
                $iNvoStockDisponible = $iStockdisponible + $iCantidadaReservar;
            break;
            case "U":
                
                $o_TMP_ALM_ReservaItemStockBN = $this->buscar_reserva( $o_ALM_ReservaItemStockBN );

                if( !$o_TMP_ALM_ReservaItemStockBN )
                {
                    throw new Exception( "No se encontro la Reserva." );
                }
                
                $f_TMP_ReservaCantidad = $o_TMP_ALM_ReservaItemStockBN->getReservaCantidad();
                
                $iStockreservado = $iStockreservado - $f_TMP_ReservaCantidad;
                
                $iNvoStockReservada  = $iStockreservado + $iCantidadaReservar;
                $iNvoStockDisponible = $iStockfisico    - $iNvoStockReservada;
                
                $o_ALM_ReservaItemStockBN->setReservaId( $o_TMP_ALM_ReservaItemStockBN->getReservaId() );
                $this->actualizarReserva( $o_ALM_ReservaItemStockBN );
            break;
        }
        
        if( $iNvoStockDisponible > $iStockfisico )
        {
            throw new Exception( "Incongruencia para la Reserva: el Item[".$o_ALM_ReservaItemStockBN->getIdItem()."] tiene un disponible mayor al Fisico." );
        }
        if( $iNvoStockReservada < 0 )
        {
            throw new Exception( "Incongruencia para la Reserva: el Item[".$o_ALM_ReservaItemStockBN->getIdItem()."] tiene una Reserva negativo." );
        }
        
        //pr( "----------------------------------------------------------------------------------------------" ); 
        //pr( "Antes   -> F[$iStockfisico] R[$iStockreservado] D[$iStockdisponible]" ); 
        //pr( "Despues -> F[$iStockfisico] R[$iNvoStockReservada] D[$iNvoStockDisponible] | CaR[$iCantidadaReservar]" ); 
        //pr( "----------------------------------------------------------------------------------------------" );
        ////////////////////////////////////////////////////////////////////////////////////////////////
        
        if( $iNvoStockDisponible < 0 )
        {
            //if( $o_ALM_ReservaItemStockBN->getIdUniadMedidaAsignada() != 59 )
            //{
                throw new Exception( "La Cantidad es mayor al disponible: Item[$s_IdItem]." );
            //}
        }

        if( $iCantidadaReservar == 0 )
        {
            //throw new Exception( "La Cantidad 0 no esta permitido: Item[$s_IdItem]." );
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////
        //SE PROCEDE EN ACTUALIZAR EL NUEVO STOCK
        
        $o_ALM_ItemAlmacenStockDP = new ALM_ItemAlmacenStockDP();
        //$o_ALM_ItemAlmacenStockDP->setDebug( true );
        $o_ALM_ItemAlmacenStockDP->setIdCompania( ( int ) $o_ALM_ReservaItemStockBN->getIdCompania() );
        $o_ALM_ItemAlmacenStockDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_ALM_ItemAlmacenStockDP->setIdItem( $o_ALM_ReservaItemStockBN->getIdItem() );
        $o_ALM_ItemAlmacenStockDP->setIdAlmacen( $o_ALM_ReservaItemStockBN->getIdAlmacen() );
        $o_ALM_ItemAlmacenStockDP->setIdCondicion( $o_ALM_ReservaItemStockBN->getIdCondicion() );
        $o_ALM_ItemAlmacenStockDP->setIdLote( $o_ALM_ReservaItemStockBN->getIdLote() );
        $o_ALM_ItemAlmacenStockDP->setStockDisponible( round( $iNvoStockDisponible, 2 ) );
        $o_ALM_ItemAlmacenStockDP->setStockReservado( $iNvoStockReservada );
        $o_ALM_ItemAlmacenStockDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_ALM_ItemAlmacenStockDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_ALM_ItemAlmacenStockDP->update();
        ////////////////////////////////////////////////////////////////////////////////////////////////
    }
}