<?php
class RequerimientoDetalleBL
{
    public function ActualizarDetalle( ALM_RequerimientoDetalleBN $o_ALM_RequerimientoDetalleBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
	        if( $o_ALM_RequerimientoDetalleBN->getArrayObjectRequerimientoDetalleLote() )
	        {
	            //SE GUARDA DETALLE LOTE
	            $this->GuardarDetalleLote( $o_ALM_RequerimientoDetalleBN );
	        }
	        
	        //SOLO SE ACTUALIZA
	        $o_ALM_RequerimientoDetalleDP = new ALM_RequerimientoDetalleDP();
	        $o_ALM_RequerimientoDetalleDP->setIdRequerimiento( ( int ) $o_ALM_RequerimientoDetalleBN->getIdRequerimiento() );
	        $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( ( int ) $o_ALM_RequerimientoDetalleBN->getIdRequerimientoDetalle() );
	        $o_ALM_RequerimientoDetalleDP->setCantidadPedida( $o_ALM_RequerimientoDetalleBN->getCantidadPedida() );
	        if( $o_ALM_RequerimientoDetalleBN->getIdLote() )
	        {
	            $o_ALM_RequerimientoDetalleDP->setIdLote( $o_ALM_RequerimientoDetalleBN->getIdLote() );
	            if( !$o_ALM_RequerimientoDetalleBN->getFechaVencimiento() )
	            {
	            	throw new Exception( "Si ingreso el Numero de Lote, se necesita la Fecha de Vencimiento." );
	            }
	        }
	        if( $o_ALM_RequerimientoDetalleBN->getFechaVencimiento() )
	        {
	            $o_ALM_RequerimientoDetalleDP->setFechaVencimiento( $o_ALM_RequerimientoDetalleBN->getFechaVencimiento() );
	            if( !$o_ALM_RequerimientoDetalleBN->getIdLote() )
	            {
	            	throw new Exception( "Si ingreso la Fecha de Vencimiento, se necesita el Numero de Lote." );
	            }
	        }
	        $o_ALM_RequerimientoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
	        $o_ALM_RequerimientoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
	        $b_Result = $o_ALM_RequerimientoDetalleDP->update();
	        
            $con->commit();
            return true;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "Mov: ".$o_Exception->getMessage() );
        }
    }
    
    public function GuardarDetalleLote( ALM_RequerimientoDetalleBN $o_ALM_RequerimientoDetalleBN )
    {
        $a_ArrayObjectRequerimientoDetalleLote = $o_ALM_RequerimientoDetalleBN->getArrayObjectRequerimientoDetalleLote();
        foreach ( $a_ArrayObjectRequerimientoDetalleLote as $i_key => $o_ALM_RequerimientoDetalleLoteBN )
        {
            $o_ALM_RequerimientoDetalleLoteBN->setIdItem( $o_ALM_RequerimientoDetalleBN->getIdItem() );
            $this->validarValoresxDefectoLote( $o_ALM_RequerimientoDetalleLoteBN );
            
            //SE REGISTRA EL DETALLE LOTE
            $o_ALM_RequerimientoDetalleLoteDP = new ALM_RequerimientoDetalleLoteDP( $o_ALM_RequerimientoDetalleLoteBN );
            $o_ALM_RequerimientoDetalleLoteDP->save();
        }
        return true;
    }
    
    private function validarValoresxDefectoLote( ALM_RequerimientoDetalleLoteBN $o_ALM_RequerimientoDetalleLoteBN )
    {
        //VALIDCIONES
        if( !$o_ALM_RequerimientoDetalleLoteBN->getIdLote() )
        {
            throw new Exception( "El Numero de Lote esta vacio, para el Item({$o_ALM_RequerimientoDetalleLoteBN->getIdItem()})" );
        }
        if( !$o_ALM_RequerimientoDetalleLoteBN->getFechaVencimiento() )
        {
            throw new Exception( "La Fecha de Vencimiento esta vacio, para el Item({$o_ALM_RequerimientoDetalleLoteBN->getIdItem()})" );
        }
        if( !$o_ALM_RequerimientoDetalleLoteBN->getCantidad() )
        {
            throw new Exception( "La Cantidad esta vacio, para el Item({$o_ALM_RequerimientoDetalleLoteBN->getIdItem()})" );
        }
        /////////////
        $i_IdRequerimientoDetalleLote = ALM_RequerimientoDetalleLoteFN::recuperarId();
        
        $o_ALM_RequerimientoDetalleLoteBN->setIdRequerimientoDetalleLote( $i_IdRequerimientoDetalleLote );
        $o_ALM_RequerimientoDetalleLoteBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_ALM_RequerimientoDetalleLoteBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
        $o_ALM_RequerimientoDetalleLoteBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_ALM_RequerimientoDetalleLoteBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        return true;
    }
    
    
}