<?php
class ProcesoAdicionalInventarioBL
{
    public function EvaluarEdadInventario( ALM_TransaccionCabeceraBN $o_ALM_TransaccionCabeceraBN )
    {
        try
        {
            if( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO ) //INGRESO
            {
                $a_TipoTrxOK = array( "ROC", "STI", "CPN", "EAD" );
                if( in_array( $o_ALM_TransaccionCabeceraBN->getIdTransaccion(), $a_TipoTrxOK ) )
                {
                    $this->realizarProcesoIngresoPrincipal( $o_ALM_TransaccionCabeceraBN );
                }
                else
                {
                    $this->realizarProcesoIngreso( $o_ALM_TransaccionCabeceraBN );
                }
            }
            
            if( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() == ALM_TransaccionCabeceraBN::TIPO_SALIDA ) //SALIDA
            {
                $this->realizarProcesoSalida( $o_ALM_TransaccionCabeceraBN );
            }
            
            if( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() == ALM_TransaccionCabeceraBN::TIPO_TRANSFERENCIA ) //TRANSFERENCIA
            {
                //continuara
                $this->realizarProcesoTransferencia( $o_ALM_TransaccionCabeceraBN );
            }

            //exit;
        }
        catch ( Exception $e ) 
        {
            throw new Exception( "PAI: ".$e->getMessage() );
        }
    }
    
    private function realizarProcesoIngresoPrincipal( $o_ALM_TransaccionCabeceraBN )
    {
        $a_ArrayMovientoKardex = $o_ALM_TransaccionCabeceraBN->getArrayMovientoKardex();
        
        foreach ( $a_ArrayMovientoKardex as $o_ALM_KardexBN ) 
        {
            $o_ALM_TransaccionDetalleBN = $o_ALM_KardexBN->getObjetoDetalleTransaccion();
            $o_ALMItemAlmacenStockBN    = $o_ALM_KardexBN->getALMItemAlmacenStockBN();
            //pr( $o_ALM_TransaccionDetalleBN );
            //pr( $o_ALMItemAlmacenStockBN );

            $s_FechaDocumento         = $o_ALM_TransaccionCabeceraBN->getFechaDocumento();
            $s_FechaDocumentoOriginal = $o_ALM_TransaccionCabeceraBN->getFechaDocumento();

            $i_CantOriginal  = $o_ALM_KardexBN->getCantidad();
            $i_CantEvaluada  = $o_ALM_KardexBN->getCantidad();
            $i_CantSaldo     = $o_ALM_KardexBN->getCantidad();
            $i_StockFisico   = $o_ALMItemAlmacenStockBN->getStockFisico();
            $i_DiasCalculado = 0;

            /************************************************************************************************************************************/
            //parametros por defecto
            $o_ALM_TransParaRepInvBN = new ALM_TransParaRepInvBN();
            $o_ALM_TransParaRepInvBN->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
            $o_ALM_TransParaRepInvBN->setIdSucursal( $o_ALM_TransaccionCabeceraBN->GetIdSucursal() );
            $o_ALM_TransParaRepInvBN->setIdNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
            $o_ALM_TransParaRepInvBN->setIdTransaccion( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
            $o_ALM_TransParaRepInvBN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
            $o_ALM_TransParaRepInvBN->setFechaDocumento( $s_FechaDocumento );
            $o_ALM_TransParaRepInvBN->setFechaDocumentoOriginal( $s_FechaDocumentoOriginal );
            $o_ALM_TransParaRepInvBN->setReferenciaTipoDocumento( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
            $o_ALM_TransParaRepInvBN->setReferenciaNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
            $o_ALM_TransParaRepInvBN->setReferenciaTipoDocumentoOriginal( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
            $o_ALM_TransParaRepInvBN->setReferenciaNumeroDocumentoOriginal( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
            $o_ALM_TransParaRepInvBN->setIdItem( $o_ALM_KardexBN->getIdItem() );
            $o_ALM_TransParaRepInvBN->setIdLote( $o_ALM_KardexBN->getIdLote() );
            $o_ALM_TransParaRepInvBN->setIdSecuencia( $o_ALM_TransaccionDetalleBN->getIdSecuencia() );
            $o_ALM_TransParaRepInvBN->setCantOriginal( $i_CantOriginal );
            $o_ALM_TransParaRepInvBN->setCantEvaluada( $i_CantEvaluada );
            $o_ALM_TransParaRepInvBN->setCantSaldo( $i_CantSaldo );
            $o_ALM_TransParaRepInvBN->setStockFisico( $i_StockFisico );
            $o_ALM_TransParaRepInvBN->setDiasCalculado( $i_DiasCalculado );
            $o_ALM_TransParaRepInvBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_ALM_TransParaRepInvBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_TransParaRepInvBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
            /************************************************************************************************************************************/

            $b_ControlInsert = true;

            $o_ALM_TransParaRepInvFN = new ALM_TransParaRepInvFN();
            $o_ALM_TransParaRepInvFN->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
            $o_ALM_TransParaRepInvFN->setIdSucursal( $o_ALM_TransaccionCabeceraBN->GetIdSucursal() );
            $o_ALM_TransParaRepInvFN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
            $o_ALM_TransParaRepInvFN->setIdItem( $o_ALM_KardexBN->getIdItem() );
            $a_ALM_TransParaRepInv = $o_ALM_TransParaRepInvFN->buscarDocumentosRelacionados();
            if( $a_ALM_TransParaRepInv )
            {
                foreach ( $a_ALM_TransParaRepInv as $o_TMP_ALM_TransParaRepInvBN ) 
                {
                    $s_FechaDocumentoOriginal = $o_TMP_ALM_TransParaRepInvBN->getFechaDocumentoOriginal();

                    $i_CantEvaluada  = 0;
                    $i_CantSaldo     = $o_TMP_ALM_TransParaRepInvBN->getCantSaldo();
                    $i_Dias          = UtilDate::diferenciaEntreFecha( $s_FechaDocumentoOriginal, $s_FechaDocumento );
                    $i_DiasCalculado = $i_Dias;

                    //aqui preguntamos si el mismo para agrega el reemplazo
                    if
                    (
                        $o_ALM_TransaccionCabeceraBN->getIdTransaccion()             == $o_TMP_ALM_TransParaRepInvBN->getIdTransaccion() && 
                        $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento()   == $o_TMP_ALM_TransParaRepInvBN->getReferenciaTipoDocumento() &&
                        $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() == $o_TMP_ALM_TransParaRepInvBN->getReferenciaNumeroDocumento()
                    )
                    {
                        //$s_FechaDocumentoOriginal = $o_TMP_ALM_TransParaRepInvBN->getFechaDocumentoOriginal();

                        $i_CantOriginal  = $o_ALM_KardexBN->getCantidad();
                        $i_CantEvaluada  = $o_ALM_KardexBN->getCantidad();
                        $i_CantSaldo     = $o_TMP_ALM_TransParaRepInvBN->getCantSaldo() + $i_CantEvaluada;

                        $i_Dias = UtilDate::diferenciaEntreFecha( $s_FechaDocumentoOriginal, $s_FechaDocumento );
                        $i_DiasCalculado = $i_Dias;

                        $b_ControlInsert = false;
                    }

                    $o_TMP_ALM_TransParaRepInvBN->setIdNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                    $o_TMP_ALM_TransParaRepInvBN->setFechaDocumento( $s_FechaDocumento );
                    $o_TMP_ALM_TransParaRepInvBN->setFechaDocumentoOriginal( $s_FechaDocumentoOriginal );
                    $o_TMP_ALM_TransParaRepInvBN->setCantOriginal( $i_CantOriginal );
                    $o_TMP_ALM_TransParaRepInvBN->setCantEvaluada( $i_CantEvaluada );
                    $o_TMP_ALM_TransParaRepInvBN->setCantSaldo( $i_CantSaldo );
                    $o_TMP_ALM_TransParaRepInvBN->setStockFisico( $i_StockFisico );
                    $o_TMP_ALM_TransParaRepInvBN->setDiasCalculado( $i_DiasCalculado );
                    $this->guardarRedEdadInv( $o_TMP_ALM_TransParaRepInvBN );
                }
            }

            if( $b_ControlInsert )
            {
                $this->guardarRedEdadInv( $o_ALM_TransParaRepInvBN );
            }
        }
    }

    private function realizarProcesoIngreso( $o_ALM_TransaccionCabeceraBN )
    {
        $a_ArrayMovientoKardex = $o_ALM_TransaccionCabeceraBN->getArrayMovientoKardex();

        foreach ( $a_ArrayMovientoKardex as $o_ALM_KardexBN ) 
        {
            $o_ALM_TransaccionDetalleBN = $o_ALM_KardexBN->getObjetoDetalleTransaccion();
            $o_ALMItemAlmacenStockBN    = $o_ALM_KardexBN->getALMItemAlmacenStockBN();
            //pr( $o_ALM_TransaccionDetalleBN );
            //pr( $o_ALMItemAlmacenStockBN );

            $s_FechaDocumento         = $o_ALM_TransaccionCabeceraBN->getFechaDocumento();
            $s_FechaDocumentoOriginal = $o_ALM_TransaccionCabeceraBN->getFechaDocumento();

            $i_CantOriginal  = $o_ALM_KardexBN->getCantidad();
            $i_CantEvaluada  = $o_ALM_KardexBN->getCantidad();
            $i_CantSaldo     = $o_ALM_KardexBN->getCantidad();
            $i_StockFisico   = $o_ALMItemAlmacenStockBN->getStockFisico();
            $i_DiasCalculado = 0;

            //aqui es un ingreso de tipo ajuste o otros
            $o_ALM_TransParaRepInvFN = new ALM_TransParaRepInvFN();
            $o_ALM_TransParaRepInvFN->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
            $o_ALM_TransParaRepInvFN->setIdSucursal( $o_ALM_TransaccionCabeceraBN->GetIdSucursal() );
            //$o_ALM_TransParaRepInvFN->setIdTransaccion( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
            $o_ALM_TransParaRepInvFN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
            //$o_ALM_TransParaRepInvFN->setReferenciaTipoDocumentoOriginal( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
            //$o_ALM_TransParaRepInvFN->setReferenciaNumeroDocumentoOriginal( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
            $o_ALM_TransParaRepInvFN->setIdItem( $o_ALM_KardexBN->getIdItem() );
            $a_ALM_TransParaRepInv = $o_ALM_TransParaRepInvFN->buscarDocumentosRelacionados();
            foreach ( $a_ALM_TransParaRepInv as $o_ALM_TransParaRepInvBN ) 
            {
                $s_FechaDocumentoOriginal = $o_ALM_TransParaRepInvBN->getFechaDocumentoOriginal();

                //$i_CantOriginal  = $o_ALM_KardexBN->getCantidad();
                //$i_CantEvaluada  = $o_ALM_KardexBN->getCantidad();
                $i_CantSaldo     = $o_ALM_TransParaRepInvBN->getCantSaldo() + $i_CantEvaluada;
                $i_Dias          = UtilDate::diferenciaEntreFecha( $s_FechaDocumentoOriginal, $s_FechaDocumento );
                $i_DiasCalculado = $i_Dias;

                //$o_ALM_TransParaRepInvBN = new ALM_TransParaRepInvBN();
                $o_ALM_TransParaRepInvBN->setIdNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                $o_ALM_TransParaRepInvBN->setIdTransaccion( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
                $o_ALM_TransParaRepInvBN->setFechaDocumento( $s_FechaDocumento );
                //$o_ALM_TransParaRepInvBN->setFechaDocumentoOriginal( $s_FechaDocumentoOriginal );
                $o_ALM_TransParaRepInvBN->setReferenciaTipoDocumento( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
                $o_ALM_TransParaRepInvBN->setReferenciaNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
                $o_ALM_TransParaRepInvBN->setCantOriginal( $i_CantOriginal );
                $o_ALM_TransParaRepInvBN->setCantEvaluada( $i_CantEvaluada );
                $o_ALM_TransParaRepInvBN->setCantSaldo( $i_CantSaldo );
                $o_ALM_TransParaRepInvBN->setStockFisico( $i_StockFisico );
                $o_ALM_TransParaRepInvBN->setDiasCalculado( $i_DiasCalculado );
                $o_ALM_TransParaRepInvBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ALM_TransParaRepInvBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_TransParaRepInvBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $this->guardarRedEdadInv( $o_ALM_TransParaRepInvBN );

                $i_CantEvaluada = 0;
            }
        }
    }

    private function realizarProcesoSalida( $o_ALM_TransaccionCabeceraBN )
    {
        $a_ArrayMovientoKardex = $o_ALM_TransaccionCabeceraBN->getArrayMovientoKardex();

        foreach ( $a_ArrayMovientoKardex as $o_ALM_KardexBN ) 
        {
            $o_ALM_TransaccionDetalleBN = $o_ALM_KardexBN->getObjetoDetalleTransaccion();
            $o_ALMItemAlmacenStockBN    = $o_ALM_KardexBN->getALMItemAlmacenStockBN();
            //pr( $o_ALM_TransaccionDetalleBN );
            //pr( $o_ALMItemAlmacenStockBN );

            $s_FechaDocumento         = $o_ALM_TransaccionCabeceraBN->getFechaDocumento();

            $i_CantEvaluada  = $o_ALM_KardexBN->getCantidad();
            $i_CantOriginal  = $i_CantEvaluada;
            $i_StockFisico   = $o_ALMItemAlmacenStockBN->getStockFisico();
            /*$i_CantSaldo     = $o_ALM_KardexBN->getCantidad();
            $i_DiasCalculado = 0;*/
            //aqui es un ingreso de tipo ajuste o otros
            $o_ALM_TransParaRepInvFN = new ALM_TransParaRepInvFN();
            $o_ALM_TransParaRepInvFN->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
            $o_ALM_TransParaRepInvFN->setIdSucursal( $o_ALM_TransaccionCabeceraBN->GetIdSucursal() );
            //$o_ALM_TransParaRepInvFN->setIdTransaccion( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
            $o_ALM_TransParaRepInvFN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
            //$o_ALM_TransParaRepInvFN->setReferenciaTipoDocumentoOriginal( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
            //$o_ALM_TransParaRepInvFN->setReferenciaNumeroDocumentoOriginal( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
            $o_ALM_TransParaRepInvFN->setIdItem( $o_ALM_KardexBN->getIdItem() );
            $a_ALM_TransParaRepInv = $o_ALM_TransParaRepInvFN->buscarDocumentosRelacionados();
            //pr( $a_ALM_TransParaRepInv );
            foreach ( $a_ALM_TransParaRepInv as $o_ALM_TransParaRepInvBN ) 
            {
                $s_FechaDocumentoOriginal = $o_ALM_TransParaRepInvBN->getFechaDocumentoOriginal();

                $i_SaldoOriginal = $o_ALM_TransParaRepInvBN->getCantSaldo();
                $i_CantResta     = $i_CantEvaluada;
                $i_CantSaldo     = $o_ALM_TransParaRepInvBN->getCantSaldo() - $i_CantResta;

                $b_Control = false;
                if( $i_CantEvaluada > $o_ALM_TransParaRepInvBN->getCantSaldo() )
                {
                    $i_CantResta = $o_ALM_TransParaRepInvBN->getCantSaldo();
                    $i_CantSaldo = 0;
                    $b_Control   = true;
                }
                
                $i_Dias          = UtilDate::diferenciaEntreFecha( $s_FechaDocumentoOriginal, $s_FechaDocumento );
                $i_DiasCalculado = $i_Dias;

                //$o_ALM_TransParaRepInvBN = new ALM_TransParaRepInvBN();
                $o_ALM_TransParaRepInvBN->setIdNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                $o_ALM_TransParaRepInvBN->setIdTransaccion( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
                $o_ALM_TransParaRepInvBN->setFechaDocumento( $s_FechaDocumento );
                //$o_ALM_TransParaRepInvBN->setFechaDocumentoOriginal( $s_FechaDocumentoOriginal );
                $o_ALM_TransParaRepInvBN->setReferenciaTipoDocumento( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
                $o_ALM_TransParaRepInvBN->setReferenciaNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
                $o_ALM_TransParaRepInvBN->setCantOriginal( $i_CantOriginal * -1  );
                $o_ALM_TransParaRepInvBN->setCantEvaluada( $i_CantResta * -1  );
                $o_ALM_TransParaRepInvBN->setCantSaldo( $i_CantSaldo );
                $o_ALM_TransParaRepInvBN->setStockFisico( $i_StockFisico );
                $o_ALM_TransParaRepInvBN->setDiasCalculado( $i_DiasCalculado );
                $o_ALM_TransParaRepInvBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ALM_TransParaRepInvBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_TransParaRepInvBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                
                $this->guardarRedEdadInv( $o_ALM_TransParaRepInvBN );

                if( !$b_Control )
                {
                    $i_CantEvaluada = 0;
                }
                else
                {
                    $i_CantEvaluada = $i_CantEvaluada - $i_SaldoOriginal;
                }
            }
        }
    }

    private function realizarProcesoTransferencia( $o_ALM_TransaccionCabeceraBN )
    {
        $a_ArrayMovientoKardex = $o_ALM_TransaccionCabeceraBN->getArrayMovientoKardex();
        
        $s_AlmacenCabSalRef = "";
        
        //PRIMERO SE REALIZA LAS SALIDAS
        $a_ALM_Kardex = array();
        foreach ( $a_ArrayMovientoKardex as $o_ALM_KardexBN ) 
        {
            if( $o_ALM_KardexBN->getIdCondicion() == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
            {
                $s_AlmacenCabSalRef = $o_ALM_KardexBN->getIdAlmacen();
                $a_ALM_Kardex[] = $o_ALM_KardexBN;
            }
        }
        $o_ALM_TransaccionCabeceraBN->setArrayMovientoKardex( $a_ALM_Kardex );
        $this->realizarProcesoSalida( $o_ALM_TransaccionCabeceraBN );

        //LUEGO SE REALIZAN LAS OPERACION DE INGRESO
        $a_ALM_Kardex = array();
        foreach ( $a_ArrayMovientoKardex as $o_ALM_KardexBN ) 
        {
            if( $o_ALM_KardexBN->getIdCondicion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
            {
                $i_CantEvaluada  = $o_ALM_KardexBN->getCantidad();
                
                $o_ALM_TransParaRepInvFN = new ALM_TransParaRepInvFN();
                $o_ALM_TransParaRepInvFN->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
                $o_ALM_TransParaRepInvFN->setIdSucursal( $o_ALM_TransaccionCabeceraBN->GetIdSucursal() );
                $o_ALM_TransParaRepInvFN->setIdAlmacen( $s_AlmacenCabSalRef );
                $o_ALM_TransParaRepInvFN->setIdItem( $o_ALM_KardexBN->getIdItem() );
                $a_ALM_TransParaRepInv = $o_ALM_TransParaRepInvFN->buscarDocumentosRelacionados();
                
                $a_ALM_Kardex = array();
                foreach( $a_ALM_TransParaRepInv as $o_ALM_TransParaRepInvBN )
                {
                    $i_SaldoOriginal = $o_ALM_TransParaRepInvBN->getCantSaldo();
                    $i_CantResta     = $i_CantEvaluada;
                    $i_CantSaldo     = $o_ALM_TransParaRepInvBN->getCantSaldo() - $i_CantResta;
                    
                    $b_Control = false;
                    if( $i_CantEvaluada > $o_ALM_TransParaRepInvBN->getCantSaldo() )
                    {
                        $i_CantResta = $o_ALM_TransParaRepInvBN->getCantSaldo();
                        $i_CantSaldo = 0;
                        $b_Control   = true;
                    }
                    else
                    {
                        $a_ALM_Kardex[] = $o_ALM_KardexBN;
                        
                        //$o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( "NI" );
                        $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $o_ALM_KardexBN->getIdAlmacen() );
                        $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $o_ALM_TransParaRepInvBN->getReferenciaTipoDocumentoOriginal()=="NI" ? "STI" : "ROC" );
                        $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $o_ALM_TransParaRepInvBN->getReferenciaTipoDocumentoOriginal() );
                        $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $o_ALM_TransParaRepInvBN->getReferenciaNumeroDocumentoOriginal() );
                        $o_ALM_TransaccionCabeceraBN->setArrayMovientoKardex( $a_ALM_Kardex );
                        //pr( $o_ALM_TransaccionCabeceraBN );
                        $this->realizarProcesoIngresoPrincipal( $o_ALM_TransaccionCabeceraBN );
                        
                        break;
                    }
                    
                    if( !$b_Control )
                    {
                        $i_CantEvaluada = 0;
                    }
                    else
                    {
                        $i_CantEvaluada = $i_CantEvaluada - $i_SaldoOriginal;
                    }
                }
                //$a_ALM_Kardex[] = $o_ALM_KardexBN;
            }
        }
        //$o_ALM_TransaccionCabeceraBN->setArrayMovientoKardex( $a_ALM_Kardex );
        //pr( $s_AlmacenCabSalRef );
        //$this->realizarProcesoIngreso( $o_ALM_TransaccionCabeceraBN );
    }
    
    private function guardarRedEdadInv( $o_ALM_TransParaRepInvBN )
    {
        $i_IdTrx = ALM_TransParaRepInvDP::recuperarId();
        $o_ALM_TransParaRepInvDP = new ALM_TransParaRepInvDP( $o_ALM_TransParaRepInvBN );
        $o_ALM_TransParaRepInvDP->setIdTrx( $i_IdTrx );
        $o_ALM_TransParaRepInvDP->save();
        //pr( $o_ALM_TransParaRepInvDP );
        return true;
    }
}