<?php
class OrdenCompraBL
{
    public function guardarOrdenCompra( COM_OrdenCompraDetalleBN $o_COM_OrdenCompraDetalleBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            
            
            $con->commit();
            return true;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "OC: ".$o_Exception->getMessage() );
        }
    }
    
    public function aprobarOrdenCompra( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            //PARAMETROS POR DEFECTO
            $s_TipoRequerimientoLog = $o_COM_OrdenCompraCabeceraBN->getTipoRequerimientoLog();
            
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
            $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO );
            $o_COM_OrdenCompraCabeceraDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) );
            $o_COM_OrdenCompraCabeceraDP->setAprobadoPor( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $b_Result = $o_COM_OrdenCompraCabeceraDP->update();
            
            $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
            $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdCompania(), $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
        
            $i_IdSucursal = ALM_AlmacenMastFN::recuperarIdSucursal( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
            
            $a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraCabeceraBN->getArrayObjectDetalles();
            foreach ( $a_COM_OrdenCompraDetalle as $i_Key => $o_COM_OrdenCompraDetalleBN )
            {
                //SE ACTUALIZA EL ESTADO EN LOS DETALLES TAMBIEN
                $o_COM_OrdenCompraDetalleDP = new COM_OrdenCompraDetalleDP();
                $o_COM_OrdenCompraDetalleDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
                $o_COM_OrdenCompraDetalleDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
                $o_COM_OrdenCompraDetalleDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO );
                $o_COM_OrdenCompraDetalleDP->setIdSecuencia( $o_COM_OrdenCompraDetalleBN->getIdSecuencia() );
                $o_COM_OrdenCompraDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_COM_OrdenCompraDetalleDP->update();

                if( $o_COM_OrdenCompraCabeceraBN->esAfectoAIGV() )
                {
                    //AHORA SE GUARDA EL LOG PARA POSTERIORMENTE RECUPERAR EL PRECIO
                    $f_TipoCambio        = $o_COM_OrdenCompraCabeceraBN->getTipoCambio();
                    $f_PrecioUnitario    = $o_COM_OrdenCompraDetalleBN->getPrecioUnitario();
                    $f_PrecioUnitarioIGV = $o_COM_OrdenCompraDetalleBN->getPrecioUnitarioIGV();

                    if( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() == "LO" )
                    {
                        $f_PrecioUnitarioMN = $f_PrecioUnitario;
                        $f_PrecioUnitarioME = round( $f_PrecioUnitario / $f_TipoCambio, 2 );

                        $f_PrecioUnitarioIGVMN = $f_PrecioUnitarioIGV;
                        $f_PrecioUnitarioIGVME = round( $f_PrecioUnitarioIGV / $f_TipoCambio, 2 );
                    }
                    if( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() == "EX" )
                    {
                        $f_PrecioUnitarioMN = round( $f_PrecioUnitario * $f_TipoCambio, 2 ) ;
                        $f_PrecioUnitarioME = $f_PrecioUnitario;

                        $f_PrecioUnitarioIGVMN = round( $f_PrecioUnitarioIGV * $f_TipoCambio, 2 );
                        $f_PrecioUnitarioIGVME = $f_PrecioUnitarioIGV;
                    }

                    $i_IdRequerimientoLog = ALM_RequerimientoDetalleLogFN::recuperarId();

                    $o_ALM_RequerimientoDetalleLogDP = new ALM_RequerimientoDetalleLogDP();
                    $o_ALM_RequerimientoDetalleLogDP->setIdRequerimientoLog( $i_IdRequerimientoLog );
                    $o_ALM_RequerimientoDetalleLogDP->setTipo( $s_TipoRequerimientoLog );
                    $o_ALM_RequerimientoDetalleLogDP->setIdRequerimiento( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
                    $o_ALM_RequerimientoDetalleLogDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
                    $o_ALM_RequerimientoDetalleLogDP->setIdRequerimientoDetalle( $o_COM_OrdenCompraDetalleBN->getIdSecuencia() );
                    $o_ALM_RequerimientoDetalleLogDP->setIdSucursal( ( int ) $i_IdSucursal );
                    $o_ALM_RequerimientoDetalleLogDP->setIdPersona( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
                    $o_ALM_RequerimientoDetalleLogDP->setIdItem( $o_COM_OrdenCompraDetalleBN->getIdItem() );
                    $o_ALM_RequerimientoDetalleLogDP->setIdMoneda( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
                    $o_ALM_RequerimientoDetalleLogDP->setTipoCambio( $f_TipoCambio );
                    $o_ALM_RequerimientoDetalleLogDP->setCantidad( $o_COM_OrdenCompraDetalleBN->getCantidadPedida() );

                    $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitario( $f_PrecioUnitario );
                    $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioMN( $f_PrecioUnitarioMN );
                    $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioME( $f_PrecioUnitarioME );
                    $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGV( $f_PrecioUnitarioIGV );
                    $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGVMN( $f_PrecioUnitarioIGVMN );
                    $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGVME( $f_PrecioUnitarioIGVME );

                    $o_ALM_RequerimientoDetalleLogDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_ALM_RequerimientoDetalleLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_RequerimientoDetalleLogDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_RequerimientoDetalleLogDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $b_Result = $o_ALM_RequerimientoDetalleLogDP->save();
                }
            }
            
            $con->commit();
            return true;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "OC: ".$o_Exception->getMessage() );
        }
    }
    
    private function validarValoresxDefecto( COM_OrdenCompraDetalleBN $o_COM_OrdenCompraDetalleBN )
    {
        
    }
    
    public function realizarProcesoRecepcionOrdenCompra( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
            $o_TMP_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdCompania(), $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
            
            ////////////////////////////////////////////////////////////////////////////
            //VALIDACION PARA REALIZAR UNA RECEPCION CON PROVEEDOR DE UNA O VARIAS GUIAS
            $i_IdProveedor = $o_COM_OrdenCompraCabeceraBN->getIdProveedor();
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdProveedor );
            if( $o_MST_PersonaMastBN )
            {
                //SIGNIFICA QUE LA ORDEN DE COMPRA YA DEBERIA DE TENER UNA ASOCIACION DE FACTURA
                $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
                $o_ALM_OrdenGuiaFacturaFN->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
                $o_ALM_OrdenGuiaFacturaFN->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
                $o_ALM_OrdenGuiaFacturaFN->setIdPersona( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );

                //$o_ALM_OrdenGuiaFacturaFN->setSerieGuia( $o_COM_OrdenCompraCabeceraBN->getSerieDocumentoFiscal() );
                //$o_ALM_OrdenGuiaFacturaFN->setNumeroGuia( $o_COM_OrdenCompraCabeceraBN->getNumeroDocumentoFiscal() );

                $o_ALM_OrdenGuiaFacturaFN->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_POR_INGRESAR );
                //$o_ALM_OrdenGuiaFacturaFN->setSecuencia( $o_COM_OrdenCompraCabeceraBN->getSecuenciaSerieNumero() ); //SE AGREGO EL CAMPO PARA VARIAS FACTURAS
                $a_ALM_OrdenGuiaFactura = $o_ALM_OrdenGuiaFacturaFN->select();
                if( !$a_ALM_OrdenGuiaFactura )
                {
                    $o_ALM_OrdenGuiaFacturaDP = new ALM_OrdenGuiaFacturaDP();
                    $o_ALM_OrdenGuiaFacturaDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
                    $o_ALM_OrdenGuiaFacturaDP->setIdSucursal( $o_COM_OrdenCompraCabeceraBN->getIdSucursal() );
                    $o_ALM_OrdenGuiaFacturaDP->setIdAlmacen( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
                    $o_ALM_OrdenGuiaFacturaDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
                    $o_ALM_OrdenGuiaFacturaDP->setIdPersona( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
                    $o_ALM_OrdenGuiaFacturaDP->setSerieGuia( $o_COM_OrdenCompraCabeceraBN->getSerieDocumentoFiscal() );
                    $o_ALM_OrdenGuiaFacturaDP->setFechaGuia( date( "Y-m-d" ) );
                    $o_ALM_OrdenGuiaFacturaDP->setNumeroGuia( $o_COM_OrdenCompraCabeceraBN->getNumeroDocumentoFiscal() );

                    $i_IdOrdenGuia = ALM_OrdenGuiaFacturaDP::generarId();

                    $o_ALM_OrdenGuiaFacturaDP->setIdOrdenGuia( $i_IdOrdenGuia );
                    $o_ALM_OrdenGuiaFacturaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_OrdenGuiaFacturaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_ALM_OrdenGuiaFacturaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_OrdenGuiaFacturaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_OrdenGuiaFacturaDP->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_POR_INGRESAR );
                    $o_ALM_OrdenGuiaFacturaDP->save();
                }
            }
            else
            {
                throw new Exception( "El Proveedor no esta Registrado." );
            }

            ////////////////////////////////////////////////////////////////////////////
            //SE REALIZA LA TRANSACCION
            $o_ALM_TransaccionCabeceraBN = $o_COM_OrdenCompraCabeceraBN->getObjectTransaccion();

            $o_MovimientoBL = new MovimientoBL();
            $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
            ////////////////////////////////////////////////////////////////////////////
            $this->actualizarObservaciones( $o_COM_OrdenCompraCabeceraBN );
            $this->actualizarCantidadRecibidaOrdenDetalle( $o_COM_OrdenCompraCabeceraBN );
            $this->iniciarAsociacionGuiaFactura( $o_COM_OrdenCompraCabeceraBN );

            ////////////////////////////////////////////////////////////////////////////
            //NUEVO PROCEDIMIENTO, CAMBIAR LAS SERIES DE PRE - 2022-01-30
            $this->realizarTransaccionSeries( $o_COM_OrdenCompraCabeceraBN );

            $con->commit();
            //exit;

            return true;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() );
        }
    }
    
    public function actualizarCantidadRecibidaOrdenDetalle( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        myUser::getUser()->validar_session();

        $a_ArrayOrdenCompraDetalle = $o_COM_OrdenCompraCabeceraBN->getArrayOrdenCompraDetalle();
        foreach ( $a_ArrayOrdenCompraDetalle as $o_COM_OrdenCompraDetalleBN )
        {
            $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
            $o_TmpCOM_OrdenCompraDetalleBN = $o_COM_OrdenCompraDetalleFN->selectByPK( $o_COM_OrdenCompraDetalleBN->getIdOrdenCompra(), $o_COM_OrdenCompraDetalleBN->getIdCompania(), $o_COM_OrdenCompraDetalleBN->getIdSecuencia()  );
            //$f_CantidadPedida        = floatval( $o_TmpCOM_OrdenCompraDetalleBN->getCantidadPedida() );
            $f_CantidadPedida        = COM_OrdenCompraDetalleFN::buscarCantidadxUnidadConversion( $o_TmpCOM_OrdenCompraDetalleBN->getObjectUnidad()->getIdUnidad(), floatval( $o_TmpCOM_OrdenCompraDetalleBN->getCantidadPedida() ) );
            $i_CantidadRecibida      = floatval( $o_TmpCOM_OrdenCompraDetalleBN->getCantidadRecibida() );
            $i_NuevaCantidadRecibida = ( $i_CantidadRecibida + $o_COM_OrdenCompraDetalleBN->getCantidadRecibida() );

            if( $i_NuevaCantidadRecibida > $f_CantidadPedida )
            {
                throw new Exception( "La cantidad excede a la cantidad Pedida." );
            }
            
            $o_COM_OrdenCompraDetalleDP = new COM_OrdenCompraDetalleDP();
            $o_COM_OrdenCompraDetalleDP->setIdOrdenCompra( $o_COM_OrdenCompraDetalleBN->getIdOrdenCompra() );
            $o_COM_OrdenCompraDetalleDP->setIdCompania( $o_COM_OrdenCompraDetalleBN->getIdCompania() );
            $o_COM_OrdenCompraDetalleDP->setIdSecuencia( $o_COM_OrdenCompraDetalleBN->getIdSecuencia() );
            $o_COM_OrdenCompraDetalleDP->setCantidadRecibida( $i_NuevaCantidadRecibida );
            
            //$o_COM_OrdenCompraDetalleDP->setMuestraUni( $o_COM_OrdenCompraDetalleBN->getMuestraUni() );
            //$o_COM_OrdenCompraDetalleDP->setMuestraKgr( $o_COM_OrdenCompraDetalleBN->getMuestraKgr() );
            
            $o_COM_OrdenCompraDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_COM_OrdenCompraDetalleDP->update();
            
            $o_COM_OrdenCompraDetalleDP->setComentario( $o_COM_OrdenCompraDetalleBN->getComentario() );
            $o_COM_OrdenCompraDetalleDP->addCommnentDetail();
        }
        $this->cambiarEstadoPorCantidadesIguales( $o_COM_OrdenCompraCabeceraBN );
        return true;
    }
    
    public function iniciarAsociacionGuiaFactura( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        myUser::getUser()->validar_session();

        $i_IdSucursal = ALM_AlmacenMastFN::recuperarIdSucursal( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        if( !$i_IdSucursal )
        {
            throw new Exception( "No se encontro el IdSucursal." );
        }
        if( !$o_COM_OrdenCompraCabeceraBN->getIdProveedor() )
        {
            throw new Exception( "No se encontro el IdProveedor." );
        }

        $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
        $o_ALM_OrdenGuiaFacturaFN->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        $o_ALM_OrdenGuiaFacturaFN->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
        $o_ALM_OrdenGuiaFacturaFN->setIdPersona( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
        //$o_ALM_OrdenGuiaFacturaFN->setSerieGuia( $o_COM_OrdenCompraCabeceraBN->getSerieDocumentoFiscal() );
        //$o_ALM_OrdenGuiaFacturaFN->setNumeroGuia( $o_COM_OrdenCompraCabeceraBN->getNumeroDocumentoFiscal() );
        //$o_ALM_OrdenGuiaFacturaFN->setSecuencia( $o_COM_OrdenCompraCabeceraBN->getSecuenciaSerieNumero() ); //SE AGREGO EL CAMPO PARA VARIAS FACTURAS
        $o_ALM_OrdenGuiaFacturaFN->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_POR_INGRESAR );
        $a_ALM_OrdenGuiaFactura = $o_ALM_OrdenGuiaFacturaFN->select();
    	if( $a_ALM_OrdenGuiaFactura )
    	{
            $o_ALM_TransaccionCabeceraBN = $o_COM_OrdenCompraCabeceraBN->getObjectTransaccion();

    	    foreach ( $a_ALM_OrdenGuiaFactura as $o_ALM_OrdenGuiaFacturaBN )
    	    {
    	        $i_IdOrdenGuia = $o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuia();
    	        
    	        $o_ALM_OrdenGuiaFacturaDP = new ALM_OrdenGuiaFacturaDP();
    	        $o_ALM_OrdenGuiaFacturaDP->setIdOrdenGuia( $i_IdOrdenGuia );
                $o_ALM_OrdenGuiaFacturaDP->setIdTipoDocumentoRef( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
                $o_ALM_OrdenGuiaFacturaDP->setIdNumeroDocumentoRef( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
    	        $o_ALM_OrdenGuiaFacturaDP->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_ASOCIADO );
    	        $o_ALM_OrdenGuiaFacturaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
    	        $o_ALM_OrdenGuiaFacturaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
    	        $o_ALM_OrdenGuiaFacturaDP->update();
    	    }
    	    return true;
    	}
    	else 
    	{
            //aqui no deberia de entrar...
    	    $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
            $o_ALM_OrdenGuiaFacturaFN->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
            $o_ALM_OrdenGuiaFacturaFN->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
            $o_ALM_OrdenGuiaFacturaFN->setIdPersona( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
            $o_ALM_OrdenGuiaFacturaFN->setSerieGuia( $o_COM_OrdenCompraCabeceraBN->getSerieDocumentoFiscal() );
            $o_ALM_OrdenGuiaFacturaFN->setNumeroGuia( $o_COM_OrdenCompraCabeceraBN->getNumeroDocumentoFiscal() );
            //$o_ALM_OrdenGuiaFacturaFN->setSecuencia( $o_COM_OrdenCompraCabeceraBN->getSecuenciaSerieNumero() ); //SE AGREGO EL CAMPO PARA VARIAS FACTURAS
            $o_ALM_OrdenGuiaFacturaFN->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_ASOCIADO );
            $a_ALM_OrdenGuiaFactura = $o_ALM_OrdenGuiaFacturaFN->select();
            if( !$a_ALM_OrdenGuiaFactura )
            {
    	       throw new Exception( "No se encontro Factura de Proveedor Asociada." );
            }
    	}
        return true;
    }
    
    public function iniciarAsociacionNotaCredito( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        /*$con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $i_IdSucursal = ALM_AlmacenMastFN::recuperarIdSucursal( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
            
            $o_ALM_OrdenGuiaFacturaBN = $o_COM_OrdenCompraCabeceraBN->getObjectOrdenGuiaFactura();
            $o_ALM_OrdenGuiaFacturaBN->setIdSucursal( $i_IdSucursal );
            $o_ALM_OrdenGuiaFacturaBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
        	$o_ALM_OrdenGuiaFacturaBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
        	$o_ALM_OrdenGuiaFacturaBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        	$o_ALM_OrdenGuiaFacturaBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
        	$o_ALM_OrdenGuiaFacturaBN->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_ASOCIADO );
            
            //VALIDACION DE QUE NO EXISTA:
            $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
        	$o_ALM_OrdenGuiaFacturaFN->setIdCompania( $o_ALM_OrdenGuiaFacturaBN->getIdCompania() );
        	$o_ALM_OrdenGuiaFacturaFN->setIdOrdenCompra( $o_ALM_OrdenGuiaFacturaBN->getIdOrdenCompra() );
        	$o_ALM_OrdenGuiaFacturaFN->setIdPersona( $o_ALM_OrdenGuiaFacturaBN->getIdPersona() );
            $o_ALM_OrdenGuiaFacturaFN->setSerieGuia( $o_ALM_OrdenGuiaFacturaBN->getSerieGuia() );
            $o_ALM_OrdenGuiaFacturaFN->setNumeroGuia( $o_ALM_OrdenGuiaFacturaBN->getNumeroGuia() );
            $o_ALM_OrdenGuiaFacturaFN->setTipoDoc( ALM_OrdenGuiaFacturaBN::TIPO_DOCUMENTO_NC );
            //$o_ALM_OrdenGuiaFacturaFN->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_POR_INGRESAR );
        	$a_ALM_OrdenGuiaFactura = $o_ALM_OrdenGuiaFacturaFN->select();
        	if( $a_ALM_OrdenGuiaFactura )
        	{
        		throw new Exception( "La Nota de Credito ya se encuentra ingresado." );
        	}
            //////////////////////////////
            
            //SE GUARDA ORDEN GUIA FACTURA
            $o_TmpALM_OrdenGuiaFacturaDP = new ALM_OrdenGuiaFacturaDP( $o_ALM_OrdenGuiaFacturaBN );
            $b_Result = $o_TmpALM_OrdenGuiaFacturaDP->save();
            ////////////////////////////////////////
            
            $a_ArrayOrdenCompraDetalle = $o_COM_OrdenCompraCabeceraBN->getArrayOrdenCompraDetalle();
            ///SE RECUPERA INFO DE LA OC
            $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
            $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdCompania(), $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
            
            //$o_COM_OrdenCompraCabeceraBN->setArrayOrdenCompraDetalle( $a_ArrayOrdenCompraDetalle );
            
            //AHORA SE REALIZA LA TRANSACCION SIN MOVIMIENTOS
            $IdCompania                 = $o_COM_OrdenCompraCabeceraBN->getIdCompania();
            $FechaDocumento             = $o_ALM_OrdenGuiaFacturaBN->getFechaFactura();
            $IdTransaccionOperacion     = COM_OrdenCompraCabeceraBN::TIPO_TRANSACCION_S_DEFECTO;
            $IdAlmacen                  = $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega(); //ALMACEN ORIGEN
            $IdTransaccion              = COM_OrdenCompraCabeceraBN::TRANSACCION_X_NC_PROV; //
            $AlmacenTraslado            = ""; //ALMACEN DE DESTINO
            $IdTipoDocumento            = COM_OrdenCompraCabeceraBN::TIPO_DOCUMENTO_S_NC;
            
            $ReferenciaTipoDocumento    = COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO;
            $ReferenciaNumeroDocumento  = $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() . ""; //
            
            $GuiaProveedor              = ""; //
            $Comentario                 = "NOTA DE CREDITO DEL PROVEEDOR"; //
            $TipodeCambio               = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            
            $TipoDocumentoFiscal        = $o_ALM_OrdenGuiaFacturaBN->getTipoDoc();
            $SerieDocumentoFiscal       = $o_ALM_OrdenGuiaFacturaBN->getSerieFactura();
            $NumeroDocumentoFiscal      = $o_ALM_OrdenGuiaFacturaBN->getNumeroFactura();
            $CodigoProveedor            = $o_COM_OrdenCompraCabeceraBN->getIdProveedor().""; //
            
            //CABECERA
            $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
            $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
            $o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
            $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $IdAlmacen );
            $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
            $o_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
            $o_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
            $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
            $o_ALM_TransaccionCabeceraBN->setGuiaProveedor( $GuiaProveedor );
            $o_ALM_TransaccionCabeceraBN->setIdCompania( $IdCompania );
            $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setComentario( $Comentario );
            
            $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $TipoDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $SerieDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $NumeroDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setCodigoProveedor( $CodigoProveedor );
            
            //DETALLE
            foreach ( $a_ArrayOrdenCompraDetalle as $i_Key => $o_COM_OrdenCompraDetalleBN )
            {
                $i_IdSecuencia = $o_COM_OrdenCompraDetalleBN->getIdSecuencia();
                $s_IdItem = $o_COM_OrdenCompraDetalleBN->getIdItem();
                $i_IdUnidad = $o_COM_OrdenCompraDetalleBN->getIdUnidad();
                $f_CantidadRecibida = $o_COM_OrdenCompraDetalleBN->getCantidadRecibida();
                
                $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                $o_ALM_TransaccionDetalleBN->setIdItem( $s_IdItem );
                $o_ALM_TransaccionDetalleBN->setUnidadCodigo( '58' ); //UNIDAD DE MEDIDA
                $o_ALM_TransaccionDetalleBN->setCantidad( $f_CantidadRecibida );
                $o_ALM_TransaccionDetalleBN->setPrecioUnitario( 0.00 );
                
                $o_ALM_TransaccionDetalleBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
                $o_ALM_TransaccionDetalleBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
                $o_ALM_TransaccionDetalleBN->setReferenciaSecuencia( $i_IdSecuencia );
                
                $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
            }
            $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );
            ////////////////////////////////////////////////////////////////////////////
            //SE REALIZA LA TRANACCION
            $o_ALM_TransaccionCabeceraBN->setGenerarKardex( false );
            $o_MovimientoBL = new MovimientoBL();
            $b_Result = $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
            
            $o_COM_OrdenCompraCabeceraBN->setObjectTransaccion( $o_ALM_TransaccionCabeceraBN );
            ////////////////////////////////////////////////////////////////////////////
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() );
        }
        return $o_COM_OrdenCompraCabeceraBN;*/
    }
    
    public function cambiarEstadoPorCantidadesIguales( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        myUser::getUser()->validar_session();

        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        $a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
        if( $a_COM_OrdenCompraDetalle )
        {
            $b_Control = true;
            foreach ( $a_COM_OrdenCompraDetalle as $i_Key => $o_COM_OrdenCompraDetalleBN )
            {
                $i_CantidadPedida   = $o_COM_OrdenCompraDetalleBN->getCantidadPedida();
                $i_CantidadRecibida = $o_COM_OrdenCompraDetalleBN->getCantidadRecibida();
                if( $i_CantidadPedida != $i_CantidadRecibida )
                {
                    $b_Control = false;
                }
            }
            if( $b_Control )
            {
                //ACTUALIZA EL ESTADO COMO COMPLETADO - CABACERA
                $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
                $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
                $o_COM_OrdenCompraCabeceraDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
                $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_COMPLETADO );
                $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_COM_OrdenCompraCabeceraDP->update();
                
                //DETALLES
                $o_COM_OrdenCompraDetalleDP = new COM_OrdenCompraDetalleDP();
                $o_COM_OrdenCompraDetalleDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
                $o_COM_OrdenCompraDetalleDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
                $o_COM_OrdenCompraDetalleDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_COMPLETADO );
                $b_Result = $o_COM_OrdenCompraDetalleDP->changeStatusDetail();
            }
        }
        return true;
    }
    
    public function actualizarObservaciones( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        if( $o_COM_OrdenCompraCabeceraBN->getObservacionEntrega() )
        {
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
            $o_COM_OrdenCompraCabeceraBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setObservacionEntrega( $o_COM_OrdenCompraCabeceraBN->getObservacionEntrega() );
            $o_COM_OrdenCompraCabeceraDP->addCommnentDelivery();
        }
        if( $o_COM_OrdenCompraCabeceraBN->getObservacion() )
        {
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
            $o_COM_OrdenCompraCabeceraBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setObservacion( $o_COM_OrdenCompraCabeceraBN->getObservacion() );
            $o_COM_OrdenCompraCabeceraDP->addCommnent();
        }
    }
    
    public function iniciarProcesoReversionOC( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        myUser::getUser()->validar_session();
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdCompania(), $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
        
        //SOLO SE PERMITE OC CON ESTADO APROBADO
        if( $o_COM_OrdenCompraCabeceraBN->getEstado() != COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO )
        {
            throw new Exception( "La Orden tiene un estado diferente a lo permitido." );
        }
        
        //SE BUSCA SI SE TIENE PROCESO DE RECEPCION PARA NO SEGUIR CON LA REVERSION
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $o_ALM_TransaccionCabeceraFN->setReferenciaTipoDocumento( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO );
        $o_ALM_TransaccionCabeceraFN->setReferenciaNumeroDocumento( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
        $o_ALM_TransaccionCabeceraFN->setIdTransaccion( COM_OrdenCompraCabeceraBN::TRANSACCION_X_DEFECTO );
        $o_ALM_TransaccionCabeceraFN->setIdTransaccionOperacion( COM_OrdenCompraCabeceraBN::TIPO_TRANSACCION_X_DEFECTO );
        $a_ALM_TransaccionCabecera = $o_ALM_TransaccionCabeceraFN->select();
        if( $a_ALM_TransaccionCabecera )
        {
            throw new Exception( "La OC se encuentra en proceso de Recepcion, por eso no se puede Revertir." );
        }
        
        //SE BUSCA SI NACE DE UNA REQUERIMIENTO - PEDIDO - REVISION DE COTIZACION
        $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
        
        if( $o_COM_OrdenCompraCabeceraBN->getIdRequerimiento() )
        {
            //NACE
            $i_IdRequerimiento = $o_COM_OrdenCompraCabeceraBN->getIdRequerimiento();
            
            //BUSCAMOS EL REQUERIMIENTO Y LE CAMBIAMOS DE ESTADO
            $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
            $o_ALM_RequerimientoCabeceraBN = $o_ALM_RequerimientoCabeceraFN->selectByPK( $i_IdRequerimiento );
            if( $o_ALM_RequerimientoCabeceraBN )
            {
                $o_ALM_RequerimientoCabeceraDP = new ALM_RequerimientoCabeceraDP();
                $o_ALM_RequerimientoCabeceraDP->setIdRequerimiento( $i_IdRequerimiento );
                $o_ALM_RequerimientoCabeceraDP->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_PREPARACION );
                $o_ALM_RequerimientoCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_RequerimientoCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ALM_RequerimientoCabeceraDP->update();
            }
            else
            {
                throw new Exception( "No se encontro el Requerimiento de Pedido asociado a esta OC." );
            }
            
            $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_ANULADO );
        }
        else 
        {
            //OC DIRECTO
            $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION );
            $o_COM_OrdenCompraCabeceraDP->setFechaPreparacion( date( "Y-m-d H:i:s" ) );
            $o_COM_OrdenCompraCabeceraDP->setRevisadoPor( myUser::getUser()->getUserId() );
            
        }
        //DE TODAS MANERAS DE CAMBIA EL ESTADO DE LA OC
        
        $o_COM_OrdenCompraCabeceraDP->setIdCompania( $o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
        $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $b_Result = $o_COM_OrdenCompraCabeceraDP->update();
        
        return true;
    }

    public function realizarTransaccionSeries( COM_OrdenCompraCabeceraBN $o_COM_OrdenCompraCabeceraBN )
    {
        $a_ArrayOrdenCompraDetalle = $o_COM_OrdenCompraCabeceraBN->getArrayOrdenCompraDetalle();
        foreach ( $a_ArrayOrdenCompraDetalle as $o_COM_OrdenCompraDetalleBN )
        {
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_COM_OrdenCompraDetalleBN->getIdItem() );

            if( $o_ALM_ItemMastBN->SiManejaSerie() )
            {

                $o_SR_MovimientoFN = new SR_MovimientoFN();
                $o_SR_MovimientoFN->setTipoMovimiento( COM_OrdenCompraCabeceraBN::TRANSACCION_X_DEFECTO ); //ROC
                $o_SR_MovimientoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO ); //I
                $o_SR_MovimientoFN->setAlmacen( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
                $o_SR_MovimientoFN->setReferenciaTipo( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO ); //OC
                $o_SR_MovimientoFN->setReferenciaNumero( $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra() );
                //$o_SR_MovimientoFN->setReferenciaFecha( $o_COM_OrdenCompraCabeceraBN->getFechaCreacion() );
                //$o_SR_MovimientoFN->setEstado( "P" );
                $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                if( $a_SR_Movimiento )
                {
                    $o_SR_MovimientoBN = $a_SR_Movimiento[0];

                    //SE PUEDE APROVECHAR PARA ACTUALIZAR EL NUMERO LOTE
                    //ahora se envia el item de referencia
                    $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
                    $o_SR_MovimientoDetalleBN->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                    $o_SR_MovimientoDetalleBN->setProductoId( $o_ALM_ItemMastBN->getIdItem() );

                    $o_SR_MovimientoBN->setMovimientoDetalleObject( $o_SR_MovimientoDetalleBN );

                    $o_SerieBL = new SerieBL();
                    $o_SerieBL->realizarTransaccionH( $o_SR_MovimientoBN );
                }
                else
                {
                    throw new Exception( "El Movimiento Cabecera por la Serie, no se encuentra registrado." );
                }

            }
        }
    }

}

?>