<?php
class MovimientoBL
{
    public function GuardarMovientoTransaccion( ALM_TransaccionCabeceraBN $o_ALM_TransaccionCabeceraBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            myUser::getUser()->validar_session();
            
            //VALIDACION DE PERIODO
            $s_Periodo = UtilDate::getFormatDate( $o_ALM_TransaccionCabeceraBN->getFechaDocumento(), "Ym" );
            $b_FlagPeriodo = PRO_CierreMensualFN::flagPeriodoAbierto( $s_Periodo );
            if( !$b_FlagPeriodo )
            {
                throw new Exception( "El Periodo se encuentra Cerrado." );
            }
            ///////////////////////
            //VALIDACION DE SESION EXPIRADA
            if( !myUser::getUser()->getUserId() )
            {
                throw new Exception( "La Sesion esta expirada, por favor actualice la pagina." );
            }
            ///////////////////////
            if( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() == "------" )
            {
                throw new Exception( "Se encontro un problema con el Almacen. Por favor reinicie la Session." );
            }
            ///////////////////////
            
            $this->validarValoresxDefecto( $o_ALM_TransaccionCabeceraBN );

            $o_ALM_TransaccionCabeceraDP = new ALM_TransaccionCabeceraDP( $o_ALM_TransaccionCabeceraBN );
            $o_ALM_TransaccionCabeceraDP->save();
            
            $o_TransaccionBL = new TransaccionBL();
            $o_TransaccionBL->guardarTransacciones( $o_ALM_TransaccionCabeceraBN );
            
            if( $o_ALM_TransaccionCabeceraBN->getGenerarKardex() )
            {
                $this->valoresxDefectoKardex( $o_ALM_TransaccionCabeceraBN );
                
                $o_TransaccionKardex = new TransaccionKardexBL();
                $o_TransaccionKardex->guardarTransaccionKardex( $o_ALM_TransaccionCabeceraBN );
            }

            //PROCESOS ADICIONALES
            $o_ProcesoAdicionalInventarioBL = new ProcesoAdicionalInventarioBL();
            $o_ProcesoAdicionalInventarioBL->EvaluarEdadInventario( $o_ALM_TransaccionCabeceraBN );
            //////////////////////
            
            $con->commit();
            //exit;
            
            return true;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "Mov: ".$o_Exception->getMessage() );
        }
    }
    
    private function validarValoresxDefecto( ALM_TransaccionCabeceraBN $o_ALM_TransaccionCabeceraBN )
    {
        $NumeroDocumento = ALM_TransaccionCabeceraFN::recuperarId();
        
        $s_Periodo = UtilDate::getFormatDate( $o_ALM_TransaccionCabeceraBN->getFechaDocumento(), "Ym" );

        if( !$o_ALM_TransaccionCabeceraBN->getTipodeCambio() )
        {
            $MonedaCambioValor  = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            if( !$MonedaCambioValor )
            {
                $s_FechaSel = date( "Y-m-d" );

                $o_iVentas = new iVentas();
                $o_iVentas->registrarTipoCambio( $s_FechaSel );

                $MonedaCambioValor  = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            }

            $o_ALM_TransaccionCabeceraBN->setTipodeCambio( $MonedaCambioValor );
        }

        if( !$o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() )
        {
            $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $NumeroDocumento );
        }

        $o_ALM_TransaccionCabeceraBN->setIdCompania( myUser::getUser()->getIdCompania() );
        $o_ALM_TransaccionCabeceraBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_ALM_TransaccionCabeceraBN->setCodigoCliente( ( string ) $o_ALM_TransaccionCabeceraBN->getCodigoCliente() );
        $o_ALM_TransaccionCabeceraBN->setPeriodo( $s_Periodo );
        $o_ALM_TransaccionCabeceraBN->setIdNumeroDocumento( $NumeroDocumento );
        $o_ALM_TransaccionCabeceraBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_ALM_TransaccionCabeceraBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );

        //VALIDACION SOBRE LA SERIE_FISCAL Y NUMERO FISCAL
        $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( str_pad( strtoupper( $o_ALM_TransaccionCabeceraBN->getSerieDocumentoFiscal() ), 4, "0", STR_PAD_LEFT ) );
        $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( str_pad( $o_ALM_TransaccionCabeceraBN->getNumeroDocumentoFiscal(), 8, "0", STR_PAD_LEFT ) );
        
        $a_ALM_TransaccionDetalle = $o_ALM_TransaccionCabeceraBN->getArrayMovientoDetalle();
        if( count( $a_ALM_TransaccionDetalle ) < 1 )
        {
            throw new Exception( "No tiene detalles para realizar la transaccion." );
        }
        //VALIDACIONES SOBRE LOS DETALLES, COMO EL COSTO, TAMBIEN VALIDACIONES POR LOTE REPETIDO CON EL MISMO ITEMS
        $b_ControSerie = false;
        $a_LstValicacion = array();
        foreach ( $a_ALM_TransaccionDetalle as $o_ALM_TransaccionDetalleBN )
        {
            $o_ALM_ItemMastBN = $o_ALM_TransaccionDetalleBN->getObjectItem();

            $f_CantidadConversion = $o_ALM_ItemMastBN->getCantidadUnidad(); //es la cantidad de conversion por la unidad de medida
            $i_ItemIdUnidadVenta  = $o_ALM_ItemMastBN->getUnidadVenta();
            $i_IdUnidadSelecion   = $o_ALM_TransaccionDetalleBN->getUnidadCodigo();
            $b_ControlConversion  = false;

            if( $i_ItemIdUnidadVenta != $i_IdUnidadSelecion )
            {
                $b_ControlConversion  = true;
            }
            if( !$o_ALM_TransaccionDetalleBN->getLote() )
            {
                $o_ALM_TransaccionDetalleBN->setLote( "000" );
            }
            //item - lote -> debe de haber solo uno
            if( !isset( $a_LstValicacion[$o_ALM_TransaccionDetalleBN->getIdItem()."-".$o_ALM_TransaccionDetalleBN->getLote()] ) )
            {
                $a_LstValicacion[$o_ALM_TransaccionDetalleBN->getIdItem()."-".$o_ALM_TransaccionDetalleBN->getLote()] = "1";
            }
            else
            {
                throw new Exception( "El Item[{$o_ALM_TransaccionDetalleBN->getIdItem()}][{$o_ALM_ItemMastBN->getDescripcionCompleta()}] se encuentra duplicado con el Lote[{$o_ALM_TransaccionDetalleBN->getLote()}]" );
            }
            ////////////////////////////////////////
            
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //SE HACE VALIDACION EXTRAR, COMO SI DE TIPO DE ITEM QUE MANEJA TRANSACCIONES, ES INVENTARIABLE, MANEJA STOCK - 2020-10-07
            if( !$o_ALM_ItemMastBN->getObjectTipoItem()->getTransacciondelSistemaFlag() )
            {
                //AHORA SE PREGUNTA SI ESTA ACTIVADO EL FLAG DE
                if( $o_ALM_ItemMastBN->getEsInventariableFlag() != "N" )
                {
                    throw new Exception( "El Producto [".$o_ALM_ItemMastBN->getIdItem()."] tiene activado el Flag Inventariable, siendo de tipo Servicio." );
                }
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /// PREGUNTA SI UNO DE LOS PRODUCTOS MANEJA SERIE
            if( $o_ALM_ItemMastBN->SiManejaSerie() )
            {
                $b_ControSerie = true;
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //se asigna el valor de operacion en condicion
            $o_ALM_TransaccionDetalleBN->setIdCondicion( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() );
            
            //se agrega fecha de documento como referencia 2020-08-16, 2020-08-17
            $o_ALM_TransaccionDetalleBN->setIdTransaccionCab( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
            $o_ALM_TransaccionDetalleBN->setFechaDocumentoCab( $o_ALM_TransaccionCabeceraBN->getFechaDocumento() );
            $o_ALM_TransaccionDetalleBN->setIdMoneda( $o_ALM_TransaccionCabeceraBN->getMonedaCod() );
            $o_ALM_TransaccionDetalleBN->setTipoCambioRef( $o_ALM_TransaccionCabeceraBN->getTipodeCambio() );
            $o_ALM_TransaccionDetalleBN->setMonedaCodRef( $o_ALM_TransaccionCabeceraBN->getMonedaCod() );
            $o_ALM_TransaccionDetalleBN->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
            $o_ALM_TransaccionDetalleBN->setIdNumeroDocumento( $NumeroDocumento );
            $o_ALM_TransaccionDetalleBN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
            $o_ALM_TransaccionDetalleBN->setIdAlmacenDestino( $o_ALM_TransaccionCabeceraBN->getAlmacenTraslado() );
            $o_ALM_TransaccionDetalleBN->setIdTransaccionOperacion( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() );
            $o_ALM_TransaccionDetalleBN->setIdTipoDocumento( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
            //se realiza el cambio para realizar el historia de movimientos de stock por item - 2020-07-01
            $o_ALM_TransaccionDetalleBN->setReferenciaCompaniaSocio( $o_ALM_TransaccionCabeceraBN->getCodDocumentoFiscal().$o_ALM_TransaccionCabeceraBN->getSerieDocumentoFiscal()."-".$o_ALM_TransaccionCabeceraBN->getNumeroDocumentoFiscal() );
            $o_ALM_TransaccionDetalleBN->setIdSucursal( $o_ALM_TransaccionCabeceraBN->getIdSucursal() );
            if( !$o_ALM_TransaccionDetalleBN->getLote() )
            {
                $o_ALM_TransaccionDetalleBN->setLote( ALM_TransaccionDetalleBN::LOTE_POR_DEFECTO );
                $o_ALM_TransaccionDetalleBN->setFechaVencimientoLote( date( "Y-m-d" ) );
                $o_ALM_TransaccionDetalleBN->setFechaVencimiento( date( "Y-m-d" ) );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se tiene que buscar el costo sin igv - si no esta seteado
            if( !$o_ALM_TransaccionDetalleBN->getPrecioUnitario() )
            {
                $f_PrecioUnitario       = 0;
                $f_PrecioUnitarioIncIGV = 0;
                if( $o_ALM_TransaccionDetalleBN->getObjectItem()->SiEsInventariable() )
                {
                    $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPorCostoGeneral( $o_ALM_TransaccionDetalleBN->getIdItem(), 1 );
                    if( !$o_MST_ListaPrecioDetalleBN )
                    {
                        //throw new Exception( "El Producto[".$o_ALM_TransaccionDetalleBN->getIdItem()."] no tiene Costo asignado." );
                        $o_MST_ListaPrecioDetalleBN = new MST_ListaPrecioDetalleBN();
                    }
                    $f_PrecioUnitario       = $o_MST_ListaPrecioDetalleBN->getPrecioCosto(); //costo asignado en el listado de precios
                    $f_PrecioUnitarioIncIGV = $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV();
                }

                $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_PrecioUnitario );
                $o_ALM_TransaccionDetalleBN->setMontoTotal( $f_PrecioUnitarioIncIGV ); //POR AHORA EL MONTO TOTAL, SE REFIERE AL COSTO INCLUIDO IGV
            }
            else
            {
                if( $o_ALM_TransaccionDetalleBN->getIdCondicion() == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
                {
                    $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPorCostoGeneral( $o_ALM_TransaccionDetalleBN->getIdItem(), 1 );

                    $f_PrecioUnitario       = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                    $f_PrecioUnitarioIncIGV = $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV();

                    $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_PrecioUnitario );
                    $o_ALM_TransaccionDetalleBN->setMontoTotal( $f_PrecioUnitarioIncIGV );
                }
            }
            if( !$o_ALM_TransaccionDetalleBN->getMontoTotal() )
            {
                if( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() )
                {
                    $o_ALM_TransaccionDetalleBN->setMontoTotal( round( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() * 1.18, 2 ) );
                }
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        }

        if( $o_ALM_ItemMastBN->getObjectTipoItem()->getTransacciondelSistemaFlag() )
        {
            if( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() <= 0 || is_null( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() ) )
            {
                if( myUser::getUser()->getObjectCompania()->esAfectoIGV() )
                {
                    //throw new Exception( "El Producto[{$o_ALM_TransaccionDetalleBN->getIdItem()}][{$o_ALM_TransaccionDetalleBN->getPrecioUnitario()}] no tiene costo para realizar la transaccion." );
                    //SE COMENTA CREO Q TEMPORALMENTE - 2024-03-19
                }
            }
        }

        $o_ALM_TransaccionCabeceraBN->setControlEstadoSerie( ALM_TransaccionCabeceraBN::CTRL_ESTADO_SERIE_NOEXISTE );
        if( $b_ControSerie )
        {
            $o_ALM_TransaccionCabeceraBN->setControlEstadoSerie( ALM_TransaccionCabeceraBN::CTRL_ESTADO_SERIE_PENDIENTE );
        }

        return true;
    }
    
    private function valoresxDefectoKardex( ALM_TransaccionCabeceraBN $o_ALM_TransaccionCabeceraBN )
    {
        $a_ALM_TransaccionDetalle = $o_ALM_TransaccionCabeceraBN->getArrayMovientoDetalle();
        
        $s_Periodo  = UtilDate::getFormatDate( $o_ALM_TransaccionCabeceraBN->getFechaDocumento(), "Ym" );
        //$s_HoraMinS = UtilDate::getFormatDate( date( "Y-m-d H:i:s" ), "H:i:s" );
        $s_FechaDoc = UtilDate::getFormatDate( $o_ALM_TransaccionCabeceraBN->getFechaDocumento(), "Y-m-d" )." ".UtilDate::getFormatDate( date( "Y-m-d H:i:s" ), "H:i:s" );
        //$s_FechaDoc = $o_ALM_TransaccionCabeceraBN->getFechaDocumento();

        //VALORES PARA EL KARDEX | SALIDA AUTOMATICO POR LOTE
        $a_ALM_Kardex = array();
        if( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() != ALM_TransaccionCabeceraBN::TIPO_TRANSFERENCIA )
        {
            $a_TMP_ALM_TransaccionDetalle = array();
            //if( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() == ALM_TransaccionCabeceraBN::TIPO_SALIDA && $o_ALM_TransaccionCabeceraBN->getIdTransaccion() == VTA_DocumentoBN::TRANSACCION_X_DEFECTO )
            if( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
            {
                //AHORA SE AGREGA UN PROCEDIMIENTO ESPECIAL PARA EL PROCESO DE LOTE
                foreach( $a_ALM_TransaccionDetalle as $o_ALM_TransaccionDetalleBN )
                {
                    if( !$o_ALM_TransaccionDetalleBN->getObjectItem()->SiEsInventariable() ){ continue; }
                    
                    $f_CantidadPedida = $o_ALM_TransaccionDetalleBN->getCantidad();

                    $a_ALM_ItemAlmacenStock = ALM_ItemAlmacenStockFN::recuperarLotes( $o_ALM_TransaccionDetalleBN->getIdCompania(), $o_ALM_TransaccionDetalleBN->getIdAlmacen(), $o_ALM_TransaccionDetalleBN->getIdItem() );
                    if( !$a_ALM_ItemAlmacenStock )
                    {
                        throw new Exception( "El Producto[{$o_ALM_TransaccionDetalleBN->getIdItem()}] no tiene Stock suificiente para realizar la transaccion." );
                    }
                    if( $a_ALM_ItemAlmacenStock )
                    {
                        foreach ( $a_ALM_ItemAlmacenStock as $i_Key => $o_ALM_ItemAlmacenStockBN )
                        {
                            $f_StockFisico = $o_ALM_ItemAlmacenStockBN->getStockFisico();
                            //pr( "if( $f_CantidadPedida > $f_StockFisico )" );
                            if( $f_CantidadPedida > $f_StockFisico )
                            {
                                //AQUI SE TIENE QUE ASOCIAR VARIOS LOTES, POR Q EL STOCK PEDIDO EN LA ORDEN NO ES SUFICIENTE PARA EL LOTE MAS PROXIMO A VENCER

                                $o_TMP_ALM_TransaccionDetalleBN = clone $o_ALM_TransaccionDetalleBN;
                                $o_TMP_ALM_TransaccionDetalleBN->setCantidad( $f_StockFisico );
                                $o_TMP_ALM_TransaccionDetalleBN->setLote( $o_ALM_ItemAlmacenStockBN->getIdLote() );
                                $o_TMP_ALM_TransaccionDetalleBN->setFechaVencimiento( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento() );

                                $a_TMP_ALM_TransaccionDetalle[] = $o_TMP_ALM_TransaccionDetalleBN;

                                $f_CantidadPedida = $f_CantidadPedida - $f_StockFisico;

                                continue;
                            }
                            else
                            {
                                $o_ALM_TransaccionDetalleBN->setCantidad( $f_CantidadPedida );
                                $o_ALM_TransaccionDetalleBN->setLote( $o_ALM_ItemAlmacenStockBN->getIdLote() );
                                $o_ALM_TransaccionDetalleBN->setFechaVencimiento( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento() );
                                $a_TMP_ALM_TransaccionDetalle[] = $o_ALM_TransaccionDetalleBN;
                                break;
                            }
                        }
                    }
                }

            }
            else
            {
                $a_TMP_ALM_TransaccionDetalle = $a_ALM_TransaccionDetalle;
            }

            //pr( $a_TMP_ALM_TransaccionDetalle ); exit;

            foreach ( $a_TMP_ALM_TransaccionDetalle as $o_ALM_TransaccionDetalleBN )
            {
                if( !$o_ALM_TransaccionDetalleBN->getObjectItem()->SiEsInventariable() ){ continue; }
                
                $o_ALM_TransaccionDetalleTmpBN = clone $o_ALM_TransaccionDetalleBN;
                
                $o_ALM_KardexBN = new ALM_KardexBN();
                $o_ALM_KardexBN->setIdCompania( $o_ALM_TransaccionDetalleBN->getIdCompania() );
                $o_ALM_KardexBN->setIdSucursal( $o_ALM_TransaccionDetalleBN->getIdSucursal() );
                $o_ALM_KardexBN->setIdAlmacen( $o_ALM_TransaccionDetalleBN->getIdAlmacen() );
                $o_ALM_KardexBN->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
                //$o_ALM_KardexBN->setIdCondicion( $o_ALM_TransaccionDetalleBN->getIdCondicion() );
                $o_ALM_KardexBN->setIdCondicion( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() );
                $o_ALM_KardexBN->setIdLote( $o_ALM_TransaccionDetalleBN->getLote() );
                $o_ALM_KardexBN->setIdFecha( $s_FechaDoc );
                $o_ALM_KardexBN->setIdTransaccion( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
                $o_ALM_KardexBN->setReferenciaNumeroInterno( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroInterno() );
                $o_ALM_KardexBN->setReferenciaCompaniaSocio( $o_ALM_TransaccionDetalleBN->getReferenciaCompaniaSocio() );
                $o_ALM_KardexBN->setReferenciaTipoDocumento( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
                $o_ALM_KardexBN->setReferenciaNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                $o_ALM_KardexBN->setReferenciaSecuencia( $o_ALM_TransaccionDetalleBN->getIdSecuencia()."" );
                $o_ALM_KardexBN->setIdUnidadMedida( $o_ALM_TransaccionDetalleBN->getUnidadCodigo() );
                $o_ALM_KardexBN->setCantidad( $o_ALM_TransaccionDetalleBN->getCantidad() );
                $o_ALM_KardexBN->setPrecioUnitario( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() );
                $o_ALM_KardexBN->setMontoTotal( $o_ALM_TransaccionDetalleBN->getMontoTotal() );
                $o_ALM_KardexBN->setPeriodo( $s_Periodo );
                $o_ALM_KardexBN->setCodigoCliente( $o_ALM_TransaccionCabeceraBN->getCodigoCliente() );
                $o_ALM_KardexBN->setCodigoProveedor( $o_ALM_TransaccionCabeceraBN->getCodigoProveedor() );
                $o_ALM_KardexBN->setTipoDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getTipoDocumentoFiscal() );
                $o_ALM_KardexBN->setCodDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getCodDocumentoFiscal() );
                $o_ALM_KardexBN->setSerieDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getSerieDocumentoFiscal() );
                $o_ALM_KardexBN->setNumeroDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getNumeroDocumentoFiscal() );
                $o_ALM_KardexBN->setFechaDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getFechaDocumentoFiscal() );
                $o_ALM_KardexBN->setReferenciaTipoDocumento2( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
                $o_ALM_KardexBN->setReferenciaNumeroDocumento2( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
                $o_ALM_KardexBN->setReferenciaSecuencia2( ( string ) $o_ALM_TransaccionDetalleBN->getReferenciaSecuencia() );
                $o_ALM_KardexBN->setObjetoDetalleTransaccion( $o_ALM_TransaccionDetalleTmpBN );
                $a_ALM_Kardex[] = $o_ALM_KardexBN;
            }
        }
        if( $o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() == ALM_TransaccionCabeceraBN::TIPO_TRANSFERENCIA )
        {
            //SE PREPARA PARA REALIZAR LA SALIDA
            foreach ( $a_ALM_TransaccionDetalle as $o_ALM_TransaccionDetalleBN )
            {
                if( !$o_ALM_TransaccionDetalleBN->getObjectItem()->SiEsInventariable() ){ continue; }

                $o_ALM_TransaccionDetalleTmpSalBN = clone $o_ALM_TransaccionDetalleBN;
                $o_ALM_TransaccionDetalleTmpSalBN->setIdTransaccionOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                $o_ALM_TransaccionDetalleTmpSalBN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
                
                $o_ALM_KardexBN = new ALM_KardexBN();
                $o_ALM_KardexBN->setIdCompania( $o_ALM_TransaccionDetalleTmpSalBN->getObjectAlmacen()->getIdCompania() ); //la compania del almacen de salida
                $o_ALM_KardexBN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() ); //almacen de salida
                $o_ALM_KardexBN->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
                $o_ALM_KardexBN->setIdCondicion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                $o_ALM_KardexBN->setIdLote( $o_ALM_TransaccionDetalleBN->getLote() );
                $o_ALM_KardexBN->setIdFecha( $s_FechaDoc );
                $o_ALM_KardexBN->setIdTransaccion( ALM_TransferenciaCabeceraBN::TIPO_TRANSACCION_SALIDA );
                $o_ALM_KardexBN->setReferenciaNumeroInterno( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroInterno() );
                $o_ALM_KardexBN->setReferenciaCompaniaSocio( $o_ALM_TransaccionDetalleBN->getReferenciaCompaniaSocio() );
                $o_ALM_KardexBN->setReferenciaTipoDocumento( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
                $o_ALM_KardexBN->setReferenciaNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                $o_ALM_KardexBN->setReferenciaSecuencia( $o_ALM_TransaccionDetalleBN->getIdSecuencia()."" );
                $o_ALM_KardexBN->setIdUnidadMedida( $o_ALM_TransaccionDetalleBN->getUnidadCodigo() );
                $o_ALM_KardexBN->setCantidad( $o_ALM_TransaccionDetalleBN->getCantidad() );
                $o_ALM_KardexBN->setPrecioUnitario( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() );
                $o_ALM_KardexBN->setMontoTotal( $o_ALM_TransaccionDetalleBN->getMontoTotal() );
                $o_ALM_KardexBN->setPeriodo( $s_Periodo );
                $o_ALM_KardexBN->setCodigoCliente( $o_ALM_TransaccionCabeceraBN->getCodigoCliente() );
                $o_ALM_KardexBN->setCodigoProveedor( $o_ALM_TransaccionCabeceraBN->getCodigoProveedor() );
                $o_ALM_KardexBN->setTipoDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getTipoDocumentoFiscal() );
                $o_ALM_KardexBN->setCodDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getCodDocumentoFiscal() );
                $o_ALM_KardexBN->setSerieDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getSerieDocumentoFiscal() );
                $o_ALM_KardexBN->setNumeroDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getNumeroDocumentoFiscal() );
                $o_ALM_KardexBN->setFechaDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getFechaDocumentoFiscal() );
                $o_ALM_KardexBN->setReferenciaTipoDocumento2( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
                $o_ALM_KardexBN->setReferenciaNumeroDocumento2( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
                $o_ALM_KardexBN->setReferenciaSecuencia2( ( string ) $o_ALM_TransaccionDetalleBN->getReferenciaSecuencia() );
                $o_ALM_KardexBN->setObjetoDetalleTransaccion( $o_ALM_TransaccionDetalleTmpSalBN );
                $a_ALM_Kardex[] = $o_ALM_KardexBN;
            }
            //SE PREPARA PARA REALIZAR LA INGRESO
            //sleep( 1 );
            $s_FechaDoc = UtilDate::getFormatDate( $o_ALM_TransaccionCabeceraBN->getFechaDocumento(), "Y-m-d" )." ".UtilDate::getFormatDate( date( "Y-m-d H:i:s" ), "H:i:s" );
            //$s_FechaDoc = $o_ALM_TransaccionCabeceraBN->getFechaDocumento();
            foreach ( $a_ALM_TransaccionDetalle as $o_ALM_TransaccionDetalleBN )
            {
                if( !$o_ALM_TransaccionDetalleBN->getObjectItem()->SiEsInventariable() ){ continue; }

                $o_ALM_TransaccionDetalleTmpIngBN = clone $o_ALM_TransaccionDetalleBN;
                $o_ALM_TransaccionDetalleTmpIngBN->setIdTransaccionOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                $o_ALM_TransaccionDetalleTmpIngBN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getAlmacenTraslado() );
                
                $o_ALM_KardexBN = new ALM_KardexBN();
                $o_ALM_KardexBN->setIdCompania( $o_ALM_TransaccionDetalleTmpIngBN->getObjectAlmacen()->getIdCompania() );
                $o_ALM_KardexBN->setIdAlmacen( $o_ALM_TransaccionCabeceraBN->getAlmacenTraslado() ); //almacen de salida
                $o_ALM_KardexBN->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
                $o_ALM_KardexBN->setIdCondicion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                $o_ALM_KardexBN->setIdLote( $o_ALM_TransaccionDetalleBN->getLote() );
                $o_ALM_KardexBN->setIdFecha( $s_FechaDoc );
                $o_ALM_KardexBN->setIdTransaccion( ALM_TransferenciaCabeceraBN::TIPO_TRANSACCION_INGRESO );
                $o_ALM_KardexBN->setReferenciaNumeroInterno( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroInterno() );
                $o_ALM_KardexBN->setReferenciaCompaniaSocio( $o_ALM_TransaccionDetalleBN->getReferenciaCompaniaSocio() );
                $o_ALM_KardexBN->setReferenciaTipoDocumento( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
                $o_ALM_KardexBN->setReferenciaNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                $o_ALM_KardexBN->setReferenciaSecuencia( $o_ALM_TransaccionDetalleBN->getIdSecuencia()."" );
                $o_ALM_KardexBN->setIdUnidadMedida( $o_ALM_TransaccionDetalleBN->getUnidadCodigo() );
                $o_ALM_KardexBN->setCantidad( $o_ALM_TransaccionDetalleBN->getCantidad() );
                $o_ALM_KardexBN->setPrecioUnitario( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() );
                $o_ALM_KardexBN->setMontoTotal( $o_ALM_TransaccionDetalleBN->getMontoTotal() );
                $o_ALM_KardexBN->setPeriodo( $s_Periodo );
                $o_ALM_KardexBN->setCodigoCliente( $o_ALM_TransaccionCabeceraBN->getCodigoCliente() );
                $o_ALM_KardexBN->setCodigoProveedor( $o_ALM_TransaccionCabeceraBN->getCodigoProveedor() );
                $o_ALM_KardexBN->setTipoDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getTipoDocumentoFiscal() );
                $o_ALM_KardexBN->setCodDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getCodDocumentoFiscal() );
                $o_ALM_KardexBN->setSerieDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getSerieDocumentoFiscal() );
                $o_ALM_KardexBN->setNumeroDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getNumeroDocumentoFiscal() );
                $o_ALM_KardexBN->setFechaDocumentoFiscal( $o_ALM_TransaccionCabeceraBN->getFechaDocumentoFiscal() );
                $o_ALM_KardexBN->setReferenciaTipoDocumento2( $o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
                $o_ALM_KardexBN->setReferenciaNumeroDocumento2( $o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
                $o_ALM_KardexBN->setReferenciaSecuencia2( ( string ) $o_ALM_TransaccionDetalleBN->getReferenciaSecuencia() );
                $o_ALM_KardexBN->setObjetoDetalleTransaccion( $o_ALM_TransaccionDetalleTmpIngBN );
                $a_ALM_Kardex[] = $o_ALM_KardexBN;
            }
        }

        $o_ALM_TransaccionCabeceraBN->setArrayMovientoKardex( $a_ALM_Kardex );
        return true;
    }
}