<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_TipoDocumentoMotivo.xml */
/* Generado: 2022-08-20 01:42:00 */

/* Busqueda de registros de la tabla VTA_TipoDocumentoMotivo. */
abstract class BaseVTA_TipoDocumentoMotivoFN extends VTA_TipoDocumentoMotivoBN
{
    /* Declaracion de constantes */
    const IdTipoDocumentoMotivo = "VTA_TipoDocumentoMotivo.IdTipoDocumentoMotivo";
    const IdTipoDocumento = "VTA_TipoDocumentoMotivo.IdTipoDocumento";
    const Descripcion = "VTA_TipoDocumentoMotivo.Descripcion";
    const CodigoFiscal = "VTA_TipoDocumentoMotivo.CodigoFiscal";
    const CodigoFiscalPr = "VTA_TipoDocumentoMotivo.CodigoFiscalPr";
    const Estado = "VTA_TipoDocumentoMotivo.Estado";
    const UsuarioCreacion = "VTA_TipoDocumentoMotivo.UsuarioCreacion";
    const FechaCreacion = "VTA_TipoDocumentoMotivo.FechaCreacion";
    const UsuarioModificacion = "VTA_TipoDocumentoMotivo.UsuarioModificacion";
    const FechaModificacion = "VTA_TipoDocumentoMotivo.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_TipoDocumentoMotivo.IdTipoDocumentoMotivo AS IdTipoDocumentoMotivo, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.CodigoFiscal AS CodigoFiscal, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.CodigoFiscalPr AS CodigoFiscalPr, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.Estado AS Estado, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "VTA_TipoDocumentoMotivo.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_TipoDocumentoMotivoBN */
    public function setByBN( VTA_TipoDocumentoMotivoBN $o_VTA_TipoDocumentoMotivoBN )
    {
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getIdTipoDocumentoMotivo() ) )
        {
            $this->setIdTipoDocumentoMotivo( $o_VTA_TipoDocumentoMotivoBN->getIdTipoDocumentoMotivo() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_VTA_TipoDocumentoMotivoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_VTA_TipoDocumentoMotivoBN->getDescripcion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getCodigoFiscal() ) )
        {
            $this->setCodigoFiscal( $o_VTA_TipoDocumentoMotivoBN->getCodigoFiscal() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getCodigoFiscalPr() ) )
        {
            $this->setCodigoFiscalPr( $o_VTA_TipoDocumentoMotivoBN->getCodigoFiscalPr() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_TipoDocumentoMotivoBN->getEstado() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_TipoDocumentoMotivoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_TipoDocumentoMotivoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_TipoDocumentoMotivoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_VTA_TipoDocumentoMotivoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_TipoDocumentoMotivoBN->getFechaModificacion() );
        }
    }

    /**
    * @return VTA_TipoDocumentoMotivoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTipoDocumentoMotivo )
    {
        if( is_null( $i_IdTipoDocumentoMotivo ) ){ $i_IdTipoDocumentoMotivo = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_TipoDocumentoMotivo ";
        $s_SQLQuery .= "WHERE IdTipoDocumentoMotivo = ".$i_IdTipoDocumentoMotivo." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_TipoDocumentoMotivoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_TipoDocumentoMotivoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_TipoDocumentoMotivoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipoDocumentoMotivo() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.IdTipoDocumentoMotivo = ".$this->getIdTipoDocumentoMotivo()." AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCodigoFiscal() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.CodigoFiscal = '".$this->getCodigoFiscal()."' AND ";
        if ( !is_null( $this->getCodigoFiscalPr() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.CodigoFiscalPr = ".$this->getCodigoFiscalPr()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_TipoDocumentoMotivo.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_TipoDocumentoMotivo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_TipoDocumentoMotivoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_TipoDocumentoMotivo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_TipoDocumentoMotivoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_TipoDocumentoMotivoBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_TipoDocumentoMotivoBN[] = $o_VTA_TipoDocumentoMotivoBN;
            }
        }
        return $a_VTA_TipoDocumentoMotivoBN;
    }

    /* Devuelve un objeto VTA_TipoDocumentoMotivoBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_TipoDocumentoMotivo )
    {
        $o_VTA_TipoDocumentoMotivoBN = new VTA_TipoDocumentoMotivoBN();
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['IdTipoDocumentoMotivo'] ) ) $o_VTA_TipoDocumentoMotivoBN->setIdTipoDocumentoMotivo( ( integer ) $a_VTA_TipoDocumentoMotivo['IdTipoDocumentoMotivo'] );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['IdTipoDocumento'] ) ) $o_VTA_TipoDocumentoMotivoBN->setIdTipoDocumento( $a_VTA_TipoDocumentoMotivo['IdTipoDocumento'] );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['Descripcion'] ) ) $o_VTA_TipoDocumentoMotivoBN->setDescripcion( $a_VTA_TipoDocumentoMotivo['Descripcion'] );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['CodigoFiscal'] ) ) $o_VTA_TipoDocumentoMotivoBN->setCodigoFiscal( $a_VTA_TipoDocumentoMotivo['CodigoFiscal'] );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['CodigoFiscalPr'] ) ) $o_VTA_TipoDocumentoMotivoBN->setCodigoFiscalPr( ( integer ) $a_VTA_TipoDocumentoMotivo['CodigoFiscalPr'] );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['Estado'] ) ) $o_VTA_TipoDocumentoMotivoBN->setEstado( $a_VTA_TipoDocumentoMotivo['Estado'] );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['UsuarioCreacion'] ) ) $o_VTA_TipoDocumentoMotivoBN->setUsuarioCreacion( $a_VTA_TipoDocumentoMotivo['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['FechaCreacion'] ) ) $o_VTA_TipoDocumentoMotivoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_TipoDocumentoMotivo['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['UsuarioModificacion'] ) ) $o_VTA_TipoDocumentoMotivoBN->setUsuarioModificacion( $a_VTA_TipoDocumentoMotivo['UsuarioModificacion'] );
        if ( !is_null( $a_VTA_TipoDocumentoMotivo['FechaModificacion'] ) ) $o_VTA_TipoDocumentoMotivoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_TipoDocumentoMotivo['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_TipoDocumentoMotivoBN;
    }
}
?>