<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenTipo.xml */
/* Generado: 2022-04-18 21:15:08 */

/* Busqueda de registros de la tabla VTA_OrdenTipo. */
abstract class BaseVTA_OrdenTipoFN extends VTA_OrdenTipoBN
{
    /* Declaracion de constantes */
    const OrdenTipoId = "VTA_OrdenTipo.OrdenTipoId";
    const OrdenTipoCod = "VTA_OrdenTipo.OrdenTipoCod";
    const OrdenTipoDescripcion = "VTA_OrdenTipo.OrdenTipoDescripcion";
    const OrdenTipoPrefijo = "VTA_OrdenTipo.OrdenTipoPrefijo";
    const DocRefTipo = "VTA_OrdenTipo.DocRefTipo";
    const OrdenTipoPublico = "VTA_OrdenTipo.OrdenTipoPublico";
    const OrdenTipoEstado = "VTA_OrdenTipo.OrdenTipoEstado";
    const OrdenCreacion = "VTA_OrdenTipo.OrdenCreacion";
    const FechaCreacion = "VTA_OrdenTipo.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_OrdenTipo.OrdenTipoId AS OrdenTipoId, ";
        $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoCod AS OrdenTipoCod, ";
        $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoDescripcion AS OrdenTipoDescripcion, ";
        $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoPrefijo AS OrdenTipoPrefijo, ";
        $s_SQLQuery .= "VTA_OrdenTipo.DocRefTipo AS DocRefTipo, ";
        $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoPublico AS OrdenTipoPublico, ";
        $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoEstado AS OrdenTipoEstado, ";
        $s_SQLQuery .= "VTA_OrdenTipo.OrdenCreacion AS OrdenCreacion, ";
        $s_SQLQuery .= "VTA_OrdenTipo.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_OrdenTipoBN */
    public function setByBN( VTA_OrdenTipoBN $o_VTA_OrdenTipoBN )
    {
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoId() ) )
        {
            $this->setOrdenTipoId( $o_VTA_OrdenTipoBN->getOrdenTipoId() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoCod() ) )
        {
            $this->setOrdenTipoCod( $o_VTA_OrdenTipoBN->getOrdenTipoCod() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoDescripcion() ) )
        {
            $this->setOrdenTipoDescripcion( $o_VTA_OrdenTipoBN->getOrdenTipoDescripcion() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoPrefijo() ) )
        {
            $this->setOrdenTipoPrefijo( $o_VTA_OrdenTipoBN->getOrdenTipoPrefijo() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getDocRefTipo() ) )
        {
            $this->setDocRefTipo( $o_VTA_OrdenTipoBN->getDocRefTipo() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoPublico() ) )
        {
            $this->setOrdenTipoPublico( $o_VTA_OrdenTipoBN->getOrdenTipoPublico() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenTipoEstado() ) )
        {
            $this->setOrdenTipoEstado( $o_VTA_OrdenTipoBN->getOrdenTipoEstado() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getOrdenCreacion() ) )
        {
            $this->setOrdenCreacion( $o_VTA_OrdenTipoBN->getOrdenCreacion() );
        }
        if ( !is_null( $o_VTA_OrdenTipoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_OrdenTipoBN->getFechaCreacion() );
        }
    }

    /**
    * @return VTA_OrdenTipoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_OrdenTipoId )
    {
        if( is_null( $i_OrdenTipoId ) ){ $i_OrdenTipoId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_OrdenTipo ";
        $s_SQLQuery .= "WHERE OrdenTipoId = ".$i_OrdenTipoId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_OrdenTipoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_OrdenTipoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_OrdenTipoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getOrdenTipoId() ) ) $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoId = ".$this->getOrdenTipoId()." AND ";
        if ( !is_null( $this->getOrdenTipoCod() ) ) $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoCod = '".$this->getOrdenTipoCod()."' AND ";
        if ( !is_null( $this->getOrdenTipoDescripcion() ) ) $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoDescripcion = '".$this->getOrdenTipoDescripcion()."' AND ";
        if ( !is_null( $this->getOrdenTipoPrefijo() ) ) $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoPrefijo = '".$this->getOrdenTipoPrefijo()."' AND ";
        if ( !is_null( $this->getDocRefTipo() ) ) $s_SQLQuery .= "VTA_OrdenTipo.DocRefTipo = '".$this->getDocRefTipo()."' AND ";
        if ( !is_null( $this->getOrdenTipoPublico() ) ) $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoPublico = '".$this->getOrdenTipoPublico()."' AND ";
        if ( !is_null( $this->getOrdenTipoEstado() ) ) $s_SQLQuery .= "VTA_OrdenTipo.OrdenTipoEstado = '".$this->getOrdenTipoEstado()."' AND ";
        if ( !is_null( $this->getOrdenCreacion() ) ) $s_SQLQuery .= "VTA_OrdenTipo.OrdenCreacion = '".$this->getOrdenCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_OrdenTipo.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_OrdenTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_OrdenTipoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_OrdenTipo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_OrdenTipoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_OrdenTipoBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_OrdenTipoBN[] = $o_VTA_OrdenTipoBN;
            }
        }
        return $a_VTA_OrdenTipoBN;
    }

    /* Devuelve un objeto VTA_OrdenTipoBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_OrdenTipo )
    {
        $o_VTA_OrdenTipoBN = new VTA_OrdenTipoBN();
        if ( !is_null( $a_VTA_OrdenTipo['OrdenTipoId'] ) ) $o_VTA_OrdenTipoBN->setOrdenTipoId( ( integer ) $a_VTA_OrdenTipo['OrdenTipoId'] );
        if ( !is_null( $a_VTA_OrdenTipo['OrdenTipoCod'] ) ) $o_VTA_OrdenTipoBN->setOrdenTipoCod( $a_VTA_OrdenTipo['OrdenTipoCod'] );
        if ( !is_null( $a_VTA_OrdenTipo['OrdenTipoDescripcion'] ) ) $o_VTA_OrdenTipoBN->setOrdenTipoDescripcion( $a_VTA_OrdenTipo['OrdenTipoDescripcion'] );
        if ( !is_null( $a_VTA_OrdenTipo['OrdenTipoPrefijo'] ) ) $o_VTA_OrdenTipoBN->setOrdenTipoPrefijo( $a_VTA_OrdenTipo['OrdenTipoPrefijo'] );
        if ( !is_null( $a_VTA_OrdenTipo['DocRefTipo'] ) ) $o_VTA_OrdenTipoBN->setDocRefTipo( $a_VTA_OrdenTipo['DocRefTipo'] );
        if ( !is_null( $a_VTA_OrdenTipo['OrdenTipoPublico'] ) ) $o_VTA_OrdenTipoBN->setOrdenTipoPublico( $a_VTA_OrdenTipo['OrdenTipoPublico'] );
        if ( !is_null( $a_VTA_OrdenTipo['OrdenTipoEstado'] ) ) $o_VTA_OrdenTipoBN->setOrdenTipoEstado( $a_VTA_OrdenTipo['OrdenTipoEstado'] );
        if ( !is_null( $a_VTA_OrdenTipo['OrdenCreacion'] ) ) $o_VTA_OrdenTipoBN->setOrdenCreacion( $a_VTA_OrdenTipo['OrdenCreacion'] );
        if ( !is_null( $a_VTA_OrdenTipo['FechaCreacion'] ) ) $o_VTA_OrdenTipoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_OrdenTipo['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_OrdenTipoBN;
    }
}
?>