<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenTipoArchivo.xml */
/* Generado: 2022-04-18 21:15:08 */

/* Busqueda de registros de la tabla VTA_OrdenTipoArchivo. */
abstract class BaseVTA_OrdenTipoArchivoFN extends VTA_OrdenTipoArchivoBN
{
    /* Declaracion de constantes */
    const TipoId = "VTA_OrdenTipoArchivo.TipoId";
    const Descripcion = "VTA_OrdenTipoArchivo.Descripcion";
    const Secuencia = "VTA_OrdenTipoArchivo.Secuencia";
    const FlagValidacion = "VTA_OrdenTipoArchivo.FlagValidacion";
    const Estado = "VTA_OrdenTipoArchivo.Estado";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_OrdenTipoArchivo.TipoId AS TipoId, ";
        $s_SQLQuery .= "VTA_OrdenTipoArchivo.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "VTA_OrdenTipoArchivo.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "VTA_OrdenTipoArchivo.FlagValidacion AS FlagValidacion, ";
        $s_SQLQuery .= "VTA_OrdenTipoArchivo.Estado AS Estado ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_OrdenTipoArchivoBN */
    public function setByBN( VTA_OrdenTipoArchivoBN $o_VTA_OrdenTipoArchivoBN )
    {
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getTipoId() ) )
        {
            $this->setTipoId( $o_VTA_OrdenTipoArchivoBN->getTipoId() );
        }
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_VTA_OrdenTipoArchivoBN->getDescripcion() );
        }
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_VTA_OrdenTipoArchivoBN->getSecuencia() );
        }
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getFlagValidacion() ) )
        {
            $this->setFlagValidacion( $o_VTA_OrdenTipoArchivoBN->getFlagValidacion() );
        }
        if ( !is_null( $o_VTA_OrdenTipoArchivoBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_OrdenTipoArchivoBN->getEstado() );
        }
    }

    /**
    * @return VTA_OrdenTipoArchivoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_TipoId )
    {
        if( is_null( $i_TipoId ) ){ $i_TipoId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_OrdenTipoArchivo ";
        $s_SQLQuery .= "WHERE TipoId = ".$i_TipoId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_OrdenTipoArchivoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_OrdenTipoArchivoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_OrdenTipoArchivoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getTipoId() ) ) $s_SQLQuery .= "VTA_OrdenTipoArchivo.TipoId = ".$this->getTipoId()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "VTA_OrdenTipoArchivo.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "VTA_OrdenTipoArchivo.Secuencia = '".$this->getSecuencia()."' AND ";
        if ( !is_null( $this->getFlagValidacion() ) ) $s_SQLQuery .= "VTA_OrdenTipoArchivo.FlagValidacion = ".$this->getFlagValidacion()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VTA_OrdenTipoArchivo.Estado = '".$this->getEstado()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_OrdenTipoArchivo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_OrdenTipoArchivoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_OrdenTipoArchivo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_OrdenTipoArchivoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_OrdenTipoArchivoBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_OrdenTipoArchivoBN[] = $o_VTA_OrdenTipoArchivoBN;
            }
        }
        return $a_VTA_OrdenTipoArchivoBN;
    }

    /* Devuelve un objeto VTA_OrdenTipoArchivoBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_OrdenTipoArchivo )
    {
        $o_VTA_OrdenTipoArchivoBN = new VTA_OrdenTipoArchivoBN();
        if ( !is_null( $a_VTA_OrdenTipoArchivo['TipoId'] ) ) $o_VTA_OrdenTipoArchivoBN->setTipoId( ( integer ) $a_VTA_OrdenTipoArchivo['TipoId'] );
        if ( !is_null( $a_VTA_OrdenTipoArchivo['Descripcion'] ) ) $o_VTA_OrdenTipoArchivoBN->setDescripcion( $a_VTA_OrdenTipoArchivo['Descripcion'] );
        if ( !is_null( $a_VTA_OrdenTipoArchivo['Secuencia'] ) ) $o_VTA_OrdenTipoArchivoBN->setSecuencia( $a_VTA_OrdenTipoArchivo['Secuencia'] );
        if ( !is_null( $a_VTA_OrdenTipoArchivo['FlagValidacion'] ) ) $o_VTA_OrdenTipoArchivoBN->setFlagValidacion( ( integer ) $a_VTA_OrdenTipoArchivo['FlagValidacion'] );
        if ( !is_null( $a_VTA_OrdenTipoArchivo['Estado'] ) ) $o_VTA_OrdenTipoArchivoBN->setEstado( $a_VTA_OrdenTipoArchivo['Estado'] );
        return $o_VTA_OrdenTipoArchivoBN;
    }
}
?>