<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_FormaPago.xml */
/* Generado: 2022-04-18 21:15:07 */

/* Busqueda de registros de la tabla VTA_FormaPago. */
abstract class BaseVTA_FormaPagoFN extends VTA_FormaPagoBN
{
    /* Declaracion de constantes */
    const IdFormaPago = "VTA_FormaPago.IdFormaPago";
    const DescripcionLocal = "VTA_FormaPago.DescripcionLocal";
    const Codigo = "VTA_FormaPago.Codigo";
    const CodigoSunat = "VTA_FormaPago.CodigoSunat";
    const ContadoFlag = "VTA_FormaPago.ContadoFlag";
    const Dias = "VTA_FormaPago.Dias";
    const Estado = "VTA_FormaPago.Estado";
    const FechaCreacion = "VTA_FormaPago.FechaCreacion";
    const UsuarioCreacion = "VTA_FormaPago.UsuarioCreacion";
    const FechaModificacion = "VTA_FormaPago.FechaModificacion";
    const UsuarioModificacion = "VTA_FormaPago.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_FormaPago.IdFormaPago AS IdFormaPago, ";
        $s_SQLQuery .= "VTA_FormaPago.DescripcionLocal AS DescripcionLocal, ";
        $s_SQLQuery .= "VTA_FormaPago.Codigo AS Codigo, ";
        $s_SQLQuery .= "VTA_FormaPago.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "VTA_FormaPago.ContadoFlag AS ContadoFlag, ";
        $s_SQLQuery .= "VTA_FormaPago.Dias AS Dias, ";
        $s_SQLQuery .= "VTA_FormaPago.Estado AS Estado, ";
        $s_SQLQuery .= "VTA_FormaPago.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "VTA_FormaPago.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_FormaPago.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "VTA_FormaPago.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_FormaPagoBN */
    public function setByBN( VTA_FormaPagoBN $o_VTA_FormaPagoBN )
    {
        if ( !is_null( $o_VTA_FormaPagoBN->getIdFormaPago() ) )
        {
            $this->setIdFormaPago( $o_VTA_FormaPagoBN->getIdFormaPago() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_VTA_FormaPagoBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_VTA_FormaPagoBN->getCodigo() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_VTA_FormaPagoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getContadoFlag() ) )
        {
            $this->setContadoFlag( $o_VTA_FormaPagoBN->getContadoFlag() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getDias() ) )
        {
            $this->setDias( $o_VTA_FormaPagoBN->getDias() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_FormaPagoBN->getEstado() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_FormaPagoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_FormaPagoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_FormaPagoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_VTA_FormaPagoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_FormaPagoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return VTA_FormaPagoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdFormaPago )
    {
        if( is_null( $s_IdFormaPago ) ){ $s_IdFormaPago = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_FormaPago ";
        $s_SQLQuery .= "WHERE IdFormaPago = '".$s_IdFormaPago."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_FormaPagoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_FormaPagoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_FormaPagoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdFormaPago() ) ) $s_SQLQuery .= "VTA_FormaPago.IdFormaPago = '".$this->getIdFormaPago()."' AND ";
        if ( !is_null( $this->getDescripcionLocal() ) ) $s_SQLQuery .= "VTA_FormaPago.DescripcionLocal = '".$this->getDescripcionLocal()."' AND ";
        if ( !is_null( $this->getCodigo() ) ) $s_SQLQuery .= "VTA_FormaPago.Codigo = '".$this->getCodigo()."' AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "VTA_FormaPago.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getContadoFlag() ) ) $s_SQLQuery .= "VTA_FormaPago.ContadoFlag = '".$this->getContadoFlag()."' AND ";
        if ( !is_null( $this->getDias() ) ) $s_SQLQuery .= "VTA_FormaPago.Dias = ".$this->getDias()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VTA_FormaPago.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_FormaPago.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_FormaPago.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_FormaPago.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_FormaPago.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_FormaPago WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_FormaPagoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_FormaPago WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_FormaPagoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_FormaPagoBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_FormaPagoBN[] = $o_VTA_FormaPagoBN;
            }
        }
        return $a_VTA_FormaPagoBN;
    }

    /* Devuelve un objeto VTA_FormaPagoBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_FormaPago )
    {
        $o_VTA_FormaPagoBN = new VTA_FormaPagoBN();
        if ( !is_null( $a_VTA_FormaPago['IdFormaPago'] ) ) $o_VTA_FormaPagoBN->setIdFormaPago( $a_VTA_FormaPago['IdFormaPago'] );
        if ( !is_null( $a_VTA_FormaPago['DescripcionLocal'] ) ) $o_VTA_FormaPagoBN->setDescripcionLocal( $a_VTA_FormaPago['DescripcionLocal'] );
        if ( !is_null( $a_VTA_FormaPago['Codigo'] ) ) $o_VTA_FormaPagoBN->setCodigo( $a_VTA_FormaPago['Codigo'] );
        if ( !is_null( $a_VTA_FormaPago['CodigoSunat'] ) ) $o_VTA_FormaPagoBN->setCodigoSunat( $a_VTA_FormaPago['CodigoSunat'] );
        if ( !is_null( $a_VTA_FormaPago['ContadoFlag'] ) ) $o_VTA_FormaPagoBN->setContadoFlag( $a_VTA_FormaPago['ContadoFlag'] );
        if ( !is_null( $a_VTA_FormaPago['Dias'] ) ) $o_VTA_FormaPagoBN->setDias( ( integer ) $a_VTA_FormaPago['Dias'] );
        if ( !is_null( $a_VTA_FormaPago['Estado'] ) ) $o_VTA_FormaPagoBN->setEstado( $a_VTA_FormaPago['Estado'] );
        if ( !is_null( $a_VTA_FormaPago['FechaCreacion'] ) ) $o_VTA_FormaPagoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_FormaPago['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_FormaPago['UsuarioCreacion'] ) ) $o_VTA_FormaPagoBN->setUsuarioCreacion( $a_VTA_FormaPago['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_FormaPago['FechaModificacion'] ) ) $o_VTA_FormaPagoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_FormaPago['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_FormaPago['UsuarioModificacion'] ) ) $o_VTA_FormaPagoBN->setUsuarioModificacion( $a_VTA_FormaPago['UsuarioModificacion'] );
        return $o_VTA_FormaPagoBN;
    }
}
?>