<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_DocumentoDetalle.xml */
/* Generado: 2022-08-08 22:21:39 */

/* Busqueda de registros de la tabla VTA_DocumentoDetalle. */
abstract class BaseVTA_DocumentoDetalleFN extends VTA_DocumentoDetalleBN
{
    /* Declaracion de constantes */
    const IdTipoDocumento = "VTA_DocumentoDetalle.IdTipoDocumento";
    const IdCompania = "VTA_DocumentoDetalle.IdCompania";
    const NumeroDocumento = "VTA_DocumentoDetalle.NumeroDocumento";
    const Secuencia = "VTA_DocumentoDetalle.Secuencia";
    const TipoDetalle = "VTA_DocumentoDetalle.TipoDetalle";
    const ItemCodigo = "VTA_DocumentoDetalle.ItemCodigo";
    const Lote = "VTA_DocumentoDetalle.Lote";
    const LoteAlias = "VTA_DocumentoDetalle.LoteAlias";
    const FechaVencimiento = "VTA_DocumentoDetalle.FechaVencimiento";
    const IdItemTipo = "VTA_DocumentoDetalle.IdItemTipo";
    const IdUnidad = "VTA_DocumentoDetalle.IdUnidad";
    const Condicion = "VTA_DocumentoDetalle.Condicion";
    const IdTipoPrecio = "VTA_DocumentoDetalle.IdTipoPrecio";
    const CodigoProductoSunat = "VTA_DocumentoDetalle.CodigoProductoSunat";
    const Descripcion = "VTA_DocumentoDetalle.Descripcion";
    const CantidadPedida = "VTA_DocumentoDetalle.CantidadPedida";
    const CantidadRecibida = "VTA_DocumentoDetalle.CantidadRecibida";
    const CostoUnitarioProm = "VTA_DocumentoDetalle.CostoUnitarioProm";
    const CostoUnitarioMN = "VTA_DocumentoDetalle.CostoUnitarioMN";
    const PrecioUnitarioMN = "VTA_DocumentoDetalle.PrecioUnitarioMN";
    const PrecioUnitario = "VTA_DocumentoDetalle.PrecioUnitario";
    const MontoDescuentoMN = "VTA_DocumentoDetalle.MontoDescuentoMN";
    const MontoDescuento = "VTA_DocumentoDetalle.MontoDescuento";
    const MontoImpuestoUnidad = "VTA_DocumentoDetalle.MontoImpuestoUnidad";
    const MontoImpuestoUnidadMN = "VTA_DocumentoDetalle.MontoImpuestoUnidadMN";
    const MontoIncImpuestoUnidad = "VTA_DocumentoDetalle.MontoIncImpuestoUnidad";
    const MontoIncImpuestoUnidadMN = "VTA_DocumentoDetalle.MontoIncImpuestoUnidadMN";
    const MontoSubTotal = "VTA_DocumentoDetalle.MontoSubTotal";
    const MontoSubTotalMN = "VTA_DocumentoDetalle.MontoSubTotalMN";
    const MontoSubTotalImpuesto = "VTA_DocumentoDetalle.MontoSubTotalImpuesto";
    const MontoSubTotalImpuestoMN = "VTA_DocumentoDetalle.MontoSubTotalImpuestoMN";
    const MontoTotalNeto = "VTA_DocumentoDetalle.MontoTotalNeto";
    const MontoTotalNetoMN = "VTA_DocumentoDetalle.MontoTotalNetoMN";
    const IGVExoneradoFlag = "VTA_DocumentoDetalle.IGVExoneradoFlag";
    const TipoIGV = "VTA_DocumentoDetalle.TipoIGV";
    const PorcentajeImpuesto = "VTA_DocumentoDetalle.PorcentajeImpuesto";
    const AlmacenCodigo = "VTA_DocumentoDetalle.AlmacenCodigo";
    const NumeroPromocion = "VTA_DocumentoDetalle.NumeroPromocion";
    const RefParent = "VTA_DocumentoDetalle.RefParent";
    const RefTipoParent = "VTA_DocumentoDetalle.RefTipoParent";
    const Estado = "VTA_DocumentoDetalle.Estado";
    const CentroCosto = "VTA_DocumentoDetalle.CentroCosto";
    const UsuarioModificacion = "VTA_DocumentoDetalle.UsuarioModificacion";
    const FechaModificacion = "VTA_DocumentoDetalle.FechaModificacion";
    const UsuarioCreacion = "VTA_DocumentoDetalle.UsuarioCreacion";
    const FechaCreacion = "VTA_DocumentoDetalle.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_DocumentoDetalle.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.NumeroDocumento AS NumeroDocumento, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.TipoDetalle AS TipoDetalle, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.ItemCodigo AS ItemCodigo, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.Lote AS Lote, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.LoteAlias AS LoteAlias, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.IdItemTipo AS IdItemTipo, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.Condicion AS Condicion, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.IdTipoPrecio AS IdTipoPrecio, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.CodigoProductoSunat AS CodigoProductoSunat, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.CantidadPedida AS CantidadPedida, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.CantidadRecibida AS CantidadRecibida, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.CostoUnitarioProm AS CostoUnitarioProm, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.CostoUnitarioMN AS CostoUnitarioMN, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.PrecioUnitarioMN AS PrecioUnitarioMN, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.PrecioUnitario AS PrecioUnitario, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoDescuentoMN AS MontoDescuentoMN, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoDescuento AS MontoDescuento, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoImpuestoUnidad AS MontoImpuestoUnidad, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoImpuestoUnidadMN AS MontoImpuestoUnidadMN, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoIncImpuestoUnidad AS MontoIncImpuestoUnidad, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoIncImpuestoUnidadMN AS MontoIncImpuestoUnidadMN, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoSubTotal AS MontoSubTotal, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoSubTotalMN AS MontoSubTotalMN, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoSubTotalImpuesto AS MontoSubTotalImpuesto, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoSubTotalImpuestoMN AS MontoSubTotalImpuestoMN, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoTotalNeto AS MontoTotalNeto, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.MontoTotalNetoMN AS MontoTotalNetoMN, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.IGVExoneradoFlag AS IGVExoneradoFlag, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.TipoIGV AS TipoIGV, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.PorcentajeImpuesto AS PorcentajeImpuesto, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.AlmacenCodigo AS AlmacenCodigo, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.NumeroPromocion AS NumeroPromocion, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.RefParent AS RefParent, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.RefTipoParent AS RefTipoParent, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.Estado AS Estado, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.CentroCosto AS CentroCosto, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_DocumentoDetalle.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_DocumentoDetalleBN */
    public function setByBN( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() ) )
        {
            $this->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getTipoDetalle() ) )
        {
            $this->setTipoDetalle( $o_VTA_DocumentoDetalleBN->getTipoDetalle() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getItemCodigo() ) )
        {
            $this->setItemCodigo( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getLote() ) )
        {
            $this->setLote( $o_VTA_DocumentoDetalleBN->getLote() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getLoteAlias() ) )
        {
            $this->setLoteAlias( $o_VTA_DocumentoDetalleBN->getLoteAlias() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_VTA_DocumentoDetalleBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getIdItemTipo() ) )
        {
            $this->setIdItemTipo( $o_VTA_DocumentoDetalleBN->getIdItemTipo() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_VTA_DocumentoDetalleBN->getIdUnidad() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getCondicion() ) )
        {
            $this->setCondicion( $o_VTA_DocumentoDetalleBN->getCondicion() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() ) )
        {
            $this->setIdTipoPrecio( $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getCodigoProductoSunat() ) )
        {
            $this->setCodigoProductoSunat( $o_VTA_DocumentoDetalleBN->getCodigoProductoSunat() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_VTA_DocumentoDetalleBN->getDescripcion() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getCantidadPedida() ) )
        {
            $this->setCantidadPedida( $o_VTA_DocumentoDetalleBN->getCantidadPedida() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getCantidadRecibida() ) )
        {
            $this->setCantidadRecibida( $o_VTA_DocumentoDetalleBN->getCantidadRecibida() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getCostoUnitarioProm() ) )
        {
            $this->setCostoUnitarioProm( $o_VTA_DocumentoDetalleBN->getCostoUnitarioProm() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getCostoUnitarioMN() ) )
        {
            $this->setCostoUnitarioMN( $o_VTA_DocumentoDetalleBN->getCostoUnitarioMN() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getPrecioUnitarioMN() ) )
        {
            $this->setPrecioUnitarioMN( $o_VTA_DocumentoDetalleBN->getPrecioUnitarioMN() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getPrecioUnitario() ) )
        {
            $this->setPrecioUnitario( $o_VTA_DocumentoDetalleBN->getPrecioUnitario() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoDescuentoMN() ) )
        {
            $this->setMontoDescuentoMN( $o_VTA_DocumentoDetalleBN->getMontoDescuentoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoDescuento() ) )
        {
            $this->setMontoDescuento( $o_VTA_DocumentoDetalleBN->getMontoDescuento() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoImpuestoUnidad() ) )
        {
            $this->setMontoImpuestoUnidad( $o_VTA_DocumentoDetalleBN->getMontoImpuestoUnidad() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoImpuestoUnidadMN() ) )
        {
            $this->setMontoImpuestoUnidadMN( $o_VTA_DocumentoDetalleBN->getMontoImpuestoUnidadMN() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad() ) )
        {
            $this->setMontoIncImpuestoUnidad( $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidadMN() ) )
        {
            $this->setMontoIncImpuestoUnidadMN( $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidadMN() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoSubTotal() ) )
        {
            $this->setMontoSubTotal( $o_VTA_DocumentoDetalleBN->getMontoSubTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoSubTotalMN() ) )
        {
            $this->setMontoSubTotalMN( $o_VTA_DocumentoDetalleBN->getMontoSubTotalMN() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoSubTotalImpuesto() ) )
        {
            $this->setMontoSubTotalImpuesto( $o_VTA_DocumentoDetalleBN->getMontoSubTotalImpuesto() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoSubTotalImpuestoMN() ) )
        {
            $this->setMontoSubTotalImpuestoMN( $o_VTA_DocumentoDetalleBN->getMontoSubTotalImpuestoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoTotalNeto() ) )
        {
            $this->setMontoTotalNeto( $o_VTA_DocumentoDetalleBN->getMontoTotalNeto() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getMontoTotalNetoMN() ) )
        {
            $this->setMontoTotalNetoMN( $o_VTA_DocumentoDetalleBN->getMontoTotalNetoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getIGVExoneradoFlag() ) )
        {
            $this->setIGVExoneradoFlag( $o_VTA_DocumentoDetalleBN->getIGVExoneradoFlag() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getTipoIGV() ) )
        {
            $this->setTipoIGV( $o_VTA_DocumentoDetalleBN->getTipoIGV() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getPorcentajeImpuesto() ) )
        {
            $this->setPorcentajeImpuesto( $o_VTA_DocumentoDetalleBN->getPorcentajeImpuesto() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getAlmacenCodigo() ) )
        {
            $this->setAlmacenCodigo( $o_VTA_DocumentoDetalleBN->getAlmacenCodigo() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getNumeroPromocion() ) )
        {
            $this->setNumeroPromocion( $o_VTA_DocumentoDetalleBN->getNumeroPromocion() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getRefParent() ) )
        {
            $this->setRefParent( $o_VTA_DocumentoDetalleBN->getRefParent() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getRefTipoParent() ) )
        {
            $this->setRefTipoParent( $o_VTA_DocumentoDetalleBN->getRefTipoParent() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_DocumentoDetalleBN->getEstado() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getCentroCosto() ) )
        {
            $this->setCentroCosto( $o_VTA_DocumentoDetalleBN->getCentroCosto() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_DocumentoDetalleBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_DocumentoDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_DocumentoDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_DocumentoDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_DocumentoDetalleBN->getFechaCreacion() );
        }
    }

    /**
    * @return VTA_DocumentoDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdTipoDocumento, $i_IdCompania, $s_NumeroDocumento, $i_Secuencia )
    {
        if( is_null( $s_IdTipoDocumento ) ){ $s_IdTipoDocumento = '-1'; } 
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_NumeroDocumento ) ){ $s_NumeroDocumento = '-1'; } 
        if( is_null( $i_Secuencia ) ){ $i_Secuencia = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_DocumentoDetalle ";
        $s_SQLQuery .= "WHERE IdTipoDocumento = '".$s_IdTipoDocumento."' ";
        $s_SQLQuery .= "AND IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND NumeroDocumento = '".$s_NumeroDocumento."' ";
        $s_SQLQuery .= "AND Secuencia = ".$i_Secuencia." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_DocumentoDetalleBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_DocumentoDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_DocumentoDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getNumeroDocumento() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.NumeroDocumento = '".$this->getNumeroDocumento()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.Secuencia = ".$this->getSecuencia()." AND ";
        if ( !is_null( $this->getTipoDetalle() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.TipoDetalle = '".$this->getTipoDetalle()."' AND ";
        if ( !is_null( $this->getItemCodigo() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.ItemCodigo = '".$this->getItemCodigo()."' AND ";
        if ( !is_null( $this->getLote() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.Lote = '".$this->getLote()."' AND ";
        if ( !is_null( $this->getLoteAlias() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.LoteAlias = '".$this->getLoteAlias()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getIdItemTipo() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.IdItemTipo = '".$this->getIdItemTipo()."' AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.IdUnidad = ".$this->getIdUnidad()." AND ";
        if ( !is_null( $this->getCondicion() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.Condicion = '".$this->getCondicion()."' AND ";
        if ( !is_null( $this->getIdTipoPrecio() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.IdTipoPrecio = '".$this->getIdTipoPrecio()."' AND ";
        if ( !is_null( $this->getCodigoProductoSunat() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.CodigoProductoSunat = '".$this->getCodigoProductoSunat()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCantidadPedida() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.CantidadPedida = ".$this->getCantidadPedida()." AND ";
        if ( !is_null( $this->getCantidadRecibida() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.CantidadRecibida = ".$this->getCantidadRecibida()." AND ";
        if ( !is_null( $this->getCostoUnitarioProm() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.CostoUnitarioProm = ".$this->getCostoUnitarioProm()." AND ";
        if ( !is_null( $this->getCostoUnitarioMN() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.CostoUnitarioMN = ".$this->getCostoUnitarioMN()." AND ";
        if ( !is_null( $this->getPrecioUnitarioMN() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.PrecioUnitarioMN = ".$this->getPrecioUnitarioMN()." AND ";
        if ( !is_null( $this->getPrecioUnitario() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.PrecioUnitario = ".$this->getPrecioUnitario()." AND ";
        if ( !is_null( $this->getMontoDescuentoMN() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoDescuentoMN = ".$this->getMontoDescuentoMN()." AND ";
        if ( !is_null( $this->getMontoDescuento() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoDescuento = ".$this->getMontoDescuento()." AND ";
        if ( !is_null( $this->getMontoImpuestoUnidad() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoImpuestoUnidad = ".$this->getMontoImpuestoUnidad()." AND ";
        if ( !is_null( $this->getMontoImpuestoUnidadMN() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoImpuestoUnidadMN = ".$this->getMontoImpuestoUnidadMN()." AND ";
        if ( !is_null( $this->getMontoIncImpuestoUnidad() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoIncImpuestoUnidad = ".$this->getMontoIncImpuestoUnidad()." AND ";
        if ( !is_null( $this->getMontoIncImpuestoUnidadMN() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoIncImpuestoUnidadMN = ".$this->getMontoIncImpuestoUnidadMN()." AND ";
        if ( !is_null( $this->getMontoSubTotal() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoSubTotal = ".$this->getMontoSubTotal()." AND ";
        if ( !is_null( $this->getMontoSubTotalMN() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoSubTotalMN = ".$this->getMontoSubTotalMN()." AND ";
        if ( !is_null( $this->getMontoSubTotalImpuesto() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoSubTotalImpuesto = ".$this->getMontoSubTotalImpuesto()." AND ";
        if ( !is_null( $this->getMontoSubTotalImpuestoMN() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoSubTotalImpuestoMN = ".$this->getMontoSubTotalImpuestoMN()." AND ";
        if ( !is_null( $this->getMontoTotalNeto() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoTotalNeto = ".$this->getMontoTotalNeto()." AND ";
        if ( !is_null( $this->getMontoTotalNetoMN() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.MontoTotalNetoMN = ".$this->getMontoTotalNetoMN()." AND ";
        if ( !is_null( $this->getIGVExoneradoFlag() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.IGVExoneradoFlag = '".$this->getIGVExoneradoFlag()."' AND ";
        if ( !is_null( $this->getTipoIGV() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.TipoIGV = '".$this->getTipoIGV()."' AND ";
        if ( !is_null( $this->getPorcentajeImpuesto() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.PorcentajeImpuesto = ".$this->getPorcentajeImpuesto()." AND ";
        if ( !is_null( $this->getAlmacenCodigo() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.AlmacenCodigo = '".$this->getAlmacenCodigo()."' AND ";
        if ( !is_null( $this->getNumeroPromocion() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.NumeroPromocion = '".$this->getNumeroPromocion()."' AND ";
        if ( !is_null( $this->getRefParent() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.RefParent = ".$this->getRefParent()." AND ";
        if ( !is_null( $this->getRefTipoParent() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.RefTipoParent = '".$this->getRefTipoParent()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getCentroCosto() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.CentroCosto = '".$this->getCentroCosto()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_DocumentoDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_DocumentoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_DocumentoDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_DocumentoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_DocumentoDetalleBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_DocumentoDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_DocumentoDetalleBN[] = $o_VTA_DocumentoDetalleBN;
            }
        }
        return $a_VTA_DocumentoDetalleBN;
    }

    /* Devuelve un objeto VTA_DocumentoDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_DocumentoDetalle )
    {
        $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
        if ( !is_null( $a_VTA_DocumentoDetalle['IdTipoDocumento'] ) ) $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $a_VTA_DocumentoDetalle['IdTipoDocumento'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['IdCompania'] ) ) $o_VTA_DocumentoDetalleBN->setIdCompania( ( integer ) $a_VTA_DocumentoDetalle['IdCompania'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['NumeroDocumento'] ) ) $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $a_VTA_DocumentoDetalle['NumeroDocumento'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['Secuencia'] ) ) $o_VTA_DocumentoDetalleBN->setSecuencia( ( integer ) $a_VTA_DocumentoDetalle['Secuencia'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['TipoDetalle'] ) ) $o_VTA_DocumentoDetalleBN->setTipoDetalle( $a_VTA_DocumentoDetalle['TipoDetalle'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['ItemCodigo'] ) ) $o_VTA_DocumentoDetalleBN->setItemCodigo( $a_VTA_DocumentoDetalle['ItemCodigo'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['Lote'] ) ) $o_VTA_DocumentoDetalleBN->setLote( $a_VTA_DocumentoDetalle['Lote'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['LoteAlias'] ) ) $o_VTA_DocumentoDetalleBN->setLoteAlias( $a_VTA_DocumentoDetalle['LoteAlias'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['FechaVencimiento'] ) ) $o_VTA_DocumentoDetalleBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_VTA_DocumentoDetalle['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_VTA_DocumentoDetalle['IdItemTipo'] ) ) $o_VTA_DocumentoDetalleBN->setIdItemTipo( $a_VTA_DocumentoDetalle['IdItemTipo'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['IdUnidad'] ) ) $o_VTA_DocumentoDetalleBN->setIdUnidad( ( integer ) $a_VTA_DocumentoDetalle['IdUnidad'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['Condicion'] ) ) $o_VTA_DocumentoDetalleBN->setCondicion( $a_VTA_DocumentoDetalle['Condicion'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['IdTipoPrecio'] ) ) $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( $a_VTA_DocumentoDetalle['IdTipoPrecio'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['CodigoProductoSunat'] ) ) $o_VTA_DocumentoDetalleBN->setCodigoProductoSunat( $a_VTA_DocumentoDetalle['CodigoProductoSunat'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['Descripcion'] ) ) $o_VTA_DocumentoDetalleBN->setDescripcion( $a_VTA_DocumentoDetalle['Descripcion'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['CantidadPedida'] ) ) $o_VTA_DocumentoDetalleBN->setCantidadPedida( ( float ) $a_VTA_DocumentoDetalle['CantidadPedida'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['CantidadRecibida'] ) ) $o_VTA_DocumentoDetalleBN->setCantidadRecibida( ( float ) $a_VTA_DocumentoDetalle['CantidadRecibida'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['CostoUnitarioProm'] ) ) $o_VTA_DocumentoDetalleBN->setCostoUnitarioProm( ( float ) $a_VTA_DocumentoDetalle['CostoUnitarioProm'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['CostoUnitarioMN'] ) ) $o_VTA_DocumentoDetalleBN->setCostoUnitarioMN( ( float ) $a_VTA_DocumentoDetalle['CostoUnitarioMN'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['PrecioUnitarioMN'] ) ) $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( ( float ) $a_VTA_DocumentoDetalle['PrecioUnitarioMN'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['PrecioUnitario'] ) ) $o_VTA_DocumentoDetalleBN->setPrecioUnitario( ( float ) $a_VTA_DocumentoDetalle['PrecioUnitario'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoDescuentoMN'] ) ) $o_VTA_DocumentoDetalleBN->setMontoDescuentoMN( ( float ) $a_VTA_DocumentoDetalle['MontoDescuentoMN'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoDescuento'] ) ) $o_VTA_DocumentoDetalleBN->setMontoDescuento( ( float ) $a_VTA_DocumentoDetalle['MontoDescuento'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoImpuestoUnidad'] ) ) $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( ( float ) $a_VTA_DocumentoDetalle['MontoImpuestoUnidad'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoImpuestoUnidadMN'] ) ) $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( ( float ) $a_VTA_DocumentoDetalle['MontoImpuestoUnidadMN'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoIncImpuestoUnidad'] ) ) $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( ( float ) $a_VTA_DocumentoDetalle['MontoIncImpuestoUnidad'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoIncImpuestoUnidadMN'] ) ) $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( ( float ) $a_VTA_DocumentoDetalle['MontoIncImpuestoUnidadMN'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoSubTotal'] ) ) $o_VTA_DocumentoDetalleBN->setMontoSubTotal( ( float ) $a_VTA_DocumentoDetalle['MontoSubTotal'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoSubTotalMN'] ) ) $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( ( float ) $a_VTA_DocumentoDetalle['MontoSubTotalMN'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoSubTotalImpuesto'] ) ) $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( ( float ) $a_VTA_DocumentoDetalle['MontoSubTotalImpuesto'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoSubTotalImpuestoMN'] ) ) $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( ( float ) $a_VTA_DocumentoDetalle['MontoSubTotalImpuestoMN'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoTotalNeto'] ) ) $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( ( float ) $a_VTA_DocumentoDetalle['MontoTotalNeto'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['MontoTotalNetoMN'] ) ) $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( ( float ) $a_VTA_DocumentoDetalle['MontoTotalNetoMN'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['IGVExoneradoFlag'] ) ) $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( $a_VTA_DocumentoDetalle['IGVExoneradoFlag'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['TipoIGV'] ) ) $o_VTA_DocumentoDetalleBN->setTipoIGV( $a_VTA_DocumentoDetalle['TipoIGV'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['PorcentajeImpuesto'] ) ) $o_VTA_DocumentoDetalleBN->setPorcentajeImpuesto( ( integer ) $a_VTA_DocumentoDetalle['PorcentajeImpuesto'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['AlmacenCodigo'] ) ) $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $a_VTA_DocumentoDetalle['AlmacenCodigo'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['NumeroPromocion'] ) ) $o_VTA_DocumentoDetalleBN->setNumeroPromocion( $a_VTA_DocumentoDetalle['NumeroPromocion'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['RefParent'] ) ) $o_VTA_DocumentoDetalleBN->setRefParent( ( integer ) $a_VTA_DocumentoDetalle['RefParent'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['RefTipoParent'] ) ) $o_VTA_DocumentoDetalleBN->setRefTipoParent( $a_VTA_DocumentoDetalle['RefTipoParent'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['Estado'] ) ) $o_VTA_DocumentoDetalleBN->setEstado( $a_VTA_DocumentoDetalle['Estado'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['CentroCosto'] ) ) $o_VTA_DocumentoDetalleBN->setCentroCosto( $a_VTA_DocumentoDetalle['CentroCosto'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['UsuarioModificacion'] ) ) $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( $a_VTA_DocumentoDetalle['UsuarioModificacion'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['FechaModificacion'] ) ) $o_VTA_DocumentoDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_DocumentoDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_DocumentoDetalle['UsuarioCreacion'] ) ) $o_VTA_DocumentoDetalleBN->setUsuarioCreacion( $a_VTA_DocumentoDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_DocumentoDetalle['FechaCreacion'] ) ) $o_VTA_DocumentoDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_DocumentoDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_DocumentoDetalleBN;
    }
}
?>