<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VIS_Destino.xml */
/* Generado: 2025-05-05 07:03:33 */

/* Busqueda de registros de la tabla VIS_Destino. */
abstract class BaseVIS_DestinoFN extends VIS_DestinoBN
{
    /* Declaracion de constantes */
    const IdDestino = "VIS_Destino.IdDestino";
    const Descripcion = "VIS_Destino.Descripcion";
    const Estado = "VIS_Destino.Estado";
    const FechaCreacion = "VIS_Destino.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VIS_Destino.IdDestino AS IdDestino, ";
        $s_SQLQuery .= "VIS_Destino.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "VIS_Destino.Estado AS Estado, ";
        $s_SQLQuery .= "VIS_Destino.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VIS_DestinoBN */
    public function setByBN( VIS_DestinoBN $o_VIS_DestinoBN )
    {
        if ( !is_null( $o_VIS_DestinoBN->getIdDestino() ) )
        {
            $this->setIdDestino( $o_VIS_DestinoBN->getIdDestino() );
        }
        if ( !is_null( $o_VIS_DestinoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_VIS_DestinoBN->getDescripcion() );
        }
        if ( !is_null( $o_VIS_DestinoBN->getEstado() ) )
        {
            $this->setEstado( $o_VIS_DestinoBN->getEstado() );
        }
        if ( !is_null( $o_VIS_DestinoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VIS_DestinoBN->getFechaCreacion() );
        }
    }

    /**
    * @return VIS_DestinoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdDestino )
    {
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VIS_Destino ";
        $s_SQLQuery .= "WHERE IdDestino = ".$i_IdDestino." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VIS_DestinoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VIS_DestinoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VIS_DestinoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdDestino() ) ) $s_SQLQuery .= "VIS_Destino.IdDestino = ".$this->getIdDestino()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "VIS_Destino.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VIS_Destino.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VIS_Destino.FechaCreacion = ".$this->getFechaCreacion()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VIS_Destino WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VIS_DestinoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VIS_Destino WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VIS_DestinoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VIS_DestinoBN = $this->insertObjectBN( $a_SQLRow );
                $a_VIS_DestinoBN[] = $o_VIS_DestinoBN;
            }
        }
        return $a_VIS_DestinoBN;
    }

    /* Devuelve un objeto VIS_DestinoBN desde un objeto propel */
    public function insertObjectBN( $a_VIS_Destino )
    {
        $o_VIS_DestinoBN = new VIS_DestinoBN();
        if ( !is_null( $a_VIS_Destino['IdDestino'] ) ) $o_VIS_DestinoBN->setIdDestino( ( integer ) $a_VIS_Destino['IdDestino'] );
        if ( !is_null( $a_VIS_Destino['Descripcion'] ) ) $o_VIS_DestinoBN->setDescripcion( $a_VIS_Destino['Descripcion'] );
        if ( !is_null( $a_VIS_Destino['Estado'] ) ) $o_VIS_DestinoBN->setEstado( $a_VIS_Destino['Estado'] );
        if ( !is_null( $a_VIS_Destino['FechaCreacion'] ) ) $o_VIS_DestinoBN->setFechaCreacion( ( integer ) $a_VIS_Destino['FechaCreacion'] );
        return $o_VIS_DestinoBN;
    }
}
?>