<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_RutaDetalle.xml */
/* Generado: 2021-07-19 02:00:14 */

/* Busqueda de registros de la tabla TR_RutaDetalle. */
abstract class BaseTR_RutaDetalleFN extends TR_RutaDetalleBN
{
    /* Declaracion de constantes */
    const IdRuta = "TR_RutaDetalle.IdRuta";
    const IdRutaLinea = "TR_RutaDetalle.IdRutaLinea";
    const RutaSecuencia = "TR_RutaDetalle.RutaSecuencia";
    const RutaDocumento = "TR_RutaDetalle.RutaDocumento";
    const RutaDocDespacho = "TR_RutaDetalle.RutaDocDespacho";
    const DocumentRefId = "TR_RutaDetalle.DocumentRefId";
    const DocParentId = "TR_RutaDetalle.DocParentId";
    const DocParentCod = "TR_RutaDetalle.DocParentCod";
    const RutaDetDir1 = "TR_RutaDetalle.RutaDetDir1";
    const RutaDetDir2 = "TR_RutaDetalle.RutaDetDir2";
    const RutaDetCiudad = "TR_RutaDetalle.RutaDetCiudad";
    const RutaDetDpto = "TR_RutaDetalle.RutaDetDpto";
    const RutaDetPais = "TR_RutaDetalle.RutaDetPais";
    const IdUbigeo = "TR_RutaDetalle.IdUbigeo";
    const RutaDetEstado = "TR_RutaDetalle.RutaDetEstado";
    const FechaHoraProgramada = "TR_RutaDetalle.FechaHoraProgramada";
    const FechaHoraLiberacion = "TR_RutaDetalle.FechaHoraLiberacion";
    const FechaHoraLlegada = "TR_RutaDetalle.FechaHoraLlegada";
    const FechaHoraEntrega = "TR_RutaDetalle.FechaHoraEntrega";
    const ComentarioChofer = "TR_RutaDetalle.ComentarioChofer";
    const ComentarioAdicional = "TR_RutaDetalle.ComentarioAdicional";
    const TipoDocRef = "TR_RutaDetalle.TipoDocRef";
    const SerieDocumentoRef = "TR_RutaDetalle.SerieDocumentoRef";
    const NumeroDocumentoRef = "TR_RutaDetalle.NumeroDocumentoRef";
    const FechaCreacion = "TR_RutaDetalle.FechaCreacion";
    const UsuarioCreacion = "TR_RutaDetalle.UsuarioCreacion";
    const FechaModificacion = "TR_RutaDetalle.FechaModificacion";
    const UsuarioModificacion = "TR_RutaDetalle.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "TR_RutaDetalle.IdRuta AS IdRuta, ";
        $s_SQLQuery .= "TR_RutaDetalle.IdRutaLinea AS IdRutaLinea, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaSecuencia AS RutaSecuencia, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaDocumento AS RutaDocumento, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaDocDespacho AS RutaDocDespacho, ";
        $s_SQLQuery .= "TR_RutaDetalle.DocumentRefId AS DocumentRefId, ";
        $s_SQLQuery .= "TR_RutaDetalle.DocParentId AS DocParentId, ";
        $s_SQLQuery .= "TR_RutaDetalle.DocParentCod AS DocParentCod, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaDetDir1 AS RutaDetDir1, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaDetDir2 AS RutaDetDir2, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaDetCiudad AS RutaDetCiudad, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaDetDpto AS RutaDetDpto, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaDetPais AS RutaDetPais, ";
        $s_SQLQuery .= "TR_RutaDetalle.IdUbigeo AS IdUbigeo, ";
        $s_SQLQuery .= "TR_RutaDetalle.RutaDetEstado AS RutaDetEstado, ";
        $s_SQLQuery .= "TR_RutaDetalle.FechaHoraProgramada AS FechaHoraProgramada, ";
        $s_SQLQuery .= "TR_RutaDetalle.FechaHoraLiberacion AS FechaHoraLiberacion, ";
        $s_SQLQuery .= "TR_RutaDetalle.FechaHoraLlegada AS FechaHoraLlegada, ";
        $s_SQLQuery .= "TR_RutaDetalle.FechaHoraEntrega AS FechaHoraEntrega, ";
        $s_SQLQuery .= "TR_RutaDetalle.ComentarioChofer AS ComentarioChofer, ";
        $s_SQLQuery .= "TR_RutaDetalle.ComentarioAdicional AS ComentarioAdicional, ";
        $s_SQLQuery .= "TR_RutaDetalle.TipoDocRef AS TipoDocRef, ";
        $s_SQLQuery .= "TR_RutaDetalle.SerieDocumentoRef AS SerieDocumentoRef, ";
        $s_SQLQuery .= "TR_RutaDetalle.NumeroDocumentoRef AS NumeroDocumentoRef, ";
        $s_SQLQuery .= "TR_RutaDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "TR_RutaDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "TR_RutaDetalle.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "TR_RutaDetalle.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto TR_RutaDetalleBN */
    public function setByBN( TR_RutaDetalleBN $o_TR_RutaDetalleBN )
    {
        if ( !is_null( $o_TR_RutaDetalleBN->getIdRuta() ) )
        {
            $this->setIdRuta( $o_TR_RutaDetalleBN->getIdRuta() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getIdRutaLinea() ) )
        {
            $this->setIdRutaLinea( $o_TR_RutaDetalleBN->getIdRutaLinea() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaSecuencia() ) )
        {
            $this->setRutaSecuencia( $o_TR_RutaDetalleBN->getRutaSecuencia() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaDocumento() ) )
        {
            $this->setRutaDocumento( $o_TR_RutaDetalleBN->getRutaDocumento() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaDocDespacho() ) )
        {
            $this->setRutaDocDespacho( $o_TR_RutaDetalleBN->getRutaDocDespacho() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getDocumentRefId() ) )
        {
            $this->setDocumentRefId( $o_TR_RutaDetalleBN->getDocumentRefId() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getDocParentId() ) )
        {
            $this->setDocParentId( $o_TR_RutaDetalleBN->getDocParentId() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getDocParentCod() ) )
        {
            $this->setDocParentCod( $o_TR_RutaDetalleBN->getDocParentCod() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaDetDir1() ) )
        {
            $this->setRutaDetDir1( $o_TR_RutaDetalleBN->getRutaDetDir1() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaDetDir2() ) )
        {
            $this->setRutaDetDir2( $o_TR_RutaDetalleBN->getRutaDetDir2() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaDetCiudad() ) )
        {
            $this->setRutaDetCiudad( $o_TR_RutaDetalleBN->getRutaDetCiudad() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaDetDpto() ) )
        {
            $this->setRutaDetDpto( $o_TR_RutaDetalleBN->getRutaDetDpto() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaDetPais() ) )
        {
            $this->setRutaDetPais( $o_TR_RutaDetalleBN->getRutaDetPais() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getIdUbigeo() ) )
        {
            $this->setIdUbigeo( $o_TR_RutaDetalleBN->getIdUbigeo() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getRutaDetEstado() ) )
        {
            $this->setRutaDetEstado( $o_TR_RutaDetalleBN->getRutaDetEstado() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getFechaHoraProgramada() ) )
        {
            $this->setFechaHoraProgramada( $o_TR_RutaDetalleBN->getFechaHoraProgramada() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getFechaHoraLiberacion() ) )
        {
            $this->setFechaHoraLiberacion( $o_TR_RutaDetalleBN->getFechaHoraLiberacion() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getFechaHoraLlegada() ) )
        {
            $this->setFechaHoraLlegada( $o_TR_RutaDetalleBN->getFechaHoraLlegada() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getFechaHoraEntrega() ) )
        {
            $this->setFechaHoraEntrega( $o_TR_RutaDetalleBN->getFechaHoraEntrega() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getComentarioChofer() ) )
        {
            $this->setComentarioChofer( $o_TR_RutaDetalleBN->getComentarioChofer() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getComentarioAdicional() ) )
        {
            $this->setComentarioAdicional( $o_TR_RutaDetalleBN->getComentarioAdicional() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getTipoDocRef() ) )
        {
            $this->setTipoDocRef( $o_TR_RutaDetalleBN->getTipoDocRef() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getSerieDocumentoRef() ) )
        {
            $this->setSerieDocumentoRef( $o_TR_RutaDetalleBN->getSerieDocumentoRef() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getNumeroDocumentoRef() ) )
        {
            $this->setNumeroDocumentoRef( $o_TR_RutaDetalleBN->getNumeroDocumentoRef() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_TR_RutaDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_TR_RutaDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_TR_RutaDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_TR_RutaDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_TR_RutaDetalleBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return TR_RutaDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdRuta, $i_IdRutaLinea )
    {
        if( is_null( $i_IdRuta ) ){ $i_IdRuta = -1; } 
        if( is_null( $i_IdRutaLinea ) ){ $i_IdRutaLinea = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_RutaDetalle ";
        $s_SQLQuery .= "WHERE IdRuta = ".$i_IdRuta." ";
        $s_SQLQuery .= "AND IdRutaLinea = ".$i_IdRutaLinea." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_TR_RutaDetalleBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_TR_RutaDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_TR_RutaDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRuta() ) ) $s_SQLQuery .= "TR_RutaDetalle.IdRuta = ".$this->getIdRuta()." AND ";
        if ( !is_null( $this->getIdRutaLinea() ) ) $s_SQLQuery .= "TR_RutaDetalle.IdRutaLinea = ".$this->getIdRutaLinea()." AND ";
        if ( !is_null( $this->getRutaSecuencia() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaSecuencia = ".$this->getRutaSecuencia()." AND ";
        if ( !is_null( $this->getRutaDocumento() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaDocumento = '".$this->getRutaDocumento()."' AND ";
        if ( !is_null( $this->getRutaDocDespacho() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaDocDespacho = '".$this->getRutaDocDespacho()."' AND ";
        if ( !is_null( $this->getDocumentRefId() ) ) $s_SQLQuery .= "TR_RutaDetalle.DocumentRefId = '".$this->getDocumentRefId()."' AND ";
        if ( !is_null( $this->getDocParentId() ) ) $s_SQLQuery .= "TR_RutaDetalle.DocParentId = ".$this->getDocParentId()." AND ";
        if ( !is_null( $this->getDocParentCod() ) ) $s_SQLQuery .= "TR_RutaDetalle.DocParentCod = '".$this->getDocParentCod()."' AND ";
        if ( !is_null( $this->getRutaDetDir1() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaDetDir1 = '".$this->getRutaDetDir1()."' AND ";
        if ( !is_null( $this->getRutaDetDir2() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaDetDir2 = '".$this->getRutaDetDir2()."' AND ";
        if ( !is_null( $this->getRutaDetCiudad() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaDetCiudad = '".$this->getRutaDetCiudad()."' AND ";
        if ( !is_null( $this->getRutaDetDpto() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaDetDpto = '".$this->getRutaDetDpto()."' AND ";
        if ( !is_null( $this->getRutaDetPais() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaDetPais = '".$this->getRutaDetPais()."' AND ";
        if ( !is_null( $this->getIdUbigeo() ) ) $s_SQLQuery .= "TR_RutaDetalle.IdUbigeo = '".$this->getIdUbigeo()."' AND ";
        if ( !is_null( $this->getRutaDetEstado() ) ) $s_SQLQuery .= "TR_RutaDetalle.RutaDetEstado = '".$this->getRutaDetEstado()."' AND ";
        if ( !is_null( $this->getFechaHoraProgramada() ) ) $s_SQLQuery .= "TR_RutaDetalle.FechaHoraProgramada = '".$this->getFechaHoraProgramada()."' AND ";
        if ( !is_null( $this->getFechaHoraLiberacion() ) ) $s_SQLQuery .= "TR_RutaDetalle.FechaHoraLiberacion = '".$this->getFechaHoraLiberacion()."' AND ";
        if ( !is_null( $this->getFechaHoraLlegada() ) ) $s_SQLQuery .= "TR_RutaDetalle.FechaHoraLlegada = '".$this->getFechaHoraLlegada()."' AND ";
        if ( !is_null( $this->getFechaHoraEntrega() ) ) $s_SQLQuery .= "TR_RutaDetalle.FechaHoraEntrega = '".$this->getFechaHoraEntrega()."' AND ";
        if ( !is_null( $this->getComentarioChofer() ) ) $s_SQLQuery .= "TR_RutaDetalle.ComentarioChofer = '".$this->getComentarioChofer()."' AND ";
        if ( !is_null( $this->getComentarioAdicional() ) ) $s_SQLQuery .= "TR_RutaDetalle.ComentarioAdicional = '".$this->getComentarioAdicional()."' AND ";
        if ( !is_null( $this->getTipoDocRef() ) ) $s_SQLQuery .= "TR_RutaDetalle.TipoDocRef = '".$this->getTipoDocRef()."' AND ";
        if ( !is_null( $this->getSerieDocumentoRef() ) ) $s_SQLQuery .= "TR_RutaDetalle.SerieDocumentoRef = '".$this->getSerieDocumentoRef()."' AND ";
        if ( !is_null( $this->getNumeroDocumentoRef() ) ) $s_SQLQuery .= "TR_RutaDetalle.NumeroDocumentoRef = '".$this->getNumeroDocumentoRef()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "TR_RutaDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "TR_RutaDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "TR_RutaDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "TR_RutaDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM TR_RutaDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return TR_RutaDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_RutaDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_TR_RutaDetalleBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_TR_RutaDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_TR_RutaDetalleBN[] = $o_TR_RutaDetalleBN;
            }
        }
        return $a_TR_RutaDetalleBN;
    }

    /* Devuelve un objeto TR_RutaDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_TR_RutaDetalle )
    {
        $o_TR_RutaDetalleBN = new TR_RutaDetalleBN();
        if ( !is_null( $a_TR_RutaDetalle['IdRuta'] ) ) $o_TR_RutaDetalleBN->setIdRuta( ( integer ) $a_TR_RutaDetalle['IdRuta'] );
        if ( !is_null( $a_TR_RutaDetalle['IdRutaLinea'] ) ) $o_TR_RutaDetalleBN->setIdRutaLinea( ( integer ) $a_TR_RutaDetalle['IdRutaLinea'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaSecuencia'] ) ) $o_TR_RutaDetalleBN->setRutaSecuencia( ( integer ) $a_TR_RutaDetalle['RutaSecuencia'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaDocumento'] ) ) $o_TR_RutaDetalleBN->setRutaDocumento( $a_TR_RutaDetalle['RutaDocumento'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaDocDespacho'] ) ) $o_TR_RutaDetalleBN->setRutaDocDespacho( $a_TR_RutaDetalle['RutaDocDespacho'] );
        if ( !is_null( $a_TR_RutaDetalle['DocumentRefId'] ) ) $o_TR_RutaDetalleBN->setDocumentRefId( $a_TR_RutaDetalle['DocumentRefId'] );
        if ( !is_null( $a_TR_RutaDetalle['DocParentId'] ) ) $o_TR_RutaDetalleBN->setDocParentId( ( integer ) $a_TR_RutaDetalle['DocParentId'] );
        if ( !is_null( $a_TR_RutaDetalle['DocParentCod'] ) ) $o_TR_RutaDetalleBN->setDocParentCod( $a_TR_RutaDetalle['DocParentCod'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaDetDir1'] ) ) $o_TR_RutaDetalleBN->setRutaDetDir1( $a_TR_RutaDetalle['RutaDetDir1'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaDetDir2'] ) ) $o_TR_RutaDetalleBN->setRutaDetDir2( $a_TR_RutaDetalle['RutaDetDir2'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaDetCiudad'] ) ) $o_TR_RutaDetalleBN->setRutaDetCiudad( $a_TR_RutaDetalle['RutaDetCiudad'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaDetDpto'] ) ) $o_TR_RutaDetalleBN->setRutaDetDpto( $a_TR_RutaDetalle['RutaDetDpto'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaDetPais'] ) ) $o_TR_RutaDetalleBN->setRutaDetPais( $a_TR_RutaDetalle['RutaDetPais'] );
        if ( !is_null( $a_TR_RutaDetalle['IdUbigeo'] ) ) $o_TR_RutaDetalleBN->setIdUbigeo( $a_TR_RutaDetalle['IdUbigeo'] );
        if ( !is_null( $a_TR_RutaDetalle['RutaDetEstado'] ) ) $o_TR_RutaDetalleBN->setRutaDetEstado( $a_TR_RutaDetalle['RutaDetEstado'] );
        if ( !is_null( $a_TR_RutaDetalle['FechaHoraProgramada'] ) ) $o_TR_RutaDetalleBN->setFechaHoraProgramada( utilTimestamp::getTimestamp( $a_TR_RutaDetalle['FechaHoraProgramada'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_RutaDetalle['FechaHoraLiberacion'] ) ) $o_TR_RutaDetalleBN->setFechaHoraLiberacion( utilTimestamp::getTimestamp( $a_TR_RutaDetalle['FechaHoraLiberacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_RutaDetalle['FechaHoraLlegada'] ) ) $o_TR_RutaDetalleBN->setFechaHoraLlegada( utilTimestamp::getTimestamp( $a_TR_RutaDetalle['FechaHoraLlegada'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_RutaDetalle['FechaHoraEntrega'] ) ) $o_TR_RutaDetalleBN->setFechaHoraEntrega( utilTimestamp::getTimestamp( $a_TR_RutaDetalle['FechaHoraEntrega'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_RutaDetalle['ComentarioChofer'] ) ) $o_TR_RutaDetalleBN->setComentarioChofer( $a_TR_RutaDetalle['ComentarioChofer'] );
        if ( !is_null( $a_TR_RutaDetalle['ComentarioAdicional'] ) ) $o_TR_RutaDetalleBN->setComentarioAdicional( $a_TR_RutaDetalle['ComentarioAdicional'] );
        if ( !is_null( $a_TR_RutaDetalle['TipoDocRef'] ) ) $o_TR_RutaDetalleBN->setTipoDocRef( $a_TR_RutaDetalle['TipoDocRef'] );
        if ( !is_null( $a_TR_RutaDetalle['SerieDocumentoRef'] ) ) $o_TR_RutaDetalleBN->setSerieDocumentoRef( $a_TR_RutaDetalle['SerieDocumentoRef'] );
        if ( !is_null( $a_TR_RutaDetalle['NumeroDocumentoRef'] ) ) $o_TR_RutaDetalleBN->setNumeroDocumentoRef( $a_TR_RutaDetalle['NumeroDocumentoRef'] );
        if ( !is_null( $a_TR_RutaDetalle['FechaCreacion'] ) ) $o_TR_RutaDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_TR_RutaDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_RutaDetalle['UsuarioCreacion'] ) ) $o_TR_RutaDetalleBN->setUsuarioCreacion( $a_TR_RutaDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_TR_RutaDetalle['FechaModificacion'] ) ) $o_TR_RutaDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_TR_RutaDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_RutaDetalle['UsuarioModificacion'] ) ) $o_TR_RutaDetalleBN->setUsuarioModificacion( $a_TR_RutaDetalle['UsuarioModificacion'] );
        return $o_TR_RutaDetalleBN;
    }
}
?>