<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionFacturacion.xml */
/* Generado: 2022-04-18 21:15:04 */

/* Busqueda de registros de la tabla SR_DevolucionFacturacion. */
abstract class BaseSR_DevolucionFacturacionFN extends SR_DevolucionFacturacionBN
{
    /* Declaracion de constantes */
    const DevolFactId = "SR_DevolucionFacturacion.DevolFactId";
    const IdCompania = "SR_DevolucionFacturacion.IdCompania";
    const IdSucursal = "SR_DevolucionFacturacion.IdSucursal";
    const IdProyecto = "SR_DevolucionFacturacion.IdProyecto";
    const IdPersona = "SR_DevolucionFacturacion.IdPersona";
    const GrupoId = "SR_DevolucionFacturacion.GrupoId";
    const TipoEstado = "SR_DevolucionFacturacion.TipoEstado";
    const EstadoDesc = "SR_DevolucionFacturacion.EstadoDesc";
    const IdItem = "SR_DevolucionFacturacion.IdItem";
    const DescripcionItem = "SR_DevolucionFacturacion.DescripcionItem";
    const FechaCorte = "SR_DevolucionFacturacion.FechaCorte";
    const SubTotal = "SR_DevolucionFacturacion.SubTotal";
    const MontoIGV = "SR_DevolucionFacturacion.MontoIGV";
    const MontoTotal = "SR_DevolucionFacturacion.MontoTotal";
    const Estado = "SR_DevolucionFacturacion.Estado";
    const IdTipoDocumento = "SR_DevolucionFacturacion.IdTipoDocumento";
    const NumeroDocumento = "SR_DevolucionFacturacion.NumeroDocumento";
    const UsuarioCreacion = "SR_DevolucionFacturacion.UsuarioCreacion";
    const FechaCreacion = "SR_DevolucionFacturacion.FechaCreacion";
    const UsuarioModificacion = "SR_DevolucionFacturacion.UsuarioModificacion";
    const FechaModificacion = "SR_DevolucionFacturacion.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_DevolucionFacturacion.DevolFactId AS DevolFactId, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.GrupoId AS GrupoId, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.TipoEstado AS TipoEstado, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.EstadoDesc AS EstadoDesc, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.IdItem AS IdItem, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.DescripcionItem AS DescripcionItem, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.FechaCorte AS FechaCorte, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.SubTotal AS SubTotal, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.MontoIGV AS MontoIGV, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.Estado AS Estado, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.NumeroDocumento AS NumeroDocumento, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "SR_DevolucionFacturacion.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_DevolucionFacturacionBN */
    public function setByBN( SR_DevolucionFacturacionBN $o_SR_DevolucionFacturacionBN )
    {
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getDevolFactId() ) )
        {
            $this->setDevolFactId( $o_SR_DevolucionFacturacionBN->getDevolFactId() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SR_DevolucionFacturacionBN->getIdCompania() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SR_DevolucionFacturacionBN->getIdSucursal() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_SR_DevolucionFacturacionBN->getIdProyecto() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_SR_DevolucionFacturacionBN->getIdPersona() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getGrupoId() ) )
        {
            $this->setGrupoId( $o_SR_DevolucionFacturacionBN->getGrupoId() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getTipoEstado() ) )
        {
            $this->setTipoEstado( $o_SR_DevolucionFacturacionBN->getTipoEstado() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getEstadoDesc() ) )
        {
            $this->setEstadoDesc( $o_SR_DevolucionFacturacionBN->getEstadoDesc() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getIdItem() ) )
        {
            $this->setIdItem( $o_SR_DevolucionFacturacionBN->getIdItem() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getDescripcionItem() ) )
        {
            $this->setDescripcionItem( $o_SR_DevolucionFacturacionBN->getDescripcionItem() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getFechaCorte() ) )
        {
            $this->setFechaCorte( $o_SR_DevolucionFacturacionBN->getFechaCorte() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getSubTotal() ) )
        {
            $this->setSubTotal( $o_SR_DevolucionFacturacionBN->getSubTotal() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getMontoIGV() ) )
        {
            $this->setMontoIGV( $o_SR_DevolucionFacturacionBN->getMontoIGV() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_SR_DevolucionFacturacionBN->getMontoTotal() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getEstado() ) )
        {
            $this->setEstado( $o_SR_DevolucionFacturacionBN->getEstado() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_SR_DevolucionFacturacionBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getNumeroDocumento() ) )
        {
            $this->setNumeroDocumento( $o_SR_DevolucionFacturacionBN->getNumeroDocumento() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SR_DevolucionFacturacionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SR_DevolucionFacturacionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_DevolucionFacturacionBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_SR_DevolucionFacturacionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_DevolucionFacturacionBN->getFechaModificacion() );
        }
    }

    /**
    * @return SR_DevolucionFacturacionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_DevolFactId )
    {
        if( is_null( $i_DevolFactId ) ){ $i_DevolFactId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionFacturacion ";
        $s_SQLQuery .= "WHERE DevolFactId = ".$i_DevolFactId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SR_DevolucionFacturacionBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_DevolucionFacturacionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_DevolucionFacturacionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getDevolFactId() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.DevolFactId = ".$this->getDevolFactId()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getGrupoId() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.GrupoId = '".$this->getGrupoId()."' AND ";
        if ( !is_null( $this->getTipoEstado() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.TipoEstado = '".$this->getTipoEstado()."' AND ";
        if ( !is_null( $this->getEstadoDesc() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.EstadoDesc = '".$this->getEstadoDesc()."' AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getDescripcionItem() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.DescripcionItem = '".$this->getDescripcionItem()."' AND ";
        if ( !is_null( $this->getFechaCorte() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.FechaCorte = '".$this->getFechaCorte()."' AND ";
        if ( !is_null( $this->getSubTotal() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.SubTotal = ".$this->getSubTotal()." AND ";
        if ( !is_null( $this->getMontoIGV() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.MontoIGV = ".$this->getMontoIGV()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getNumeroDocumento() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.NumeroDocumento = '".$this->getNumeroDocumento()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SR_DevolucionFacturacion.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_DevolucionFacturacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_DevolucionFacturacionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionFacturacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SR_DevolucionFacturacionBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_DevolucionFacturacionBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_DevolucionFacturacionBN[] = $o_SR_DevolucionFacturacionBN;
            }
        }
        return $a_SR_DevolucionFacturacionBN;
    }

    /* Devuelve un objeto SR_DevolucionFacturacionBN desde un objeto propel */
    public function insertObjectBN( $a_SR_DevolucionFacturacion )
    {
        $o_SR_DevolucionFacturacionBN = new SR_DevolucionFacturacionBN();
        if ( !is_null( $a_SR_DevolucionFacturacion['DevolFactId'] ) ) $o_SR_DevolucionFacturacionBN->setDevolFactId( ( integer ) $a_SR_DevolucionFacturacion['DevolFactId'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['IdCompania'] ) ) $o_SR_DevolucionFacturacionBN->setIdCompania( ( integer ) $a_SR_DevolucionFacturacion['IdCompania'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['IdSucursal'] ) ) $o_SR_DevolucionFacturacionBN->setIdSucursal( ( integer ) $a_SR_DevolucionFacturacion['IdSucursal'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['IdProyecto'] ) ) $o_SR_DevolucionFacturacionBN->setIdProyecto( ( integer ) $a_SR_DevolucionFacturacion['IdProyecto'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['IdPersona'] ) ) $o_SR_DevolucionFacturacionBN->setIdPersona( ( integer ) $a_SR_DevolucionFacturacion['IdPersona'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['GrupoId'] ) ) $o_SR_DevolucionFacturacionBN->setGrupoId( $a_SR_DevolucionFacturacion['GrupoId'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['TipoEstado'] ) ) $o_SR_DevolucionFacturacionBN->setTipoEstado( $a_SR_DevolucionFacturacion['TipoEstado'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['EstadoDesc'] ) ) $o_SR_DevolucionFacturacionBN->setEstadoDesc( $a_SR_DevolucionFacturacion['EstadoDesc'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['IdItem'] ) ) $o_SR_DevolucionFacturacionBN->setIdItem( $a_SR_DevolucionFacturacion['IdItem'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['DescripcionItem'] ) ) $o_SR_DevolucionFacturacionBN->setDescripcionItem( $a_SR_DevolucionFacturacion['DescripcionItem'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['FechaCorte'] ) ) $o_SR_DevolucionFacturacionBN->setFechaCorte( utilTimestamp::getTimestamp( $a_SR_DevolucionFacturacion['FechaCorte'], "Y-m-d" ) );
        if ( !is_null( $a_SR_DevolucionFacturacion['SubTotal'] ) ) $o_SR_DevolucionFacturacionBN->setSubTotal( ( float ) $a_SR_DevolucionFacturacion['SubTotal'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['MontoIGV'] ) ) $o_SR_DevolucionFacturacionBN->setMontoIGV( ( float ) $a_SR_DevolucionFacturacion['MontoIGV'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['MontoTotal'] ) ) $o_SR_DevolucionFacturacionBN->setMontoTotal( ( float ) $a_SR_DevolucionFacturacion['MontoTotal'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['Estado'] ) ) $o_SR_DevolucionFacturacionBN->setEstado( $a_SR_DevolucionFacturacion['Estado'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['IdTipoDocumento'] ) ) $o_SR_DevolucionFacturacionBN->setIdTipoDocumento( $a_SR_DevolucionFacturacion['IdTipoDocumento'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['NumeroDocumento'] ) ) $o_SR_DevolucionFacturacionBN->setNumeroDocumento( $a_SR_DevolucionFacturacion['NumeroDocumento'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['UsuarioCreacion'] ) ) $o_SR_DevolucionFacturacionBN->setUsuarioCreacion( $a_SR_DevolucionFacturacion['UsuarioCreacion'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['FechaCreacion'] ) ) $o_SR_DevolucionFacturacionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SR_DevolucionFacturacion['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_DevolucionFacturacion['UsuarioModificacion'] ) ) $o_SR_DevolucionFacturacionBN->setUsuarioModificacion( $a_SR_DevolucionFacturacion['UsuarioModificacion'] );
        if ( !is_null( $a_SR_DevolucionFacturacion['FechaModificacion'] ) ) $o_SR_DevolucionFacturacionBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SR_DevolucionFacturacion['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_SR_DevolucionFacturacionBN;
    }
}
?>