<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_UsuarioCompania.xml */
/* Generado: 2022-04-18 21:15:03 */

/* Busqueda de registros de la tabla SEG_UsuarioCompania. */
abstract class BaseSEG_UsuarioCompaniaFN extends SEG_UsuarioCompaniaBN
{
    /* Declaracion de constantes */
    const IdCompania = "SEG_UsuarioCompania.IdCompania";
    const IdUsuario = "SEG_UsuarioCompania.IdUsuario";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_UsuarioCompania.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SEG_UsuarioCompania.IdUsuario AS IdUsuario ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_UsuarioCompaniaBN */
    public function setByBN( SEG_UsuarioCompaniaBN $o_SEG_UsuarioCompaniaBN )
    {
        if ( !is_null( $o_SEG_UsuarioCompaniaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SEG_UsuarioCompaniaBN->getIdCompania() );
        }
        if ( !is_null( $o_SEG_UsuarioCompaniaBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_SEG_UsuarioCompaniaBN->getIdUsuario() );
        }
    }

    /**
    * @return SEG_UsuarioCompaniaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdUsuario )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdUsuario ) ){ $s_IdUsuario = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_UsuarioCompania ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdUsuario = '".$s_IdUsuario."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_UsuarioCompaniaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_UsuarioCompaniaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_UsuarioCompaniaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SEG_UsuarioCompania.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdUsuario() ) ) $s_SQLQuery .= "SEG_UsuarioCompania.IdUsuario = '".$this->getIdUsuario()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_UsuarioCompania WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_UsuarioCompaniaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_UsuarioCompania WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_UsuarioCompaniaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_UsuarioCompaniaBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_UsuarioCompaniaBN[] = $o_SEG_UsuarioCompaniaBN;
            }
        }
        return $a_SEG_UsuarioCompaniaBN;
    }

    /* Devuelve un objeto SEG_UsuarioCompaniaBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_UsuarioCompania )
    {
        $o_SEG_UsuarioCompaniaBN = new SEG_UsuarioCompaniaBN();
        if ( !is_null( $a_SEG_UsuarioCompania['IdCompania'] ) ) $o_SEG_UsuarioCompaniaBN->setIdCompania( ( integer ) $a_SEG_UsuarioCompania['IdCompania'] );
        if ( !is_null( $a_SEG_UsuarioCompania['IdUsuario'] ) ) $o_SEG_UsuarioCompaniaBN->setIdUsuario( $a_SEG_UsuarioCompania['IdUsuario'] );
        return $o_SEG_UsuarioCompaniaBN;
    }
}
?>