<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_TareaRol.xml */
/* Generado: 2022-04-18 21:15:03 */

/* Busqueda de registros de la tabla SEG_TareaRol. */
abstract class BaseSEG_TareaRolFN extends SEG_TareaRolBN
{
    /* Declaracion de constantes */
    const IdRol = "SEG_TareaRol.IdRol";
    const IdTarea = "SEG_TareaRol.IdTarea";
    const FechaCreacion = "SEG_TareaRol.FechaCreacion";
    const UsuarioCreacion = "SEG_TareaRol.UsuarioCreacion";
    const FechaModificacion = "SEG_TareaRol.FechaModificacion";
    const UsuarioModificacion = "SEG_TareaRol.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_TareaRol.IdRol AS IdRol, ";
        $s_SQLQuery .= "SEG_TareaRol.IdTarea AS IdTarea, ";
        $s_SQLQuery .= "SEG_TareaRol.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_TareaRol.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_TareaRol.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_TareaRol.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_TareaRolBN */
    public function setByBN( SEG_TareaRolBN $o_SEG_TareaRolBN )
    {
        if ( !is_null( $o_SEG_TareaRolBN->getIdRol() ) )
        {
            $this->setIdRol( $o_SEG_TareaRolBN->getIdRol() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getIdTarea() ) )
        {
            $this->setIdTarea( $o_SEG_TareaRolBN->getIdTarea() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_TareaRolBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_TareaRolBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_TareaRolBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_TareaRolBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_TareaRolBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_TareaRolBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdRol, $s_IdTarea )
    {
        if( is_null( $s_IdRol ) ){ $s_IdRol = '-1'; } 
        if( is_null( $s_IdTarea ) ){ $s_IdTarea = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_TareaRol ";
        $s_SQLQuery .= "WHERE IdRol = '".$s_IdRol."' ";
        $s_SQLQuery .= "AND IdTarea = '".$s_IdTarea."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_TareaRolBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_TareaRolBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_TareaRolBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRol() ) ) $s_SQLQuery .= "SEG_TareaRol.IdRol = '".$this->getIdRol()."' AND ";
        if ( !is_null( $this->getIdTarea() ) ) $s_SQLQuery .= "SEG_TareaRol.IdTarea = '".$this->getIdTarea()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_TareaRol.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_TareaRol.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_TareaRol.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_TareaRol.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_TareaRol WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_TareaRolBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_TareaRol WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_TareaRolBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_TareaRolBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_TareaRolBN[] = $o_SEG_TareaRolBN;
            }
        }
        return $a_SEG_TareaRolBN;
    }

    /* Devuelve un objeto SEG_TareaRolBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_TareaRol )
    {
        $o_SEG_TareaRolBN = new SEG_TareaRolBN();
        if ( !is_null( $a_SEG_TareaRol['IdRol'] ) ) $o_SEG_TareaRolBN->setIdRol( $a_SEG_TareaRol['IdRol'] );
        if ( !is_null( $a_SEG_TareaRol['IdTarea'] ) ) $o_SEG_TareaRolBN->setIdTarea( $a_SEG_TareaRol['IdTarea'] );
        if ( !is_null( $a_SEG_TareaRol['FechaCreacion'] ) ) $o_SEG_TareaRolBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_TareaRol['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_TareaRol['UsuarioCreacion'] ) ) $o_SEG_TareaRolBN->setUsuarioCreacion( $a_SEG_TareaRol['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_TareaRol['FechaModificacion'] ) ) $o_SEG_TareaRolBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_TareaRol['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_TareaRol['UsuarioModificacion'] ) ) $o_SEG_TareaRolBN->setUsuarioModificacion( $a_SEG_TareaRol['UsuarioModificacion'] );
        return $o_SEG_TareaRolBN;
    }
}
?>