<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_SucursalUsuario.xml */
/* Generado: 2024-11-12 17:32:16 */

/* Busqueda de registros de la tabla SEG_SucursalUsuario. */
abstract class BaseSEG_SucursalUsuarioFN extends SEG_SucursalUsuarioBN
{
    /* Declaracion de constantes */
    const IdUsuario = "SEG_SucursalUsuario.IdUsuario";
    const IdSucursal = "SEG_SucursalUsuario.IdSucursal";
    const IdCompania = "SEG_SucursalUsuario.IdCompania";
    const IdAlmacen = "SEG_SucursalUsuario.IdAlmacen";
    const Estado = "SEG_SucursalUsuario.Estado";
    const FechaCreacion = "SEG_SucursalUsuario.FechaCreacion";
    const UsuarioCreacion = "SEG_SucursalUsuario.UsuarioCreacion";
    const FechaModificacion = "SEG_SucursalUsuario.FechaModificacion";
    const UsuarioModificacion = "SEG_SucursalUsuario.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_SucursalUsuario.IdUsuario AS IdUsuario, ";
        $s_SQLQuery .= "SEG_SucursalUsuario.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "SEG_SucursalUsuario.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SEG_SucursalUsuario.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "SEG_SucursalUsuario.Estado AS Estado, ";
        $s_SQLQuery .= "SEG_SucursalUsuario.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_SucursalUsuario.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_SucursalUsuario.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_SucursalUsuario.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_SucursalUsuarioBN */
    public function setByBN( SEG_SucursalUsuarioBN $o_SEG_SucursalUsuarioBN )
    {
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_SEG_SucursalUsuarioBN->getIdUsuario() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SEG_SucursalUsuarioBN->getIdSucursal() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SEG_SucursalUsuarioBN->getIdCompania() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_SEG_SucursalUsuarioBN->getIdAlmacen() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getEstado() ) )
        {
            $this->setEstado( $o_SEG_SucursalUsuarioBN->getEstado() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_SucursalUsuarioBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_SucursalUsuarioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_SucursalUsuarioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_SucursalUsuarioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_SucursalUsuarioBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_SucursalUsuarioBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdUsuario, $i_IdSucursal )
    {
        if( is_null( $s_IdUsuario ) ){ $s_IdUsuario = '-1'; } 
        if( is_null( $i_IdSucursal ) ){ $i_IdSucursal = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_SucursalUsuario ";
        $s_SQLQuery .= "WHERE IdUsuario = '".$s_IdUsuario."' ";
        $s_SQLQuery .= "AND IdSucursal = ".$i_IdSucursal." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_SucursalUsuarioBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_SucursalUsuarioBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_SucursalUsuarioBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdUsuario() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.IdUsuario = '".$this->getIdUsuario()."' AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_SucursalUsuario.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_SucursalUsuario WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_SucursalUsuarioBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_SucursalUsuario WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_SucursalUsuarioBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_SucursalUsuarioBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_SucursalUsuarioBN[] = $o_SEG_SucursalUsuarioBN;
            }
        }
        return $a_SEG_SucursalUsuarioBN;
    }

    /* Devuelve un objeto SEG_SucursalUsuarioBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_SucursalUsuario )
    {
        $o_SEG_SucursalUsuarioBN = new SEG_SucursalUsuarioBN();
        if ( !is_null( $a_SEG_SucursalUsuario['IdUsuario'] ) ) $o_SEG_SucursalUsuarioBN->setIdUsuario( $a_SEG_SucursalUsuario['IdUsuario'] );
        if ( !is_null( $a_SEG_SucursalUsuario['IdSucursal'] ) ) $o_SEG_SucursalUsuarioBN->setIdSucursal( ( integer ) $a_SEG_SucursalUsuario['IdSucursal'] );
        if ( !is_null( $a_SEG_SucursalUsuario['IdCompania'] ) ) $o_SEG_SucursalUsuarioBN->setIdCompania( ( integer ) $a_SEG_SucursalUsuario['IdCompania'] );
        if ( !is_null( $a_SEG_SucursalUsuario['IdAlmacen'] ) ) $o_SEG_SucursalUsuarioBN->setIdAlmacen( $a_SEG_SucursalUsuario['IdAlmacen'] );
        if ( !is_null( $a_SEG_SucursalUsuario['Estado'] ) ) $o_SEG_SucursalUsuarioBN->setEstado( $a_SEG_SucursalUsuario['Estado'] );
        if ( !is_null( $a_SEG_SucursalUsuario['FechaCreacion'] ) ) $o_SEG_SucursalUsuarioBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_SucursalUsuario['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_SucursalUsuario['UsuarioCreacion'] ) ) $o_SEG_SucursalUsuarioBN->setUsuarioCreacion( $a_SEG_SucursalUsuario['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_SucursalUsuario['FechaModificacion'] ) ) $o_SEG_SucursalUsuarioBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_SucursalUsuario['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_SucursalUsuario['UsuarioModificacion'] ) ) $o_SEG_SucursalUsuarioBN->setUsuarioModificacion( $a_SEG_SucursalUsuario['UsuarioModificacion'] );
        return $o_SEG_SucursalUsuarioBN;
    }
}
?>