<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_SubSistema.xml */
/* Generado: 2022-04-18 21:15:03 */

/* Busqueda de registros de la tabla SEG_SubSistema. */
abstract class BaseSEG_SubSistemaFN extends SEG_SubSistemaBN
{
    /* Declaracion de constantes */
    const IdSubSistema = "SEG_SubSistema.IdSubSistema";
    const SubSistemaDescripcion = "SEG_SubSistema.SubSistemaDescripcion";
    const SubSistemaDir = "SEG_SubSistema.SubSistemaDir";
    const TareaPrefijo = "SEG_SubSistema.TareaPrefijo";
    const FechaCreacion = "SEG_SubSistema.FechaCreacion";
    const UsuarioCreacion = "SEG_SubSistema.UsuarioCreacion";
    const FechaModificacion = "SEG_SubSistema.FechaModificacion";
    const UsuarioModificacion = "SEG_SubSistema.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_SubSistema.IdSubSistema AS IdSubSistema, ";
        $s_SQLQuery .= "SEG_SubSistema.SubSistemaDescripcion AS SubSistemaDescripcion, ";
        $s_SQLQuery .= "SEG_SubSistema.SubSistemaDir AS SubSistemaDir, ";
        $s_SQLQuery .= "SEG_SubSistema.TareaPrefijo AS TareaPrefijo, ";
        $s_SQLQuery .= "SEG_SubSistema.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_SubSistema.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_SubSistema.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_SubSistema.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_SubSistemaBN */
    public function setByBN( SEG_SubSistemaBN $o_SEG_SubSistemaBN )
    {
        if ( !is_null( $o_SEG_SubSistemaBN->getIdSubSistema() ) )
        {
            $this->setIdSubSistema( $o_SEG_SubSistemaBN->getIdSubSistema() );
        }
        if ( !is_null( $o_SEG_SubSistemaBN->getSubSistemaDescripcion() ) )
        {
            $this->setSubSistemaDescripcion( $o_SEG_SubSistemaBN->getSubSistemaDescripcion() );
        }
        if ( !is_null( $o_SEG_SubSistemaBN->getSubSistemaDir() ) )
        {
            $this->setSubSistemaDir( $o_SEG_SubSistemaBN->getSubSistemaDir() );
        }
        if ( !is_null( $o_SEG_SubSistemaBN->getTareaPrefijo() ) )
        {
            $this->setTareaPrefijo( $o_SEG_SubSistemaBN->getTareaPrefijo() );
        }
        if ( !is_null( $o_SEG_SubSistemaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_SubSistemaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_SubSistemaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_SubSistemaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_SubSistemaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_SubSistemaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_SubSistemaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_SubSistemaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_SubSistemaBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdSubSistema )
    {
        if( is_null( $s_IdSubSistema ) ){ $s_IdSubSistema = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_SubSistema ";
        $s_SQLQuery .= "WHERE IdSubSistema = '".$s_IdSubSistema."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_SubSistemaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_SubSistemaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_SubSistemaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdSubSistema() ) ) $s_SQLQuery .= "SEG_SubSistema.IdSubSistema = '".$this->getIdSubSistema()."' AND ";
        if ( !is_null( $this->getSubSistemaDescripcion() ) ) $s_SQLQuery .= "SEG_SubSistema.SubSistemaDescripcion = '".$this->getSubSistemaDescripcion()."' AND ";
        if ( !is_null( $this->getSubSistemaDir() ) ) $s_SQLQuery .= "SEG_SubSistema.SubSistemaDir = '".$this->getSubSistemaDir()."' AND ";
        if ( !is_null( $this->getTareaPrefijo() ) ) $s_SQLQuery .= "SEG_SubSistema.TareaPrefijo = '".$this->getTareaPrefijo()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_SubSistema.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_SubSistema.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_SubSistema.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_SubSistema.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_SubSistema WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_SubSistemaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_SubSistema WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_SubSistemaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_SubSistemaBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_SubSistemaBN[] = $o_SEG_SubSistemaBN;
            }
        }
        return $a_SEG_SubSistemaBN;
    }

    /* Devuelve un objeto SEG_SubSistemaBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_SubSistema )
    {
        $o_SEG_SubSistemaBN = new SEG_SubSistemaBN();
        if ( !is_null( $a_SEG_SubSistema['IdSubSistema'] ) ) $o_SEG_SubSistemaBN->setIdSubSistema( $a_SEG_SubSistema['IdSubSistema'] );
        if ( !is_null( $a_SEG_SubSistema['SubSistemaDescripcion'] ) ) $o_SEG_SubSistemaBN->setSubSistemaDescripcion( $a_SEG_SubSistema['SubSistemaDescripcion'] );
        if ( !is_null( $a_SEG_SubSistema['SubSistemaDir'] ) ) $o_SEG_SubSistemaBN->setSubSistemaDir( $a_SEG_SubSistema['SubSistemaDir'] );
        if ( !is_null( $a_SEG_SubSistema['TareaPrefijo'] ) ) $o_SEG_SubSistemaBN->setTareaPrefijo( $a_SEG_SubSistema['TareaPrefijo'] );
        if ( !is_null( $a_SEG_SubSistema['FechaCreacion'] ) ) $o_SEG_SubSistemaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_SubSistema['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_SubSistema['UsuarioCreacion'] ) ) $o_SEG_SubSistemaBN->setUsuarioCreacion( $a_SEG_SubSistema['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_SubSistema['FechaModificacion'] ) ) $o_SEG_SubSistemaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_SubSistema['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_SubSistema['UsuarioModificacion'] ) ) $o_SEG_SubSistemaBN->setUsuarioModificacion( $a_SEG_SubSistema['UsuarioModificacion'] );
        return $o_SEG_SubSistemaBN;
    }
}
?>