<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: RegistroHistorial.xml */
/* Generado: 2022-04-18 21:15:02 */

/* Busqueda de registros de la tabla RegistroHistorial. */
abstract class BaseRegistroHistorialFN extends RegistroHistorialBN
{
    /* Declaracion de constantes */
    const IdLog = "RegistroHistorial.IdLog";
    const IdCompania = "RegistroHistorial.IdCompania";
    const IdSucursal = "RegistroHistorial.IdSucursal";
    const BaseDatos = "RegistroHistorial.BaseDatos";
    const Tabla = "RegistroHistorial.Tabla";
    const IdFecha = "RegistroHistorial.IdFecha";
    const IdDocumento = "RegistroHistorial.IdDocumento";
    const IdCampo = "RegistroHistorial.IdCampo";
    const CampoValor = "RegistroHistorial.CampoValor";
    const CampoDescripcion = "RegistroHistorial.CampoDescripcion";
    const Modulo = "RegistroHistorial.Modulo";
    const IP = "RegistroHistorial.IP";
    const ValorAnterior = "RegistroHistorial.ValorAnterior";
    const ValorNuevo = "RegistroHistorial.ValorNuevo";
    const UsuarioCreacion = "RegistroHistorial.UsuarioCreacion";
    const FechaCreacion = "RegistroHistorial.FechaCreacion";
    const UsuarioModificacion = "RegistroHistorial.UsuarioModificacion";
    const FechaModificacion = "RegistroHistorial.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "RegistroHistorial.IdLog AS IdLog, ";
        $s_SQLQuery .= "RegistroHistorial.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "RegistroHistorial.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "RegistroHistorial.BaseDatos AS BaseDatos, ";
        $s_SQLQuery .= "RegistroHistorial.Tabla AS Tabla, ";
        $s_SQLQuery .= "RegistroHistorial.IdFecha AS IdFecha, ";
        $s_SQLQuery .= "RegistroHistorial.IdDocumento AS IdDocumento, ";
        $s_SQLQuery .= "RegistroHistorial.IdCampo AS IdCampo, ";
        $s_SQLQuery .= "RegistroHistorial.CampoValor AS CampoValor, ";
        $s_SQLQuery .= "RegistroHistorial.CampoDescripcion AS CampoDescripcion, ";
        $s_SQLQuery .= "RegistroHistorial.Modulo AS Modulo, ";
        $s_SQLQuery .= "RegistroHistorial.IP AS IP, ";
        $s_SQLQuery .= "RegistroHistorial.ValorAnterior AS ValorAnterior, ";
        $s_SQLQuery .= "RegistroHistorial.ValorNuevo AS ValorNuevo, ";
        $s_SQLQuery .= "RegistroHistorial.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "RegistroHistorial.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "RegistroHistorial.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "RegistroHistorial.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto RegistroHistorialBN */
    public function setByBN( RegistroHistorialBN $o_RegistroHistorialBN )
    {
        if ( !is_null( $o_RegistroHistorialBN->getIdLog() ) )
        {
            $this->setIdLog( $o_RegistroHistorialBN->getIdLog() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_RegistroHistorialBN->getIdCompania() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_RegistroHistorialBN->getIdSucursal() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getBaseDatos() ) )
        {
            $this->setBaseDatos( $o_RegistroHistorialBN->getBaseDatos() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getTabla() ) )
        {
            $this->setTabla( $o_RegistroHistorialBN->getTabla() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdFecha() ) )
        {
            $this->setIdFecha( $o_RegistroHistorialBN->getIdFecha() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdDocumento() ) )
        {
            $this->setIdDocumento( $o_RegistroHistorialBN->getIdDocumento() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIdCampo() ) )
        {
            $this->setIdCampo( $o_RegistroHistorialBN->getIdCampo() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getCampoValor() ) )
        {
            $this->setCampoValor( $o_RegistroHistorialBN->getCampoValor() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getCampoDescripcion() ) )
        {
            $this->setCampoDescripcion( $o_RegistroHistorialBN->getCampoDescripcion() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getModulo() ) )
        {
            $this->setModulo( $o_RegistroHistorialBN->getModulo() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getIP() ) )
        {
            $this->setIP( $o_RegistroHistorialBN->getIP() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getValorAnterior() ) )
        {
            $this->setValorAnterior( $o_RegistroHistorialBN->getValorAnterior() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getValorNuevo() ) )
        {
            $this->setValorNuevo( $o_RegistroHistorialBN->getValorNuevo() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_RegistroHistorialBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_RegistroHistorialBN->getFechaCreacion() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_RegistroHistorialBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_RegistroHistorialBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_RegistroHistorialBN->getFechaModificacion() );
        }
    }

    /**
    * @return RegistroHistorialBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdLog )
    {
        if( is_null( $i_IdLog ) ){ $i_IdLog = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM RegistroHistorial ";
        $s_SQLQuery .= "WHERE IdLog = ".$i_IdLog." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_RegistroHistorialBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_RegistroHistorialBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_RegistroHistorialBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdLog() ) ) $s_SQLQuery .= "RegistroHistorial.IdLog = ".$this->getIdLog()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "RegistroHistorial.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "RegistroHistorial.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getBaseDatos() ) ) $s_SQLQuery .= "RegistroHistorial.BaseDatos = '".$this->getBaseDatos()."' AND ";
        if ( !is_null( $this->getTabla() ) ) $s_SQLQuery .= "RegistroHistorial.Tabla = '".$this->getTabla()."' AND ";
        if ( !is_null( $this->getIdFecha() ) ) $s_SQLQuery .= "RegistroHistorial.IdFecha = '".$this->getIdFecha()."' AND ";
        if ( !is_null( $this->getIdDocumento() ) ) $s_SQLQuery .= "RegistroHistorial.IdDocumento = '".$this->getIdDocumento()."' AND ";
        if ( !is_null( $this->getIdCampo() ) ) $s_SQLQuery .= "RegistroHistorial.IdCampo = '".$this->getIdCampo()."' AND ";
        if ( !is_null( $this->getCampoValor() ) ) $s_SQLQuery .= "RegistroHistorial.CampoValor = '".$this->getCampoValor()."' AND ";
        if ( !is_null( $this->getCampoDescripcion() ) ) $s_SQLQuery .= "RegistroHistorial.CampoDescripcion = '".$this->getCampoDescripcion()."' AND ";
        if ( !is_null( $this->getModulo() ) ) $s_SQLQuery .= "RegistroHistorial.Modulo = '".$this->getModulo()."' AND ";
        if ( !is_null( $this->getIP() ) ) $s_SQLQuery .= "RegistroHistorial.IP = '".$this->getIP()."' AND ";
        if ( !is_null( $this->getValorAnterior() ) ) $s_SQLQuery .= "RegistroHistorial.ValorAnterior = '".$this->getValorAnterior()."' AND ";
        if ( !is_null( $this->getValorNuevo() ) ) $s_SQLQuery .= "RegistroHistorial.ValorNuevo = '".$this->getValorNuevo()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "RegistroHistorial.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "RegistroHistorial.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "RegistroHistorial.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "RegistroHistorial.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM RegistroHistorial WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return RegistroHistorialBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM RegistroHistorial WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_RegistroHistorialBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_RegistroHistorialBN = $this->insertObjectBN( $a_SQLRow );
                $a_RegistroHistorialBN[] = $o_RegistroHistorialBN;
            }
        }
        return $a_RegistroHistorialBN;
    }

    /* Devuelve un objeto RegistroHistorialBN desde un objeto propel */
    public function insertObjectBN( $a_RegistroHistorial )
    {
        $o_RegistroHistorialBN = new RegistroHistorialBN();
        if ( !is_null( $a_RegistroHistorial['IdLog'] ) ) $o_RegistroHistorialBN->setIdLog( ( integer ) $a_RegistroHistorial['IdLog'] );
        if ( !is_null( $a_RegistroHistorial['IdCompania'] ) ) $o_RegistroHistorialBN->setIdCompania( ( integer ) $a_RegistroHistorial['IdCompania'] );
        if ( !is_null( $a_RegistroHistorial['IdSucursal'] ) ) $o_RegistroHistorialBN->setIdSucursal( ( integer ) $a_RegistroHistorial['IdSucursal'] );
        if ( !is_null( $a_RegistroHistorial['BaseDatos'] ) ) $o_RegistroHistorialBN->setBaseDatos( $a_RegistroHistorial['BaseDatos'] );
        if ( !is_null( $a_RegistroHistorial['Tabla'] ) ) $o_RegistroHistorialBN->setTabla( $a_RegistroHistorial['Tabla'] );
        if ( !is_null( $a_RegistroHistorial['IdFecha'] ) ) $o_RegistroHistorialBN->setIdFecha( utilTimestamp::getTimestamp( $a_RegistroHistorial['IdFecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_RegistroHistorial['IdDocumento'] ) ) $o_RegistroHistorialBN->setIdDocumento( $a_RegistroHistorial['IdDocumento'] );
        if ( !is_null( $a_RegistroHistorial['IdCampo'] ) ) $o_RegistroHistorialBN->setIdCampo( $a_RegistroHistorial['IdCampo'] );
        if ( !is_null( $a_RegistroHistorial['CampoValor'] ) ) $o_RegistroHistorialBN->setCampoValor( $a_RegistroHistorial['CampoValor'] );
        if ( !is_null( $a_RegistroHistorial['CampoDescripcion'] ) ) $o_RegistroHistorialBN->setCampoDescripcion( $a_RegistroHistorial['CampoDescripcion'] );
        if ( !is_null( $a_RegistroHistorial['Modulo'] ) ) $o_RegistroHistorialBN->setModulo( $a_RegistroHistorial['Modulo'] );
        if ( !is_null( $a_RegistroHistorial['IP'] ) ) $o_RegistroHistorialBN->setIP( $a_RegistroHistorial['IP'] );
        if ( !is_null( $a_RegistroHistorial['ValorAnterior'] ) ) $o_RegistroHistorialBN->setValorAnterior( $a_RegistroHistorial['ValorAnterior'] );
        if ( !is_null( $a_RegistroHistorial['ValorNuevo'] ) ) $o_RegistroHistorialBN->setValorNuevo( $a_RegistroHistorial['ValorNuevo'] );
        if ( !is_null( $a_RegistroHistorial['UsuarioCreacion'] ) ) $o_RegistroHistorialBN->setUsuarioCreacion( $a_RegistroHistorial['UsuarioCreacion'] );
        if ( !is_null( $a_RegistroHistorial['FechaCreacion'] ) ) $o_RegistroHistorialBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_RegistroHistorial['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_RegistroHistorial['UsuarioModificacion'] ) ) $o_RegistroHistorialBN->setUsuarioModificacion( $a_RegistroHistorial['UsuarioModificacion'] );
        if ( !is_null( $a_RegistroHistorial['FechaModificacion'] ) ) $o_RegistroHistorialBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_RegistroHistorial['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_RegistroHistorialBN;
    }
}
?>