<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRO_CierreMensual.xml */
/* Generado: 2022-04-18 21:15:02 */

/* Busqueda de registros de la tabla PRO_CierreMensual. */
abstract class BasePRO_CierreMensualFN extends PRO_CierreMensualBN
{
    /* Declaracion de constantes */
    const IdCompania = "PRO_CierreMensual.IdCompania";
    const IdPeriodo = "PRO_CierreMensual.IdPeriodo";
    const Anio = "PRO_CierreMensual.Anio";
    const Mes = "PRO_CierreMensual.Mes";
    const Estado = "PRO_CierreMensual.Estado";
    const Comentario = "PRO_CierreMensual.Comentario";
    const FechaCreacion = "PRO_CierreMensual.FechaCreacion";
    const UsuarioCreacion = "PRO_CierreMensual.UsuarioCreacion";
    const UsuarioModificacion = "PRO_CierreMensual.UsuarioModificacion";
    const FechaModificacion = "PRO_CierreMensual.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PRO_CierreMensual.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "PRO_CierreMensual.IdPeriodo AS IdPeriodo, ";
        $s_SQLQuery .= "PRO_CierreMensual.Anio AS Anio, ";
        $s_SQLQuery .= "PRO_CierreMensual.Mes AS Mes, ";
        $s_SQLQuery .= "PRO_CierreMensual.Estado AS Estado, ";
        $s_SQLQuery .= "PRO_CierreMensual.Comentario AS Comentario, ";
        $s_SQLQuery .= "PRO_CierreMensual.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "PRO_CierreMensual.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "PRO_CierreMensual.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PRO_CierreMensual.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PRO_CierreMensualBN */
    public function setByBN( PRO_CierreMensualBN $o_PRO_CierreMensualBN )
    {
        if ( !is_null( $o_PRO_CierreMensualBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_PRO_CierreMensualBN->getIdCompania() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getIdPeriodo() ) )
        {
            $this->setIdPeriodo( $o_PRO_CierreMensualBN->getIdPeriodo() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getAnio() ) )
        {
            $this->setAnio( $o_PRO_CierreMensualBN->getAnio() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getMes() ) )
        {
            $this->setMes( $o_PRO_CierreMensualBN->getMes() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getEstado() ) )
        {
            $this->setEstado( $o_PRO_CierreMensualBN->getEstado() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getComentario() ) )
        {
            $this->setComentario( $o_PRO_CierreMensualBN->getComentario() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PRO_CierreMensualBN->getFechaCreacion() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PRO_CierreMensualBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRO_CierreMensualBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRO_CierreMensualBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRO_CierreMensualBN->getFechaModificacion() );
        }
    }

    /**
    * @return PRO_CierreMensualBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdCompania, $s_IdPeriodo )
    {
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_IdPeriodo ) ){ $s_IdPeriodo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRO_CierreMensual ";
        $s_SQLQuery .= "WHERE IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND IdPeriodo = '".$s_IdPeriodo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_PRO_CierreMensualBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PRO_CierreMensualBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PRO_CierreMensualBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "PRO_CierreMensual.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdPeriodo() ) ) $s_SQLQuery .= "PRO_CierreMensual.IdPeriodo = '".$this->getIdPeriodo()."' AND ";
        if ( !is_null( $this->getAnio() ) ) $s_SQLQuery .= "PRO_CierreMensual.Anio = '".$this->getAnio()."' AND ";
        if ( !is_null( $this->getMes() ) ) $s_SQLQuery .= "PRO_CierreMensual.Mes = '".$this->getMes()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PRO_CierreMensual.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "PRO_CierreMensual.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "PRO_CierreMensual.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "PRO_CierreMensual.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PRO_CierreMensual.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PRO_CierreMensual.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PRO_CierreMensual WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PRO_CierreMensualBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRO_CierreMensual WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_PRO_CierreMensualBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PRO_CierreMensualBN = $this->insertObjectBN( $a_SQLRow );
                $a_PRO_CierreMensualBN[] = $o_PRO_CierreMensualBN;
            }
        }
        return $a_PRO_CierreMensualBN;
    }

    /* Devuelve un objeto PRO_CierreMensualBN desde un objeto propel */
    public function insertObjectBN( $a_PRO_CierreMensual )
    {
        $o_PRO_CierreMensualBN = new PRO_CierreMensualBN();
        if ( !is_null( $a_PRO_CierreMensual['IdCompania'] ) ) $o_PRO_CierreMensualBN->setIdCompania( ( integer ) $a_PRO_CierreMensual['IdCompania'] );
        if ( !is_null( $a_PRO_CierreMensual['IdPeriodo'] ) ) $o_PRO_CierreMensualBN->setIdPeriodo( $a_PRO_CierreMensual['IdPeriodo'] );
        if ( !is_null( $a_PRO_CierreMensual['Anio'] ) ) $o_PRO_CierreMensualBN->setAnio( $a_PRO_CierreMensual['Anio'] );
        if ( !is_null( $a_PRO_CierreMensual['Mes'] ) ) $o_PRO_CierreMensualBN->setMes( $a_PRO_CierreMensual['Mes'] );
        if ( !is_null( $a_PRO_CierreMensual['Estado'] ) ) $o_PRO_CierreMensualBN->setEstado( $a_PRO_CierreMensual['Estado'] );
        if ( !is_null( $a_PRO_CierreMensual['Comentario'] ) ) $o_PRO_CierreMensualBN->setComentario( $a_PRO_CierreMensual['Comentario'] );
        if ( !is_null( $a_PRO_CierreMensual['FechaCreacion'] ) ) $o_PRO_CierreMensualBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_PRO_CierreMensual['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PRO_CierreMensual['UsuarioCreacion'] ) ) $o_PRO_CierreMensualBN->setUsuarioCreacion( $a_PRO_CierreMensual['UsuarioCreacion'] );
        if ( !is_null( $a_PRO_CierreMensual['UsuarioModificacion'] ) ) $o_PRO_CierreMensualBN->setUsuarioModificacion( $a_PRO_CierreMensual['UsuarioModificacion'] );
        if ( !is_null( $a_PRO_CierreMensual['FechaModificacion'] ) ) $o_PRO_CierreMensualBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PRO_CierreMensual['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_PRO_CierreMensualBN;
    }
}
?>