<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_ServicioExterno.xml */
/* Generado: 2022-04-18 21:15:02 */

/* Busqueda de registros de la tabla PRD_ServicioExterno. */
abstract class BasePRD_ServicioExternoFN extends PRD_ServicioExternoBN
{
    /* Declaracion de constantes */
    const IdServExt = "PRD_ServicioExterno.IdServExt";
    const Descripcion = "PRD_ServicioExterno.Descripcion";
    const Estado = "PRD_ServicioExterno.Estado";
    const UsuarioRegistro = "PRD_ServicioExterno.UsuarioRegistro";
    const FechaRegistro = "PRD_ServicioExterno.FechaRegistro";
    const UsuarioModificacion = "PRD_ServicioExterno.UsuarioModificacion";
    const FechaModificacion = "PRD_ServicioExterno.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PRD_ServicioExterno.IdServExt AS IdServExt, ";
        $s_SQLQuery .= "PRD_ServicioExterno.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "PRD_ServicioExterno.Estado AS Estado, ";
        $s_SQLQuery .= "PRD_ServicioExterno.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "PRD_ServicioExterno.FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "PRD_ServicioExterno.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PRD_ServicioExterno.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PRD_ServicioExternoBN */
    public function setByBN( PRD_ServicioExternoBN $o_PRD_ServicioExternoBN )
    {
        if ( !is_null( $o_PRD_ServicioExternoBN->getIdServExt() ) )
        {
            $this->setIdServExt( $o_PRD_ServicioExternoBN->getIdServExt() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PRD_ServicioExternoBN->getDescripcion() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getEstado() ) )
        {
            $this->setEstado( $o_PRD_ServicioExternoBN->getEstado() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_PRD_ServicioExternoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_PRD_ServicioExternoBN->getFechaRegistro() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRD_ServicioExternoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRD_ServicioExternoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRD_ServicioExternoBN->getFechaModificacion() );
        }
    }

    /**
    * @return PRD_ServicioExternoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdServExt )
    {
        if( is_null( $i_IdServExt ) ){ $i_IdServExt = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_ServicioExterno ";
        $s_SQLQuery .= "WHERE IdServExt = ".$i_IdServExt." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_PRD_ServicioExternoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PRD_ServicioExternoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PRD_ServicioExternoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdServExt() ) ) $s_SQLQuery .= "PRD_ServicioExterno.IdServExt = ".$this->getIdServExt()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "PRD_ServicioExterno.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PRD_ServicioExterno.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "PRD_ServicioExterno.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "PRD_ServicioExterno.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PRD_ServicioExterno.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PRD_ServicioExterno.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PRD_ServicioExterno WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PRD_ServicioExternoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_ServicioExterno WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_PRD_ServicioExternoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PRD_ServicioExternoBN = $this->insertObjectBN( $a_SQLRow );
                $a_PRD_ServicioExternoBN[] = $o_PRD_ServicioExternoBN;
            }
        }
        return $a_PRD_ServicioExternoBN;
    }

    /* Devuelve un objeto PRD_ServicioExternoBN desde un objeto propel */
    public function insertObjectBN( $a_PRD_ServicioExterno )
    {
        $o_PRD_ServicioExternoBN = new PRD_ServicioExternoBN();
        if ( !is_null( $a_PRD_ServicioExterno['IdServExt'] ) ) $o_PRD_ServicioExternoBN->setIdServExt( ( integer ) $a_PRD_ServicioExterno['IdServExt'] );
        if ( !is_null( $a_PRD_ServicioExterno['Descripcion'] ) ) $o_PRD_ServicioExternoBN->setDescripcion( $a_PRD_ServicioExterno['Descripcion'] );
        if ( !is_null( $a_PRD_ServicioExterno['Estado'] ) ) $o_PRD_ServicioExternoBN->setEstado( $a_PRD_ServicioExterno['Estado'] );
        if ( !is_null( $a_PRD_ServicioExterno['UsuarioRegistro'] ) ) $o_PRD_ServicioExternoBN->setUsuarioRegistro( $a_PRD_ServicioExterno['UsuarioRegistro'] );
        if ( !is_null( $a_PRD_ServicioExterno['FechaRegistro'] ) ) $o_PRD_ServicioExternoBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_PRD_ServicioExterno['FechaRegistro'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PRD_ServicioExterno['UsuarioModificacion'] ) ) $o_PRD_ServicioExternoBN->setUsuarioModificacion( $a_PRD_ServicioExterno['UsuarioModificacion'] );
        if ( !is_null( $a_PRD_ServicioExterno['FechaModificacion'] ) ) $o_PRD_ServicioExternoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PRD_ServicioExterno['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_PRD_ServicioExternoBN;
    }
}
?>