<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_MarcacionRegistro.xml */
/* Generado: 2022-04-18 21:15:01 */

/* Busqueda de registros de la tabla PLA_MarcacionRegistro. */
abstract class BasePLA_MarcacionRegistroFN extends PLA_MarcacionRegistroBN
{
    /* Declaracion de constantes */
    const IdRegistro = "PLA_MarcacionRegistro.IdRegistro";
    const Descripcion = "PLA_MarcacionRegistro.Descripcion";
    const Secuencia = "PLA_MarcacionRegistro.Secuencia";
    const Estado = "PLA_MarcacionRegistro.Estado";
    const ObligatorioFlag = "PLA_MarcacionRegistro.ObligatorioFlag";
    const IdEquivalente = "PLA_MarcacionRegistro.IdEquivalente";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PLA_MarcacionRegistro.IdRegistro AS IdRegistro, ";
        $s_SQLQuery .= "PLA_MarcacionRegistro.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "PLA_MarcacionRegistro.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "PLA_MarcacionRegistro.Estado AS Estado, ";
        $s_SQLQuery .= "PLA_MarcacionRegistro.ObligatorioFlag AS ObligatorioFlag, ";
        $s_SQLQuery .= "PLA_MarcacionRegistro.IdEquivalente AS IdEquivalente ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PLA_MarcacionRegistroBN */
    public function setByBN( PLA_MarcacionRegistroBN $o_PLA_MarcacionRegistroBN )
    {
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getIdRegistro() ) )
        {
            $this->setIdRegistro( $o_PLA_MarcacionRegistroBN->getIdRegistro() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_PLA_MarcacionRegistroBN->getDescripcion() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_PLA_MarcacionRegistroBN->getSecuencia() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getEstado() ) )
        {
            $this->setEstado( $o_PLA_MarcacionRegistroBN->getEstado() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getObligatorioFlag() ) )
        {
            $this->setObligatorioFlag( $o_PLA_MarcacionRegistroBN->getObligatorioFlag() );
        }
        if ( !is_null( $o_PLA_MarcacionRegistroBN->getIdEquivalente() ) )
        {
            $this->setIdEquivalente( $o_PLA_MarcacionRegistroBN->getIdEquivalente() );
        }
    }

    /**
    * @return PLA_MarcacionRegistroBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdRegistro )
    {
        if( is_null( $s_IdRegistro ) ){ $s_IdRegistro = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_MarcacionRegistro ";
        $s_SQLQuery .= "WHERE IdRegistro = '".$s_IdRegistro."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_PLA_MarcacionRegistroBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PLA_MarcacionRegistroBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PLA_MarcacionRegistroBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRegistro() ) ) $s_SQLQuery .= "PLA_MarcacionRegistro.IdRegistro = '".$this->getIdRegistro()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "PLA_MarcacionRegistro.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "PLA_MarcacionRegistro.Secuencia = ".$this->getSecuencia()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "PLA_MarcacionRegistro.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getObligatorioFlag() ) ) $s_SQLQuery .= "PLA_MarcacionRegistro.ObligatorioFlag = ".$this->getObligatorioFlag()." AND ";
        if ( !is_null( $this->getIdEquivalente() ) ) $s_SQLQuery .= "PLA_MarcacionRegistro.IdEquivalente = ".$this->getIdEquivalente()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PLA_MarcacionRegistro WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PLA_MarcacionRegistroBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PLA_MarcacionRegistro WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_PLA_MarcacionRegistroBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PLA_MarcacionRegistroBN = $this->insertObjectBN( $a_SQLRow );
                $a_PLA_MarcacionRegistroBN[] = $o_PLA_MarcacionRegistroBN;
            }
        }
        return $a_PLA_MarcacionRegistroBN;
    }

    /* Devuelve un objeto PLA_MarcacionRegistroBN desde un objeto propel */
    public function insertObjectBN( $a_PLA_MarcacionRegistro )
    {
        $o_PLA_MarcacionRegistroBN = new PLA_MarcacionRegistroBN();
        if ( !is_null( $a_PLA_MarcacionRegistro['IdRegistro'] ) ) $o_PLA_MarcacionRegistroBN->setIdRegistro( $a_PLA_MarcacionRegistro['IdRegistro'] );
        if ( !is_null( $a_PLA_MarcacionRegistro['Descripcion'] ) ) $o_PLA_MarcacionRegistroBN->setDescripcion( $a_PLA_MarcacionRegistro['Descripcion'] );
        if ( !is_null( $a_PLA_MarcacionRegistro['Secuencia'] ) ) $o_PLA_MarcacionRegistroBN->setSecuencia( ( integer ) $a_PLA_MarcacionRegistro['Secuencia'] );
        if ( !is_null( $a_PLA_MarcacionRegistro['Estado'] ) ) $o_PLA_MarcacionRegistroBN->setEstado( $a_PLA_MarcacionRegistro['Estado'] );
        if ( !is_null( $a_PLA_MarcacionRegistro['ObligatorioFlag'] ) ) $o_PLA_MarcacionRegistroBN->setObligatorioFlag( ( integer ) $a_PLA_MarcacionRegistro['ObligatorioFlag'] );
        if ( !is_null( $a_PLA_MarcacionRegistro['IdEquivalente'] ) ) $o_PLA_MarcacionRegistroBN->setIdEquivalente( ( integer ) $a_PLA_MarcacionRegistro['IdEquivalente'] );
        return $o_PLA_MarcacionRegistroBN;
    }
}
?>