<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Ubicacion.xml */
/* Generado: 2022-04-18 21:15:01 */

/* Busqueda de registros de la tabla MST_Ubicacion. */
abstract class BaseMST_UbicacionFN extends MST_UbicacionBN
{
    /* Declaracion de constantes */
    const IdUbicacion = "MST_Ubicacion.IdUbicacion";
    const IdCompania = "MST_Ubicacion.IdCompania";
    const IdSucursal = "MST_Ubicacion.IdSucursal";
    const IdUbicacionPertenece = "MST_Ubicacion.IdUbicacionPertenece";
    const IdTipoUbicacion = "MST_Ubicacion.IdTipoUbicacion";
    const IdCategoria = "MST_Ubicacion.IdCategoria";
    const IdPisos = "MST_Ubicacion.IdPisos";
    const TopePersonas = "MST_Ubicacion.TopePersonas";
    const Tolerancia = "MST_Ubicacion.Tolerancia";
    const Nombre = "MST_Ubicacion.Nombre";
    const Descripcion = "MST_Ubicacion.Descripcion";
    const Estado = "MST_Ubicacion.Estado";
    const FechaCreacion = "MST_Ubicacion.FechaCreacion";
    const UsuarioCreacion = "MST_Ubicacion.UsuarioCreacion";
    const FechaModificacion = "MST_Ubicacion.FechaModificacion";
    const UsuarioModificacion = "MST_Ubicacion.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_Ubicacion.IdUbicacion AS IdUbicacion, ";
        $s_SQLQuery .= "MST_Ubicacion.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "MST_Ubicacion.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "MST_Ubicacion.IdUbicacionPertenece AS IdUbicacionPertenece, ";
        $s_SQLQuery .= "MST_Ubicacion.IdTipoUbicacion AS IdTipoUbicacion, ";
        $s_SQLQuery .= "MST_Ubicacion.IdCategoria AS IdCategoria, ";
        $s_SQLQuery .= "MST_Ubicacion.IdPisos AS IdPisos, ";
        $s_SQLQuery .= "MST_Ubicacion.TopePersonas AS TopePersonas, ";
        $s_SQLQuery .= "MST_Ubicacion.Tolerancia AS Tolerancia, ";
        $s_SQLQuery .= "MST_Ubicacion.Nombre AS Nombre, ";
        $s_SQLQuery .= "MST_Ubicacion.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "MST_Ubicacion.Estado AS Estado, ";
        $s_SQLQuery .= "MST_Ubicacion.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "MST_Ubicacion.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "MST_Ubicacion.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "MST_Ubicacion.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_UbicacionBN */
    public function setByBN( MST_UbicacionBN $o_MST_UbicacionBN )
    {
        if ( !is_null( $o_MST_UbicacionBN->getIdUbicacion() ) )
        {
            $this->setIdUbicacion( $o_MST_UbicacionBN->getIdUbicacion() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_MST_UbicacionBN->getIdCompania() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_MST_UbicacionBN->getIdSucursal() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getIdUbicacionPertenece() ) )
        {
            $this->setIdUbicacionPertenece( $o_MST_UbicacionBN->getIdUbicacionPertenece() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getIdTipoUbicacion() ) )
        {
            $this->setIdTipoUbicacion( $o_MST_UbicacionBN->getIdTipoUbicacion() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getIdCategoria() ) )
        {
            $this->setIdCategoria( $o_MST_UbicacionBN->getIdCategoria() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getIdPisos() ) )
        {
            $this->setIdPisos( $o_MST_UbicacionBN->getIdPisos() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getTopePersonas() ) )
        {
            $this->setTopePersonas( $o_MST_UbicacionBN->getTopePersonas() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getTolerancia() ) )
        {
            $this->setTolerancia( $o_MST_UbicacionBN->getTolerancia() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_UbicacionBN->getNombre() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_UbicacionBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_UbicacionBN->getEstado() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_UbicacionBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_UbicacionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_UbicacionBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_UbicacionBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_UbicacionBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return MST_UbicacionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdUbicacion )
    {
        if( is_null( $i_IdUbicacion ) ){ $i_IdUbicacion = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Ubicacion ";
        $s_SQLQuery .= "WHERE IdUbicacion = ".$i_IdUbicacion." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_UbicacionBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_UbicacionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_UbicacionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdUbicacion() ) ) $s_SQLQuery .= "MST_Ubicacion.IdUbicacion = ".$this->getIdUbicacion()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "MST_Ubicacion.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "MST_Ubicacion.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getIdUbicacionPertenece() ) ) $s_SQLQuery .= "MST_Ubicacion.IdUbicacionPertenece = ".$this->getIdUbicacionPertenece()." AND ";
        if ( !is_null( $this->getIdTipoUbicacion() ) ) $s_SQLQuery .= "MST_Ubicacion.IdTipoUbicacion = ".$this->getIdTipoUbicacion()." AND ";
        if ( !is_null( $this->getIdCategoria() ) ) $s_SQLQuery .= "MST_Ubicacion.IdCategoria = ".$this->getIdCategoria()." AND ";
        if ( !is_null( $this->getIdPisos() ) ) $s_SQLQuery .= "MST_Ubicacion.IdPisos = ".$this->getIdPisos()." AND ";
        if ( !is_null( $this->getTopePersonas() ) ) $s_SQLQuery .= "MST_Ubicacion.TopePersonas = ".$this->getTopePersonas()." AND ";
        if ( !is_null( $this->getTolerancia() ) ) $s_SQLQuery .= "MST_Ubicacion.Tolerancia = ".$this->getTolerancia()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "MST_Ubicacion.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_Ubicacion.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "MST_Ubicacion.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "MST_Ubicacion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "MST_Ubicacion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "MST_Ubicacion.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "MST_Ubicacion.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_Ubicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_UbicacionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_Ubicacion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_UbicacionBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_UbicacionBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_UbicacionBN[] = $o_MST_UbicacionBN;
            }
        }
        return $a_MST_UbicacionBN;
    }

    /* Devuelve un objeto MST_UbicacionBN desde un objeto propel */
    public function insertObjectBN( $a_MST_Ubicacion )
    {
        $o_MST_UbicacionBN = new MST_UbicacionBN();
        if ( !is_null( $a_MST_Ubicacion['IdUbicacion'] ) ) $o_MST_UbicacionBN->setIdUbicacion( ( integer ) $a_MST_Ubicacion['IdUbicacion'] );
        if ( !is_null( $a_MST_Ubicacion['IdCompania'] ) ) $o_MST_UbicacionBN->setIdCompania( ( integer ) $a_MST_Ubicacion['IdCompania'] );
        if ( !is_null( $a_MST_Ubicacion['IdSucursal'] ) ) $o_MST_UbicacionBN->setIdSucursal( ( integer ) $a_MST_Ubicacion['IdSucursal'] );
        if ( !is_null( $a_MST_Ubicacion['IdUbicacionPertenece'] ) ) $o_MST_UbicacionBN->setIdUbicacionPertenece( ( integer ) $a_MST_Ubicacion['IdUbicacionPertenece'] );
        if ( !is_null( $a_MST_Ubicacion['IdTipoUbicacion'] ) ) $o_MST_UbicacionBN->setIdTipoUbicacion( ( integer ) $a_MST_Ubicacion['IdTipoUbicacion'] );
        if ( !is_null( $a_MST_Ubicacion['IdCategoria'] ) ) $o_MST_UbicacionBN->setIdCategoria( ( integer ) $a_MST_Ubicacion['IdCategoria'] );
        if ( !is_null( $a_MST_Ubicacion['IdPisos'] ) ) $o_MST_UbicacionBN->setIdPisos( ( integer ) $a_MST_Ubicacion['IdPisos'] );
        if ( !is_null( $a_MST_Ubicacion['TopePersonas'] ) ) $o_MST_UbicacionBN->setTopePersonas( ( integer ) $a_MST_Ubicacion['TopePersonas'] );
        if ( !is_null( $a_MST_Ubicacion['Tolerancia'] ) ) $o_MST_UbicacionBN->setTolerancia( ( integer ) $a_MST_Ubicacion['Tolerancia'] );
        if ( !is_null( $a_MST_Ubicacion['Nombre'] ) ) $o_MST_UbicacionBN->setNombre( $a_MST_Ubicacion['Nombre'] );
        if ( !is_null( $a_MST_Ubicacion['Descripcion'] ) ) $o_MST_UbicacionBN->setDescripcion( $a_MST_Ubicacion['Descripcion'] );
        if ( !is_null( $a_MST_Ubicacion['Estado'] ) ) $o_MST_UbicacionBN->setEstado( $a_MST_Ubicacion['Estado'] );
        if ( !is_null( $a_MST_Ubicacion['FechaCreacion'] ) ) $o_MST_UbicacionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_MST_Ubicacion['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Ubicacion['UsuarioCreacion'] ) ) $o_MST_UbicacionBN->setUsuarioCreacion( $a_MST_Ubicacion['UsuarioCreacion'] );
        if ( !is_null( $a_MST_Ubicacion['FechaModificacion'] ) ) $o_MST_UbicacionBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_MST_Ubicacion['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_MST_Ubicacion['UsuarioModificacion'] ) ) $o_MST_UbicacionBN->setUsuarioModificacion( $a_MST_Ubicacion['UsuarioModificacion'] );
        return $o_MST_UbicacionBN;
    }
}
?>