<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoNotaDebito.xml */
/* Generado: 2022-04-18 21:15:00 */

/* Busqueda de registros de la tabla MST_TipoNotaDebito. */
abstract class BaseMST_TipoNotaDebitoFN extends MST_TipoNotaDebitoBN
{
    /* Declaracion de constantes */
    const Id = "MST_TipoNotaDebito.Id";
    const CodigoSunat = "MST_TipoNotaDebito.CodigoSunat";
    const Descripcion = "MST_TipoNotaDebito.Descripcion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_TipoNotaDebito.Id AS Id, ";
        $s_SQLQuery .= "MST_TipoNotaDebito.CodigoSunat AS CodigoSunat, ";
        $s_SQLQuery .= "MST_TipoNotaDebito.Descripcion AS Descripcion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TipoNotaDebitoBN */
    public function setByBN( MST_TipoNotaDebitoBN $o_MST_TipoNotaDebitoBN )
    {
        if ( !is_null( $o_MST_TipoNotaDebitoBN->getId() ) )
        {
            $this->setId( $o_MST_TipoNotaDebitoBN->getId() );
        }
        if ( !is_null( $o_MST_TipoNotaDebitoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_MST_TipoNotaDebitoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_MST_TipoNotaDebitoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_TipoNotaDebitoBN->getDescripcion() );
        }
    }

    /**
    * @return MST_TipoNotaDebitoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_Id )
    {
        if( is_null( $i_Id ) ){ $i_Id = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoNotaDebito ";
        $s_SQLQuery .= "WHERE Id = ".$i_Id." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_TipoNotaDebitoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TipoNotaDebitoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TipoNotaDebitoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getId() ) ) $s_SQLQuery .= "MST_TipoNotaDebito.Id = ".$this->getId()." AND ";
        if ( !is_null( $this->getCodigoSunat() ) ) $s_SQLQuery .= "MST_TipoNotaDebito.CodigoSunat = '".$this->getCodigoSunat()."' AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "MST_TipoNotaDebito.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_TipoNotaDebito WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TipoNotaDebitoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoNotaDebito WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_TipoNotaDebitoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TipoNotaDebitoBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TipoNotaDebitoBN[] = $o_MST_TipoNotaDebitoBN;
            }
        }
        return $a_MST_TipoNotaDebitoBN;
    }

    /* Devuelve un objeto MST_TipoNotaDebitoBN desde un objeto propel */
    public function insertObjectBN( $a_MST_TipoNotaDebito )
    {
        $o_MST_TipoNotaDebitoBN = new MST_TipoNotaDebitoBN();
        if ( !is_null( $a_MST_TipoNotaDebito['Id'] ) ) $o_MST_TipoNotaDebitoBN->setId( ( integer ) $a_MST_TipoNotaDebito['Id'] );
        if ( !is_null( $a_MST_TipoNotaDebito['CodigoSunat'] ) ) $o_MST_TipoNotaDebitoBN->setCodigoSunat( $a_MST_TipoNotaDebito['CodigoSunat'] );
        if ( !is_null( $a_MST_TipoNotaDebito['Descripcion'] ) ) $o_MST_TipoNotaDebitoBN->setDescripcion( $a_MST_TipoNotaDebito['Descripcion'] );
        return $o_MST_TipoNotaDebitoBN;
    }
}
?>