<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoGarantia.xml */
/* Generado: 2022-04-18 21:15:00 */

/* Busqueda de registros de la tabla MST_TipoGarantia. */
abstract class BaseMST_TipoGarantiaFN extends MST_TipoGarantiaBN
{
    /* Declaracion de constantes */
    const TipoGarantiaId = "MST_TipoGarantia.TipoGarantiaId";
    const Nombre = "MST_TipoGarantia.Nombre";
    const NumeroDias = "MST_TipoGarantia.NumeroDias";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "MST_TipoGarantia.TipoGarantiaId AS TipoGarantiaId, ";
        $s_SQLQuery .= "MST_TipoGarantia.Nombre AS Nombre, ";
        $s_SQLQuery .= "MST_TipoGarantia.NumeroDias AS NumeroDias ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto MST_TipoGarantiaBN */
    public function setByBN( MST_TipoGarantiaBN $o_MST_TipoGarantiaBN )
    {
        if ( !is_null( $o_MST_TipoGarantiaBN->getTipoGarantiaId() ) )
        {
            $this->setTipoGarantiaId( $o_MST_TipoGarantiaBN->getTipoGarantiaId() );
        }
        if ( !is_null( $o_MST_TipoGarantiaBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_TipoGarantiaBN->getNombre() );
        }
        if ( !is_null( $o_MST_TipoGarantiaBN->getNumeroDias() ) )
        {
            $this->setNumeroDias( $o_MST_TipoGarantiaBN->getNumeroDias() );
        }
    }

    /**
    * @return MST_TipoGarantiaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_TipoGarantiaId )
    {
        if( is_null( $i_TipoGarantiaId ) ){ $i_TipoGarantiaId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoGarantia ";
        $s_SQLQuery .= "WHERE TipoGarantiaId = ".$i_TipoGarantiaId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_MST_TipoGarantiaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_MST_TipoGarantiaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_MST_TipoGarantiaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getTipoGarantiaId() ) ) $s_SQLQuery .= "MST_TipoGarantia.TipoGarantiaId = ".$this->getTipoGarantiaId()." AND ";
        if ( !is_null( $this->getNombre() ) ) $s_SQLQuery .= "MST_TipoGarantia.Nombre = '".$this->getNombre()."' AND ";
        if ( !is_null( $this->getNumeroDias() ) ) $s_SQLQuery .= "MST_TipoGarantia.NumeroDias = ".$this->getNumeroDias()." AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM MST_TipoGarantia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return MST_TipoGarantiaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM MST_TipoGarantia WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_MST_TipoGarantiaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_MST_TipoGarantiaBN = $this->insertObjectBN( $a_SQLRow );
                $a_MST_TipoGarantiaBN[] = $o_MST_TipoGarantiaBN;
            }
        }
        return $a_MST_TipoGarantiaBN;
    }

    /* Devuelve un objeto MST_TipoGarantiaBN desde un objeto propel */
    public function insertObjectBN( $a_MST_TipoGarantia )
    {
        $o_MST_TipoGarantiaBN = new MST_TipoGarantiaBN();
        if ( !is_null( $a_MST_TipoGarantia['TipoGarantiaId'] ) ) $o_MST_TipoGarantiaBN->setTipoGarantiaId( ( integer ) $a_MST_TipoGarantia['TipoGarantiaId'] );
        if ( !is_null( $a_MST_TipoGarantia['Nombre'] ) ) $o_MST_TipoGarantiaBN->setNombre( $a_MST_TipoGarantia['Nombre'] );
        if ( !is_null( $a_MST_TipoGarantia['NumeroDias'] ) ) $o_MST_TipoGarantiaBN->setNumeroDias( ( float ) $a_MST_TipoGarantia['NumeroDias'] );
        return $o_MST_TipoGarantiaBN;
    }
}
?>